/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.jaxrs.ui.wizards;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.wizards.NewElementWizard;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.jboss.tools.common.ui.CommonUIImages;
import org.jboss.tools.ws.jaxrs.ui.internal.utils.Logger;
import org.jboss.tools.ws.jaxrs.ui.wizards.JaxrsApplicationCreationWizardPage;

public class JaxrsApplicationCreationWizard
extends NewElementWizard
implements INewWizard {
    private IStructuredSelection selection;
    private JaxrsApplicationCreationWizardPage applicationPage;

    public JaxrsApplicationCreationWizard() {
        this.setDefaultPageImageDescriptor(CommonUIImages.getInstance().getOrCreateImageDescriptor("wizard/WebServiceWizBan.png"));
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
    }

    public void addPages() {
        this.applicationPage = new JaxrsApplicationCreationWizardPage(false);
        this.addPage((IWizardPage)this.applicationPage);
        this.applicationPage.init(this.selection);
    }

    public boolean performFinish() {
        boolean applicationCreated = super.performFinish();
        if (applicationCreated) {
            if (this.applicationPage.getApplicationMode() == 0) {
                try {
                    JavaUI.openInEditor((IJavaElement)this.applicationPage.getCreatedType());
                }
                catch (PartInitException e) {
                    Logger.error("Failed to open '" + this.applicationPage.getCreatedType().getFullyQualifiedName() + "'", e);
                }
                catch (JavaModelException e) {
                    Logger.error("Failed to open '" + this.applicationPage.getCreatedType().getFullyQualifiedName() + "'", e);
                }
            } else {
                try {
                    IFile webxmlResource = this.applicationPage.getWebxmlResource();
                    if (webxmlResource != null && webxmlResource.exists()) {
                        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                        IEditorDescriptor desc = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(webxmlResource.getName());
                        try {
                            page.openEditor((IEditorInput)new FileEditorInput(webxmlResource), desc.getId());
                        }
                        catch (PartInitException e) {
                            Logger.error("Failed to open '" + webxmlResource.getLocation().toString() + "'", e);
                        }
                    }
                }
                catch (CoreException e) {
                    Logger.error("Failed to open web.xml file in project {}", e, this.applicationPage.getJavaProject().getElementName());
                }
            }
        }
        return applicationCreated;
    }

    protected void finishPage(IProgressMonitor monitor) throws InterruptedException, CoreException {
        this.applicationPage.createType(monitor);
    }

    public IJavaElement getCreatedElement() {
        if (this.applicationPage.getApplicationMode() == 0) {
            return this.applicationPage.getCreatedType();
        }
        return null;
    }
}

