/*
 * Decompiled with CFR 0.152.
 */
package ui.internal.org.atteo.evo.inflector;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class TwoFormInflector {
    private final List<Rule> rules = new ArrayList<Rule>();

    protected String getPlural(String word) {
        for (Rule rule : this.rules) {
            String result = rule.getPlural(word);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    protected void uncountable(String[] list) {
        this.rules.add(new CategoryRule(list, "", ""));
    }

    protected void irregular(String singular, String plural) {
        if (singular.charAt(0) == plural.charAt(0)) {
            this.rules.add(new RegExpRule(Pattern.compile("(?i)(" + singular.charAt(0) + ")" + singular.substring(1) + "$"), "$1" + plural.substring(1)));
        } else {
            this.rules.add(new RegExpRule(Pattern.compile(String.valueOf(Character.toUpperCase(singular.charAt(0))) + "(?i)" + singular.substring(1) + "$"), String.valueOf(Character.toUpperCase(plural.charAt(0))) + plural.substring(1)));
            this.rules.add(new RegExpRule(Pattern.compile(String.valueOf(Character.toLowerCase(singular.charAt(0))) + "(?i)" + singular.substring(1) + "$"), String.valueOf(Character.toLowerCase(plural.charAt(0))) + plural.substring(1)));
        }
    }

    protected void irregular(String[][] list) {
        String[][] stringArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            String[] pair = stringArray[n2];
            this.irregular(pair[0], pair[1]);
            ++n2;
        }
    }

    protected void rule(String singular, String plural) {
        this.rules.add(new RegExpRule(Pattern.compile(singular, 2), plural));
    }

    protected void rule(String[][] list) {
        String[][] stringArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            String[] pair = stringArray[n2];
            this.rules.add(new RegExpRule(Pattern.compile(pair[0], 2), pair[1]));
            ++n2;
        }
    }

    protected void categoryRule(String[] list, String singular, String plural) {
        this.rules.add(new CategoryRule(list, singular, plural));
    }

    private static class CategoryRule
    implements Rule {
        private final String[] list;
        private final String singular;
        private final String plural;

        public CategoryRule(String[] list, String singular, String plural) {
            if (list != null) {
                this.list = new String[list.length];
                int i = 0;
                while (i < list.length) {
                    this.list[i] = list[i];
                    ++i;
                }
            } else {
                this.list = new String[0];
            }
            this.singular = singular;
            this.plural = plural;
        }

        @Override
        public String getPlural(String word) {
            String lowerWord = word.toLowerCase();
            String[] stringArray = this.list;
            int n = this.list.length;
            int n2 = 0;
            while (n2 < n) {
                String suffix = stringArray[n2];
                if (lowerWord.endsWith(suffix)) {
                    if (!lowerWord.endsWith(this.singular)) {
                        throw new RuntimeException("Internal error");
                    }
                    return String.valueOf(word.substring(0, word.length() - this.singular.length())) + this.plural;
                }
                ++n2;
            }
            return null;
        }
    }

    private static class RegExpRule
    implements Rule {
        private final Pattern singular;
        private final String plural;

        private RegExpRule(Pattern singular, String plural) {
            this.singular = singular;
            this.plural = plural;
        }

        @Override
        public String getPlural(String word) {
            StringBuffer buffer = new StringBuffer();
            Matcher matcher = this.singular.matcher(word);
            if (matcher.find()) {
                matcher.appendReplacement(buffer, this.plural);
                matcher.appendTail(buffer);
                return buffer.toString();
            }
            return null;
        }
    }

    private static interface Rule {
        public String getPlural(String var1);
    }
}

