/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.ui.utils;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.jboss.tools.ws.ui.utils.TreeParent;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.SAXException;

public class XMLParser {
    Document dom;
    TreeParent root;

    public void parseXmlFile(String fileContents) {
        this.root = new TreeParent("Invisible Root");
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            String cleanedFileContents = fileContents.trim();
            cleanedFileContents = cleanedFileContents.replaceAll("(\\r|\\n)", "");
            ByteArrayInputStream bais = new ByteArrayInputStream(cleanedFileContents.getBytes());
            this.dom = db.parse(bais);
            this.dom.getDocumentElement().normalize();
            this.parseDocument();
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
        }
        catch (SAXException se) {
            se.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    private void parseDocument() {
        Element docEle = this.dom.getDocumentElement();
        TreeParent soapRoot = new TreeParent(docEle.getTagName());
        soapRoot.setData(docEle);
        this.processChildren(soapRoot, docEle);
        this.root.addChild(soapRoot);
    }

    private void processChildren(TreeParent parent, Element el) {
        el.normalize();
        parent.setData(el);
        NodeList children = el.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            if (children.item(i) instanceof Element) {
                Element child = (Element)children.item(i);
                String name = child.getTagName();
                TreeParent childNode = new TreeParent(name);
                this.processChildren(childNode, child);
                parent.addChild(childNode);
            }
            ++i;
        }
    }

    public String updateValue(String input, TreeParent tp, String value) {
        Element found;
        this.parseXmlFile(input);
        this.dom.normalizeDocument();
        Element docEle = this.dom.getDocumentElement();
        Element toFind = (Element)tp.getData();
        NodeList nl = docEle.getElementsByTagName(toFind.getTagName());
        if (nl.getLength() > 0 && (found = (Element)nl.item(0)).getChildNodes() != null && found.getChildNodes().getLength() > 0) {
            Node node = found.getChildNodes().item(0);
            node.setTextContent(value);
            TransformerFactory transFactory = TransformerFactory.newInstance();
            try {
                Transformer transformer = transFactory.newTransformer();
                StringWriter buffer = new StringWriter();
                transformer.setOutputProperty("omit-xml-declaration", "yes");
                transformer.transform(new DOMSource(docEle), new StreamResult(buffer));
                String str = buffer.toString();
                return str;
            }
            catch (TransformerConfigurationException e) {
                e.printStackTrace();
            }
            catch (TransformerException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public TreeParent getRoot() {
        return this.root;
    }

    public static String prettyPrint(String xml) {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            ByteArrayInputStream bais = new ByteArrayInputStream(xml.getBytes());
            Document dom = db.parse(bais);
            String stringOutput = XMLParser.prettyPrintWithDOM3LS(dom);
            return stringOutput;
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
        }
        catch (SAXException se) {
            se.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return null;
    }

    static String prettyPrintWithDOM3LS(Document document) {
        DOMImplementation domImplementation = document.getImplementation();
        if (domImplementation.hasFeature("LS", "3.0") && domImplementation.hasFeature("Core", "2.0")) {
            DOMImplementationLS domImplementationLS = (DOMImplementationLS)domImplementation.getFeature("LS", "3.0");
            LSSerializer lsSerializer = domImplementationLS.createLSSerializer();
            DOMConfiguration domConfiguration = lsSerializer.getDomConfig();
            if (domConfiguration.canSetParameter("format-pretty-print", Boolean.TRUE)) {
                lsSerializer.getDomConfig().setParameter("format-pretty-print", Boolean.TRUE);
                LSOutput lsOutput = domImplementationLS.createLSOutput();
                lsOutput.setEncoding("UTF-8");
                StringWriter stringWriter = new StringWriter();
                lsOutput.setCharacterStream(stringWriter);
                lsSerializer.write(document, lsOutput);
                return stringWriter.toString();
            }
            throw new RuntimeException("DOMConfiguration 'format-pretty-print' parameter isn't settable.");
        }
        throw new RuntimeException("DOM 3.0 LS and/or DOM 2.0 Core not supported.");
    }

    public static boolean isXMLLike(String inXMLStr) {
        boolean retBool = false;
        if (inXMLStr != null && inXMLStr.trim().length() > 0 && inXMLStr.trim().startsWith("<")) {
            Pattern pattern = Pattern.compile("<(\\S+?)(.*?)>(.*?)</\\1>", 42);
            Matcher matcher = pattern.matcher(inXMLStr);
            retBool = matcher.matches();
        }
        return retBool;
    }

    public static boolean isValidXML(String xml) {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            ByteArrayInputStream bais = new ByteArrayInputStream(xml.getBytes());
            db.parse(bais);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static String prettyPrintJSON(String inJSON) {
        int numberOfSpaces = 4;
        String spaces = String.format("%" + numberOfSpaces + "s", "");
        if ((inJSON = inJSON.trim()).startsWith("{") && inJSON.endsWith("}")) {
            String output = "";
            char[] chars = inJSON.toCharArray();
            int i = 0;
            while (i < chars.length) {
                char current = chars[i];
                switch (current) {
                    case '{': {
                        output = String.valueOf(output) + current + "\r\n" + spaces;
                        break;
                    }
                    case '}': {
                        output = String.valueOf(output) + "\r\n" + current;
                        break;
                    }
                    case ',': {
                        output = String.valueOf(output) + current + "\r\n" + spaces;
                        break;
                    }
                    default: {
                        output = String.valueOf(output) + current;
                    }
                }
                ++i;
            }
            return output;
        }
        if (inJSON.startsWith("[") && inJSON.endsWith("]")) {
            String output = "[\r\n";
            inJSON = inJSON.substring(1, inJSON.length() - 1);
            String innerParts = XMLParser.prettyPrintJSON(inJSON);
            output = String.valueOf(output) + innerParts;
            output = String.valueOf(output) + "\r\n]";
            return output;
        }
        return inJSON;
    }
}

