/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.ui.views;

import java.util.Stack;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.ScrolledPageBook;
import org.jboss.tools.ws.ui.JBossWSUIPlugin;
import org.jboss.tools.ws.ui.messages.JBossWSUIMessages;
import org.jboss.tools.ws.ui.utils.TreeParent;
import org.jboss.tools.ws.ui.utils.XMLParser;
import org.jboss.tools.ws.ui.views.FormExpansionAdapter;
import org.jboss.tools.ws.ui.views.ShowRawAction;
import org.jboss.tools.ws.ui.views.ToggleAction;
import org.jboss.tools.ws.ui.views.WebServicesTestView;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RequestBodyComposite {
    public static final String PAGE1_KEY = "page1";
    public static final String PAGE2_KEY = "page2";
    private static final String[] TREE_COLUMNS = new String[]{"name", "value"};
    private Text bodyText;
    private TreeViewer treeRequestBody;

    public void createControl(WebServicesTestView view, Composite parent) {
        ExpandableComposite bodyComposite = view.getToolkit().createExpandableComposite(parent, 82);
        bodyComposite.setText(JBossWSUIMessages.JAXRSWSTestView2_BodyText_Section);
        ScrolledPageBook requestPageBook = view.getToolkit().createPageBook((Composite)bodyComposite, 0);
        this.createRequestToolbar(requestPageBook, bodyComposite);
        Composite page1 = requestPageBook.createPage((Object)PAGE1_KEY);
        page1.setLayout((Layout)new GridLayout());
        this.bodyText = view.getToolkit().createText(page1, "", 2624);
        GridData gd7 = new GridData(4, 4, true, true);
        gd7.heightHint = 1;
        this.bodyText.setLayoutData((Object)gd7);
        requestPageBook.showPage((Object)PAGE1_KEY);
        Composite page2 = requestPageBook.createPage((Object)PAGE2_KEY);
        page2.setLayout((Layout)new GridLayout());
        this.treeRequestBody = new TreeViewer(page2, 68160);
        this.treeRequestBody.setAutoExpandLevel(-1);
        GridData gd11 = new GridData(4, 4, true, true);
        gd11.heightHint = 1;
        view.getToolkit().adapt((Composite)this.treeRequestBody.getTree());
        this.treeRequestBody.getTree().setLayoutData((Object)gd11);
        this.treeRequestBody.getTree().setHeaderVisible(true);
        TreeColumn nameColumn = new TreeColumn(this.treeRequestBody.getTree(), 16384);
        nameColumn.setText(JBossWSUIMessages.JAXRSWSTestView2_Name_column);
        nameColumn.setWidth(200);
        TreeColumn valueColumn = new TreeColumn(this.treeRequestBody.getTree(), 16384);
        valueColumn.setText(JBossWSUIMessages.JAXRSWSTestView2_Value_column);
        valueColumn.setWidth(200);
        this.treeRequestBody.setColumnProperties(TREE_COLUMNS);
        this.treeRequestBody.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                if (element instanceof TreeParent && property.equalsIgnoreCase("name")) {
                    return true;
                }
                return element instanceof TreeParent && property.equalsIgnoreCase("value");
            }

            public void removeListener(ILabelProviderListener listener) {
            }

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                Node node;
                Element tpelement;
                TreeParent tp;
                if (element instanceof TreeParent && columnIndex == 0) {
                    return ((TreeParent)element).getName();
                }
                if (element instanceof TreeParent && columnIndex == 1 && (tp = (TreeParent)element).getData() != null && tp.getData() instanceof Element && (tpelement = (Element)tp.getData()).getChildNodes() != null && tpelement.getChildNodes().getLength() > 0 && (node = tpelement.getChildNodes().item(0)).getNodeType() == 3) {
                    return node.getTextContent();
                }
                return null;
            }
        });
        this.treeRequestBody.setContentProvider((IContentProvider)new ITreeContentProvider(){
            String text;
            TreeParent tree;

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                if (newInput instanceof String) {
                    this.text = (String)newInput;
                    XMLParser parser = new XMLParser();
                    parser.parseXmlFile(this.text);
                    this.tree = parser.getRoot().getChildren().length > 0 ? (TreeParent)parser.getRoot().getChildren()[0] : null;
                }
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof String && this.tree != null) {
                    return new Object[]{this.tree};
                }
                if (inputElement instanceof TreeParent) {
                    return ((TreeParent)inputElement).getChildren();
                }
                return null;
            }

            public Object[] getChildren(Object parentElement) {
                if (parentElement == null && this.tree != null) {
                    return new Object[]{this.tree};
                }
                if (parentElement instanceof TreeParent && ((TreeParent)parentElement).hasChildren()) {
                    return ((TreeParent)parentElement).getChildren();
                }
                return null;
            }

            public Object getParent(Object element) {
                if (element instanceof TreeParent) {
                    return ((TreeParent)element).getParent();
                }
                return null;
            }

            public boolean hasChildren(Object element) {
                if (element instanceof TreeParent) {
                    return ((TreeParent)element).hasChildren();
                }
                return false;
            }
        });
        this.treeRequestBody.setCellModifier(new ICellModifier(){

            public boolean canModify(Object element, String property) {
                Node node;
                Element tpelement;
                TreeParent tp;
                return element instanceof TreeParent && property.equalsIgnoreCase("value") && (tp = (TreeParent)element).getData() != null && tp.getData() instanceof Element && (tpelement = (Element)tp.getData()).getChildNodes() != null && tpelement.getChildNodes().getLength() > 0 && (node = tpelement.getChildNodes().item(0)).getNodeType() == 3 && node.getNodeValue().trim().length() > 0;
            }

            public Object getValue(Object element, String property) {
                Element tpelement;
                TreeParent tp = (TreeParent)element;
                if (tp.getData() != null && tp.getData() instanceof Element && (tpelement = (Element)tp.getData()).getChildNodes() != null && tpelement.getChildNodes().getLength() > 0) {
                    Node node = tpelement.getChildNodes().item(0);
                    return node.getTextContent();
                }
                return null;
            }

            public void modify(Object element, String property, Object value) {
                Node node;
                Element tpelement;
                TreeItem ti = (TreeItem)element;
                TreeParent tp = (TreeParent)ti.getData();
                if (tp.getData() != null && tp.getData() instanceof Element && (tpelement = (Element)tp.getData()).getChildNodes() != null && tpelement.getChildNodes().getLength() > 0 && (node = tpelement.getChildNodes().item(0)).getNodeType() == 3) {
                    node.setTextContent((String)value);
                    RequestBodyComposite.this.treeRequestBody.update((Object)tp, null);
                    XMLParser parser = new XMLParser();
                    String updatedOut = parser.updateValue((String)RequestBodyComposite.this.treeRequestBody.getInput(), tp, (String)value);
                    if (updatedOut != null && updatedOut.trim().length() > 0) {
                        Stack<String> pathStack = new Stack<String>();
                        pathStack.push(ti.getText());
                        TreeItem tiPath = ti;
                        while (tiPath.getParentItem() != null) {
                            tiPath = tiPath.getParentItem();
                            pathStack.push(tiPath.getText());
                        }
                        RequestBodyComposite.this.setBodyText(updatedOut);
                        RequestBodyComposite.this.treeRequestBody.setAutoExpandLevel(-1);
                        while (!pathStack.isEmpty()) {
                            TreeItem[] items = RequestBodyComposite.this.treeRequestBody.getTree().getItems();
                            String find = (String)pathStack.pop();
                            RequestBodyComposite.this.findTreeItem(RequestBodyComposite.this.treeRequestBody, find, items);
                        }
                    }
                }
            }
        });
        CellEditor[] cellEditorArray = new CellEditor[2];
        cellEditorArray[1] = new TextCellEditor((Composite)this.treeRequestBody.getTree());
        this.treeRequestBody.setCellEditors(cellEditorArray);
        requestPageBook.showPage((Object)PAGE1_KEY);
        GridData gd = new GridData(4, 4, true, true);
        gd.heightHint = 1;
        gd.minimumHeight = 100;
        requestPageBook.setLayoutData((Object)gd);
        requestPageBook.showPage((Object)PAGE1_KEY);
        bodyComposite.setClient((Control)requestPageBook);
        GridData gd9 = new GridData(4, 4, true, true);
        gd9.minimumHeight = 200;
        bodyComposite.setLayoutData((Object)gd9);
        bodyComposite.addExpansionListener((IExpansionListener)new FormExpansionAdapter(view));
    }

    private void createRequestToolbar(ScrolledPageBook requestPageBook, ExpandableComposite parent) {
        ShowRawAction rawRequestAction = new ShowRawAction(requestPageBook, PAGE1_KEY);
        rawRequestAction.setChecked(true);
        ShowInTreeAction treeAction = new ShowInTreeAction(requestPageBook);
        ToolBarManager toolBarManager = new ToolBarManager(0x800000);
        ToolBar toolbar = toolBarManager.createControl((Composite)parent);
        toolBarManager.add((IAction)rawRequestAction);
        toolBarManager.add((IAction)treeAction);
        toolBarManager.update(true);
        parent.setTextClient((Control)toolbar);
    }

    private boolean findTreeItem(TreeViewer treeRequestBody, String name, TreeItem[] treeItems) {
        TreeItem[] treeItemArray = treeItems;
        int n = treeItems.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem treeItem = treeItemArray[n2];
            int i = 0;
            while (i < treeRequestBody.getTree().getColumnCount()) {
                String text = treeItem.getText(i);
                if (text.toUpperCase().contains(name.toUpperCase())) {
                    treeRequestBody.getTree().setSelection(treeItem);
                    return true;
                }
                if (treeItem.getItemCount() > 0) {
                    return this.findTreeItem(treeRequestBody, name, treeItem.getItems());
                }
                ++i;
            }
            ++n2;
        }
        return false;
    }

    public void setBodyText(String text) {
        this.bodyText.setText(text);
        this.treeRequestBody.setInput((Object)text);
    }

    public String getBodyText() {
        return this.bodyText.getText();
    }

    class ShowInTreeAction
    extends ToggleAction {
        private ScrolledPageBook requestPageBook;

        public ShowInTreeAction(ScrolledPageBook requestPageBook) {
            this.requestPageBook = requestPageBook;
        }

        public void run() {
            this.requestPageBook.showPage((Object)RequestBodyComposite.PAGE2_KEY);
        }

        public String getToolTipText() {
            return JBossWSUIMessages.JAXRSWSTestView2_ShowRequestTree_toolbar_btn;
        }

        public ImageDescriptor getImageDescriptor() {
            return JBossWSUIPlugin.getImageDescriptor("obj16/hierarchicalLayout.gif");
        }
    }
}

