/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.connector.svnkit;

import java.io.OutputStream;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.subversion.javahl.ClientException;
import org.apache.subversion.javahl.CommitItem;
import org.apache.subversion.javahl.DiffSummary;
import org.apache.subversion.javahl.SubversionException;
import org.apache.subversion.javahl.callback.ChangelistCallback;
import org.apache.subversion.javahl.callback.CommitCallback;
import org.apache.subversion.javahl.callback.CommitMessageCallback;
import org.apache.subversion.javahl.callback.DiffSummaryCallback;
import org.apache.subversion.javahl.callback.ListCallback;
import org.apache.subversion.javahl.callback.StatusCallback;
import org.apache.subversion.javahl.callback.UserPasswordCallback;
import org.apache.subversion.javahl.types.DirEntry;
import org.apache.subversion.javahl.types.Lock;
import org.apache.subversion.javahl.types.NodeKind;
import org.apache.subversion.javahl.types.Status;
import org.eclipse.team.svn.core.connector.ISVNAnnotationCallback;
import org.eclipse.team.svn.core.connector.ISVNChangeListCallback;
import org.eclipse.team.svn.core.connector.ISVNConflictResolutionCallback;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.connector.ISVNCredentialsPrompt;
import org.eclipse.team.svn.core.connector.ISVNDiffStatusCallback;
import org.eclipse.team.svn.core.connector.ISVNEntryCallback;
import org.eclipse.team.svn.core.connector.ISVNEntryInfoCallback;
import org.eclipse.team.svn.core.connector.ISVNEntryStatusCallback;
import org.eclipse.team.svn.core.connector.ISVNImportFilterCallback;
import org.eclipse.team.svn.core.connector.ISVNLogEntryCallback;
import org.eclipse.team.svn.core.connector.ISVNNotificationCallback;
import org.eclipse.team.svn.core.connector.ISVNPatchCallback;
import org.eclipse.team.svn.core.connector.ISVNProgressMonitor;
import org.eclipse.team.svn.core.connector.ISVNPropertyCallback;
import org.eclipse.team.svn.core.connector.SVNConflictResolution;
import org.eclipse.team.svn.core.connector.SVNConnectorException;
import org.eclipse.team.svn.core.connector.SVNDepth;
import org.eclipse.team.svn.core.connector.SVNDiffStatus;
import org.eclipse.team.svn.core.connector.SVNEntry;
import org.eclipse.team.svn.core.connector.SVNEntryInfo;
import org.eclipse.team.svn.core.connector.SVNEntryReference;
import org.eclipse.team.svn.core.connector.SVNEntryRevisionReference;
import org.eclipse.team.svn.core.connector.SVNEntryStatus;
import org.eclipse.team.svn.core.connector.SVNExternalReference;
import org.eclipse.team.svn.core.connector.SVNMergeInfo;
import org.eclipse.team.svn.core.connector.SVNProperty;
import org.eclipse.team.svn.core.connector.SVNRevision;
import org.eclipse.team.svn.core.connector.SVNRevisionRange;
import org.eclipse.team.svn.core.connector.configuration.ISVNConfigurationEventHandler;
import org.eclipse.team.svn.core.connector.ssl.SSLServerCertificateFailures;
import org.eclipse.team.svn.core.connector.ssl.SSLServerCertificateInfo;
import org.eclipse.team.svn.core.utility.SVNNotificationComposite;
import org.eclipse.team.svn.core.utility.SVNUtility;
import org.polarion.team.svn.connector.svnkit.ConversionUtility;
import org.polarion.team.svn.connector.svnkit.SVNKitService;
import org.tmatesoft.svn.core.client.SVNClientEx17;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.javahl17.UserPasswordProxyCallback;
import org.tmatesoft.svn.core.javahl17.UserPasswordSSHCallback;
import org.tmatesoft.svn.core.javahl17.UserPasswordSSLCallback;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SVNKitConnector
extends SVNKitService
implements ISVNConnector {
    protected SVNClientEx17 client;
    protected ISVNCredentialsPrompt prompt;
    protected SVNNotificationComposite composite;
    protected ISVNNotificationCallback installedNotify2;
    protected ISVNConflictResolutionCallback conflictResolver;
    protected ISVNConfigurationEventHandler configHandler;

    public SVNKitConnector() {
        SVNFileUtil.setSleepForTimestamp((boolean)false);
        this.client = new SVNClientEx17();
        this.composite = new SVNNotificationComposite();
        this.client.notification2(ConversionUtility.convert((ISVNNotificationCallback)this.composite));
    }

    public void setConfigurationEventHandler(ISVNConfigurationEventHandler configHandler) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("configHandler", configHandler);
        this.fireAsked("setConfigurationEventHandler", parameters);
        this.configHandler = configHandler = (ISVNConfigurationEventHandler)parameters.get("configHandler");
        this.fireSucceeded("setConfigurationEventHandler", parameters, null);
    }

    public ISVNConfigurationEventHandler getConfigurationEventHandler() throws SVNConnectorException {
        this.fireAsked("getConfigurationEventHandler", null);
        this.fireSucceeded("getConfigurationEventHandler", null, this.configHandler);
        return this.configHandler;
    }

    public String getConfigDirectory() throws SVNConnectorException {
        this.fireAsked("getConfigDirectory", null);
        try {
            String retVal = this.client.getConfigDirectory();
            this.fireSucceeded("getConfigDirectory", null, retVal);
            return retVal;
        }
        catch (ClientException ex) {
            this.handleClientException(ex, "getConfigDirectory", null);
            return null;
        }
    }

    public void setConfigDirectory(String configDir) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("configDir", configDir);
        this.fireAsked("setConfigDirectory", parameters);
        configDir = (String)parameters.get("configDir");
        try {
            this.client.setConfigDirectory(configDir);
            this.fireSucceeded("getConfigDirectory", parameters, null);
        }
        catch (ClientException ex) {
            this.handleClientException(ex, "setConfigDirectory", parameters);
        }
    }

    public void setUsername(String username) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("username", username);
        this.fireAsked("setUsername", parameters);
        username = (String)parameters.get("username");
        this.client.username(username);
        this.fireSucceeded("setUsername", parameters, null);
    }

    public void setPassword(String password) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("password", password);
        this.fireAsked("setUsername", parameters);
        password = (String)parameters.get("password");
        this.client.password(password);
        this.fireSucceeded("setUsername", parameters, null);
    }

    public boolean isCredentialsCacheEnabled() {
        this.fireAsked("isCredentialsCacheEnabled", null);
        boolean retVal = this.client.isCredentialsCacheEnabled();
        this.fireSucceeded("isCredentialsCacheEnabled", null, retVal);
        return retVal;
    }

    public void setCredentialsCacheEnabled(boolean cacheCredentials) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("cacheCredentials", cacheCredentials);
        this.fireAsked("setCredentialsCacheEnabled", parameters);
        cacheCredentials = (Boolean)parameters.get("cacheCredentials");
        this.client.setCredentialsCacheEnabled(cacheCredentials);
        this.fireSucceeded("setCredentialsCacheEnabled", parameters, null);
    }

    public void setPrompt(ISVNCredentialsPrompt prompt) {
        RepositoryInfoPrompt repositoryInfoPrompt;
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("prompt", prompt);
        this.fireAsked("setPrompt", parameters);
        prompt = (ISVNCredentialsPrompt)parameters.get("prompt");
        if (prompt == null) {
            repositoryInfoPrompt = null;
        } else {
            this.prompt = prompt;
            RepositoryInfoPrompt repositoryInfoPrompt2 = new RepositoryInfoPrompt(this.prompt);
            repositoryInfoPrompt = repositoryInfoPrompt2;
        }
        this.client.setPrompt((UserPasswordCallback)repositoryInfoPrompt);
        this.fireSucceeded("setPrompt", parameters, null);
    }

    public ISVNCredentialsPrompt getPrompt() {
        this.fireAsked("getPrompt", null);
        this.fireSucceeded("getPrompt", null, this.prompt);
        return this.prompt;
    }

    public void setProxy(String host, int port, String username, String password) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("host", host);
        parameters.put("port", port);
        parameters.put("username", username);
        parameters.put("password", password);
        this.fireAsked("setProxy", parameters);
        host = (String)parameters.get("host");
        port = (Integer)parameters.get("port");
        username = (String)parameters.get("username");
        password = (String)parameters.get("password");
        this.client.setProxy(host, port, username, password);
        this.fireSucceeded("setProxy", parameters, null);
    }

    public void setClientSSLCertificate(String certPath, String passphrase) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("certPath", certPath);
        parameters.put("passphrase", passphrase);
        this.fireAsked("setClientSSLCertificate", parameters);
        certPath = (String)parameters.get("certPath");
        passphrase = (String)parameters.get("passphrase");
        this.client.setClientSSLCertificate(certPath, passphrase);
        this.fireSucceeded("setClientSSLCertificate", parameters, null);
    }

    public boolean isSSLCertificateCacheEnabled() {
        this.fireAsked("isSSLCertificateCacheEnabled", null);
        boolean retVal = this.client.isSSLCertificateCacheEnabled();
        this.fireSucceeded("isSSLCertificateCacheEnabled", null, retVal);
        return retVal;
    }

    public void setSSLCertificateCacheEnabled(boolean enabled) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("enabled", enabled);
        this.fireAsked("setSSLCertificateCacheEnabled", parameters);
        enabled = (Boolean)parameters.get("enabled");
        this.client.setSSLCertificateCacheEnabled(enabled);
        this.fireSucceeded("setSSLCertificateCacheEnabled", parameters, null);
    }

    public void setSSHCredentials(String username, String privateKeyPath, String passphrase, int port) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("username", username);
        parameters.put("privateKeyPath", privateKeyPath);
        parameters.put("passphrase", passphrase);
        parameters.put("port", port);
        this.fireAsked("setSSHCredentials", parameters);
        username = (String)parameters.get("username");
        privateKeyPath = (String)parameters.get("privateKeyPath");
        passphrase = (String)parameters.get("passphrase");
        port = (Integer)parameters.get("port");
        this.client.setSSHCredentials(username, privateKeyPath, passphrase, port);
        this.fireSucceeded("setSSHCredentials", parameters, null);
    }

    public void setSSHCredentials(String username, String password, int port) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("username", username);
        parameters.put("password", password);
        parameters.put("port", port);
        this.fireAsked("setSSHCredentialsPassword", parameters);
        username = (String)parameters.get("username");
        password = (String)parameters.get("password");
        port = (Integer)parameters.get("port");
        this.client.setSSHCredentials(username, password, port);
        this.fireSucceeded("setSSHCredentialsPassword", parameters, null);
    }

    public void setCommitMissingFiles(boolean commitMissingFiles) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("commitMissingFiles", commitMissingFiles);
        this.fireAsked("setCommitMissingFiles", parameters);
        commitMissingFiles = (Boolean)parameters.get("commitMissingFiles");
        this.client.setCommitMissedFiles(commitMissingFiles);
        this.fireSucceeded("setCommitMissingFiles", parameters, null);
    }

    public boolean isCommitMissingFiles() {
        this.fireAsked("isCommitMissingFiles", null);
        boolean retVal = this.client.isCommitMissingFile();
        this.fireSucceeded("isCommitMissingFiles", null, retVal);
        return retVal;
    }

    public void setNotificationCallback(ISVNNotificationCallback notify) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("notify", notify);
        this.fireAsked("setNotificationCallback", parameters);
        notify = (ISVNNotificationCallback)parameters.get("notify");
        if (this.installedNotify2 != null) {
            this.composite.remove(this.installedNotify2);
        }
        this.installedNotify2 = notify;
        if (this.installedNotify2 != null) {
            this.composite.add(this.installedNotify2);
        }
        this.fireSucceeded("setNotificationCallback", parameters, null);
    }

    public ISVNNotificationCallback getNotificationCallback() {
        this.fireAsked("getNotificationCallback", null);
        this.fireSucceeded("getNotificationCallback", null, this.installedNotify2);
        return this.installedNotify2;
    }

    public long checkout(SVNEntryRevisionReference fromReference, String destPath, SVNDepth depth, long options, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("fromReference", fromReference);
        parameters.put("destPath", destPath);
        parameters.put("depth", depth);
        parameters.put("options", options);
        parameters.put("monitor", monitor);
        this.fireAsked("checkout", parameters);
        fromReference = (SVNEntryRevisionReference)parameters.get("fromReference");
        destPath = (String)parameters.get("destPath");
        depth = (SVNDepth)parameters.get("depth");
        options = (Long)parameters.get("options");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        SVNKitService.ProgressMonitorWrapper wrapper = new SVNKitService.ProgressMonitorWrapper(this, monitor);
        try {
            this.composite.add((ISVNNotificationCallback)wrapper);
            wrapper.start();
            long retVal = this.client.checkout(fromReference.path, destPath, ConversionUtility.convert(fromReference.revision), ConversionUtility.convert(fromReference.pegRevision), ConversionUtility.convertDepth(depth), (options & 1L) != 0L, (options & 2L) != 0L);
            this.fireSucceeded("checkout", parameters, retVal);
            long l = retVal;
            return l;
        }
        catch (ClientException ex) {
            this.handleClientException(ex, "checkout", parameters);
        }
        finally {
            wrapper.finish();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
        return 0L;
    }

    public void lock(String[] path, String comment, long options, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("path", path);
        parameters.put("comment", comment);
        parameters.put("options", options);
        parameters.put("monitor", monitor);
        this.fireAsked("lock", parameters);
        path = (String[])parameters.get("path");
        comment = (String)parameters.get("comment");
        options = (Long)parameters.get("options");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        SVNKitService.ProgressMonitorWrapper wrapper = new SVNKitService.ProgressMonitorWrapper(this, monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                this.client.lock(new HashSet<String>(Arrays.asList(path)), comment, (options & 4L) != 0L);
                this.fireSucceeded("lock", parameters, null);
            }
            catch (ClientException ex) {
                this.handleClientException(ex, "lock", parameters);
                wrapper.finish();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.finish();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public void unlock(String[] path, long options, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("path", path);
        parameters.put("options", options);
        parameters.put("monitor", monitor);
        this.fireAsked("unlock", parameters);
        path = (String[])parameters.get("path");
        options = (Long)parameters.get("options");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        SVNKitService.ProgressMonitorWrapper wrapper = new SVNKitService.ProgressMonitorWrapper(this, monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                this.client.unlock(new HashSet<String>(Arrays.asList(path)), (options & 4L) != 0L);
                this.fireSucceeded("unlock", parameters, null);
            }
            catch (ClientException ex) {
                this.handleClientException(ex, "unlock", parameters);
                wrapper.finish();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.finish();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public void add(String path, SVNDepth depth, long options, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("path", path);
        parameters.put("depth", depth);
        parameters.put("options", options);
        parameters.put("monitor", monitor);
        this.fireAsked("add", parameters);
        path = (String)parameters.get("path");
        depth = (SVNDepth)parameters.get("depth");
        options = (Long)parameters.get("options");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        SVNKitService.ProgressMonitorWrapper wrapper = new SVNKitService.ProgressMonitorWrapper(this, monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                this.client.add(path, ConversionUtility.convertDepth(depth), (options & 4L) != 0L, (options & 0x100L) != 0L, (options & 0x4000000L) != 0L, (options & 8L) != 0L);
                this.fireSucceeded("add", parameters, null);
            }
            catch (ClientException ex) {
                this.handleClientException(ex, "add", parameters);
                wrapper.finish();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.finish();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public void commit(String[] path, String message, String[] changeLists, SVNDepth depth, long options, Map revProps, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("path", path);
        parameters.put("message", message);
        parameters.put("changeLists", changeLists);
        parameters.put("depth", depth);
        parameters.put("options", options);
        parameters.put("revProps", revProps);
        parameters.put("monitor", monitor);
        this.fireAsked("commit", parameters);
        path = (String[])parameters.get("path");
        message = (String)parameters.get("message");
        changeLists = (String[])parameters.get("changeLists");
        depth = (SVNDepth)parameters.get("depth");
        options = (Long)parameters.get("options");
        revProps = (Map)parameters.get("revProps");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        boolean noUnlock = (options & 0x10L) != 0L;
        boolean keepChangelist = (options & 0x20L) != 0L;
        SVNKitService.ProgressMonitorWrapper wrapper = new SVNKitService.ProgressMonitorWrapper(this, monitor);
        try {
            try {
                if (this.client.isCommitMissingFile()) {
                    int i = 0;
                    while (i < path.length && !monitor.isActivityCancelled()) {
                        this.client.status(path[i], ConversionUtility.convertDepth(depth), false, false, false, true, null, new StatusCallback(){

                            public void doStatus(String path, Status status) {
                                if (status.getTextStatus() == Status.Kind.missing) {
                                    try {
                                        SVNKitConnector.this.client.remove(new HashSet<String>(Arrays.asList(path)), true, false, null, null, null);
                                    }
                                    catch (ClientException clientException) {}
                                }
                            }
                        });
                        ++i;
                    }
                }
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                CommitInfo info1 = new CommitInfo(monitor);
                this.client.commit(new HashSet<String>(Arrays.asList(path)), ConversionUtility.convertDepth(depth), noUnlock, keepChangelist, changeLists == null ? null : Arrays.asList(changeLists), ConversionUtility.convertRevPropsToSVN(revProps), (CommitMessageCallback)new CommitMessage(message), (CommitCallback)info1);
                if (info1.info != null && info1.info.getPostCommitError() != null) {
                    parameters.put("lastPostCommitError", info1.info.getPostCommitError());
                }
                this.fireSucceeded("commit", parameters, null);
            }
            catch (ClientException ex) {
                this.handleClientException(ex, "commit", parameters);
                wrapper.finish();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.finish();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public long[] update(String[] path, SVNRevision revision, SVNDepth depth, long options, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("path", path);
        parameters.put("revision", revision);
        parameters.put("depth", depth);
        parameters.put("options", options);
        parameters.put("monitor", monitor);
        this.fireAsked("update", parameters);
        path = (String[])parameters.get("path");
        revision = (SVNRevision)parameters.get("revision");
        depth = (SVNDepth)parameters.get("depth");
        options = (Long)parameters.get("options");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        SVNKitService.ProgressMonitorWrapper wrapper = new SVNKitService.ProgressMonitorWrapper(this, monitor);
        try {
            this.composite.add((ISVNNotificationCallback)wrapper);
            wrapper.start();
            long[] retVal = this.client.update(new HashSet<String>(Arrays.asList(path)), ConversionUtility.convert(revision), ConversionUtility.convertDepth(depth), (options & 0x4000L) != 0L, (options & 8L) != 0L, (options & 1L) != 0L, (options & 2L) != 0L);
            this.fireSucceeded("update", parameters, retVal);
            long[] lArray = retVal;
            return lArray;
        }
        catch (ClientException ex) {
            this.handleClientException(ex, "update", parameters);
        }
        finally {
            wrapper.finish();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
        return null;
    }

    public long switchTo(String path, SVNEntryRevisionReference toReference, SVNDepth depth, long options, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("path", path);
        parameters.put("toReference", toReference);
        parameters.put("depth", depth);
        parameters.put("options", options);
        parameters.put("monitor", monitor);
        this.fireAsked("switchTo", parameters);
        path = (String)parameters.get("path");
        toReference = (SVNEntryRevisionReference)parameters.get("toReference");
        depth = (SVNDepth)parameters.get("depth");
        options = (Long)parameters.get("options");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        SVNKitService.ProgressMonitorWrapper wrapper = new SVNKitService.ProgressMonitorWrapper(this, monitor);
        try {
            this.composite.add((ISVNNotificationCallback)wrapper);
            wrapper.start();
            long retVal = this.client.doSwitch(path, toReference.path, ConversionUtility.convert(toReference.revision), ConversionUtility.convert(toReference.pegRevision), ConversionUtility.convertDepth(depth), (options & 0x4000L) != 0L, (options & 1L) != 0L, (options & 2L) != 0L, (options & 0x200L) != 0L);
            this.fireSucceeded("switchTo", parameters, retVal);
            long l = retVal;
            return l;
        }
        catch (ClientException ex) {
            this.handleClientException(ex, "switchTo", parameters);
        }
        finally {
            wrapper.finish();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
        return 0L;
    }

    public void revert(String[] paths, SVNDepth depth, String[] changeLists, long options, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("paths", paths);
        parameters.put("depth", depth);
        parameters.put("changeLists", changeLists);
        parameters.put("options", options);
        parameters.put("monitor", monitor);
        this.fireAsked("revert", parameters);
        paths = (String[])parameters.get("paths");
        depth = (SVNDepth)parameters.get("depth");
        changeLists = (String[])parameters.get("changeLists");
        options = (Long)parameters.get("options");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        SVNKitService.ProgressMonitorWrapper wrapper = new SVNKitService.ProgressMonitorWrapper(this, monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                String[] stringArray = paths;
                int n = paths.length;
                int n2 = 0;
                while (n2 < n) {
                    String path = stringArray[n2];
                    this.client.revert(path, ConversionUtility.convertDepth(depth), changeLists == null ? null : Arrays.asList(changeLists));
                    ++n2;
                }
                this.fireSucceeded("revert", parameters, null);
            }
            catch (ClientException ex) {
                this.handleClientException(ex, "revert", parameters);
                wrapper.finish();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.finish();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public void status(String path, SVNDepth depth, long options, String[] changeLists, ISVNEntryStatusCallback callback, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("path", path);
        parameters.put("depth", depth);
        parameters.put("options", options);
        parameters.put("changeLists", changeLists);
        parameters.put("callback", callback);
        parameters.put("monitor", monitor);
        this.fireAsked("status", parameters);
        path = (String)parameters.get("path");
        depth = (SVNDepth)parameters.get("depth");
        options = (Long)parameters.get("options");
        changeLists = (String[])parameters.get("changeLists");
        callback = (ISVNEntryStatusCallback)parameters.get("callback");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        SVNKitService.ProgressMonitorWrapper wrapper = new SVNKitService.ProgressMonitorWrapper(this, monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                this.client.status(path, ConversionUtility.convertDepth(depth), (options & 0x40L) != 0L, (options & 0x80L) != 0L, (options & 0x100L) != 0L, (options & 1L) != 0L, changeLists == null ? null : Arrays.asList(changeLists), ConversionUtility.convert(callback));
                this.fireSucceeded("status", parameters, null);
            }
            catch (ClientException ex) {
                this.handleClientException(ex, "status", parameters);
                wrapper.finish();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.finish();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public void relocate(String from, String to, String path, SVNDepth depth, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("from", from);
        parameters.put("to", to);
        parameters.put("path", path);
        parameters.put("depth", depth);
        parameters.put("monitor", monitor);
        this.fireAsked("relocate", parameters);
        from = (String)parameters.get("from");
        to = (String)parameters.get("to");
        path = (String)parameters.get("path");
        depth = (SVNDepth)parameters.get("depth");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        SVNKitService.ProgressMonitorWrapper wrapper = new SVNKitService.ProgressMonitorWrapper(this, monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                this.client.relocate(from, to, path, depth == SVNDepth.INFINITY);
                this.fireSucceeded("relocate", parameters, null);
            }
            catch (ClientException ex) {
                this.handleClientException(ex, "relocate", parameters);
                wrapper.finish();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.finish();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public void cleanup(String path, long options, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("path", path);
        parameters.put("options", options);
        parameters.put("monitor", monitor);
        this.fireAsked("cleanup", parameters);
        path = (String)parameters.get("path");
        options = (Long)parameters.get("options");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        SVNKitService.ProgressMonitorWrapper wrapper = new SVNKitService.ProgressMonitorWrapper(this, monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                this.client.cleanup(path);
                this.fireSucceeded("cleanup", parameters, null);
            }
            catch (ClientException ex) {
                this.handleClientException(ex, "cleanup", parameters);
                wrapper.finish();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.finish();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public void mergeTwo(SVNEntryRevisionReference reference1, SVNEntryRevisionReference reference2, String localPath, SVNDepth depth, long options, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("reference1", reference1);
        parameters.put("reference2", reference2);
        parameters.put("localPath", localPath);
        parameters.put("depth", depth);
        parameters.put("options", options);
        parameters.put("monitor", monitor);
        this.fireAsked("mergeTwo", parameters);
        reference1 = (SVNEntryRevisionReference)parameters.get("reference1");
        reference2 = (SVNEntryRevisionReference)parameters.get("reference2");
        localPath = (String)parameters.get("localPath");
        depth = (SVNDepth)parameters.get("depth");
        options = (Long)parameters.get("options");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        SVNKitService.ProgressMonitorWrapper wrapper = new SVNKitService.ProgressMonitorWrapper(this, monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                reference1 = SVNUtility.convertRevisionReference((ISVNConnector)this, (SVNEntryRevisionReference)reference1, (ISVNProgressMonitor)monitor);
                reference2 = SVNUtility.convertRevisionReference((ISVNConnector)this, (SVNEntryRevisionReference)reference2, (ISVNProgressMonitor)monitor);
                this.client.merge(reference1.path, ConversionUtility.convert(reference1.revision), reference2.path, ConversionUtility.convert(reference2.revision), localPath, (options & 4L) != 0L, ConversionUtility.convertDepth(depth), (options & 0x200L) != 0L, (options & 0x400L) != 0L, (options & 0x800L) != 0L);
                this.fireSucceeded("mergeTwo", parameters, null);
            }
            catch (ClientException ex) {
                this.handleClientException(ex, "mergeTwo", parameters);
                wrapper.finish();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.finish();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public void merge(SVNEntryReference reference, SVNRevisionRange[] revisions, String localPath, SVNDepth depth, long options, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("reference", reference);
        parameters.put("revisions", revisions);
        parameters.put("localPath", localPath);
        parameters.put("depth", depth);
        parameters.put("options", options);
        parameters.put("monitor", monitor);
        this.fireAsked("merge", parameters);
        reference = (SVNEntryReference)parameters.get("reference");
        revisions = (SVNRevisionRange[])parameters.get("revisions");
        localPath = (String)parameters.get("localPath");
        depth = (SVNDepth)parameters.get("depth");
        options = (Long)parameters.get("options");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        SVNKitService.ProgressMonitorWrapper wrapper = new SVNKitService.ProgressMonitorWrapper(this, monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                this.client.merge(reference.path, ConversionUtility.convert(reference.pegRevision), Arrays.asList(ConversionUtility.convert(revisions)), localPath, (options & 4L) != 0L, ConversionUtility.convertDepth(depth), (options & 0x20000000L) != 0L, (options & 0x200L) != 0L, (options & 0x400L) != 0L, (options & 0x800L) != 0L);
                this.fireSucceeded("merge", parameters, null);
            }
            catch (ClientException ex) {
                this.handleClientException(ex, "merge", parameters);
                wrapper.finish();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.finish();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public void mergeReintegrate(SVNEntryReference reference, String localPath, long options, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("reference", reference);
        parameters.put("localPath", localPath);
        parameters.put("options", options);
        parameters.put("monitor", monitor);
        this.fireAsked("mergeReintegrate", parameters);
        reference = (SVNEntryReference)parameters.get("reference");
        localPath = (String)parameters.get("localPath");
        options = (Long)parameters.get("options");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        SVNKitService.ProgressMonitorWrapper wrapper = new SVNKitService.ProgressMonitorWrapper(this, monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                this.client.mergeReintegrate(reference.path, ConversionUtility.convert(reference.pegRevision), localPath, (options & 0x400L) != 0L);
                this.fireSucceeded("mergeReintegrate", parameters, null);
            }
            catch (ClientException ex) {
                this.handleClientException(ex, "mergeReintegrate", parameters);
                wrapper.finish();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.finish();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public SVNMergeInfo getMergeInfo(SVNEntryReference reference, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("reference", reference);
        parameters.put("monitor", monitor);
        this.fireAsked("getMergeInfo", parameters);
        reference = (SVNEntryReference)parameters.get("reference");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        SVNKitService.ProgressMonitorWrapper wrapper = new SVNKitService.ProgressMonitorWrapper(this, monitor);
        try {
            this.composite.add((ISVNNotificationCallback)wrapper);
            wrapper.start();
            SVNMergeInfo retVal = ConversionUtility.convert(this.client.getMergeinfo(reference.path, ConversionUtility.convert(reference.pegRevision)));
            this.fireSucceeded("getMergeInfo", parameters, retVal);
            SVNMergeInfo sVNMergeInfo = retVal;
            return sVNMergeInfo;
        }
        catch (ClientException ex) {
            this.handleClientException(ex, "getMergeInfo", parameters);
        }
        catch (SubversionException ex) {
            this.handleSubversionException(ex, "getMergeInfo", parameters);
        }
        finally {
            wrapper.finish();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
        return null;
    }

    public void listMergeInfoLog(SVNMergeInfo.LogKind logKind, SVNEntryReference reference, SVNEntryReference mergeSourceReference, SVNRevisionRange mergeSourceRange, String[] revProps, SVNDepth depth, long options, ISVNLogEntryCallback cb, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("logKind", logKind);
        parameters.put("reference", reference);
        parameters.put("mergeSourceReference", mergeSourceReference);
        parameters.put("mergeSourceRange", mergeSourceRange);
        parameters.put("revProps", revProps);
        parameters.put("options", options);
        parameters.put("cb", cb);
        parameters.put("monitor", monitor);
        this.fireAsked("listMergeInfoLog", parameters);
        logKind = (SVNMergeInfo.LogKind)parameters.get("logKind");
        reference = (SVNEntryReference)parameters.get("reference");
        mergeSourceReference = (SVNEntryReference)parameters.get("mergeSourceReference");
        mergeSourceRange = (SVNRevisionRange)parameters.get("mergeSourceRange");
        revProps = (String[])parameters.get("revProps");
        options = (Long)parameters.get("options");
        cb = (ISVNLogEntryCallback)parameters.get("cb");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        SVNKitService.ProgressMonitorWrapper wrapper = new SVNKitService.ProgressMonitorWrapper(this, monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                this.client.getMergeinfoLog(ConversionUtility.convertLogKind(logKind), reference.path, ConversionUtility.convert(reference.pegRevision), mergeSourceReference.path, ConversionUtility.convert(mergeSourceReference.pegRevision), ConversionUtility.convert(mergeSourceRange.from), ConversionUtility.convert(mergeSourceRange.to), (options & 0x40000L) != 0L, ConversionUtility.convertDepth(depth), new HashSet<String>(Arrays.asList(revProps)), ConversionUtility.convert(cb));
                this.fireSucceeded("listMergeInfoLog", parameters, null);
            }
            catch (ClientException ex) {
                this.handleClientException(ex, "listMergeInfoLog", parameters);
                wrapper.finish();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.finish();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public String[] suggestMergeSources(SVNEntryReference reference, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("reference", reference);
        parameters.put("monitor", monitor);
        this.fireAsked("suggestMergeSources", parameters);
        reference = (SVNEntryReference)parameters.get("reference");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        SVNKitService.ProgressMonitorWrapper wrapper = new SVNKitService.ProgressMonitorWrapper(this, monitor);
        try {
            this.composite.add((ISVNNotificationCallback)wrapper);
            wrapper.start();
            Set tmp = this.client.suggestMergeSources(reference.path, ConversionUtility.convert(reference.pegRevision));
            String[] retVal = tmp == null ? null : tmp.toArray(new String[tmp.size()]);
            this.fireSucceeded("suggestMergeSources", parameters, retVal);
            String[] stringArray = retVal;
            return stringArray;
        }
        catch (ClientException ex) {
            this.handleClientException(ex, "suggestMergeSources", parameters);
        }
        catch (SubversionException ex) {
            this.handleSubversionException(ex, "suggestMergeSources", parameters);
        }
        finally {
            wrapper.finish();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
        return null;
    }

    public void resolve(String path, SVNConflictResolution.Choice conflictResult, SVNDepth depth, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("path", path);
        parameters.put("conflictResult", conflictResult);
        parameters.put("depth", depth);
        parameters.put("monitor", monitor);
        this.fireAsked("resolve", parameters);
        path = (String)parameters.get("path");
        conflictResult = (SVNConflictResolution.Choice)parameters.get("conflictResult");
        depth = (SVNDepth)parameters.get("depth");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        SVNKitService.ProgressMonitorWrapper wrapper = new SVNKitService.ProgressMonitorWrapper(this, monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                this.client.resolve(path, ConversionUtility.convertDepth(depth), ConversionUtility.convertConflictChoice(conflictResult));
                this.fireSucceeded("resolve", parameters, null);
            }
            catch (ClientException ex) {
                this.handleClientException(ex, "resolve", parameters);
                wrapper.finish();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
            catch (SubversionException ex) {
                this.handleSubversionException(ex, "resolve", parameters);
                wrapper.finish();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.finish();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public void setConflictResolver(ISVNConflictResolutionCallback listener) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("listener", listener);
        this.fireAsked("setConflictResolver", parameters);
        this.conflictResolver = listener = (ISVNConflictResolutionCallback)parameters.get("listener");
        this.client.setConflictResolver(ConversionUtility.convert(listener));
        this.fireSucceeded("setConflictResolver", parameters, null);
    }

    public ISVNConflictResolutionCallback getConflictResolver() {
        this.fireAsked("getConflictResolver", null);
        this.fireSucceeded("getConflictResolver", null, this.conflictResolver);
        return this.conflictResolver;
    }

    public void addToChangeList(String[] paths, String changelist, SVNDepth depth, String[] changeLists, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("paths", paths);
        parameters.put("changelist", changelist);
        parameters.put("depth", depth);
        parameters.put("changeLists", changeLists);
        parameters.put("monitor", monitor);
        this.fireAsked("addToChangeList", parameters);
        paths = (String[])parameters.get("paths");
        changelist = (String)parameters.get("changelist");
        depth = (SVNDepth)parameters.get("depth");
        changeLists = (String[])parameters.get("changeLists");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        SVNKitService.ProgressMonitorWrapper wrapper = new SVNKitService.ProgressMonitorWrapper(this, monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                this.client.addToChangelist(new HashSet<String>(Arrays.asList(paths)), changelist, ConversionUtility.convertDepth(depth), changeLists == null ? null : Arrays.asList(changeLists));
                this.fireSucceeded("addToChangeList", parameters, null);
            }
            catch (ClientException ex) {
                this.handleClientException(ex, "addToChangeList", parameters);
                wrapper.finish();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.finish();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public void removeFromChangeLists(String[] paths, SVNDepth depth, String[] changeLists, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("paths", paths);
        parameters.put("depth", depth);
        parameters.put("changeLists", changeLists);
        parameters.put("monitor", monitor);
        this.fireAsked("removeFromChangeLists", parameters);
        paths = (String[])parameters.get("paths");
        depth = (SVNDepth)parameters.get("depth");
        changeLists = (String[])parameters.get("changeLists");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        SVNKitService.ProgressMonitorWrapper wrapper = new SVNKitService.ProgressMonitorWrapper(this, monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                this.client.removeFromChangelists(new HashSet<String>(Arrays.asList(paths)), ConversionUtility.convertDepth(depth), changeLists == null ? null : Arrays.asList(changeLists));
                this.fireSucceeded("removeFromChangeLists", parameters, null);
            }
            catch (ClientException ex) {
                this.handleClientException(ex, "removeFromChangeLists", parameters);
                wrapper.finish();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.finish();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public void dumpChangeLists(String[] changeLists, String rootPath, SVNDepth depth, ISVNChangeListCallback cb, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("changeLists", changeLists);
        parameters.put("rootPath", rootPath);
        parameters.put("depth", depth);
        parameters.put("cb", cb);
        parameters.put("monitor", monitor);
        this.fireAsked("dumpChangeLists", parameters);
        changeLists = (String[])parameters.get("changeLists");
        rootPath = (String)parameters.get("rootPath");
        depth = (SVNDepth)parameters.get("depth");
        final ISVNChangeListCallback cb1 = (ISVNChangeListCallback)parameters.get("cb");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        SVNKitService.ProgressMonitorWrapper wrapper = new SVNKitService.ProgressMonitorWrapper(this, monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                this.client.getChangelists(rootPath, Arrays.asList(changeLists), ConversionUtility.convertDepth(depth), new ChangelistCallback(){

                    public void doChangelist(String path, String changelist) {
                        cb1.next(path, changelist);
                    }
                });
                this.fireSucceeded("dumpChangeLists", parameters, null);
            }
            catch (ClientException ex) {
                this.handleClientException(ex, "dumpChangeLists", parameters);
                wrapper.finish();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.finish();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public void importTo(String path, String url, String message, SVNDepth depth, long options, Map revProps, ISVNImportFilterCallback filter, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("path", path);
        parameters.put("url", url);
        parameters.put("message", message);
        parameters.put("depth", depth);
        parameters.put("options", options);
        parameters.put("revProps", revProps);
        parameters.put("filter", filter);
        parameters.put("monitor", monitor);
        this.fireAsked("importTo", parameters);
        path = (String)parameters.get("path");
        url = (String)parameters.get("url");
        message = (String)parameters.get("message");
        depth = (SVNDepth)parameters.get("depth");
        options = (Long)parameters.get("options");
        revProps = (Map)parameters.get("revProps");
        filter = (ISVNImportFilterCallback)parameters.get("filter");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        SVNKitService.ProgressMonitorWrapper wrapper = new SVNKitService.ProgressMonitorWrapper(this, monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                this.client.doImport(path, url, ConversionUtility.convertDepth(depth), (options & 0x100L) != 0L, (options & 0x4000000L) != 0L, (options & 0x1000L) != 0L, ConversionUtility.convertRevPropsToSVN(revProps), ConversionUtility.convert(filter), (CommitMessageCallback)new CommitMessage(message), (CommitCallback)new CommitInfo(monitor));
                this.fireSucceeded("importTo", parameters, null);
            }
            catch (ClientException ex) {
                this.handleClientException(ex, "importTo", parameters);
                wrapper.finish();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.finish();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public long exportTo(SVNEntryRevisionReference fromReference, String destPath, String nativeEOL, SVNDepth depth, long options, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("fromReference", fromReference);
        parameters.put("destPath", destPath);
        parameters.put("nativeEOL", nativeEOL);
        parameters.put("depth", depth);
        parameters.put("options", options);
        parameters.put("monitor", monitor);
        this.fireAsked("exportTo", parameters);
        fromReference = (SVNEntryRevisionReference)parameters.get("fromReference");
        destPath = (String)parameters.get("destPath");
        nativeEOL = (String)parameters.get("nativeEOL");
        depth = (SVNDepth)parameters.get("depth");
        options = (Long)parameters.get("options");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        SVNKitService.ProgressMonitorWrapper wrapper = new SVNKitService.ProgressMonitorWrapper(this, monitor);
        try {
            this.composite.add((ISVNNotificationCallback)wrapper);
            wrapper.start();
            long retVal = this.client.doExport(fromReference.path, destPath, ConversionUtility.convert(fromReference.revision), ConversionUtility.convert(fromReference.pegRevision), (options & 4L) != 0L, (options & 1L) != 0L, ConversionUtility.convertDepth(depth), nativeEOL);
            this.fireSucceeded("exportTo", parameters, retVal);
            long l = retVal;
            return l;
        }
        catch (ClientException ex) {
            this.handleClientException(ex, "exportTo", parameters);
        }
        finally {
            wrapper.finish();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
        return 0L;
    }

    public void diffTwo(SVNEntryRevisionReference reference1, SVNEntryRevisionReference reference2, String relativeToDir, String fileName, SVNDepth depth, long options, String[] changeLists, long outputOptions, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("reference1", reference1);
        parameters.put("reference2", reference2);
        parameters.put("relativeToDir", relativeToDir);
        parameters.put("fileName", fileName);
        parameters.put("depth", depth);
        parameters.put("options", options);
        parameters.put("changeLists", changeLists);
        parameters.put("outputOptions", outputOptions);
        parameters.put("monitor", monitor);
        this.fireAsked("diffTwoFile", parameters);
        reference1 = (SVNEntryRevisionReference)parameters.get("reference1");
        reference2 = (SVNEntryRevisionReference)parameters.get("reference2");
        relativeToDir = (String)parameters.get("relativeToDir");
        fileName = (String)parameters.get("fileName");
        depth = (SVNDepth)parameters.get("depth");
        options = (Long)parameters.get("options");
        changeLists = (String[])parameters.get("changeLists");
        outputOptions = (Long)parameters.get("outputOptions");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        SVNKitService.ProgressMonitorWrapper wrapper = new SVNKitService.ProgressMonitorWrapper(this, monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                reference1 = SVNUtility.convertRevisionReference((ISVNConnector)this, (SVNEntryRevisionReference)reference1, (ISVNProgressMonitor)monitor);
                reference2 = SVNUtility.convertRevisionReference((ISVNConnector)this, (SVNEntryRevisionReference)reference2, (ISVNProgressMonitor)monitor);
                this.client.diff(reference1.path, ConversionUtility.convert(reference1.revision), reference2.path, ConversionUtility.convert(reference2.revision), relativeToDir, fileName, ConversionUtility.convertDepth(depth), changeLists == null ? null : Arrays.asList(changeLists), (options & 0x200L) != 0L, (options & 0x2000L) != 0L, (options & 4L) != 0L, (options & 0x400000L) != 0L, (options & 0x40000000L) != 0L, (options & Integer.MIN_VALUE) != 0L, ConversionUtility.convertDiffOptions(outputOptions));
                this.fireSucceeded("diffTwoFile", parameters, null);
            }
            catch (ClientException ex) {
                this.handleClientException(ex, "diffTwoFile", parameters);
                wrapper.finish();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.finish();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public void diff(SVNEntryReference reference, SVNRevisionRange range, String relativeToDir, String fileName, SVNDepth depth, long options, String[] changeLists, long outputOptions, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("reference", reference);
        parameters.put("range", range);
        parameters.put("relativeToDir", relativeToDir);
        parameters.put("fileName", fileName);
        parameters.put("depth", depth);
        parameters.put("options", options);
        parameters.put("changeLists", changeLists);
        parameters.put("outputOptions", outputOptions);
        parameters.put("monitor", monitor);
        this.fireAsked("diff", parameters);
        reference = (SVNEntryReference)parameters.get("reference");
        range = (SVNRevisionRange)parameters.get("range");
        relativeToDir = (String)parameters.get("relativeToDir");
        fileName = (String)parameters.get("fileName");
        depth = (SVNDepth)parameters.get("depth");
        options = (Long)parameters.get("options");
        changeLists = (String[])parameters.get("changeLists");
        outputOptions = (Long)parameters.get("outputOptions");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        SVNKitService.ProgressMonitorWrapper wrapper = new SVNKitService.ProgressMonitorWrapper(this, monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                this.client.diff(reference.path, ConversionUtility.convert(reference.pegRevision), ConversionUtility.convert(range.from), ConversionUtility.convert(range.to), relativeToDir, fileName, ConversionUtility.convertDepth(depth), changeLists == null ? null : Arrays.asList(changeLists), (options & 0x200L) != 0L, (options & 0x2000L) != 0L, (options & 4L) != 0L, (options & 0x400000L) != 0L, (options & 0x40000000L) != 0L, (options & Integer.MIN_VALUE) != 0L, ConversionUtility.convertDiffOptions(outputOptions));
                this.fireSucceeded("diff", parameters, null);
            }
            catch (ClientException ex) {
                this.handleClientException(ex, "diff", parameters);
                wrapper.finish();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.finish();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public void diffTwo(SVNEntryRevisionReference reference1, SVNEntryRevisionReference reference2, String relativeToDir, OutputStream stream, SVNDepth depth, long options, String[] changeLists, long outputOptions, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("reference1", reference1);
        parameters.put("reference2", reference2);
        parameters.put("relativeToDir", relativeToDir);
        parameters.put("stream", stream);
        parameters.put("depth", depth);
        parameters.put("options", options);
        parameters.put("changeLists", changeLists);
        parameters.put("outputOptions", outputOptions);
        parameters.put("monitor", monitor);
        this.fireAsked("diffTwoStream", parameters);
        reference1 = (SVNEntryRevisionReference)parameters.get("reference1");
        reference2 = (SVNEntryRevisionReference)parameters.get("reference2");
        relativeToDir = (String)parameters.get("relativeToDir");
        stream = (OutputStream)parameters.get("stream");
        depth = (SVNDepth)parameters.get("depth");
        options = (Long)parameters.get("options");
        changeLists = (String[])parameters.get("changeLists");
        outputOptions = (Long)parameters.get("outputOptions");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        SVNKitService.ProgressMonitorWrapper wrapper = new SVNKitService.ProgressMonitorWrapper(this, monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                reference1 = SVNUtility.convertRevisionReference((ISVNConnector)this, (SVNEntryRevisionReference)reference1, (ISVNProgressMonitor)monitor);
                reference2 = SVNUtility.convertRevisionReference((ISVNConnector)this, (SVNEntryRevisionReference)reference2, (ISVNProgressMonitor)monitor);
                this.client.diff(reference1.path, ConversionUtility.convert(reference1.revision), reference2.path, ConversionUtility.convert(reference2.revision), relativeToDir, stream, ConversionUtility.convertDepth(depth), changeLists == null ? null : Arrays.asList(changeLists), (options & 0x200L) != 0L, (options & 0x2000L) != 0L, (options & 4L) != 0L, (options & 0x400000L) != 0L, (options & 0x40000000L) != 0L, (options & Integer.MIN_VALUE) != 0L, ConversionUtility.convertDiffOptions(outputOptions));
                this.fireSucceeded("diffTwoStream", parameters, null);
            }
            catch (ClientException ex) {
                this.handleClientException(ex, "diffTwoStream", parameters);
                wrapper.finish();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.finish();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public void diff(SVNEntryReference reference, SVNRevisionRange range, String relativeToDir, OutputStream stream, SVNDepth depth, long options, String[] changeLists, long outputOptions, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("reference", reference);
        parameters.put("range", range);
        parameters.put("relativeToDir", relativeToDir);
        parameters.put("stream", stream);
        parameters.put("depth", depth);
        parameters.put("options", options);
        parameters.put("changeLists", changeLists);
        parameters.put("outputOptions", outputOptions);
        parameters.put("monitor", monitor);
        this.fireAsked("diffStream", parameters);
        reference = (SVNEntryReference)parameters.get("reference");
        range = (SVNRevisionRange)parameters.get("range");
        relativeToDir = (String)parameters.get("relativeToDir");
        stream = (OutputStream)parameters.get("stream");
        depth = (SVNDepth)parameters.get("depth");
        options = (Long)parameters.get("options");
        changeLists = (String[])parameters.get("changeLists");
        outputOptions = (Long)parameters.get("outputOptions");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        SVNKitService.ProgressMonitorWrapper wrapper = new SVNKitService.ProgressMonitorWrapper(this, monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                this.client.diff(reference.path, ConversionUtility.convert(reference.pegRevision), ConversionUtility.convert(range.from), ConversionUtility.convert(range.to), relativeToDir, stream, ConversionUtility.convertDepth(depth), changeLists == null ? null : Arrays.asList(changeLists), (options & 0x200L) != 0L, (options & 0x2000L) != 0L, (options & 4L) != 0L, (options & 0x400000L) != 0L, (options & 0x40000000L) != 0L, (options & Integer.MIN_VALUE) != 0L, ConversionUtility.convertDiffOptions(outputOptions));
                this.fireSucceeded("diffStream", parameters, null);
            }
            catch (ClientException ex) {
                this.handleClientException(ex, "diffStream", parameters);
                wrapper.finish();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.finish();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public void diffStatusTwo(SVNEntryRevisionReference reference1, SVNEntryRevisionReference reference2, SVNDepth depth, long options, String[] changeLists, ISVNDiffStatusCallback cb, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("reference1", reference1);
        parameters.put("reference2", reference2);
        parameters.put("depth", depth);
        parameters.put("options", options);
        parameters.put("changeLists", changeLists);
        parameters.put("cb", cb);
        parameters.put("monitor", monitor);
        this.fireAsked("diffStatusTwo", parameters);
        reference1 = (SVNEntryRevisionReference)parameters.get("reference1");
        reference2 = (SVNEntryRevisionReference)parameters.get("reference2");
        depth = (SVNDepth)parameters.get("depth");
        options = (Long)parameters.get("options");
        changeLists = (String[])parameters.get("changeLists");
        cb = (ISVNDiffStatusCallback)parameters.get("cb");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        SVNEntryInfo[] infos = SVNUtility.info((ISVNConnector)this, (SVNEntryRevisionReference)reference1, (SVNDepth)SVNDepth.EMPTY, (ISVNProgressMonitor)monitor);
        boolean isFile = infos.length > 0 && infos[0] != null && infos[0].kind == SVNEntry.Kind.FILE;
        SVNKitService.ProgressMonitorWrapper wrapper = new SVNKitService.ProgressMonitorWrapper(this, monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                reference1 = SVNUtility.convertRevisionReference((ISVNConnector)this, (SVNEntryRevisionReference)reference1, (ISVNProgressMonitor)monitor);
                reference2 = SVNUtility.convertRevisionReference((ISVNConnector)this, (SVNEntryRevisionReference)reference2, (ISVNProgressMonitor)monitor);
                DiffCallback callback = new DiffCallback(reference1.path, reference2.path, isFile, cb);
                this.client.diffSummarize(reference1.path, ConversionUtility.convert(reference1.revision), reference2.path, ConversionUtility.convert(reference2.revision), ConversionUtility.convertDepth(depth), changeLists == null ? null : Arrays.asList(changeLists), (options & 0x200L) != 0L, (DiffSummaryCallback)callback);
                callback.doLastDiff();
                this.fireSucceeded("diffStatusTwo", parameters, null);
            }
            catch (ClientException ex) {
                this.handleClientException(ex, "diffStatusTwo", parameters);
                wrapper.finish();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.finish();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public void diffStatus(SVNEntryReference reference, SVNRevisionRange range, SVNDepth depth, long options, String[] changeLists, ISVNDiffStatusCallback cb, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("reference", reference);
        parameters.put("range", range);
        parameters.put("depth", depth);
        parameters.put("options", options);
        parameters.put("changeLists", changeLists);
        parameters.put("cb", cb);
        parameters.put("monitor", monitor);
        this.fireAsked("diffStatus", parameters);
        reference = (SVNEntryReference)parameters.get("reference");
        range = (SVNRevisionRange)parameters.get("range");
        depth = (SVNDepth)parameters.get("depth");
        options = (Long)parameters.get("options");
        changeLists = (String[])parameters.get("changeLists");
        cb = (ISVNDiffStatusCallback)parameters.get("cb");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        SVNEntryInfo[] infos = SVNUtility.info((ISVNConnector)this, (SVNEntryRevisionReference)new SVNEntryRevisionReference(reference, range.from), (SVNDepth)SVNDepth.EMPTY, (ISVNProgressMonitor)monitor);
        boolean isFile = infos.length > 0 && infos[0] != null && infos[0].kind == SVNEntry.Kind.FILE;
        SVNKitService.ProgressMonitorWrapper wrapper = new SVNKitService.ProgressMonitorWrapper(this, monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                DiffCallback callback = new DiffCallback(reference.path, reference.path, isFile, cb);
                this.client.diffSummarize(reference.path, ConversionUtility.convert(reference.pegRevision), ConversionUtility.convert(range.from), ConversionUtility.convert(range.to), ConversionUtility.convertDepth(depth), changeLists == null ? null : Arrays.asList(changeLists), (options & 0x200L) != 0L, (DiffSummaryCallback)callback);
                callback.doLastDiff();
                this.fireSucceeded("diffStatus", parameters, null);
            }
            catch (ClientException ex) {
                this.handleClientException(ex, "diffStatus", parameters);
                wrapper.finish();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.finish();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public void getInfo(SVNEntryRevisionReference reference, SVNDepth depth, long options, String[] changeLists, ISVNEntryInfoCallback cb, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("reference", reference);
        parameters.put("depth", depth);
        parameters.put("options", options);
        parameters.put("changeLists", changeLists);
        parameters.put("cb", cb);
        parameters.put("monitor", monitor);
        this.fireAsked("getInfo", parameters);
        reference = (SVNEntryRevisionReference)parameters.get("reference");
        depth = (SVNDepth)parameters.get("depth");
        options = (Long)parameters.get("options");
        changeLists = (String[])parameters.get("changeLists");
        cb = (ISVNEntryInfoCallback)parameters.get("cb");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        SVNKitService.ProgressMonitorWrapper wrapper = new SVNKitService.ProgressMonitorWrapper(this, monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                this.client.info2(reference.path, ConversionUtility.convert(reference.revision), ConversionUtility.convert(reference.pegRevision), ConversionUtility.convertDepth(depth), changeLists == null ? null : Arrays.asList(changeLists), ConversionUtility.convert(cb));
                this.fireSucceeded("getInfo", parameters, null);
            }
            catch (ClientException ex) {
                this.handleClientException(ex, "getInfo", parameters);
                wrapper.finish();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.finish();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public SVNProperty[] streamFileContent(SVNEntryRevisionReference reference, long options, OutputStream stream, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("reference", reference);
        parameters.put("options", options);
        parameters.put("stream", stream);
        parameters.put("monitor", monitor);
        this.fireAsked("streamFileContent", parameters);
        reference = (SVNEntryRevisionReference)parameters.get("reference");
        options = (Long)parameters.get("options");
        stream = (OutputStream)parameters.get("stream");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        SVNKitService.ProgressMonitorWrapper wrapper = new SVNKitService.ProgressMonitorWrapper(this, monitor);
        try {
            this.composite.add((ISVNNotificationCallback)wrapper);
            wrapper.start();
            this.client.streamFileContent(reference.path, ConversionUtility.convert(reference.revision), ConversionUtility.convert(reference.pegRevision), stream);
            this.fireSucceeded("streamFileContent", parameters, null);
            return null;
        }
        catch (ClientException ex) {
            this.handleClientException(ex, "streamFileContent", parameters);
        }
        finally {
            wrapper.finish();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
        return null;
    }

    public void mkdir(String[] path, String message, long options, Map revProps, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("path", path);
        parameters.put("message", message);
        parameters.put("options", options);
        parameters.put("revProps", revProps);
        parameters.put("monitor", monitor);
        this.fireAsked("mkdir", parameters);
        path = (String[])parameters.get("path");
        message = (String)parameters.get("message");
        options = (Long)parameters.get("options");
        revProps = (Map)parameters.get("revProps");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        SVNKitService.ProgressMonitorWrapper wrapper = new SVNKitService.ProgressMonitorWrapper(this, monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                this.client.mkdir(new HashSet<String>(Arrays.asList(path)), (options & 8L) != 0L, ConversionUtility.convertRevPropsToSVN(revProps), (CommitMessageCallback)new CommitMessage(message), (CommitCallback)new CommitInfo(monitor));
                this.fireSucceeded("mkdir", parameters, null);
            }
            catch (ClientException ex) {
                this.handleClientException(ex, "mkdir", parameters);
                wrapper.finish();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.finish();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public void moveLocal(String[] srcPaths, String dstPath, long options, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("srcPaths", srcPaths);
        parameters.put("dstPath", dstPath);
        parameters.put("options", options);
        parameters.put("monitor", monitor);
        this.fireAsked("moveLocal", parameters);
        srcPaths = (String[])parameters.get("srcPaths");
        dstPath = (String)parameters.get("dstPath");
        options = (Long)parameters.get("options");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        SVNKitService.ProgressMonitorWrapper wrapper = new SVNKitService.ProgressMonitorWrapper(this, monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                this.client.move(new HashSet<String>(Arrays.asList(srcPaths)), dstPath, (options & 4L) != 0L, true, false, (options & 0x8000000L) != 0L, (options & 0x10000000L) != 0L, null, null, null);
                this.fireSucceeded("moveLocal", parameters, null);
            }
            catch (ClientException ex) {
                this.handleClientException(ex, "moveLocal", parameters);
                wrapper.finish();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.finish();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public void moveRemote(String[] srcPaths, String dstPath, String message, long options, Map revProps, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("srcPaths", srcPaths);
        parameters.put("dstPath", dstPath);
        parameters.put("message", message);
        parameters.put("options", options);
        parameters.put("revProps", revProps);
        parameters.put("monitor", monitor);
        this.fireAsked("moveRemote", parameters);
        srcPaths = (String[])parameters.get("srcPaths");
        dstPath = (String)parameters.get("dstPath");
        message = (String)parameters.get("message");
        options = (Long)parameters.get("options");
        revProps = (Map)parameters.get("revProps");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        SVNKitService.ProgressMonitorWrapper wrapper = new SVNKitService.ProgressMonitorWrapper(this, monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                this.client.move(new HashSet<String>(Arrays.asList(srcPaths)), dstPath, (options & 4L) != 0L, (options & 0x8000L) != 0L, (options & 8L) != 0L, false, true, ConversionUtility.convertRevPropsToSVN(revProps), (CommitMessageCallback)new CommitMessage(message), (CommitCallback)new CommitInfo(monitor));
                this.fireSucceeded("moveRemote", parameters, null);
            }
            catch (ClientException ex) {
                this.handleClientException(ex, "moveRemote", parameters);
                wrapper.finish();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.finish();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public void copyLocal(SVNEntryRevisionReference[] srcPaths, String destPath, long options, Map<String, List<SVNExternalReference>> externalsToPin, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("srcPaths", srcPaths);
        parameters.put("destPath", destPath);
        parameters.put("options", options);
        parameters.put("externalsToPin", externalsToPin);
        parameters.put("monitor", monitor);
        this.fireAsked("copyLocal", parameters);
        srcPaths = (SVNEntryRevisionReference[])parameters.get("srcPaths");
        destPath = (String)parameters.get("destPath");
        options = (Long)parameters.get("options");
        externalsToPin = (Map)parameters.get("externalsToPin");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        SVNKitService.ProgressMonitorWrapper wrapper = new SVNKitService.ProgressMonitorWrapper(this, monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                this.client.copy(Arrays.asList(ConversionUtility.convert(srcPaths)), destPath, true, false, (options & 1L) != 0L, null, null, null);
                this.fireSucceeded("copyLocal", parameters, null);
            }
            catch (ClientException ex) {
                this.handleClientException(ex, "copyLocal", parameters);
                wrapper.finish();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.finish();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public void copyRemote(SVNEntryRevisionReference[] srcPaths, String destPath, String message, long options, Map revProps, Map<String, List<SVNExternalReference>> externalsToPin, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("srcPaths", srcPaths);
        parameters.put("destPath", destPath);
        parameters.put("message", message);
        parameters.put("options", options);
        parameters.put("revProps", revProps);
        parameters.put("externalsToPin", externalsToPin);
        parameters.put("monitor", monitor);
        this.fireAsked("copyRemote", parameters);
        srcPaths = (SVNEntryRevisionReference[])parameters.get("srcPaths");
        destPath = (String)parameters.get("destPath");
        message = (String)parameters.get("message");
        options = (Long)parameters.get("options");
        revProps = (Map)parameters.get("revProps");
        externalsToPin = (Map)parameters.get("externalsToPin");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        SVNKitService.ProgressMonitorWrapper wrapper = new SVNKitService.ProgressMonitorWrapper(this, monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                this.client.copy(Arrays.asList(ConversionUtility.convert(srcPaths)), destPath, (options & 0x8000L) != 0L, (options & 8L) != 0L, false, ConversionUtility.convertRevPropsToSVN(revProps), (CommitMessageCallback)new CommitMessage(message), (CommitCallback)new CommitInfo(monitor));
                this.fireSucceeded("copyRemote", parameters, null);
            }
            catch (ClientException ex) {
                this.handleClientException(ex, "copyRemote", parameters);
                wrapper.finish();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.finish();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public void removeRemote(String[] path, String message, long options, Map revProps, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("path", path);
        parameters.put("message", message);
        parameters.put("options", options);
        parameters.put("revProps", revProps);
        parameters.put("monitor", monitor);
        this.fireAsked("removeRemote", parameters);
        path = (String[])parameters.get("path");
        message = (String)parameters.get("message");
        options = (Long)parameters.get("options");
        revProps = (Map)parameters.get("revProps");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        SVNKitService.ProgressMonitorWrapper wrapper = new SVNKitService.ProgressMonitorWrapper(this, monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                this.client.remove(new HashSet<String>(Arrays.asList(path)), (options & 4L) != 0L, false, ConversionUtility.convertRevPropsToSVN(revProps), (CommitMessageCallback)new CommitMessage(message), (CommitCallback)new CommitInfo(monitor));
                this.fireSucceeded("removeRemote", parameters, null);
            }
            catch (ClientException ex) {
                this.handleClientException(ex, "removeRemote", parameters);
                wrapper.finish();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.finish();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public void removeLocal(String[] path, long options, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("path", path);
        parameters.put("options", options);
        parameters.put("monitor", monitor);
        this.fireAsked("removeLocal", parameters);
        path = (String[])parameters.get("path");
        options = (Long)parameters.get("options");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        SVNKitService.ProgressMonitorWrapper wrapper = new SVNKitService.ProgressMonitorWrapper(this, monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                this.client.remove(new HashSet<String>(Arrays.asList(path)), (options & 4L) != 0L, (options & 0x10000L) != 0L, null, null, null);
                this.fireSucceeded("removeLocal", parameters, null);
            }
            catch (ClientException ex) {
                this.handleClientException(ex, "removeLocal", parameters);
                wrapper.finish();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.finish();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public void listHistoryLog(SVNEntryReference reference, SVNRevisionRange[] revisionRanges, String[] revProps, long limit, long options, ISVNLogEntryCallback cb, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("reference", reference);
        parameters.put("revisionRanges", revisionRanges);
        parameters.put("revProps", revProps);
        parameters.put("limit", limit);
        parameters.put("options", options);
        parameters.put("cb", cb);
        parameters.put("monitor", monitor);
        this.fireAsked("listHistoryLog", parameters);
        reference = (SVNEntryReference)parameters.get("reference");
        revisionRanges = (SVNRevisionRange[])parameters.get("revisionRanges");
        revProps = (String[])parameters.get("revProps");
        limit = (Long)parameters.get("limit");
        options = (Long)parameters.get("options");
        cb = (ISVNLogEntryCallback)parameters.get("cb");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        SVNKitService.ProgressMonitorWrapper wrapper = new SVNKitService.ProgressMonitorWrapper(this, monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                this.client.logMessages(reference.path, ConversionUtility.convert(reference.pegRevision), Arrays.asList(ConversionUtility.convert(revisionRanges)), (options & 0x20000L) != 0L, (options & 0x40000L) != 0L, (options & 0x80000L) != 0L, new HashSet<String>(Arrays.asList(revProps)), limit, ConversionUtility.convert(cb));
                this.fireSucceeded("listHistoryLog", parameters, null);
            }
            catch (ClientException ex) {
                this.handleClientException(ex, "listHistoryLog", parameters);
                wrapper.finish();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.finish();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public void annotate(SVNEntryReference reference, SVNRevisionRange revisionRange, long options, long diffOptions, ISVNAnnotationCallback callback, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("reference", reference);
        parameters.put("revisionRange", revisionRange);
        parameters.put("options", options);
        parameters.put("diffOptions", diffOptions);
        parameters.put("callback", callback);
        parameters.put("monitor", monitor);
        this.fireAsked("annotate", parameters);
        reference = (SVNEntryReference)parameters.get("reference");
        revisionRange = (SVNRevisionRange)parameters.get("revisionRange");
        options = (Long)parameters.get("options");
        diffOptions = (Long)parameters.get("diffOptions");
        callback = (ISVNAnnotationCallback)parameters.get("callback");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        SVNKitService.ProgressMonitorWrapper wrapper = new SVNKitService.ProgressMonitorWrapper(this, monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                this.client.blame(reference.path, ConversionUtility.convert(reference.pegRevision), ConversionUtility.convert(revisionRange.from), ConversionUtility.convert(revisionRange.to), (options & 0x100000L) != 0L, (options & 0x80000L) != 0L, ConversionUtility.convert(callback));
                this.fireSucceeded("annotate", parameters, null);
            }
            catch (ClientException ex) {
                this.handleClientException(ex, "annotate", parameters);
                wrapper.finish();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.finish();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public void listEntries(SVNEntryRevisionReference reference, SVNDepth depth, int direntFields, long options, ISVNEntryCallback cb, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("reference", reference);
        parameters.put("depth", depth);
        parameters.put("direntFields", direntFields);
        parameters.put("options", options);
        parameters.put("cb", cb);
        parameters.put("monitor", monitor);
        this.fireAsked("list", parameters);
        reference = (SVNEntryRevisionReference)parameters.get("reference");
        depth = (SVNDepth)parameters.get("depth");
        direntFields = (Integer)parameters.get("direntFields");
        options = (Long)parameters.get("options");
        final ISVNEntryCallback cb1 = (ISVNEntryCallback)parameters.get("cb");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        SVNKitService.ProgressMonitorWrapper wrapper = new SVNKitService.ProgressMonitorWrapper(this, monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                this.client.list(reference.path, ConversionUtility.convert(reference.revision), ConversionUtility.convert(reference.pegRevision), ConversionUtility.convertDepth(depth), direntFields, (options & 0x200000L) != 0L, new ListCallback(){

                    public void doEntry(DirEntry dirent, Lock lock) {
                        String path = dirent.getPath();
                        if (path != null && path.length() != 0 || dirent.getNodeKind() == NodeKind.file) {
                            Date date = dirent.getLastChanged();
                            cb1.next(new SVNEntry(path, dirent.getLastChangedRevisionNumber(), date == null ? 0L : date.getTime(), dirent.getLastAuthor(), dirent.getHasProps(), ConversionUtility.convert(dirent.getNodeKind()), dirent.getSize(), ConversionUtility.convert(lock)));
                        }
                    }
                });
                this.fireSucceeded("list", parameters, null);
            }
            catch (ClientException ex) {
                this.handleClientException(ex, "list", parameters);
                wrapper.finish();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.finish();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public void listProperties(SVNEntryRevisionReference reference, SVNDepth depth, String[] changeLists, long options, ISVNPropertyCallback callback, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("reference", reference);
        parameters.put("depth", depth);
        parameters.put("changeLists", changeLists);
        parameters.put("callback", callback);
        parameters.put("monitor", monitor);
        this.fireAsked("getProperties", parameters);
        reference = (SVNEntryRevisionReference)parameters.get("reference");
        depth = (SVNDepth)parameters.get("depth");
        changeLists = (String[])parameters.get("changeLists");
        callback = (ISVNPropertyCallback)parameters.get("callback");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        SVNKitService.ProgressMonitorWrapper wrapper = new SVNKitService.ProgressMonitorWrapper(this, monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                if ((options & 0x100000000L) != 0L) {
                    this.client.properties(reference.path, ConversionUtility.convert(reference.revision), ConversionUtility.convert(reference.pegRevision), ConversionUtility.convertDepth(depth), changeLists == null ? null : Arrays.asList(changeLists), ConversionUtility.convertInherited(callback));
                } else {
                    this.client.properties(reference.path, ConversionUtility.convert(reference.revision), ConversionUtility.convert(reference.pegRevision), ConversionUtility.convertDepth(depth), changeLists == null ? null : Arrays.asList(changeLists), ConversionUtility.convert(callback));
                }
                this.fireSucceeded("getProperties", parameters, null);
            }
            catch (ClientException ex) {
                this.handleClientException(ex, "getProperties", parameters);
                wrapper.finish();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.finish();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public SVNProperty getProperty(SVNEntryRevisionReference reference, String name, String[] changeLists, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("reference", reference);
        parameters.put("name", name);
        parameters.put("changeLists", changeLists);
        parameters.put("monitor", monitor);
        this.fireAsked("getProperty", parameters);
        reference = (SVNEntryRevisionReference)parameters.get("reference");
        name = (String)parameters.get("name");
        changeLists = (String[])parameters.get("changeLists");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        SVNKitService.ProgressMonitorWrapper wrapper = new SVNKitService.ProgressMonitorWrapper(this, monitor);
        try {
            this.composite.add((ISVNNotificationCallback)wrapper);
            wrapper.start();
            byte[] data = this.client.propertyGet(reference.path, name, ConversionUtility.convert(reference.revision), ConversionUtility.convert(reference.pegRevision), changeLists == null ? null : Arrays.asList(changeLists));
            SVNProperty retVal = data != null ? new SVNProperty(name, data) : null;
            this.fireSucceeded("getProperty", parameters, retVal);
            SVNProperty sVNProperty = retVal;
            return sVNProperty;
        }
        catch (ClientException ex) {
            this.handleClientException(ex, "getProperty", parameters);
        }
        finally {
            wrapper.finish();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
        return null;
    }

    public void setPropertyLocal(String[] path, SVNProperty property, SVNDepth depth, long options, String[] changeLists, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("path", path);
        parameters.put("property", property);
        parameters.put("depth", depth);
        parameters.put("options", options);
        parameters.put("changeLists", changeLists);
        parameters.put("monitor", monitor);
        this.fireAsked("setPropertyLocal", parameters);
        path = (String[])parameters.get("path");
        property = (SVNProperty)parameters.get("property");
        depth = (SVNDepth)parameters.get("depth");
        options = (Long)parameters.get("options");
        changeLists = (String[])parameters.get("changeLists");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        SVNKitService.ProgressMonitorWrapper wrapper = new SVNKitService.ProgressMonitorWrapper(this, monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                this.client.propertySetLocal(new HashSet<String>(Arrays.asList(path)), property.name, property.binValue, ConversionUtility.convertDepth(depth), changeLists == null ? null : Arrays.asList(changeLists), (options & 4L) != 0L);
                this.fireSucceeded("setPropertyLocal", parameters, null);
            }
            catch (ClientException ex) {
                this.handleClientException(ex, "setPropertyLocal", parameters);
                wrapper.finish();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.finish();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public void setPropertyRemote(SVNEntryReference reference, SVNProperty property, String message, long options, Map revProps, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("reference", reference);
        parameters.put("property", property);
        parameters.put("message", message);
        parameters.put("options", options);
        parameters.put("revProps", revProps);
        parameters.put("monitor", monitor);
        this.fireAsked("setPropertyRemote", parameters);
        reference = (SVNEntryReference)parameters.get("reference");
        property = (SVNProperty)parameters.get("property");
        message = (String)parameters.get("message");
        options = (Long)parameters.get("options");
        revProps = (Map)parameters.get("revProps");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        SVNKitService.ProgressMonitorWrapper wrapper = new SVNKitService.ProgressMonitorWrapper(this, monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                this.client.propertySetRemote(reference.path, ((SVNRevision.Number)reference.pegRevision).getNumber(), property.name, property.binValue, (CommitMessageCallback)new CommitMessage(message), (options & 4L) != 0L, ConversionUtility.convertRevPropsToSVN(revProps), (CommitCallback)new CommitInfo(monitor));
                this.fireSucceeded("setPropertyRemote", parameters, null);
            }
            catch (ClientException ex) {
                this.handleClientException(ex, "setPropertyRemote", parameters);
                wrapper.finish();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.finish();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public SVNProperty[] listRevisionProperties(SVNEntryReference reference, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("reference", reference);
        parameters.put("monitor", monitor);
        this.fireAsked("listRevisionProperties", parameters);
        reference = (SVNEntryReference)parameters.get("reference");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        SVNKitService.ProgressMonitorWrapper wrapper = new SVNKitService.ProgressMonitorWrapper(this, monitor);
        try {
            this.composite.add((ISVNNotificationCallback)wrapper);
            wrapper.start();
            SVNProperty[] retVal = ConversionUtility.convertRevProps(this.client.revProperties(reference.path, ConversionUtility.convert(reference.pegRevision)));
            this.fireSucceeded("listRevisionProperties", parameters, retVal);
            SVNProperty[] sVNPropertyArray = retVal;
            return sVNPropertyArray;
        }
        catch (ClientException ex) {
            this.handleClientException(ex, "listRevisionProperties", parameters);
        }
        finally {
            wrapper.finish();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
        return null;
    }

    public SVNProperty getRevisionProperty(SVNEntryReference reference, String name, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("reference", reference);
        parameters.put("name", name);
        parameters.put("monitor", monitor);
        this.fireAsked("getRevisionProperty", parameters);
        reference = (SVNEntryReference)parameters.get("reference");
        name = (String)parameters.get("name");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        SVNKitService.ProgressMonitorWrapper wrapper = new SVNKitService.ProgressMonitorWrapper(this, monitor);
        try {
            this.composite.add((ISVNNotificationCallback)wrapper);
            wrapper.start();
            SVNProperty retVal = new SVNProperty(name, this.client.revProperty(reference.path, name, ConversionUtility.convert(reference.pegRevision)));
            this.fireSucceeded("getRevisionProperty", parameters, retVal);
            SVNProperty sVNProperty = retVal;
            return sVNProperty;
        }
        catch (ClientException ex) {
            this.handleClientException(ex, "getRevisionProperty", parameters);
        }
        finally {
            wrapper.finish();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
        return null;
    }

    public void setRevisionProperty(SVNEntryReference reference, SVNProperty property, String originalValue, long options, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("reference", reference);
        parameters.put("property", property);
        parameters.put("originalValue", originalValue);
        parameters.put("options", options);
        parameters.put("monitor", monitor);
        this.fireAsked("setRevisionProperty", parameters);
        reference = (SVNEntryReference)parameters.get("reference");
        property = (SVNProperty)parameters.get("property");
        originalValue = (String)parameters.get("originalValue");
        options = (Long)parameters.get("options");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        SVNKitService.ProgressMonitorWrapper wrapper = new SVNKitService.ProgressMonitorWrapper(this, monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                this.client.setRevProperty(reference.path, property.name, ConversionUtility.convert(reference.pegRevision), property.value, originalValue, (options & 4L) != 0L);
                this.fireSucceeded("setRevisionProperty", parameters, null);
            }
            catch (ClientException ex) {
                this.handleClientException(ex, "setRevisionProperty", parameters);
                wrapper.finish();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.finish();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public void upgrade(String path, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("path", path);
        parameters.put("monitor", monitor);
        this.fireAsked("upgrade", parameters);
        path = (String)parameters.get("path");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        SVNKitService.ProgressMonitorWrapper wrapper = new SVNKitService.ProgressMonitorWrapper(this, monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                this.client.upgrade(path);
                this.fireSucceeded("upgrade", parameters, null);
            }
            catch (ClientException ex) {
                this.handleClientException(ex, "upgrade", parameters);
                wrapper.finish();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.finish();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public void patch(String patchPath, String targetPath, int stripCount, long options, ISVNPatchCallback callback, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("patchPath", patchPath);
        parameters.put("targetPath", targetPath);
        parameters.put("stripCount", stripCount);
        parameters.put("options", options);
        parameters.put("callback", callback);
        parameters.put("monitor", monitor);
        this.fireAsked("patch", parameters);
        patchPath = (String)parameters.get("patchPath");
        targetPath = (String)parameters.get("targetPath");
        stripCount = (Integer)parameters.get("stripCount");
        options = (Long)parameters.get("options");
        callback = (ISVNPatchCallback)parameters.get("callback");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        SVNKitService.ProgressMonitorWrapper wrapper = new SVNKitService.ProgressMonitorWrapper(this, monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                this.client.patch(patchPath, targetPath, (options & 0x400L) != 0L, stripCount, (options & 0x800000L) != 0L, (options & 0x1000000L) != 0L, (options & 0x2000000L) != 0L, ConversionUtility.convert(callback));
                this.fireSucceeded("patch", parameters, null);
            }
            catch (ClientException ex) {
                this.handleClientException(ex, "patch", parameters);
                wrapper.finish();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.finish();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public void vacuum(String path, long options, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("path", path);
        parameters.put("options", options);
        parameters.put("monitor", monitor);
        this.fireAsked("vacuum", parameters);
        path = (String)parameters.get("path");
        options = (Long)parameters.get("options");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        this.fireSucceeded("vacuum", parameters, null);
    }

    public void dispose() {
        this.client.dispose();
    }

    @Override
    protected void cancelOperation() throws Exception {
        this.client.cancelOperation();
    }

    private static String collapsePaths(String lPath, String rPath) {
        String res = "";
        res = SVNKitConnector.basename(lPath).equals(SVNKitConnector.rootdirname(rPath)) ? String.valueOf(SVNKitConnector.dirname(lPath)) + "/" + rPath : String.valueOf(lPath) + "/" + rPath;
        return res;
    }

    private static String basename(String path) {
        int lastSepIndex = path.lastIndexOf(47);
        if (lastSepIndex != -1) {
            return path.substring(lastSepIndex + 1);
        }
        return path;
    }

    private static String dirname(String path) {
        int lastSepIndex = path.lastIndexOf(47);
        if (lastSepIndex != -1) {
            return path.substring(0, lastSepIndex);
        }
        return path;
    }

    private static String rootdirname(String path) {
        int firstSepIndex = path.indexOf(47);
        if (firstSepIndex != -1) {
            return path.substring(0, firstSepIndex);
        }
        return path;
    }

    protected class CommitInfo
    implements CommitCallback {
        public org.apache.subversion.javahl.CommitInfo info;
        private ISVNProgressMonitor monitor;

        public CommitInfo(ISVNProgressMonitor monitor) {
            this.monitor = monitor;
        }

        public void commitInfo(org.apache.subversion.javahl.CommitInfo info) {
            this.info = info;
            this.monitor.commitStatus(ConversionUtility.convert(info));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class CommitMessage
    implements CommitMessageCallback {
        private String message;

        public CommitMessage(String message) {
            this.message = message == null ? "" : message;
        }

        public String getLogMessage(Set<CommitItem> elementsToBeCommitted) {
            return this.message;
        }
    }

    private class DiffCallback
    implements DiffSummaryCallback {
        private String prev;
        private String next;
        private boolean isFile;
        private SVNDiffStatus savedDiff;
        private ISVNDiffStatusCallback cb;

        public DiffCallback(String prev, String next, boolean isFile, ISVNDiffStatusCallback cb) {
            this.prev = SVNUtility.decodeURL((String)prev);
            this.next = SVNUtility.decodeURL((String)next);
            this.isFile = isFile;
            this.cb = cb;
        }

        public void onSummary(DiffSummary descriptor) {
            SVNEntryStatus.Kind propChangeType;
            SVNEntryStatus.Kind changeType = SVNEntryStatus.Kind.NORMAL;
            if (descriptor.getDiffKind() == DiffSummary.DiffKind.added) {
                changeType = SVNEntryStatus.Kind.ADDED;
            } else if (descriptor.getDiffKind() == DiffSummary.DiffKind.deleted) {
                changeType = SVNEntryStatus.Kind.DELETED;
            } else if (descriptor.getDiffKind() == DiffSummary.DiffKind.modified) {
                changeType = SVNEntryStatus.Kind.MODIFIED;
            }
            SVNEntryStatus.Kind kind = propChangeType = descriptor.propsChanged() ? SVNEntryStatus.Kind.MODIFIED : SVNEntryStatus.Kind.NORMAL;
            if (changeType != SVNEntryStatus.Kind.NORMAL || propChangeType != SVNEntryStatus.Kind.NORMAL) {
                String tPath1;
                String tPath2 = tPath1 = descriptor.getPath();
                if (tPath1.length() == 0 || this.isFile) {
                    tPath1 = this.prev;
                    tPath2 = this.next;
                } else {
                    tPath1 = SVNKitConnector.collapsePaths(this.prev, tPath1);
                    tPath2 = SVNKitConnector.collapsePaths(this.next, tPath2);
                }
                SVNDiffStatus status = new SVNDiffStatus(SVNUtility.encodeURL((String)tPath1), SVNUtility.encodeURL((String)tPath2), ConversionUtility.convert(descriptor.getNodeKind()), changeType, propChangeType);
                if (this.savedDiff != null) {
                    if (this.savedDiff.pathPrev.equals(status.pathPrev) && this.savedDiff.pathNext.equals(status.pathNext) && this.savedDiff.textStatus == SVNEntryStatus.Kind.DELETED && status.textStatus == SVNEntryStatus.Kind.ADDED) {
                        this.savedDiff = new SVNDiffStatus(SVNUtility.encodeURL((String)tPath1), SVNUtility.encodeURL((String)tPath2), ConversionUtility.convert(descriptor.getNodeKind()), SVNEntryStatus.Kind.REPLACED, SVNEntryStatus.Kind.NORMAL);
                        status = null;
                    }
                    this.cb.next(this.savedDiff);
                }
                this.savedDiff = status;
            }
        }

        public void doLastDiff() {
            if (this.savedDiff != null) {
                this.cb.next(this.savedDiff);
            }
        }
    }

    protected class RepositoryInfoPrompt
    implements UserPasswordSSHCallback,
    UserPasswordSSLCallback,
    UserPasswordProxyCallback {
        protected ISVNCredentialsPrompt prompt;

        public RepositoryInfoPrompt(ISVNCredentialsPrompt prompt) {
            this.prompt = prompt;
        }

        public boolean prompt(String realm, String username) {
            return this.prompt.prompt(null, realm);
        }

        public boolean prompt(String realm, String username, boolean maySave) {
            return this.prompt.prompt(null, realm);
        }

        public int askTrustSSLServer(String info, boolean allowPermanently) {
            SSLServerCertificateInfo certInfo;
            try {
                certInfo = SVNUtility.decodeCertificateData((Map)SVNUtility.splitCertificateString((String)info));
            }
            catch (ParseException parseException) {
                certInfo = new SSLServerCertificateInfo("", "", 0L, 0L, new byte[0], Arrays.asList(""), null);
            }
            return this.prompt.askTrustSSLServer(null, (SSLServerCertificateFailures)new SSLServerCertificateFailures((int)0x40000000), (SSLServerCertificateInfo)certInfo, (boolean)allowPermanently).id;
        }

        public String getUsername() {
            return this.prompt.getUsername();
        }

        public String getPassword() {
            return this.prompt.getPassword();
        }

        public boolean askYesNo(String realm, String question, boolean yesIsDefault) {
            return true;
        }

        public String askQuestion(String realm, String question, boolean showAnswer, boolean maySave) {
            return null;
        }

        public String askQuestion(String realm, String question, boolean showAnswer) {
            return null;
        }

        public boolean userAllowedSave() {
            return false;
        }

        public boolean promptProxy(String url, boolean maySave) {
            return this.prompt.promptProxy(null);
        }

        public String getProxyHost() {
            return this.prompt.getProxyHost();
        }

        public int getProxyPort() {
            return this.prompt.getProxyPort();
        }

        public String getProxyUserName() {
            return this.prompt.getProxyUserName();
        }

        public String getProxyPassword() {
            return this.prompt.getProxyPassword();
        }

        public boolean promptSSL(String realm, boolean maySave) {
            return this.prompt.promptSSL(null, realm);
        }

        public String getSSLClientCertPath() {
            return this.prompt.getSSLClientCertPath();
        }

        public String getSSLClientCertPassword() {
            return this.prompt.getSSLClientCertPassword();
        }

        public boolean promptSSH(String realm, String username, int sshPort, boolean maySave) {
            return this.prompt.promptSSH(null, realm);
        }

        public String getSSHPrivateKeyPath() {
            return this.prompt.getSSHPrivateKeyPath();
        }

        public String getSSHPrivateKeyPassphrase() {
            return this.prompt.getSSHPrivateKeyPassphrase();
        }

        public int getSSHPort() {
            return this.prompt.getSSHPort();
        }
    }
}

