/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.tools.internal.ui.wizards;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;
import tern.eclipse.ide.tools.core.generator.IGenerator;
import tern.eclipse.ide.tools.internal.ui.TernToolsUIMessages;
import tern.eclipse.ide.tools.internal.ui.wizards.TernWizardPage;

public abstract class NewFileWizardPage<T>
extends TernWizardPage<T> {
    private final String fileExtension;
    private Text containerText;
    private Text fileText;

    public NewFileWizardPage(String pageName, String fileExtension) {
        super(pageName);
        this.fileExtension = fileExtension;
    }

    @Override
    protected Composite createUI(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 3;
        layout.verticalSpacing = 9;
        this.createBody(container);
        return container;
    }

    protected void createBody(Composite container) {
        Label label = new Label(container, 0);
        label.setText(TernToolsUIMessages.NewFileWizardPage_container_text);
        this.containerText = this.createFileText(container);
        GridData gd = new GridData(768);
        this.containerText.setLayoutData((Object)gd);
        this.containerText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewFileWizardPage.this.dialogChanged();
            }
        });
        Button button = new Button(container, 8);
        button.setText(TernToolsUIMessages.Button_browse);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewFileWizardPage.this.handleBrowse();
            }
        });
        label = new Label(container, 0);
        label.setText(TernToolsUIMessages.NewFileWizardPage_fileName_text);
        this.fileText = this.createFileText(container);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.fileText.setLayoutData((Object)gd);
        this.fileText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewFileWizardPage.this.dialogChanged();
            }
        });
    }

    protected Text createFileText(Composite parent) {
        return new Text(parent, 2052);
    }

    @Override
    protected void initialize() {
        IResource resource = this.getResource();
        if (resource != null) {
            IContainer container = null;
            container = resource instanceof IContainer ? (IContainer)resource : resource.getParent();
            this.containerText.setText(container.getFullPath().toString());
        }
    }

    private void handleBrowse() {
        Object[] result;
        ContainerSelectionDialog dialog = new ContainerSelectionDialog(this.getShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), false, "Select new file container");
        if (dialog.open() == 0 && (result = dialog.getResult()).length == 1) {
            this.containerText.setText(((Path)result[0]).toString());
        }
    }

    @Override
    protected String validate() {
        String ext;
        IResource container = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(this.getContainerName()));
        String fileName = this.getFileName();
        if (this.getContainerName().length() == 0) {
            return "File container must be specified";
        }
        if (container == null || (container.getType() & 6) == 0) {
            return "File container must exist";
        }
        if (!container.isAccessible()) {
            return "Project must be writable";
        }
        if (fileName.length() == 0) {
            return "File name must be specified";
        }
        if (fileName.replace('\\', '/').indexOf(47, 1) > 0) {
            return "File name must be valid";
        }
        int dotLoc = fileName.lastIndexOf(46);
        if (dotLoc != -1 && !(ext = fileName.substring(dotLoc + 1)).equalsIgnoreCase(this.fileExtension)) {
            return "File extension must be \"" + this.fileExtension + "\"";
        }
        return null;
    }

    public String getContainerName() {
        return this.containerText.getText();
    }

    public String getFileName() {
        return this.fileText.getText();
    }

    protected Text getFileText() {
        return this.fileText;
    }

    public String getFileExtension() {
        return this.fileExtension;
    }

    public abstract IGenerator getGenerator(String var1);
}

