/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.tools.internal.ui.wizards;

import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import tern.eclipse.ide.tools.internal.ui.wizards.ITernWizardPage;

public abstract class TernWizardPage<T>
extends WizardPage
implements ITernWizardPage<T> {
    private T model;
    private ISelection selection;

    protected TernWizardPage(String pageName) {
        super(pageName);
    }

    @Override
    public void setModel(T model) {
        this.model = model;
    }

    public T getModel() {
        return this.model;
    }

    @Override
    public void setSelection(ISelection selection) {
        this.selection = selection;
    }

    public ISelection getSelection() {
        return this.selection;
    }

    protected IResource getResource() {
        if (this.selection != null && !this.selection.isEmpty() && this.selection instanceof IStructuredSelection) {
            IStructuredSelection ssel = (IStructuredSelection)this.selection;
            if (ssel.size() > 1) {
                return null;
            }
            Object obj = ssel.getFirstElement();
            if (obj instanceof IResource) {
                return (IResource)obj;
            }
        }
        return null;
    }

    public final void createControl(Composite parent) {
        Composite container = this.createUI(parent);
        this.initialize();
        this.dialogChanged();
        this.setControl((Control)container);
    }

    protected void initialize() {
    }

    protected void dialogChanged() {
        String message = this.validate();
        this.updateStatus(message);
        if (message == null) {
            this.updateModel(this.model);
        }
    }

    private void updateStatus(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    protected abstract Composite createUI(Composite var1);

    protected abstract String validate();

    protected abstract void updateModel(T var1);
}

