/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.ui.handlers;

import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.handlers.HandlerUtil;
import tern.EcmaVersion;
import tern.ITernProject;
import tern.eclipse.ide.core.IIDETernProject;
import tern.eclipse.ide.core.TernCorePlugin;
import tern.eclipse.ide.core.preferences.TernCorePreferenceConstants;
import tern.eclipse.ide.internal.ui.Trace;
import tern.eclipse.ide.ui.TernUIPlugin;
import tern.server.ITernModule;
import tern.utils.TernModuleHelper;

public abstract class AbstractConvertProjectCommandHandler
extends AbstractHandler {
    private IPreferencesService fPreferenceService = Platform.getPreferencesService();

    private void doInstall(IProject project, IProgressMonitor monitor, ExecutionEvent event) throws CoreException {
        boolean force = !TernCorePlugin.hasTernNature((IProject)project);
        IIDETernProject ternProject = TernCorePlugin.getTernProject((IProject)project, (boolean)force);
        IScopeContext[] context = new IScopeContext[]{InstanceScope.INSTANCE, DefaultScope.INSTANCE};
        EcmaVersion ecmaVersion = this.getEcmaVersion(context);
        ternProject.setEcmaVersion(ecmaVersion);
        ITernModule[] modules = this.getModules(context);
        int i = 0;
        while (i < modules.length) {
            TernModuleHelper.update((ITernModule)modules[i], (ITernProject)ternProject);
            ++i;
        }
        this.showPropertiesOn(project, monitor, event);
        try {
            ternProject.save();
        }
        catch (IOException e) {
            Trace.trace((byte)3, "Error while configuring tern nature.", e);
        }
    }

    private void doUninstall(IProject project, IProgressMonitor monitor) {
    }

    public Object execute(final ExecutionEvent event) throws ExecutionException {
        final IProject project = this.getSelectedProject(event);
        if (project == null) {
            return null;
        }
        WorkspaceJob convertJob = new WorkspaceJob(this.getConvertingProjectJobTitle(project)){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                AbstractConvertProjectCommandHandler.this.doInstall(project, monitor, event);
                return Status.OK_STATUS;
            }
        };
        convertJob.setUser(true);
        convertJob.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        convertJob.schedule();
        return null;
    }

    private IProject getSelectedProject(ExecutionEvent event) {
        ISelection currentSelection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (currentSelection instanceof IStructuredSelection) {
            Object element = ((IStructuredSelection)currentSelection).getFirstElement();
            return (IProject)Platform.getAdapterManager().getAdapter(element, IProject.class);
        }
        return null;
    }

    private void showPropertiesOn(final IProject project, final IProgressMonitor monitor, ExecutionEvent event) {
        Shell finalShell;
        IWorkbenchWindow activeWorkbenchWindow;
        IExtension[] extensions = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.ui.propertyPages").getExtensions();
        final ArrayList<String> pageIds = new ArrayList<String>(8);
        int i = 0;
        while (i < extensions.length) {
            if (extensions[i].getNamespaceIdentifier().startsWith("tern.eclipse.ide.ui")) {
                IConfigurationElement[] configurationElements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < configurationElements.length) {
                    if ("page".equals(configurationElements[j].getName())) {
                        pageIds.add(configurationElements[j].getAttribute("id"));
                    }
                    ++j;
                }
            }
            ++i;
        }
        Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        if (shell == null && (activeWorkbenchWindow = TernUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow()) != null) {
            shell = activeWorkbenchWindow.getShell();
        }
        if ((finalShell = shell) != null) {
            finalShell.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    PreferenceDialog dialog = PreferencesUtil.createPropertyDialogOn((Shell)finalShell, (IAdaptable)project, (String)"tern.eclipse.ide.ui.properties.modules", (String[])pageIds.toArray(new String[pageIds.size()]), null);
                    if (dialog.open() == 1) {
                        AbstractConvertProjectCommandHandler.this.doUninstall(project, monitor);
                    }
                }
            });
        }
    }

    protected EcmaVersion getEcmaVersion(IScopeContext[] context) {
        int version = this.fPreferenceService.getInt(TernCorePlugin.getDefault().getBundle().getSymbolicName(), "ecmaVersion", TernCorePreferenceConstants.DEFAULT_ECMA_VERSION_VALUE, context);
        return EcmaVersion.get((int)version);
    }

    protected ITernModule[] getModules(IScopeContext[] context) {
        String moduleNames = this.fPreferenceService.getString(TernCorePlugin.getDefault().getBundle().getSymbolicName(), "defaultTernModules", TernCorePreferenceConstants.DEFAULT_TERN_MODULES_VALUE, context);
        return TernCorePlugin.getTernRepositoryManager().getTernModules(moduleNames, null);
    }

    protected abstract String getConvertingProjectJobTitle(IProject var1);
}

