/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.ui.hyperlink;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import tern.eclipse.ide.core.IIDETernProject;
import tern.eclipse.ide.ui.utils.EditorUtils;
import tern.server.protocol.ITernResultsAsyncCollector;
import tern.server.protocol.definition.ITernDefinitionCollector;
import tern.utils.StringUtils;

public abstract class AbstractTernHyperlink
implements IHyperlink,
ITernDefinitionCollector,
ITernResultsAsyncCollector {
    protected final IRegion region;
    protected final IIDETernProject ternProject;
    private IFile file;
    private Long start;
    private Long end;

    public AbstractTernHyperlink(IRegion region, IIDETernProject ternProject) {
        this.region = region;
        this.ternProject = ternProject;
    }

    public IRegion getHyperlinkRegion() {
        return this.region;
    }

    public void setDefinition(String filename, Long start, Long end) {
        this.file = this.findFile(filename);
        this.start = start;
        this.end = end;
    }

    private IFile findFile(String filename) {
        if (StringUtils.isEmpty((String)filename)) {
            return null;
        }
        return this.ternProject.getIDEFile(filename);
    }

    public final void open() {
        IFile file = this.getFile();
        Long start = this.getStart();
        Long end = this.getEnd();
        if (file != null && file.exists()) {
            EditorUtils.openInEditor(file, start != null ? start.intValue() : -1, start != null && end != null ? end.intValue() - start.intValue() : -1, true);
        }
    }

    public boolean isValid() {
        try {
            this.findDef();
        }
        catch (Exception exception) {
            return false;
        }
        return this.file != null && this.file.exists();
    }

    public IFile getFile() {
        return this.file;
    }

    public Long getStart() {
        return this.start;
    }

    public Long getEnd() {
        return this.end;
    }

    public void timeout(ITernResultsAsyncCollector.TimeoutReason reason) {
    }

    public void done() {
    }

    public String getRequestDisplayName() {
        return "Searching definition...";
    }

    protected abstract void findDef() throws Exception;
}

