/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.ui.preferences;

import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public abstract class ComboViewerFieldEditor
extends FieldEditor {
    private ComboViewer viewer;
    private Object selectedValue;
    private boolean isValid = true;

    public ComboViewerFieldEditor(String name, String labelText, Composite parent) {
        this.init(name, labelText);
        this.createControl(parent);
        this.setContentProvider((IStructuredContentProvider)ArrayContentProvider.getInstance());
    }

    protected void adjustForNumColumns(int numColumns) {
        Combo combo = this.viewer.getCombo();
        if (numColumns > 1) {
            Label control = this.getLabelControl();
            int left = numColumns;
            if (control != null) {
                ((GridData)control.getLayoutData()).horizontalSpan = 1;
                --left;
            }
            ((GridData)combo.getLayoutData()).horizontalSpan = left;
        } else {
            Label control = this.getLabelControl();
            if (control != null) {
                ((GridData)control.getLayoutData()).horizontalSpan = 1;
            }
            ((GridData)combo.getLayoutData()).horizontalSpan = 1;
        }
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        int comboC = 1;
        if (numColumns > 1) {
            comboC = numColumns - 1;
        }
        Label control = this.getLabelControl(parent);
        GridData gd = new GridData();
        gd.horizontalSpan = 1;
        control.setLayoutData((Object)gd);
        control = this.getComboBoxControl(parent);
        gd = new GridData();
        gd.horizontalSpan = comboC;
        gd.horizontalAlignment = 4;
        control.setLayoutData((Object)gd);
        control.setFont(parent.getFont());
    }

    protected void doLoad() {
        this.updateComboForValue(this.getPreferenceStore().getString(this.getPreferenceName()));
    }

    protected void doLoadDefault() {
        this.updateComboForValue(this.getPreferenceStore().getDefaultString(this.getPreferenceName()));
    }

    protected void updateComboForValue(String value) {
        this.selectedValue = this.getValueFromPreference(value);
        if (this.selectedValue != null) {
            this.viewer.setSelection((ISelection)new StructuredSelection(this.selectedValue));
        }
    }

    protected void doStore() {
        if (this.selectedValue == null) {
            this.getPreferenceStore().setToDefault(this.getPreferenceName());
            return;
        }
        this.getPreferenceStore().setValue(this.getPreferenceName(), this.getPreferenceValue(this.selectedValue));
    }

    public int getNumberOfControls() {
        return 2;
    }

    private Combo getComboBoxControl(Composite parent) {
        if (this.viewer == null) {
            Combo comboBox = new Combo(parent, 8);
            comboBox.setFont(parent.getFont());
            this.viewer = new ComboViewer(comboBox);
            comboBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    boolean oldValid = ComboViewerFieldEditor.this.isValid;
                    Object oldValue = ComboViewerFieldEditor.this.selectedValue;
                    ComboViewerFieldEditor.this.selectedValue = ComboViewerFieldEditor.this.viewer.getSelection().isEmpty() ? null : ((IStructuredSelection)ComboViewerFieldEditor.this.viewer.getSelection()).getFirstElement();
                    ComboViewerFieldEditor.this.setPresentsDefaultValue(false);
                    ComboViewerFieldEditor.this.fireValueChanged("field_editor_value", oldValue, ComboViewerFieldEditor.this.selectedValue);
                    ComboViewerFieldEditor.this.refreshValidState();
                    boolean newValid = ComboViewerFieldEditor.this.isValid;
                    if (oldValid != newValid) {
                        ComboViewerFieldEditor.this.fireValueChanged("field_editor_is_valid", oldValid, newValid);
                    }
                }
            });
        }
        return this.viewer.getCombo();
    }

    public void setEnabled(boolean enabled, Composite parent) {
        super.setEnabled(enabled, parent);
        this.getComboBoxControl(parent).setEnabled(enabled);
    }

    public void setLabelProvider(IBaseLabelProvider labelProvider) {
        this.viewer.setLabelProvider(labelProvider);
    }

    public void setContentProvider(IStructuredContentProvider provider) {
        this.viewer.setContentProvider((IContentProvider)provider);
    }

    public void setInput(Object input) {
        this.viewer.setInput(input);
        this.viewer.getCombo().select(0);
    }

    protected abstract String getPreferenceValue(Object var1);

    protected abstract Object getValueFromPreference(String var1);

    public Object getSelectedValue() {
        return this.selectedValue;
    }

    protected void refreshValidState() {
        this.isValid = this.checkState();
    }

    protected boolean checkState() {
        return true;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public ComboViewer getViewer() {
        return this.viewer;
    }
}

