/*
 * Decompiled with CFR 0.152.
 */
package tern.server.nodejs;

import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.websocket.ClientEndpoint;
import javax.websocket.OnMessage;
import javax.websocket.Session;
import javax.websocket.WebSocketContainer;
import tern.ITernProject;
import tern.TernException;
import tern.TernResourcesManager;
import tern.server.AbstractTernServer;
import tern.server.IInterceptor;
import tern.server.IResponseHandler;
import tern.server.ITernPlugin;
import tern.server.ITernServer;
import tern.server.TernPlugin;
import tern.server.WebSocketContainerProvider;
import tern.server.nodejs.NodejsTernHelper;
import tern.server.nodejs.process.INodejsLaunchConfiguration;
import tern.server.nodejs.process.INodejsProcess;
import tern.server.nodejs.process.INodejsProcessListener;
import tern.server.nodejs.process.NodejsProcessAdapter;
import tern.server.nodejs.process.NodejsProcessException;
import tern.server.nodejs.process.NodejsProcessManager;
import tern.server.protocol.IJSONObjectHelper;
import tern.server.protocol.MinimalJSONHelper;
import tern.server.protocol.TernDoc;
import tern.server.protocol.html.ScriptTagRegion;

public class NodejsTernServer
extends AbstractTernServer
implements INodejsLaunchConfiguration {
    private static final String BASE_URL = "http://127.0.0.1:";
    private static final String HTTP_PROTOCOL = "http:";
    private static final String WS_PROTOCOL = "ws:";
    private String baseURL;
    private List<IInterceptor> interceptors;
    private INodejsProcess process;
    private List<INodejsProcessListener> listeners;
    private long timeout = 200L;
    private int testNumber = 50;
    private Integer port;
    private boolean verbose;
    private boolean noPortFile = true;
    private boolean persistent;
    private boolean loadingLocalPlugins;
    private boolean isDebugLaunch;
    private boolean isSaveLaunch;
    private final INodejsProcessListener listener = new NodejsProcessAdapter(){

        @Override
        public void onStart(INodejsProcess server) {
            NodejsTernServer.this.fireStartServer();
            this.initializeWebSocketIfNeeded();
        }

        private void initializeWebSocketIfNeeded() {
            ITernProject project = NodejsTernServer.this.getProject();
            if (project == null) {
                return;
            }
            if (!project.hasPlugin((ITernPlugin)TernPlugin.push)) {
                return;
            }
            try {
                String baseURL = NodejsTernServer.this.getBaseURL();
                URI uri = URI.create(baseURL.replace(NodejsTernServer.HTTP_PROTOCOL, NodejsTernServer.WS_PROTOCOL));
                WebSocketContainer container = WebSocketContainerProvider.getWebSocketContainer();
                NodejsTernServer.this.session = container.connectToServer((Object)new WebSocketMessageDispatcher(), uri);
            }
            catch (Throwable e) {
                NodejsTernServer.this.onError("Error while initializing WebSocket client.", e);
            }
        }

        @Override
        public void onStop(INodejsProcess server) {
            NodejsTernServer.this.dispose();
            NodejsTernServer.this.fireEndServer();
        }
    };
    private Session session;

    public NodejsTernServer(File projectDir, int port) {
        this(TernResourcesManager.getTernProject((Object)projectDir), port);
    }

    public NodejsTernServer(ITernProject project, int port) {
        super(project);
        this.baseURL = this.computeBaseURL(port);
    }

    public NodejsTernServer(ITernProject project) throws TernException {
        this(project, NodejsProcessManager.getInstance().create(project.getProjectDir()));
    }

    public NodejsTernServer(ITernProject project, File nodejsBaseDir) throws TernException {
        this(project, NodejsProcessManager.getInstance().create(project.getProjectDir(), nodejsBaseDir));
    }

    public NodejsTernServer(ITernProject project, File nodejsBaseDir, File nodejsTernBaseDir) throws TernException {
        this(project, NodejsProcessManager.getInstance().create(project.getProjectDir(), nodejsBaseDir, nodejsTernBaseDir));
    }

    public NodejsTernServer(ITernProject project, INodejsProcess process) {
        super(project);
        this.process = process;
        process.setLaunchConfiguration(this);
        process.addProcessListener(this.listener);
    }

    private String computeBaseURL(Integer port) {
        return BASE_URL + port + "/";
    }

    public void addFile(String name, String text, ScriptTagRegion[] tags) {
        TernDoc t = new TernDoc();
        t.addFile(name, text, tags, null);
        try {
            this.makeRequest(t);
        }
        catch (Exception e) {
            this.onError("Error while adding file.", e);
        }
    }

    public void request(TernDoc doc, IResponseHandler handler) {
        try {
            JsonObject json = this.makeRequest(doc);
            handler.onSuccess((Object)json, handler.isDataAsJsonString() ? json.toString() : null);
        }
        catch (Exception e) {
            handler.onError(e.getMessage(), (Throwable)e);
        }
    }

    private JsonObject makeRequest(TernDoc doc) throws IOException, InterruptedException, TernException {
        ArrayList<IInterceptor> interceptors;
        String baseURL = null;
        try {
            baseURL = this.getBaseURL();
            if (baseURL == null) {
                throw new TernException("Server has been disposed");
            }
        }
        catch (NodejsProcessException e) {
            this.dispose();
            throw e;
        }
        this.beginReadState();
        try {
            interceptors = this.interceptors != null ? new ArrayList<IInterceptor>(this.interceptors) : null;
        }
        finally {
            this.endReadState();
        }
        JsonObject json = NodejsTernHelper.makeRequest(baseURL, doc, false, interceptors, (ITernServer)this);
        return json;
    }

    public void addInterceptor(IInterceptor interceptor) {
        this.beginWriteState();
        try {
            if (this.interceptors == null) {
                this.interceptors = new ArrayList<IInterceptor>();
            }
            this.interceptors.add(interceptor);
        }
        finally {
            this.endWriteState();
        }
    }

    public void removeInterceptor(IInterceptor interceptor) {
        this.beginWriteState();
        try {
            if (this.interceptors != null) {
                this.interceptors.remove(interceptor);
            }
        }
        finally {
            this.endWriteState();
        }
    }

    public String getBaseURL() throws InterruptedException, TernException {
        this.beginReadState();
        try {
            if (this.baseURL == null) {
                this.endReadState();
                this.beginWriteState();
                try {
                    if (this.baseURL != null || this.isDisposed()) {
                        String string = this.baseURL;
                        return string;
                    }
                    int port = this.getProcess().start(this.timeout, this.testNumber);
                    this.baseURL = this.computeBaseURL(port);
                }
                finally {
                    this.endWriteState();
                    this.beginReadState();
                }
            }
            String string = this.baseURL;
            return string;
        }
        finally {
            this.endReadState();
        }
    }

    private INodejsProcess getProcess() throws TernException {
        if (this.process == null) {
            ITernProject project = super.getProject();
            this.process = NodejsProcessManager.getInstance().create(project.getProjectDir());
            this.process.addProcessListener(this.listener);
        }
        return this.process;
    }

    public void addProcessListener(INodejsProcessListener listener) {
        this.beginWriteState();
        try {
            if (this.listeners == null) {
                this.listeners = new ArrayList<INodejsProcessListener>();
            }
            this.listeners.add(listener);
            if (this.process != null) {
                this.process.addProcessListener(listener);
            }
        }
        finally {
            this.endWriteState();
        }
    }

    public void removeProcessListener(INodejsProcessListener listener) {
        this.beginWriteState();
        try {
            if (this.listeners != null && listener != null) {
                this.listeners.remove(listener);
            }
            if (this.process != null) {
                this.process.removeProcessListener(listener);
            }
        }
        finally {
            this.endWriteState();
        }
    }

    public IJSONObjectHelper getJSONObjectHelper() {
        return MinimalJSONHelper.INSTANCE;
    }

    public void doDispose() {
        this.beginWriteState();
        try {
            if (this.process != null) {
                this.process.kill();
            }
            this.baseURL = null;
            this.process = null;
            if (this.session != null) {
                try {
                    this.session.close();
                }
                catch (Throwable e) {
                    this.onError("Error while closing WebSocket client session.", e);
                }
            }
        }
        finally {
            this.endWriteState();
        }
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTestNumber(int testNumber) {
        this.testNumber = testNumber;
    }

    public int getTestNumber() {
        return this.testNumber;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setNoPortFile(boolean noPortFile) {
        this.noPortFile = noPortFile;
    }

    public boolean isNoPortFile() {
        return this.noPortFile;
    }

    public void setPersistent(boolean persistent) {
        this.persistent = persistent;
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public void setLoadingLocalPlugins(boolean loadingLocalPlugins) {
        this.loadingLocalPlugins = loadingLocalPlugins;
    }

    public boolean isLoadingLocalPlugins() {
        return this.loadingLocalPlugins;
    }

    public Integer getPort() {
        return this.port;
    }

    protected void onError(String message, Throwable e) {
        e.printStackTrace();
    }

    @Override
    public List<String> createNodeArgs() {
        LinkedList<String> args = new LinkedList<String>();
        Integer port = this.getPort();
        if (port != null) {
            args.add("--port");
            args.add(port.toString());
        }
        if (this.isVerbose()) {
            args.add("--verbose");
            args.add("1");
        }
        if (this.isNoPortFile()) {
            args.add("--no-port-file");
        }
        if (this.isPersistent()) {
            args.add("--persistent");
        }
        if (!this.isLoadingLocalPlugins()) {
            args.add("--disable-loading-local");
        }
        return args;
    }

    @Override
    public String generateLaunchConfigurationName() {
        return "tern.js for " + this.getProject().getProjectDir().getName();
    }

    @Override
    public String getLaunchMode() {
        return this.isDebugLaunch ? "debug" : "run";
    }

    public void setDebugLaunch(boolean isDebugLaunch) {
        this.isDebugLaunch = isDebugLaunch;
    }

    @Override
    public boolean isSaveLaunch() {
        return this.isSaveLaunch;
    }

    public void setSaveLaunch(boolean isSaveLaunch) {
        this.isSaveLaunch = isSaveLaunch;
    }

    @Override
    public boolean isWaitOnPort() {
        return true;
    }

    @ClientEndpoint
    public class WebSocketMessageDispatcher {
        @OnMessage
        public void dispatchMessage(String data) {
            JsonObject value = Json.parse((String)data).asObject();
            String type = value.getString("type", null);
            JsonValue json = value.get("data");
            if (type != null && json != null) {
                NodejsTernServer.this.fireOnMessage(type, json);
            }
        }
    }
}

