/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.components.ui.settings;

import com.jrockit.mc.components.ui.messages.internal.Messages;
import com.jrockit.mc.components.ui.settings.BrowseInput;
import com.jrockit.mc.ui.idesupport.IDESupportUIToolkit;
import java.io.File;
import org.eclipse.swt.widgets.Shell;

public class FileInput
extends BrowseInput {
    private String m_browseTitle = Messages.FILE_INPUT_SELECT_FILE_TITLE;
    private String m_description = "";
    private boolean m_allowDirectory = true;
    private boolean m_allowFile = true;
    private boolean m_mustExists = false;

    public FileInput(String property, String name) {
        super(property, name);
    }

    public void setAllowDirectory(boolean allowDirectory) {
        this.m_allowDirectory = allowDirectory;
    }

    public void setAllowFile(boolean allowfile) {
        this.m_allowFile = allowfile;
    }

    public boolean getAllowFile() {
        return this.m_allowFile;
    }

    public boolean getAllowDirectory() {
        return this.m_allowDirectory;
    }

    public void setMustExist(boolean mustExist) {
        this.m_mustExists = mustExist;
    }

    public boolean getMustExits() {
        return this.m_mustExists;
    }

    private File getCurrentFile() {
        return new File(this.getPropertyValue());
    }

    @Override
    protected boolean hasValidData() {
        File file = this.getCurrentFile();
        if (!file.exists() && this.getMustExits()) {
            return false;
        }
        if (!this.getAllowDirectory() && file.isDirectory()) {
            return false;
        }
        return this.getAllowFile() || file.isDirectory();
    }

    public void setBrowseTitle(String browseTitle) {
        this.m_browseTitle = browseTitle;
    }

    @Override
    protected boolean browse(Shell shell) {
        File file = IDESupportUIToolkit.browseForOpenFile((String)this.m_browseTitle, (File)this.getCurrentFile());
        if (file != null) {
            this.setFile(file);
            return true;
        }
        return false;
    }

    public String getDescription() {
        return this.m_description;
    }

    public void setDescription(String description) {
        this.m_description = description;
    }

    @Override
    protected String getTextualRepresentation() {
        return this.getPropertyValue();
    }

    public void setFile(File file) {
        this.setPropertyValue(file.getAbsolutePath());
        this.refresh();
    }
}

