/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.tabs.threads;

import com.jrockit.mc.console.ui.ConsolePlugin;
import com.jrockit.mc.console.ui.messages.internal.Messages;
import com.jrockit.mc.console.ui.tabs.threads.AllThreadsContentProvider;
import com.jrockit.mc.console.ui.tabs.threads.CPULoadBackgroundTablerPainter;
import com.jrockit.mc.console.ui.tabs.threads.IThreadsModel;
import com.jrockit.mc.console.ui.tabs.threads.ThreadModelException;
import com.jrockit.mc.ui.UIPlugin;
import com.jrockit.mc.ui.misc.DialogToolkit;
import com.jrockit.mc.ui.misc.DisplayToolkit;
import com.jrockit.mc.ui.model.fields.Field;
import com.jrockit.mc.ui.polling.PollManager;
import com.jrockit.mc.ui.polling.RefreshPollAction;
import com.jrockit.mc.ui.sections.FieldTableViewerSectionPart;
import java.text.DateFormat;
import java.util.Date;
import java.util.logging.Level;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class ThreadTableSectionPart
extends FieldTableViewerSectionPart
implements PollManager.Pollable {
    private static Field[] FIELDPROTOTYPES = new Field[]{AllThreadsContentProvider.FIELD_THREAD_NAME, AllThreadsContentProvider.FIELD_THREAD_STATE, AllThreadsContentProvider.FIELD_BLOCKED_COUNT, AllThreadsContentProvider.FIELD_BLOCKED_TIME, AllThreadsContentProvider.FIELD_WAITED_COUNT, AllThreadsContentProvider.FIELD_WAITED_TIME, AllThreadsContentProvider.FIELD_CPU_TIME, AllThreadsContentProvider.FIELD_IS_DEADLOCKED, AllThreadsContentProvider.FIELD_LOCK_NAME, AllThreadsContentProvider.FIELD_LOCK_OWNER_ID, AllThreadsContentProvider.FIELD_LOCK_OWNER_NAME, AllThreadsContentProvider.FIELD_THREAD_ID, AllThreadsContentProvider.FIELD_IS_NATIVE, AllThreadsContentProvider.FIELD_IS_SUSPENDED, AllThreadsContentProvider.FIELD_ALLOCATED_BYTES};
    private final DateFormat m_dateFormat = DateFormat.getTimeInstance(2);
    private final IThreadsModel m_threadsModel;
    private boolean m_informedMonitoredDeadlockedThreads;
    private RefreshPollAction m_pollAction;
    private Button m_buttonCpuTiming;
    private Button m_buttonDeadlockDetection;
    private Button m_buttonAllocation;

    protected Composite createTopControl(Composite parent) {
        Composite container = this.getFormToolkit().createComposite(parent);
        GridData gd1 = new GridData(4, 4, true, true);
        this.m_fieldViewerFilterControl = this.createViewerFilterControl(container);
        this.m_fieldViewerFilterControl.setLayoutData((Object)gd1);
        GridData gd2 = new GridData(4, 4, false, true);
        this.m_buttonCpuTiming = this.createTimingButton(container);
        this.m_buttonCpuTiming.setLayoutData((Object)gd2);
        GridData gd3 = new GridData(4, 4, false, true);
        this.m_buttonDeadlockDetection = this.createDeadlockDetection(container);
        this.m_buttonDeadlockDetection.setLayoutData((Object)gd3);
        GridData gd4 = new GridData(4, 4, false, true);
        this.m_buttonAllocation = this.createAllocation(container);
        this.m_buttonAllocation.setLayoutData((Object)gd4);
        GridLayout layout = new GridLayout(4, false);
        container.setLayout((Layout)layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        return container;
    }

    private Button createTimingButton(Composite parent) {
        final Button button = this.getFormToolkit().createButton(parent, Messages.ThreadTableSectionPart_ENABLE_THREAD_CPU_PROFILING_BUTTON_TEXT, 32);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ThreadTableSectionPart.this.m_threadsModel.setCPUTimeEnabled(button.getSelection());
            }
        });
        return button;
    }

    private Button createDeadlockDetection(Composite parent) {
        final Button button = this.getFormToolkit().createButton(parent, Messages.ThreadTableSectionPart_ENABLE_DEADLOCK_DETECTION_BUTTON_TEXT, 32);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ThreadTableSectionPart.this.m_threadsModel.setDeadlockDetectionEnabled(button.getSelection());
            }
        });
        return button;
    }

    private Button createAllocation(Composite parent) {
        final Button button = this.getFormToolkit().createButton(parent, Messages.ThreadTableSectionPart_ENABLE_THREAD_ALLOCATION_BUTTON_TEXT, 32);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ThreadTableSectionPart.this.m_threadsModel.setAllocationEnabled(button.getSelection());
            }
        });
        return button;
    }

    public ThreadTableSectionPart(Composite parent, FormToolkit toolkit, IThreadsModel threadsModel, String sectionIdetifier) {
        super(parent, toolkit, 384, sectionIdetifier, FIELDPROTOTYPES, ConsolePlugin.getDefault().getMCDialogSettings());
        this.setHelpContextID("com.jrockit.mc.console.ui.ThreadTableSectionPart");
        this.m_threadsModel = threadsModel;
    }

    protected IThreadsModel getModel() {
        return this.m_threadsModel;
    }

    public void initialize(IManagedForm form) {
        this.m_pollAction = new RefreshPollAction(Messages.ThreadTableSectionPart_REFRESH_STACK_TRACE, this.m_threadsModel.getPollManager(), (PollManager.Pollable)this);
        this.getMCToolBarManager().add((IAction)this.m_pollAction);
        super.initialize(form);
    }

    protected void initializeSection(Section section) {
        section.setText(Messages.ThreadTableSectionPart_SECTION_TEXT);
        section.setDescription(Messages.ThreadTableSectionPart_SECTION_DESCRIPTION);
        section.setData("name", (Object)"threads.ThreadsTab.LiveThreadsTable");
    }

    protected void initializePart() {
        super.initializePart();
        this.getTableViewer().setContentProvider((IContentProvider)new AllThreadsContentProvider());
        this.getTableViewer().setInput((Object)this.getModel());
        int numberOfCPUS = this.getModel().getNumberOfCPUs();
        if (numberOfCPUS > 0) {
            this.getTableViewer().getTable().addListener(40, (Listener)new CPULoadBackgroundTablerPainter(this.getFields(), numberOfCPUS));
        }
        this.selectFirstElement();
    }

    public boolean poll() {
        Control control = this.getTableViewer().getControl();
        if (control == null || control.isDisposed()) {
            return false;
        }
        final Display display = control.getDisplay();
        if (display == null || display.isDisposed()) {
            return false;
        }
        if (!this.m_threadsModel.isConnected()) {
            return false;
        }
        try {
            this.m_threadsModel.update();
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!ThreadTableSectionPart.this.m_threadsModel.isConnected()) {
                        ThreadTableSectionPart.this.m_threadsModel.getPollManager().stop();
                    }
                    ThreadTableSectionPart.this.getTableViewer().refresh();
                    Section section = ThreadTableSectionPart.this.getSection();
                    if (!section.isDisposed()) {
                        section.setDescription(NLS.bind((String)Messages.ThreadTableSectionPart_SECTION_DESCRIPTION_DATE, (Object)ThreadTableSectionPart.this.m_dateFormat.format(new Date())));
                    }
                    if (!ThreadTableSectionPart.this.m_informedMonitoredDeadlockedThreads && ThreadTableSectionPart.this.m_threadsModel.isUsingMonitoredThreadlockedThreads()) {
                        ThreadTableSectionPart.this.m_informedMonitoredDeadlockedThreads = true;
                        DialogToolkit.showWarningDialogAsync((Display)display, (String)Messages.ThreadTableSectionPart_USING_FIND_MONITORED_DEADLOCKED_THREADS_HEADER, (String)Messages.ThreadTableSectionPart_USING_FIND_MONITORED_DEADLOCKED_THREADS_TEXT);
                    }
                }
            });
        }
        catch (ThreadModelException e) {
            this.updateButtonStatedFromModel();
            final String message = e.getLocalizedMessage();
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    ThreadTableSectionPart.this.getForm().setMessage(message, 2);
                }
            });
            ConsolePlugin.getDefault().getLogger().log(Level.WARNING, "Could not update the threads table!", e);
            return false;
        }
        return true;
    }

    private void updateButtonStatedFromModel() {
        DisplayToolkit.safeSyncExec((Display)this.getForm().getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                ThreadTableSectionPart.this.m_buttonCpuTiming.setSelection(ThreadTableSectionPart.this.getModel().isCPUTimeEnabled());
                ThreadTableSectionPart.this.m_buttonAllocation.setSelection(ThreadTableSectionPart.this.getModel().isAllocationEnabled());
                ThreadTableSectionPart.this.m_buttonDeadlockDetection.setSelection(ThreadTableSectionPart.this.getModel().isDeadlockeDetectionEnabled());
            }
        });
    }

    public final class FindDeadlockedAction
    extends Action {
        public FindDeadlockedAction(String name) {
            super(name, 2);
            this.setToolTipText(name);
            this.setChecked(false);
            this.setImageDescriptor(UIPlugin.getDefault().getMCImageDescriptor("live-thread-deadlocked-16.PNG"));
            this.setDisabledImageDescriptor(UIPlugin.getDefault().getMCImageDescriptor("live-thread-deadlocked-grey-16.PNG"));
        }

        public void run() {
            ThreadTableSectionPart.this.getModel().setDeadlockDetectionEnabled(this.isChecked());
        }
    }
}

