/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rcp.intro;

import com.jrockit.mc.rcp.application.actions.OpenFileAction;
import com.jrockit.mc.rcp.intro.IntroToolkit;
import com.jrockit.mc.rcp.intro.Messages;
import com.jrockit.mc.ui.MCPathEditorInput;
import com.jrockit.mc.ui.WorkbenchToolkit;
import com.jrockit.mc.ui.misc.DialogToolkit;
import java.io.File;
import java.util.Properties;
import java.util.logging.Level;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.intro.IIntroManager;
import org.eclipse.ui.intro.IIntroSite;
import org.eclipse.ui.intro.config.IIntroAction;

public class FlightRecordingExampleAction
implements IIntroAction {
    public void run(IIntroSite site, Properties params) {
        File file = null;
        boolean readable = false;
        String filename = String.valueOf(OpenFileAction.getSamplePath()) + File.separator + params.getProperty("file");
        IntroToolkit.getLogger().log(Level.INFO, "Trying to open flight recording sample from: " + filename);
        try {
            file = new File(filename);
            readable = file.canRead();
        }
        catch (Exception e) {
            IntroToolkit.logException(e);
            DialogToolkit.showException((Shell)site.getShell(), (String)Messages.OPEN_SAMPLE_RECORDING_PROBLEM, (String)NLS.bind((String)Messages.OPEN_SAMPLE_RECORDING_EXCEPTION, (Object)filename), (Throwable)e);
        }
        if (readable) {
            WorkbenchToolkit.openEditor((IWorkbenchWindow)site.getWorkbenchWindow(), (IPathEditorInput)new MCPathEditorInput(file));
            IIntroManager manager = PlatformUI.getWorkbench().getIntroManager();
            manager.closeIntro(manager.getIntro());
        } else {
            DialogToolkit.showError((Shell)site.getShell(), (String)Messages.OPEN_SAMPLE_RECORDING_PROBLEM, (String)NLS.bind((String)Messages.OPEN_SAMPLE_RECORDING_NONEXISTENT, (Object)filename));
        }
    }
}

