/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.subscription.internal;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.management.MBeanServerConnection;
import javax.management.NotificationFilter;
import javax.management.NotificationFilterSupport;
import javax.management.NotificationListener;
import javax.management.ObjectName;

public class SyntheticAttributeToolkit {
    public static Set<ObjectName> lookupMxBeans(MBeanServerConnection connection, String domain, String type) {
        HashSet<ObjectName> mxBeans = new HashSet<ObjectName>();
        try {
            for (ObjectName objectName : connection.queryNames(null, null)) {
                if (!objectName.getDomain().equals(domain) || !type.equals(objectName.getKeyProperty("type"))) continue;
                mxBeans.add(objectName);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return mxBeans;
    }

    public static void subscribeToNotifications(MBeanServerConnection connection, NotificationListener listener, Iterable<? extends ObjectName> beans, String type) {
        for (ObjectName objectName : beans) {
            try {
                connection.addNotificationListener(objectName, listener, SyntheticAttributeToolkit.createNotificationFilter(type), null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static NotificationFilter createNotificationFilter(String type) {
        NotificationFilterSupport filter = new NotificationFilterSupport();
        filter.enableType(type);
        return filter;
    }

    public static void unsubscribeFromNotifications(MBeanServerConnection connection, NotificationListener listener, Iterable<? extends ObjectName> beans) {
        for (ObjectName objectName : beans) {
            try {
                connection.removeNotificationListener(objectName, listener);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

