/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.jmx.json.impl;

import com.oracle.javafx.jmx.json.JSONDocument;
import com.oracle.javafx.jmx.json.JSONException;
import com.oracle.javafx.jmx.json.JSONReader;
import com.oracle.javafx.jmx.json.impl.JSONMessages;
import com.oracle.javafx.jmx.json.impl.JSONScanner;
import com.oracle.javafx.jmx.json.impl.JSONSymbol;
import java.io.IOException;
import java.io.Reader;
import java.util.Iterator;
import java.util.Stack;

public class JSONStreamReaderImpl
implements JSONReader {
    private JSONScanner scanner;
    private JSONSymbol currentSymbol;
    private JSONReader.EventType currentEvent;
    private volatile boolean nullValue;
    private String key;
    private Stack<String> stack = new Stack();
    private boolean eod = false;
    private JSONDocument collection = null;
    private String collectionKey = null;
    private int depth = 0;

    public JSONStreamReaderImpl(Reader reader) throws JSONException {
        this.currentSymbol = JSONSymbol.EOS;
        try {
            this.scanner = new JSONScanner(reader);
            JSONSymbol.init(this.scanner);
        }
        catch (IOException iOException) {
            throw new JSONException(iOException, this.scanner.line(), this.scanner.column());
        }
    }

    @Override
    public Iterator<JSONReader.EventType> iterator() {
        return this;
    }

    @Override
    public JSONReader.EventType next(String string, int n) throws JSONException {
        if (string == null && n < 0) {
            throw new IllegalArgumentException(JSONMessages.localize(null, "either_objectName_or_level_must_be_specified"));
        }
        JSONReader.EventType eventType = JSONReader.EventType.END_DOCUMENT;
        eventType = this.next();
        while (!(eventType == JSONReader.EventType.END_DOCUMENT || eventType == JSONReader.EventType.ERROR || eventType == JSONReader.EventType.START_VALUE && (string != null && n >= 0 ? this.checkName(string) && this.checkLevel(n) : string != null && this.checkName(string) || n >= 0 && this.checkLevel(n)))) {
            eventType = this.next();
        }
        return eventType;
    }

    private boolean checkName(String string) {
        return string.equals(this.key());
    }

    private boolean checkLevel(int n) {
        return n == this.depth;
    }

    @Override
    public JSONReader.EventType next() throws JSONException {
        boolean bl = false;
        if (this.eod) {
            this.currentEvent = JSONReader.EventType.END_DOCUMENT;
            return this.currentEvent;
        }
        this.nullValue = false;
        while (!bl) {
            try {
                this.currentSymbol = JSONSymbol.next();
            }
            catch (IOException iOException) {
                throw new JSONException(iOException, this.scanner.line(), this.scanner.column());
            }
            switch (this.currentSymbol) {
                case O: {
                    this.key = null;
                    ++this.depth;
                    this.currentEvent = JSONReader.EventType.START_OBJECT;
                    return this.currentEvent;
                }
                case O_: {
                    this.key = null;
                    --this.depth;
                    this.currentEvent = JSONReader.EventType.END_OBJECT;
                    return this.currentEvent;
                }
                case OV: {
                    if (this.next() == JSONReader.EventType.STRING) {
                        this.key = JSONSymbol.getValue();
                    }
                    this.stack.push(this.key);
                    this.nullValue = true;
                    this.currentEvent = JSONReader.EventType.START_VALUE;
                    return this.currentEvent;
                }
                case OV_: {
                    this.key = this.stack.pop();
                    this.nullValue = true;
                    this.currentEvent = JSONReader.EventType.END_VALUE;
                    return this.currentEvent;
                }
                case X: {
                    this.depth = -1;
                    this.stack.removeAllElements();
                    this.currentEvent = JSONReader.EventType.START_DOCUMENT;
                    return this.currentEvent;
                }
                case X_: {
                    this.eod = true;
                    this.stack.removeAllElements();
                }
                case EOS: {
                    if (!this.eod) {
                        throw new JSONException(JSONMessages.localize(null, "unexpected_end_of_stream"), this.scanner.line(), this.scanner.column());
                    }
                    this.depth = -1;
                    this.currentEvent = JSONReader.EventType.END_DOCUMENT;
                    return this.currentEvent;
                }
                case KEYWORD: {
                    String string = JSONSymbol.getValue();
                    if (string.equals("true")) {
                        this.nullValue = true;
                        this.currentEvent = JSONReader.EventType.TRUE;
                        return this.currentEvent;
                    }
                    if (string.equals("false")) {
                        this.nullValue = true;
                        this.currentEvent = JSONReader.EventType.FALSE;
                        return this.currentEvent;
                    }
                    if (string.equals("null")) {
                        this.nullValue = true;
                        this.currentEvent = JSONReader.EventType.NULL;
                        return this.currentEvent;
                    }
                    this.currentEvent = JSONReader.EventType.ERROR;
                    return this.currentEvent;
                }
                case STRING: {
                    this.currentEvent = JSONReader.EventType.STRING;
                    return this.currentEvent;
                }
                case NUMBER: {
                    if (this.scanner.isInteger()) {
                        this.currentEvent = JSONReader.EventType.INTEGER;
                        return this.currentEvent;
                    }
                    this.currentEvent = JSONReader.EventType.NUMBER;
                    return this.currentEvent;
                }
                case A: {
                    this.currentEvent = JSONReader.EventType.START_ARRAY;
                    return this.currentEvent;
                }
                case A_: {
                    this.currentEvent = JSONReader.EventType.END_ARRAY;
                    return this.currentEvent;
                }
                case VA: {
                    this.currentEvent = JSONReader.EventType.START_ARRAY_ELEMENT;
                    return this.currentEvent;
                }
                case VA_: {
                    this.nullValue = true;
                    this.currentEvent = JSONReader.EventType.END_ARRAY_ELEMENT;
                    return this.currentEvent;
                }
            }
            bl = false;
        }
        this.currentEvent = JSONReader.EventType.ERROR;
        return this.currentEvent;
    }

    @Override
    public boolean hasNext() {
        return this.currentSymbol != JSONSymbol.X_;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String value() {
        return this.nullValue ? null : JSONSymbol.getValue();
    }

    @Override
    public int line() {
        return this.scanner.line();
    }

    @Override
    public int column() {
        return this.scanner.column();
    }

    @Override
    public long offset() {
        return this.scanner.getCharacterOffset();
    }

    @Override
    public int depth() {
        return this.depth;
    }

    @Override
    public String[] path() {
        String[] stringArray = new String[this.stack.size()];
        Iterator iterator = this.stack.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            stringArray[n++] = (String)iterator.next();
        }
        return stringArray;
    }

    @Override
    public String key() {
        return this.key;
    }

    public String toString() {
        String string = this.key() == null ? "" : this.key();
        String string2 = this.value() == null ? "" : this.value();
        return "(" + this.scanner.line() + ":" + this.scanner.column() + ") " + (Object)((Object)this.currentEvent) + " " + ("".equals(string) && "".equals(string2) ? "" : "(" + string + ", " + string2 + ")");
    }

    @Override
    public JSONDocument build() {
        Object object;
        if (this.currentEvent != JSONReader.EventType.START_ARRAY && this.currentEvent != JSONReader.EventType.START_OBJECT) {
            object = this.next();
            while (object != JSONReader.EventType.END_DOCUMENT && object != JSONReader.EventType.ERROR && object != JSONReader.EventType.START_ARRAY && object != JSONReader.EventType.START_OBJECT) {
                object = this.next();
            }
        }
        object = new Stack();
        switch (this.currentEvent) {
            case END_DOCUMENT: {
                return null;
            }
            case START_ARRAY: {
                this.collection = new JSONDocument(JSONDocument.Type.ARRAY);
                break;
            }
            case START_OBJECT: {
                this.collection = new JSONDocument(JSONDocument.Type.OBJECT);
            }
        }
        JSONDocument jSONDocument = ((Stack)object).push(this.collection);
        JSONReader.EventType eventType = this.next();
        while (eventType != JSONReader.EventType.END_DOCUMENT && eventType != JSONReader.EventType.ERROR && !((Stack)object).empty()) {
            this.insert(eventType, (Stack<JSONDocument>)object);
            eventType = this.next();
        }
        return jSONDocument;
    }

    private void insert(JSONReader.EventType eventType, Stack<JSONDocument> stack) throws NumberFormatException {
        switch (eventType) {
            case TRUE: {
                this.insert(Boolean.TRUE);
                break;
            }
            case FALSE: {
                this.insert(Boolean.FALSE);
                break;
            }
            case NULL: {
                this.insert(null);
                break;
            }
            case STRING: {
                this.insert(this.value());
                break;
            }
            case INTEGER: {
                this.insert(Long.parseLong(this.value()));
                break;
            }
            case NUMBER: {
                this.insert(Double.parseDouble(this.value()));
                break;
            }
            case START_ARRAY: {
                stack.push(this.collection);
                JSONDocument jSONDocument = new JSONDocument(JSONDocument.Type.ARRAY);
                this.insert(jSONDocument);
                this.collection = jSONDocument;
                break;
            }
            case END_ARRAY: {
                this.collection = stack.pop();
                break;
            }
            case START_VALUE: {
                this.collectionKey = this.key();
                break;
            }
            case END_VALUE: {
                this.collectionKey = null;
                break;
            }
            case START_OBJECT: {
                stack.push(this.collection);
                JSONDocument jSONDocument = new JSONDocument(JSONDocument.Type.OBJECT);
                this.insert(jSONDocument);
                this.collection = jSONDocument;
                break;
            }
            case END_OBJECT: {
                this.collection = stack.pop();
            }
        }
    }

    private void insert(Object object) {
        if (this.collection.isArray()) {
            this.collection.array().add(object);
        } else if (this.collection.isObject()) {
            this.collection.object().put(this.collectionKey, object);
        } else assert (false);
    }

    @Override
    public void close() {
        try {
            this.scanner.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

