/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.common.util;

import java.util.Date;

public final class TimeRange {
    static final long NEGATIVE_INFINITY = -4611686018427387904L;
    static final long POSITIVE_INFINITY = 0x3FFFFFFFFFFFFFFFL;
    static final long INFINITE_DURATION = Long.MAX_VALUE;
    static final TimeRange INFINITE_RANGE = new TimeRange(-4611686018427387904L, 0x3FFFFFFFFFFFFFFFL);
    private final long m_startTimestamp;
    private final long m_endTimestamp;

    public TimeRange(long start, long end) {
        assert (start <= end);
        this.m_startTimestamp = start;
        this.m_endTimestamp = end;
    }

    public String toString() {
        return TimeRange.formatRange(this);
    }

    public long getDuration() {
        return TimeRange.calculateDuration(this.m_startTimestamp, this.m_endTimestamp);
    }

    public long getEndTimestamp() {
        return this.m_endTimestamp;
    }

    public long getStartTimestamp() {
        return this.m_startTimestamp;
    }

    public TimeRange createExpanded(long newValue) {
        long min = Math.min(this.m_startTimestamp, newValue);
        long max = Math.max(this.m_endTimestamp, newValue);
        return new TimeRange(min, max);
    }

    public static String formatRange(TimeRange timeRange) {
        return "[" + TimeRange.getTimeAsString(timeRange.getStartTimestamp()) + ", " + TimeRange.getTimeAsString(timeRange.getEndTimestamp()) + ']';
    }

    private static String getTimeAsString(long time) {
        if (time == -4611686018427387904L) {
            return "-Infinity";
        }
        if (time == 0x3FFFFFFFFFFFFFFFL) {
            return "+Infinity";
        }
        return String.valueOf(new Date(time / 1000000L).toString()) + ' ' + (double)(time % 1000000L) / 1000.0 + " ms";
    }

    private static long calculateDuration(long startTimestamp, long endTimestamp) {
        if (startTimestamp == -4611686018427387904L || endTimestamp == 0x3FFFFFFFFFFFFFFFL) {
            return Long.MAX_VALUE;
        }
        return endTimestamp - startTimestamp;
    }
}

