/*
 * Decompiled with CFR 0.152.
 */
package oracle.jvm.hotspot.jfr;

import java.util.Observable;
import java.util.Observer;
import oracle.jvm.hotspot.jfr.JFRStreamWriter;
import oracle.jvm.hotspot.jfr.JavaStringConstantPool;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.runtime.VMObject;
import sun.jvm.hotspot.runtime.VMObjectFactory;
import sun.jvm.hotspot.types.AddressField;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;

public final class JavaConstantPools
extends VMObject {
    private static AddressField poolsField;
    private static JavaStringConstantPool pool;

    public JavaConstantPools(Address addr) {
        super(addr);
        pool = (JavaStringConstantPool)VMObjectFactory.newObject(JavaStringConstantPool.class, poolsField.getValue(addr));
    }

    private static synchronized void initialize(TypeDataBase db) {
        Type type = db.lookupType("JavaConstantPools");
        poolsField = type.getAddressField("_pools");
    }

    public JavaStringConstantPool getPool() {
        return pool;
    }

    public JavaStringConstantPool getNextPool(JavaStringConstantPool pl) {
        return (JavaStringConstantPool)VMObjectFactory.newObject(JavaStringConstantPool.class, pl.getNext());
    }

    public void write_all_string_pools(JFRStreamWriter sw) {
        JavaStringConstantPool pool = this.getPool();
        JavaStringConstantPool nextPool = null;
        while (pool != null) {
            pool.write(sw);
            pool = nextPool = this.getNextPool(pool);
        }
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            @Override
            public void update(Observable o, Object data) {
                JavaConstantPools.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

