﻿// *************************************************************************************************************************
// LinkObj (Javascript Object)
//
// A LinkObj is a wrapper around a 'a' HTML element.  The ID, URL, Link Text, and Target are specified through the constructor.
// A LinkObj can contain other HTML elements, such as images.  To allow adding elements, null be sent for the 'text' parameter
// in the constructor.  Otherwise, any inner elements will be ignored.
// To add the link to a element, call the draw() function providing the actula HTML element to which appendChild() will be called
// to attach the link.
// *************************************************************************************************************************

// Dependencies:
/// <reference path="uicore.js">

LinkObj = function(uniqueID, url, text, target, nocolor)
{
    /// <summary>Constructor for LinkObj.  [Link = 'a' HTML Element]</summary>
    /// <param name="uniqueID">[OPTIONAL] (string) Actual ID of this element.  If null, generates random unique ID.</param>
    /// <param name="url">(string) Path/URL this link points to</param>
    /// <param name="text">[OPTIONAL] (string) Text to display for this link.  (To add other elements, this argument must be null)</param>
    /// <param name="target">[OPTIONAL] (string) target property of this link 
    /// ['name of target window'] | [_blank] | [_media] | [_parent] | [_search] | [_self (default)] | [_top]</param>
    /// <returns>A new LinkObj</returns>
    this.m_strURL = (url != undefined) ? url : '';
    this.m_strText = text;
    this.m_strTarget = target;
    this.m_strID = (uniqueID != null) ? uniqueID : 'LinkObj' + UIHelper.generateRandomString(10);
    this.m_strClassName = null;
    this.m_strTitle = null;
    this.m_bOnFocus = false;
    
    // Elements
    this.m_elContainer = null;
    this.m_elLink = null;
    
    this.m_elLink = document.createElement('a');
    this.m_elLink.id = this.m_strID;
    this.m_elLink.href = this.m_strURL;
    
    if(this.m_strText != undefined)
        this.m_elLink.innerText = this.m_strText;
    if(this.m_strTarget != undefined)
        this.m_elLink.target = this.m_strTarget;

    if ( null == nocolor || undefined == nocolor || !nocolor )
    {
        this.o_ExObj = new ExternalWrapperObj();
        this.o_CobrandObj = this.o_ExObj.getCobranding();
        this.m_elLink.style.color = this.o_CobrandObj.getLinkColor();
    }
}

LinkObj.prototype =
{
    draw:function(elementDiv)
    {
        /// <summary>Calls appendChild() on the provided element, appending this link element</summary>
        /// <param name="elementDiv">(HTML Element) HTML element to append this link to</param>
        if(elementDiv != undefined)
        {
            var self = this;
            this.m_elContainer = elementDiv;
            
            this.m_elLink.onkeypress = function() {self.keyPress()};
            this.m_elLink.onfocus = function() {self.setOnFocus(true)};
            this.m_elLink.onblur = function() {self.setOnFocus(false)};
            
            this.m_elContainer.appendChild(this.m_elLink);
        }
    },

    setClassName:function(className)
    {
        this.m_strClassName = className;
        if(this.m_strClassName != null && this.m_strClassName != undefined)
            this.m_elLink.className = this.m_strClassName;
    },
    
    getID:function()
    {
        /// <summary>Retrieves the ID of this 'a' HTML Element</summary>
        return this.m_strID;
    },
    
    getElement:function()
    {
        /// <summary>Retrieves the 'a' HTML Element this Link contains</summary>
        return this.m_elLink;
    },
    
    setTabIndex:function(value)
    {
        /// <summary>Sets the tab index of this link</summary>
        /// <param name="value">(int) Tab index of this link</param>
        if((this.m_elLink != undefined) && (value != undefined))
            this.m_elLink.tabIndex = value;
    },  

	setHref:function(value)
    {
        /// <summary>Sets the src property</summary>
        /// <param name="value">(string) new src</param>
        if((this.m_elLink != undefined) && (value != undefined))
            this.m_elLink.href = value;
    },    
    
    getHref:function()
    {
        /// <summary>Returns the class name of this div</summary>
        var toReturn = 'undefined';
        if(this.m_elLink != undefined)
            toReturn = this.m_elLink.href;
        return toReturn;
    },
    
    addObject:function(child)
    {
        /// <summary>If no text has been provided, adds element to the link</summary>
        /// <param name="child">(HTML Element) HTML element to append to this 'a' HTML element</param>
        if((this.m_strText == undefined) && (this.m_elLink != undefined) && (child != undefined))
            this.m_elLink.appendChild(child);
    },
    
    setTitle:function(value)
    {
        /// <summary>Sets the title for this link</summary>
        /// <param name="value">(string) New title for this element</param>
        if((this.m_elLink != undefined) && (value != undefined))
        {
            this.m_strTitle = value;        
            this.m_elLink.title = value;
        }
    },
    
    setOnFocus:function(value)
    {
        /// <summary>Sets onfocus key flag for this link</summary>
        /// <param name="value">(string) New value for this element</param>
        if((this.m_bOnFocus != undefined) && (value != undefined))
        {
            this.m_bOnFocus = value;
        }
    },  

    isOnFocus:function()
    {
        /// <summary>Retrieves the onfocus flag of this Element</summary>
        return this.m_bOnFocus;
    },    
    
    keyPress:function()
    {
        /// <summary>Event called when user pushes a key while focused on this link.
        /// If spacebar -> Click link</summary>
        if((window.event != undefined) && (this.m_elLink != undefined))
        {
            if(window.event.keyCode == KEY_CODE_SPACE)
                this.m_elLink.click();
        }
    }
}
