﻿DisplayObj = function(objID, displayText, value)
{
    /// <summary>Object for displaying an element (contains an object ID, Display Text, and Actual Value)</summary>
    /// <param name="objID">(string) ID of this element</param>
    /// <param name="displayText">(string) Text to display in this element</param>
    /// <param name="value">(any) Value this Display Object represents</param>
    /// <returns>A new DisplayObj</returns>
    this.ID = objID;
    this.Text = displayText;
    this.Value = value;
}

Point = function(xCoor, yCoor)
{
    /// <summary>Object representing an x, y coordinate point</summary>
    /// <param name="xCoor">(int) X Coordinate of the point</param>
    /// <param name="yCoor">(int) Y Coordinate of the point</param>
    /// <returns>A new Point</returns>
    this.X = xCoor;
    this.Y = yCoor;
}

UIHelper = function()
{
    /// <summary>Static Helper Class</summary>
    
    // this is a static class, but we need to declare it like this
    // in order for it to have methods
    this.isStatic = true;
}

UIHelper.generateRandomString = function(length)
{
    /// <summary>Method which generates a string of random numbers and letters (lower and upper case)</summary>
    /// <param name="length">(int) length of the random string to generate</param>
    /// <returns>A string of random numbers</returns>
    var newID = '';
    for(var i=0; i < length; i++)
        newID += UIHelper.randomChar();

    return newID;
}

UIHelper.randomChar = function()
{
    /// <summary>Method which generates a random character</summary>
    /// <returns>A random character</returns>
	var randomNumber = Math.floor(Math.random() * 75);
	randomNumber = randomNumber + 48;
	while((randomNumber > 57 && randomNumber < 65) || ( randomNumber >90 && randomNumber < 97))
	{
		randomNumber = Math.floor(Math.random() * 75);
		randomNumber = randomNumber + 48;
	}
	var h = randomNumber.toString(16);
	if(h.length==1)
		h="0"+h;
	h = "%" + h;
	return unescape(h);
}

UIHelper.getObjCoords = function(element)
{
    /// <summary>Method which finds the absolute X,Y coordinates of the provided element</summary>
    /// <param name="element">(HTML Element) Element to find the x,y absolute coordintes of</param>
    /// <returns>Point representing the x,y coordinates of this element</returns>
    var oX = 0;
    var oY = 0;
    if ((element!=undefined) && (element.offsetParent!=undefined)) 
    {
        while (1) 
        {
            oX+=element.offsetLeft;
            oY+=element.offsetTop;
            if (element.offsetParent==undefined)
                break;
            element=element.offsetParent;
        }
    }
    else if (element.X!=undefined)
    {
        oX+=element.X;
        oY+=element.Y;
    }
    return new Point(oX, oY);
}

UIHelper.drawShadow = function(element, bgColor, shadowWidth, offsetTop, offsetLeft)
{
    /// <summary>Creates a 'shadow' for the specified HTML element</summary>
    /// <param name="element">(HTML Element) Element to add the shadow to</param>
    /// <param name="bgColor">[OPTIONAL] (string) Shadow color [Default: '#bbb']</param>
    /// <param name="shadowWidth">[OPTIONAL] (string/int) Width of the shadow [Default: 3]</param>
    /// <param name="offsetTop">[OPTIONAL] (int) Top Offset of the element to shadow from its parent</param>
    /// <param name="offsetLeft">[OPTIONAL] (int) Left Offset of the element to shadow from its parent</param>
    if(element != undefined)
    {
        var div = document.createElement('div');
        div.style.position = 'absolute';
        div.style.backgroundColor = (bgColor != undefined) ? bgColor : '#bbb';
        div.style.height = element.style.height
        div.style.width = element.style.width;
        var topOffset = (shadowWidth != undefined) ? shadowWidth : 3;
        var leftOffset = (shadowWidth != undefined) ? shadowWidth : 3;
        if(offsetTop != undefined)
            topOffset += offsetTop;
        if(offsetLeft != undefined)
            leftOffset += offsetLeft;
        div.style.top = topOffset;
        div.style.left = leftOffset;
        div.style.zIndex = -1;
        element.parentNode.appendChild(div);
    }
}

UIHelper.getIndex=function(arrContents, value)
{
    // find and return the index of value from the arrContents, which is a list of DisplayObj

    var index = 0;
    if(arrContents != undefined && arrContents != null  && value != undefined && value != null )
    {
        for(var i=0; i < arrContents.length; i++)
        {
            if ( arrContents[i].Value == value )
            {
                index = i;
                break;
            }
        }
    }    
    return index;
}

UIHelper.truncateName=function(name , length)
{
    var defaultlength = 0;
    var namelimit = 0;
    var ellipsis = '...';
    var shortname = '';
    if ( undefined == name || null == name )
        return shortname;
    
    defaultlength = name.length;
    
    if ( undefined == length || null == length )
        namelimit = defaultlength;
    else 
        namelimit = length;

    shortname = name;    
    if ( name.length <= namelimit )
        return shortname;
    
    shortname = shortname.substring(0, namelimit - ellipsis.length ) + ellipsis;
    return shortname;
}

UIHelper.setAlign=function(name , align)
{
    if ( null == name || undefined == name )
        return;

    if ( null == align || undefined == align )
        return;

    var obj = document.getElementById( name );
    if ( null == obj || undefined == obj )
        return;

    obj.align = align;       
}

function sendToHIP()
{
    // disable any input from users when before the new page rendered
    // see bug768634 for the detail
    var g_ExObj = new ExternalWrapperObj();
    g_ExObj.enableWindow(false);

    window.location = "HIPUser.htm";
}

var KEY_CODE_BACKSPACE = 8;
var KEY_CODE_TAB = 9;
var KEY_CODE_ENTER = 13;
var KEY_CODE_PAUSE = 19;
var KEY_CODE_CAPS = 20;
var KEY_CODE_ESC = 27;
var KEY_CODE_SPACE = 32;
var KEY_CODE_PAGE_UP = 33;
var KEY_CODE_PAGE_DOWN = 34;
var KEY_CODE_END = 35;
var KEY_CODE_HOME = 36;
var KEY_CODE_LEFT = 37;
var KEY_CODE_UP = 38;
var KEY_CODE_RIGHT = 39;
var KEY_CODE_DOWN = 40;
var KEY_CODE_INSERT = 45;
var KEY_CODE_DELETE = 46;
