﻿// *************************************************************************************************************************
// ImageObj (Javascript Object)
//
// A ImageObj is a wrapper around a 'img' HTML element.  The ID, Image Source, Height, Width, Horizontal and Veritical align
// are specified through the constructor.  
// To add the image to a div, call the draw() function providing the actual HTML element to which appendChild() will be called'
// to attach this image
// *************************************************************************************************************************

// Dependencies:
/// <reference path="uicore.js">

ImageObj = function(uniqueID, imgSrc, imgHeight, imgWidth, imgAlign, imgVAlign, className)
{
    /// <summary>Constructor for ImageObj.  [Image = 'img' HTML Element]</summary>
    /// <param name="uniqueID">[OPTIONAL] (string) Actual ID of this element.  If null, generates random unique ID.</param>
    /// <param name="imgSrc">(string) Path/URL to image</param>
    /// <param name="imgHeight">[OPTIONAL] (string/int) HTML height of this image</param>
    /// <param name="imgWidth">[OPTIONAL] (string/int) HTML width of this image</param>
    /// <param name="imgAlign">[OPTIONAL] (string) align property value for this image
    /// [absbottom] | [absmiddle] | [baseline] | [bottom] | [left] | [middle] | [right] | [texttop] | [top]</param>
    /// <param name="imgVAlign">[OPTIONAL] (string) verticalAlign property for this image</param>
    /// <returns>A new ImageObj</returns>
    this.m_strSource = imgSrc;
    this.m_varHeight = imgHeight;
    this.m_varWidth = imgWidth;
    this.m_strAlign = imgAlign;
    this.m_strVAlign = imgVAlign;
    this.m_strID = (uniqueID != undefined) ? uniqueID : 'ImageObj' + UIHelper.generateRandomString(10);
    this.m_className = className;
    // Elements
    this.m_elContainer = null;
    this.m_elImage = null;
    
    // Create image element
    this.m_elImage = document.createElement('img');
    this.m_elImage.id = this.m_strID;
    this.m_elImage.src = this.m_strSource;

    if(this.m_className != undefined && this.m_className != null )
        this.m_elImage.className = this.m_className;
    if(this.m_varHeight != undefined && this.m_varHeight != null)
        this.m_elImage.style.height = this.m_varHeight;
    if(this.m_varWidth != undefined && this.m_varWidth != null)
        this.m_elImage.style.width = this.m_varWidth;
    if(this.m_strAlign != undefined && this.m_strAlign != null)
        this.m_elImage.style.align = this.m_strAlign;
    if(this.m_strVAlign != undefined && this.m_strVAlign != null)
        this.m_elImage.style.verticalAlign = this.m_strVAlign;
}

ImageObj.prototype =
{
    draw:function(elementDiv)
    {
        /// <summary>Calls appendChild() on the provided element, appending this img element</summary>
        /// <param name="elementDiv">(HTML Element) HTML element to append this image to</param>
        if(elementDiv != undefined)
        {
            this.m_elContainer = elementDiv;
                
            this.m_elContainer.appendChild(this.m_elImage);
        }
    },
    
    getElement:function()
    {
        /// <summary>Returns the 'img' HTML element this object contains</summary>
        return this.m_elImage;
    },
    
    getWidth:function()
    {
        /// <summary>Retrieves the style.width property value of this image</summary>
        var toReturn = null;
        if(this.m_elImage != undefined)
            toReturn = this.m_elImage.width;
        return toReturn;
    },
    
    setWidth:function(value)
    {
        /// <summary>Sets the style.width property of this image</summary>
        /// <param name="value">(string/int) New value for the style.width property</param>
        if((this.m_elImage != undefined) && (value != undefined))
        {
            this.m_varWidth = value;
            this.m_elImage.style.width = this.m_varWidth;
        }
    },
    
    getHeight:function()
    {
        /// <summary>Retrieves the style.height property value of this image</summary>
        var toReturn = null;
        if(this.m_elImage != undefined)
            toReturn = this.m_elImage.height;
        return toReturn;
    },
    
    setHeight:function(value)
    {
        /// <summary>Sets the style.height property of this image</summary>
        /// <param name="value">(string/int) New value for the style.height property</param>
        if((this.m_elImage != undefined) && (value != undefined))
        {
            this.m_varHeight = value;
            this.m_elImage.style.height = this.m_varHeight;
        }
    },
    
    setBorder:function(value)
    {
        /// <summary>Sets the style.border property of this image</summary>
        /// <param name="value">(string) New value for the style.border property (width/style/color)</param>
        if((this.m_elImage != undefined) && (value != undefined))
            this.m_elImage.style.border = value;
    },
    
    setBorderColor:function(value)
    {
        /// <summary>Sets the style.borderColor of this image</summary>
        /// <param name="value">(string) New color</param>
        if((this.m_elImage != undefined) && (value != undefined))
            this.m_elImage.style.borderColor = value;
    },
    
    setBorderWidth:function(value)
    {
        /// <summary>Sets the style.borderWidth of this image</summary>
        /// <param name="value">(string/int) New border width</param>
        if((this.m_elImage != undefined) && (value != undefined))
            this.m_elImage.style.borderWidth = value;
    },
    
    getID:function()
    {
        /// <summary>Retrieves the id of this 'img' HTML element</summary>
        return this.m_strID;
    },
    
    setPosition:function(value)
    {
        /// <summary>Sets the style.position property of this image</summary>
        /// <param name="value">(string) [static] | [absolute] | [relative] | [fixed]</param>
        if(this.m_elImage)
            this.m_elImage.style.position = value;
    },
    setClassName:function(value)
    {
        /// <summary>Sets the className property</summary>
        /// <param name="value">(string) new className</param>
        if((this.m_elImage != undefined) && (value != undefined))
            this.m_elImage.className = value;
    },
    
    getClassName:function()
    {
        /// <summary>Returns the class name of this div</summary>
        var toReturn = 'undefined';
        if(this.m_elImage != undefined)
            toReturn = this.m_elImage.className;
        return toReturn;
    },
    
    setSource:function(value)
    {
        /// <summary>Sets the src property</summary>
        /// <param name="value">(string) new src</param>
        if((this.m_elImage != undefined) && (value != undefined))
            this.m_elImage.src = value;
    },    
    
    getSource:function()
    {
        /// <summary>Returns the class name of this div</summary>
        var toReturn = 'undefined';
        if(this.m_elImage != undefined)
            toReturn = this.m_elImage.src;
        return toReturn;
    },
    
    setOffset:function(dimension, value)
    {
        /// <summary>Sets the offset value for the specified side of this image</summary>
        /// <param name="dimension">(string) [top] | [right] | [bottom] | [left]</param>
        /// <param name="value">(string/int) Value for the offset</param>
        if((this.m_elImage != undefined) && (dimension != undefined) && (typeof dimension == 'string'))
        {
            dimension = dimension.toLowerCase();
            switch(dimension)
            {
                case 'top':
                    this.m_elImage.top = value;
                    break;
                case 'right':
                    this.m_elImage.right = value;
                    break;
                case 'bottom':
                    this.m_elImage.bottom = value;
                    break;
                case 'left':
                    this.m_elImage.left = value;
                    break;
            }
        }
    }
    
}
