var id_PageDiv_CP_InfoMsg = 'pd_id_CL_InfoMsg';
var g_tabCPInfoMsg = null;
var g_divCPInfoMsg = null;

function initCapsLockWarning( locObj)
{
    if ( null == locObj || undefined == locObj )
        return;
    // create cap lock warning info
    g_divCPInfoMsg = new DivObj('CPInfoDiv');
    var info = locObj.getString(L_TEXT_CAPSLOCKON_T);
    g_tabCPInfoMsg = locObj.createInfoTable('Info' , info );
    if ( null != g_tabCPInfoMsg && undefined != g_tabCPInfoMsg)
        g_divCPInfoMsg.getElement().appendChild(g_tabCPInfoMsg);

    g_divCPInfoMsg.draw(document.getElementById( id_PageDiv_CP_InfoMsg));
    g_divCPInfoMsg.hide(true);
}
// set focus on username or password textbox
function setDefaultFocus()
{
    // direct back from fed user page
    if ( false == g_bInitRealmChecking )
    {
        g_tbUsername.getElement().focus();    
        g_tbUsername.select();
        return;
    }
    
    if ( g_tbUsername.isEnable() && '' == g_tbUsername.getText()  )
    {
        g_tbUsername.getElement().focus();    
        return;
    }

    if(g_divPasswordTextBox.isVisible())
    {
        g_tbPassword.getElement().focus();
        return;
    } 
    else if ( g_divPINTextBox.isVisible() )
    {
        g_tbPIN.getElement().focus();
        return;
    }
    return;
}


// ------------------------------------------------------------------
// showForEID()
// 
// Hides or shows all the Fields for the Smart Cart credtype, depending
// on the 'visible' param
// ------------------------------------------------------------------
function showForEID(visible)
{
    if(g_divPINLbl)
    {
        if(visible)
            g_divPINLbl.show(true);
        else
            g_divPINLbl.hide(true);
    }
    if(g_divPINTextBox)
    {
        if(visible)
            g_divPINTextBox.show(true);
        else
            g_divPINTextBox.hide(true);
    }
    if(g_divCertLbl)
    {
        if(visible)
            g_divCertLbl.show(true);
        else
            g_divCertLbl.hide(true);
    }
    if(g_divCertPicker)
    {
        if(visible)
            g_divCertPicker.show(true);
        else
            g_divCertPicker.hide(true);
    }
    if ( visible )
    {
        if (g_ExObj.hasDummyCertOnly(g_arrCertList) )
        {
            if(g_btnSignIn != undefined)
            {
                g_btnSignIn.disable();
                g_divPINLbl.hide(true);
                g_divPINTextBox.hide(true);
            }
        }            
        else
            switchCert();    
    }
}

// ------------------------------------------------------------------
// showForPassword()
// 
// Hides or shows all the Fields for the password credtype, depending
// on the 'visible' param
// ------------------------------------------------------------------
function showForPassword(visible)
{
    if(g_divPasswordLbl)
    {
        if(visible)
            g_divPasswordLbl.show(true);
        else
            g_divPasswordLbl.hide(true);
    }
    if(g_divPasswordTextBox)
    {
        if(visible)
            g_divPasswordTextBox.show(true);
        else
            g_divPasswordTextBox.hide(true);
    }
    if(g_divForgotLink)
    {
        if(visible)
            g_divForgotLink.show(true);
        else
            g_divForgotLink.hide(true);
    }
    if(g_divRememberPwd != null && g_divRememberPwd != undefined && !g_bHideRememberPwd)
    {
        if(visible)
            g_divRememberPwd.show(true);
        else
            g_divRememberPwd.hide(true);
    }
    if(g_btnSignIn != undefined)
    {
        if(visible)
            g_btnSignIn.enable();
    }
}
function switchCert()
{
    g_divPINTextBox.hide(true);
    g_divPINLbl.hide(true);

    if ( g_comboCertPick )
    {
        g_dispChosenCert = g_comboCertPick.getSelectedObj();
        if ( g_dispChosenCert != null  )
        {
            if( g_ExObj.isSmartCardCert( g_dispChosenCert.Value ) )
            {
                g_divPINTextBox.show(true);
                g_divPINLbl.show(true);
                g_divPINTextBox.setPadding("top", 12);
                g_divPINLbl.setPadding("top", 12);
                g_tbPIN.setText('');
            }
        }
    }    

    g_ExObj.adjustWindowSize( id_tbLayout, g_CobrandObj, true, min_Height);                 
}

// ------------------------------------------------------------------
// remembermeClicked()
// 
// When remember me check box is unchecked, we should uncheck the remember password
//
// ------------------------------------------------------------------
function remembermeClicked()
{
    var cbrMe = document.getElementById('CheckBoxObj' + id_cb_rememberme);
    var cbrPwd = document.getElementById('CheckBoxObj'  + id_cb_rememberpwd);    
    if ( undefined != cbrMe && undefined != cbrPwd )
    {
        if ( !cbrMe.checked )
        {
            cbrPwd.checked = false;
        }
    }
}

// ------------------------------------------------------------------
// rememberpwdClicked()
// 
// When remember password is checked, we should check the remember me too
//
// ------------------------------------------------------------------
function rememberpwdClicked()
{
    var cbrMe = document.getElementById('CheckBoxObj' + id_cb_rememberme);
    var cbrPwd = document.getElementById('CheckBoxObj'  + id_cb_rememberpwd);    
    if ( undefined != cbrMe && undefined != cbrPwd )
    {
        if ( cbrPwd.checked )
        {
            cbrMe.checked = true;
        }            
    }
}

function applySavedCheckStates()
{
    if ( g_strRedirNewPage == 'yes' )
        return;

    if( 'undefined' == typeof g_strDefaultUsername || null == g_strDefaultUsername )
        return;

    var errorCode = g_ExObj.getErrorCode();
    if(0 == errorCode || null == errorCode )
        return;

    var savepassword = g_ExObj.isUserPersisted( g_strDefaultUsername, PPCRL_CREDTYPE_PASSWORD);
    var savemember = g_ExObj.isUserPersisted( g_strDefaultUsername, PPCRL_CREDTYPE_MEMBERNAMEONLY);

    if ( g_cbRememberPwd != null && g_cbRememberPwd!= undefined && g_cbRememberPwd.isEnabled())
    {
        g_cbRememberPwd.setChecked(savepassword);
    }            
    
    if ( g_cbRememberUser != null && g_cbRememberUser!= undefined && g_cbRememberUser.isEnabled())
    {
        g_cbRememberUser.setChecked(savemember||savepassword);
    }
            
}


// some preset properties are not honored in XP, need to refresh themm
// after all elements have been rendered
function refreshElements()
{
    if ( g_cbRememberUser != null && g_cbRememberUser!= undefined )
        g_cbRememberUser.refresh();
    if ( g_cbRememberPwd != null && g_cbRememberPwd!= undefined )        
        g_cbRememberPwd.refresh();
}
