﻿// *************************************************************************************************************************
// QueryString (Javascript Object)
//
// Object used to parsing and breaking up a query string
// *************************************************************************************************************************

QueryString = function(query)
{
    /// <summary>Constructor for QueryString which takes the raw query string as a parameter</summary>
    /// <param name="query">(string) QueryString to parse (If null, automatically grabs the query string from location.search)</param>
    this.params = new Array();
    if(query == undefined)
        query = location.search.substring(1, location.search.length);
        
    if(query.indexOf('?') == 0)
        query = query.substring(1, query.length);
        
    if(query.length > 0)
    {
        query = query.replace(/\+/g, ' ');
        var pairs = query.split('&');
        
        for(var i=0; i<pairs.length; i++)
        {
            var pair = pairs[i].split('=');
            var pName = unescape(pair[0]);
            var pValue = (pair[1]) ? pair[1] : '';
            this.params[pName] = pValue;
        }
    }
}

QueryString.prototype = 
{
    getValue:function(pName)
    {
        /// <summary>Retrieves the value for the specified query string parameter (blank string if not found)</summary>
        /// <param name="pName">(string) Name of query string parameter to retrieve value for</param>
        return ((pName != undefined) && (this.params[pName] != undefined)) ? this.params[pName] : '';
    }
}