﻿var SAVED_USER_PROP_CERT_THUMB = 'CertThumbPrint';
var LAST_SIGNIN_FED_PARTNER_NAME = 'FedPartnerName';

// *************************************************************************************************************************
// SavedUserObj (Javascript Object)
//
// Represents data for a persisted/active user
// *************************************************************************************************************************

SavedUserObj = function(username)
{
    this.m_strUsername = username;
    this.m_strPassword = null;
    this.m_bSignedIn = false;
    this.m_bRememberMe = false;
    this.m_bRememberMe_orig = false;
    this.m_bPasswordSaved = false;
    this.m_bPasswordSaved_orig = false;
    this.m_bNewPassword = false;
    this.m_strCredType = null;
    this.m_strImage = WLID_IMAGE_DEFAULT_USER_TILE;
    this.m_iIndex = 0;
    this.m_bSSO = false;
    this.m_arrProperties = new Array();
}

SavedUserObj.compare = function(savedUserOne, savedUserTwo)
{
    /// <summary>Compares two saved users (1) Active User w/ Saved Password (2) Active User w/ Rememember Me (3) Active User 
    /// (4) Persisted User w/ Saved Password (5) Persisted User</summary>
    /// <param name="savedUserOne">First user to compare</param>
    /// <param name="savedUserTwo">Second user to compare</param>
    if((savedUserOne == undefined) && (savedUserTwo == undefined))
        return 0;

    if(savedUserOne == undefined)
        return 1;

    if(savedUserTwo == undefined)
        return -1;

    var userOneSignedIn = savedUserOne.getSignedIn();
    var userTwoSignedIn = savedUserTwo.getSignedIn();

    if(userOneSignedIn == userTwoSignedIn)
    {
        var onePersistState = (savedUserOne.getSavePassword(false) == true) ? 0 : (savedUserOne.getRememberMe(false) == true) ? 1 : 2;
        var twoPersistState = (savedUserTwo.getSavePassword(false) == true) ? 0 : (savedUserTwo.getRememberMe(false) == true) ? 1 : 2;
        if(onePersistState == twoPersistState)
        {
            // For users with save state priority, just compare their original indexes
            var indexOne = savedUserOne.getIndex();
            var indexTwo = savedUserTwo.getIndex();
            return (indexOne - indexTwo);
        }
        else
        {
            return (onePersistState - twoPersistState);
        }
    }
    else
    {
        if(userOneSignedIn)
            return -1;
        else
            return 1;
    }
}

SavedUserObj.prototype =
{
    setUsername:function(username)
    {
        /// <summary>Set the username for this user</summary>
        /// <param name="value">(string) New Username</param>
        if(username != undefined)
            this.m_strUsername = username;
    },
    
    getUsername:function()
    {
        /// <summary>Gets the Username (string) of this user</summary>
        return this.m_strUsername;
    },
    
    setPassword:function(password)
    {
        /// <summary>Set the password for this user</summary>
        /// <param name="value">(string) New Password</param>
        this.m_strPassword = password;
    },
    
    getPassword:function()
    {
        /// <summary>Gets the Password (string) of this user</summary>
        return this.m_strPassword;
    },
    
    setSignedIn:function(value)
    {
        /// <summary>Set the 'Signed In' state for this user</summary>
        /// <param name="value">(bool) New Signed In state</param>
        this.m_bSignedIn = (value == true) ? true : false;
    },
    
    getSignedIn:function()
    {
        /// <summary>Gets the 'Signed In' state (bool) of this user</summary>
        return this.m_bSignedIn;
    },
    
    setSavePassword:function(value, original)
    {
        /// <summary>Sets the save password state of this user.  There is an original saved password state, and a current saved password state</summary>
        /// <param name="value">(bool) Value of Save Password</param>
        /// <param name="original">(bool) True = Set Original and Current value, False = Set current value only</param>
        this.m_bPasswordSaved = (value == true) ? true : false;
        if(original)
            this.m_bPasswordSaved_orig = this.m_bPasswordSaved;
    },
    
    getSavePassword:function(original)
    {
        /// <summary>Gets either the current saved password state, or original saved password state</summary>
        /// <param name="original">(bool) True = return original value, False = return current value</param>
        if(original)
            return this.m_bPasswordSaved_orig;
        return this.m_bPasswordSaved;
    },
    
    setRememberMe:function(value, original)
    {
        /// <summary>Sets the remember me state of this user.  There is an original remember me state, and a current rememeber me state</summary>
        /// <param name="value">(bool) Value of Remember Me</param>
        /// <param name="original">(bool) True = Set Original and Current value, False = Set current value only</param>
        this.m_bRememberMe = (value == true) ? true : false;
        if(original)
            this.m_bRememberMe_orig = this.m_bRememberMe;
    },
    
    getRememberMe:function(original)
    {
        /// <summary>Gets either the current remember me state, or original remember me state</summary>
        /// <param name="original">(bool) True = return original value, False = return current value</param>
        if(original)
            return this.m_bRememberMe_orig;
        return this.m_bRememberMe;
    },
    
    setCredType:function(value)
    {
        /// <summary>Set the credential type for this user</summary>
        /// <param name="value">(string) New credential type</param>
        this.m_strCredType = value;
    },
    
    getCredType:function()
    {
        /// <summary>Gets the Credential Type (string) of this user</summary>
        return this.m_strCredType;
    },
    
    setImage:function(value)
    {
        /// <summary>Set the path of the user image for this user</summary>
        /// <param name="value">(string) New Image Path</param>
        if((value != undefined) && (value.length > 0))
            this.m_strImage = value;
    },
    
    getImage:function()
    {
        /// <summary>Gets the Image Path (string) of this user</summary>
        return this.m_strImage;
    },
    
    getNewPassword:function()
    {
        /// <summary>Gets the 'New Password' state (bool) of this user</summary>
        return this.m_bNewPassword;
    },
    
    setNewPassword:function(value)
    {
        /// <summary>Set the 'New Password' state for this user</summary>
        /// <param name="value">(bool) New 'New Password' State</param>
        this.m_bNewPassword = (value == true) ? true : false;
    },
    
    setIndex:function(value)
    {
        /// <summary>Set the index value for this user</summary>
        /// <param name="value">(int) New index</param>
        if(value != undefined)
            this.m_iIndex = value;
    },
    
    getIndex:function()
    {
        /// <summary>Gets the index (int) of this user</summary>
        return this.m_iIndex;
    },
    
    setSSO:function(value)
    {
        /// <summary>Set the SSO state of this user</summary>
        /// <param name="value">(bool) New SSO State</param>
        this.m_bSSO = value;
    },
    
    getSSO:function()
    {
        /// <summary>Get the SSO State (string) of this user</summary>
        return this.m_bSSO;
    },
    
    setProperty:function(propName, propValue)
    {
        /// <summary>Set the value for an extra saved user property</summary>
        /// <param name="propName">(string) Name of property to set</param>
        /// <param name="propValue">(bool) Value of property to set</param>
        this.m_arrProperties[propName] = propValue;
    },
    
    getProperty:function(propName)
    {
        /// <summary>Get the value for an extra saved user property</summary>
        /// <param name="propName">(string) Name of property to get</param>
        var toReturn = null;
        if((this.m_arrProperties != undefined) && (propName != undefined) && (this.m_arrProperties[propName] != undefined))
            toReturn = this.m_arrProperties[propName];
        return toReturn;
    },
    
    getProperties:function()
    {
        /// <summary>Gets the map (array) of extra user properties</summary>
        return this.m_arrProperties;
    }
}