/*
 * Decompiled with CFR 0.152.
 */
package org.xmlpull.v1;

import java.io.InputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class XmlPullParserFactory {
    private static Class a;
    public static final String PROPERTY_NAME = "org.xmlpull.v1.XmlPullParserFactory";
    private static final String b = "/META-INF/services/org.xmlpull.v1.XmlPullParserFactory";
    protected Vector parserClasses;
    protected String classNamesLocation;
    protected Vector serializerClasses;
    protected Hashtable features = new Hashtable();

    protected XmlPullParserFactory() {
    }

    public void setFeature(String string, boolean bl) throws XmlPullParserException {
        this.features.put(string, new Boolean(bl));
    }

    public boolean getFeature(String string) {
        Boolean bl = (Boolean)((XmlPullParserFactory)((Object)bl)).features.get(string);
        if (bl != null) {
            return bl;
        }
        return false;
    }

    public void setNamespaceAware(boolean bl) {
        this.features.put("http://xmlpull.org/v1/doc/features.html#process-namespaces", new Boolean(bl));
    }

    public boolean isNamespaceAware() {
        return this.getFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces");
    }

    public void setValidating(boolean bl) {
        this.features.put("http://xmlpull.org/v1/doc/features.html#validation", new Boolean(bl));
    }

    public boolean isValidating() {
        return this.getFeature("http://xmlpull.org/v1/doc/features.html#validation");
    }

    public XmlPullParser newPullParser() throws XmlPullParserException {
        if (this.parserClasses == null) {
            throw new XmlPullParserException("Factory initialization was incomplete - has not tried " + this.classNamesLocation);
        }
        if (this.parserClasses.size() == 0) {
            throw new XmlPullParserException("No valid parser classes found in " + this.classNamesLocation);
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < this.parserClasses.size()) {
            Class clazz = (Class)this.parserClasses.elementAt(n2);
            try {
                XmlPullParser xmlPullParser = (XmlPullParser)clazz.newInstance();
                Enumeration enumeration = this.features.keys();
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    Boolean bl = (Boolean)this.features.get(string);
                    if (bl == null || !bl.booleanValue()) continue;
                    xmlPullParser.setFeature(string, true);
                }
                return xmlPullParser;
            }
            catch (Exception exception) {
                stringBuffer.append(clazz.getName() + ": " + exception.toString() + "; ");
                ++n2;
            }
        }
        throw new XmlPullParserException("could not create parser: " + stringBuffer);
    }

    public XmlSerializer newSerializer() throws XmlPullParserException {
        if (this.serializerClasses == null) {
            throw new XmlPullParserException("Factory initialization incomplete - has not tried " + this.classNamesLocation);
        }
        if (this.serializerClasses.size() == 0) {
            throw new XmlPullParserException("No valid serializer classes found in " + this.classNamesLocation);
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < this.serializerClasses.size()) {
            Class clazz = (Class)this.serializerClasses.elementAt(n2);
            try {
                XmlSerializer xmlSerializer = (XmlSerializer)clazz.newInstance();
                return xmlSerializer;
            }
            catch (Exception exception) {
                stringBuffer.append(clazz.getName() + ": " + exception.toString() + "; ");
                ++n2;
            }
        }
        throw new XmlPullParserException("could not create serializer: " + stringBuffer);
    }

    public static XmlPullParserFactory newInstance() throws XmlPullParserException {
        return XmlPullParserFactory.newInstance(null, null);
    }

    public static XmlPullParserFactory newInstance(String string, Class object) throws XmlPullParserException {
        Serializable serializable;
        if (object == null) {
            object = a;
        }
        String string2 = null;
        if (string == null || string.length() == 0 || "DEFAULT".equals(string)) {
            try {
                int n2;
                object = ((Class)object).getResourceAsStream(b);
                if (object == null) {
                    throw new XmlPullParserException("resource not found: /META-INF/services/org.xmlpull.v1.XmlPullParserFactory make sure that parser implementing XmlPull API is available");
                }
                serializable = new StringBuffer();
                while ((n2 = ((InputStream)object).read()) >= 0) {
                    if (n2 <= 32) continue;
                    ((StringBuffer)serializable).append((char)n2);
                }
                ((InputStream)object).close();
                string = ((StringBuffer)serializable).toString();
            }
            catch (Exception exception) {
                throw new XmlPullParserException(null, null, exception);
            }
            string2 = "resource /META-INF/services/org.xmlpull.v1.XmlPullParserFactory that contained '" + string + "'";
        } else {
            string2 = "parameter classNames to newInstance() that contained '" + string + "'";
        }
        object = null;
        serializable = new Vector();
        Vector vector = new Vector();
        int n3 = 0;
        while (n3 < string.length()) {
            int n4 = string.indexOf(44, n3);
            if (n4 == -1) {
                n4 = string.length();
            }
            String string3 = string.substring(n3, n4);
            Class<?> clazz = null;
            Object var8_11 = null;
            try {
                clazz = Class.forName(string3);
                var8_11 = clazz.newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (clazz != null) {
                boolean bl = false;
                if (var8_11 instanceof XmlPullParser) {
                    ((Vector)serializable).addElement(clazz);
                    bl = true;
                }
                if (var8_11 instanceof XmlSerializer) {
                    vector.addElement(clazz);
                    bl = true;
                }
                if (var8_11 instanceof XmlPullParserFactory) {
                    if (object == null) {
                        object = var8_11;
                    }
                    bl = true;
                }
                if (!bl) {
                    throw new XmlPullParserException("incompatible class: " + string3);
                }
            }
            n3 = n4 + 1;
        }
        if (object == null) {
            object = new XmlPullParserFactory();
        }
        ((XmlPullParserFactory)object).parserClasses = serializable;
        ((XmlPullParserFactory)object).serializerClasses = vector;
        ((XmlPullParserFactory)object).classNamesLocation = string2;
        return object;
    }

    static {
        XmlPullParserFactory xmlPullParserFactory = new XmlPullParserFactory();
        a = xmlPullParserFactory.getClass();
    }
}

