/*
 * Decompiled with CFR 0.152.
 */
package com.jargon.cedp;

public class Rectangle {
    public int x;
    public int y;
    public int w;
    public int h;

    public static void union(Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3) throws IllegalArgumentException {
        if (rectangle == null) {
            throw new IllegalArgumentException();
        }
        if (rectangle2 == null) {
            throw new IllegalArgumentException();
        }
        if (rectangle3 == null) {
            throw new IllegalArgumentException();
        }
        int n2 = Math.min(rectangle.x, rectangle2.x);
        int n3 = Math.min(rectangle.y, rectangle2.y);
        int n4 = Math.max(rectangle.x + rectangle.w, rectangle2.x + rectangle2.w);
        int n5 = Math.max(rectangle.y + rectangle.h, rectangle2.y + rectangle2.h);
        int n6 = n4 - n2;
        rectangle3.x = n2;
        rectangle3.y = n3;
        rectangle3.w = n6;
        rectangle3.h = n5 -= n3;
    }

    public Rectangle() {
    }

    public Rectangle(int n2, int n3, int n4, int n5) {
        this.x = n2;
        this.y = n3;
        this.w = n4;
        this.h = n5;
    }

    public Rectangle(Rectangle rectangle) {
        if (rectangle != null) {
            this.x = rectangle.x;
            this.y = rectangle.y;
            this.w = rectangle.w;
            this.h = rectangle.h;
        }
    }

    public void assume(Rectangle rectangle) {
        if (rectangle != null) {
            this.x = rectangle.x;
            this.y = rectangle.y;
            this.w = rectangle.w;
            this.h = rectangle.h;
        }
    }

    public boolean isZero() {
        return this.x == 0 && this.y == 0 && this.w == 0 && this.h == 0;
    }

    public void setZero() {
        this.x = 0;
        this.y = 0;
        this.w = 0;
        this.h = 0;
    }

    public boolean contains(int n2, int n3) {
        int n4 = this.x;
        int n5 = this.y;
        int n6 = this.x + this.w;
        int n7 = this.y + this.h;
        if (n2 < n4 || n2 > n6) {
            return false;
        }
        return n3 >= n5 && n3 <= n7;
    }

    public boolean intersects(Rectangle rectangle) throws IllegalArgumentException {
        if (rectangle == null) {
            throw new IllegalArgumentException();
        }
        int n2 = this.x;
        int n3 = this.y;
        int n4 = this.w;
        int n5 = this.h;
        int n6 = rectangle.x;
        int n7 = rectangle.y;
        int n8 = rectangle.w;
        int n9 = rectangle.h;
        if (n7 + n9 < n3) {
            return false;
        }
        if (n7 > n3 + n5) {
            return false;
        }
        if (n6 + n8 < n2) {
            return false;
        }
        return n6 <= n2 + n4;
    }

    public void intersection(Rectangle rectangle) throws IllegalArgumentException {
        if (rectangle == null) {
            throw new IllegalArgumentException();
        }
        int n2 = this.x;
        int n3 = this.y;
        int n4 = rectangle.x;
        int n5 = rectangle.y;
        long l2 = n2;
        l2 += (long)this.w;
        long l3 = n3;
        l3 += (long)this.h;
        long l4 = n4;
        l4 += (long)rectangle.w;
        long l5 = n5;
        l5 += (long)rectangle.h;
        if (n2 < n4) {
            n2 = n4;
        }
        if (n3 < n5) {
            n3 = n5;
        }
        if (l2 > l4) {
            l2 = l4;
        }
        if (l3 > l5) {
            l3 = l5;
        }
        l3 -= (long)n3;
        if ((l2 -= (long)n2) < Integer.MIN_VALUE) {
            l2 = Integer.MIN_VALUE;
        }
        if (l3 < Integer.MIN_VALUE) {
            l3 = Integer.MIN_VALUE;
        }
        this.x = n2;
        this.y = n3;
        this.w = (int)l2;
        this.h = (int)l3;
    }

    public void union(Rectangle rectangle) throws IllegalArgumentException {
        if (rectangle == null) {
            throw new IllegalArgumentException();
        }
        int n2 = Math.min(this.x, rectangle.x);
        int n3 = Math.min(this.y, rectangle.y);
        int n4 = Math.max(this.x + this.w, rectangle.x + rectangle.w);
        int n5 = Math.max(this.y + this.h, rectangle.y + rectangle.h);
        this.x = n2;
        this.y = n3;
        this.w = n4 -= n2;
        this.h = n5 -= n3;
    }

    public boolean equals(Object object) throws ClassCastException {
        object = (Rectangle)object;
        return this.x == ((Rectangle)object).x && this.y == ((Rectangle)object).y && this.w == ((Rectangle)object).w && this.h == ((Rectangle)object).h;
    }

    public int hashCode() {
        return this.x + this.y + this.w + this.h;
    }

    public String toString() {
        return "[" + this.x + "," + this.y + " " + this.w + "," + this.h + "]";
    }
}

