/*
 * Decompiled with CFR 0.152.
 */
package com.javelindvd.bluray.utility;

import com.javelindvd.bluray.utility.Debug;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.IOException;
import java.net.URL;
import org.dvb.ui.FontFactory;
import org.dvb.ui.FontFormatException;
import org.dvb.ui.FontNotAvailableException;
import org.havi.ui.HGraphicButton;
import org.havi.ui.HScene;
import org.havi.ui.HSceneFactory;
import org.havi.ui.HScreen;
import org.havi.ui.HStaticIcon;
import org.havi.ui.HStaticText;
import org.havi.ui.HTextButton;
import org.havi.ui.HVisible;

public final class GUI {
    private static final String a;
    public static final int AUTO = -1;
    public static final Color CLEAR;
    private static Class b;

    static {
        Class<?> clazz = b;
        if (clazz == null) {
            try {
                clazz = b = Class.forName("com.javelindvd.bluray.utility.GUI");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        a = clazz.getName();
        CLEAR = new Color(0, 0, 0, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearRect(Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        Debug.logMethod("GUI", a, "clearRect", 1);
        Graphics2D graphics2D2 = graphics2D;
        synchronized (graphics2D2) {
            Color color = graphics2D.getColor();
            Composite composite = graphics2D.getComposite();
            graphics2D.setColor(CLEAR);
            graphics2D.setComposite(AlphaComposite.Src);
            graphics2D.fillRect(n, n2, n3, n4);
            graphics2D.setComposite(composite);
            graphics2D.setColor(color);
            return;
        }
    }

    public static void clearRect(Graphics2D graphics2D, Rectangle rectangle) {
        GUI.clearRect(graphics2D, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HStaticIcon addHStaticIcon(Container container, URL object, int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl) {
        Debug.logMethod("GUI", a, "addHStaticIcon");
        HStaticIcon hStaticIcon = null;
        if (container != null && object != null) {
            Container container2 = container;
            synchronized (container2) {
                object = GUI.getImageResource((URL)object, container);
                if (object != null) {
                    if (n3 == -1) {
                        n3 = ((Image)object).getWidth(container);
                    }
                    if (n4 == -1) {
                        n4 = ((Image)object).getHeight(container);
                    }
                    n = GUI.alignHorizontal(container, n, n3, n5, n7);
                    n2 = GUI.alignVertical(container, n2, n4, n6, n7);
                    hStaticIcon = new HStaticIcon((Image)object, n, n2, n3, n4);
                    hStaticIcon.setHorizontalAlignment(n5);
                    hStaticIcon.setVerticalAlignment(n6);
                    hStaticIcon.setBordersEnabled(bl);
                    container.add((Component)hStaticIcon);
                }
            }
        }
        return hStaticIcon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HStaticText addHStaticText(Container container, String string, int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl, Color color) {
        Debug.logMethod("GUI", a, "addHStaticText");
        HStaticText hStaticText = null;
        if (container != null) {
            Container container2 = container;
            synchronized (container2) {
                hStaticText = new HStaticText(string);
                container.add((Component)hStaticText);
                GUI.adjustBounds((HVisible)hStaticText, container, n, n2, n3, n4, n5, n6, n7);
                hStaticText.setHorizontalAlignment(n5);
                hStaticText.setVerticalAlignment(n6);
                hStaticText.setBordersEnabled(bl);
                if (color != null) {
                    hStaticText.setForeground(color);
                }
            }
        }
        return hStaticText;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HTextButton addHTextButton(Container container, String string, int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl, Color color) {
        Debug.logMethod("GUI", a, "addHTextButton");
        HTextButton hTextButton = null;
        if (container != null) {
            Container container2 = container;
            synchronized (container2) {
                hTextButton = new HTextButton(string);
                container.add((Component)hTextButton);
                GUI.adjustBounds((HVisible)hTextButton, container, n, n2, n3, n4, n5, n6, n7);
                hTextButton.setHorizontalAlignment(n5);
                hTextButton.setVerticalAlignment(n6);
                hTextButton.setBordersEnabled(bl);
                if (color != null) {
                    hTextButton.setForeground(color);
                }
            }
        }
        return hTextButton;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HGraphicButton addHGraphicButton(Container container, URL object, URL object2, URL object3, int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl) {
        Debug.logMethod("GUI", a, "addHGraphicButton");
        HGraphicButton hGraphicButton = null;
        if (container != null && object != null && object2 != null && object3 != null) {
            Container container2 = container;
            synchronized (container2) {
                object = GUI.getImageResource((URL)object, container);
                object2 = GUI.getImageResource((URL)object2, container);
                object3 = GUI.getImageResource((URL)object3, container);
                if (object != null && object2 != null && object3 != null) {
                    if (n3 == -1) {
                        n3 = ((Image)object).getWidth(container);
                    }
                    if (n4 == -1) {
                        n4 = ((Image)object).getHeight(container);
                    }
                    n = GUI.alignHorizontal(container, n, n3, n5, n7);
                    n2 = GUI.alignVertical(container, n2, n4, n6, n7);
                    hGraphicButton = new HGraphicButton((Image)object, (Image)object2, (Image)object3, n, n2, n3, n4);
                    hGraphicButton.setHorizontalAlignment(n5);
                    hGraphicButton.setVerticalAlignment(n6);
                    hGraphicButton.setBordersEnabled(bl);
                    container.add((Component)hGraphicButton);
                }
            }
        }
        return hGraphicButton;
    }

    public static void adjustBounds(HVisible hVisible, Container container, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        Debug.logMethod("GUI", a, "adjustBounds", new String[]{Integer.toString(n), Integer.toString(n2), Integer.toString(n3), Integer.toString(n4)});
        if (container != null && hVisible != null) {
            Dimension dimension = hVisible.getPreferredSize();
            if (dimension != null) {
                if (dimension.width <= 0 || dimension.height <= 0) {
                    Debug.log("GUI", 8, "HVisible.getPreferredSize() returned a zero or negative length dimension.");
                }
                if (n3 == -1) {
                    n3 = dimension.width;
                } else if (n3 < 0 && dimension.width > (n3 = -n3)) {
                    n3 = dimension.width;
                }
                if (n4 == -1 || n4 < 0) {
                    if (n4 != -1) {
                        if (dimension.height > (n4 = -n4)) {
                            n4 = dimension.height;
                        }
                    } else {
                        n4 = dimension.height;
                    }
                }
            } else {
                Debug.log("GUI", 16, "HVisible.getPreferredSize() returned null.");
            }
            if ((dimension = hVisible.getMinimumSize()) != null) {
                if (dimension.width <= 0 || dimension.height <= 0) {
                    Debug.log("GUI", 8, "HVisible.getMinimumSize() returned a zero or negative length dimension.");
                }
                if (n4 < dimension.height) {
                    n4 = dimension.height;
                }
            } else {
                Debug.log("GUI", 16, "HVisible.getMinimumSize() returned null.");
            }
            n = GUI.alignHorizontal(container, n, n3, n5, n7);
            n2 = GUI.alignVertical(container, n2, n4, n6, n7);
            hVisible.setBounds(n, n2, n3, n4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int alignHorizontal(Container container, int n, int n2, int n3, int n4) {
        Debug.logMethod("GUI", a, "alignHorizontal");
        int n5 = n;
        if (container != null) {
            Container container2 = container;
            synchronized (container2) {
                if (n == -1) {
                    switch (n3) {
                        case 0: {
                            n5 = 0;
                            break;
                        }
                        case 2: {
                            n5 = container.getWidth() - n2;
                            break;
                        }
                        case 1: {
                            n5 = (container.getWidth() - n2) / 2;
                        }
                    }
                } else {
                    switch (n4) {
                        case 0: 
                        case 1: 
                        case 2: {
                            n5 = n;
                            break;
                        }
                        case 3: 
                        case 4: 
                        case 5: {
                            n5 -= n2 / 2;
                            break;
                        }
                        case 6: 
                        case 7: 
                        case 8: {
                            n5 -= n2;
                            break;
                        }
                        default: {
                            n5 = n;
                        }
                    }
                }
            }
        }
        return n5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int alignVertical(Container container, int n, int n2, int n3, int n4) {
        Debug.logMethod("GUI", a, "alignVertical");
        int n5 = n;
        if (container != null) {
            Container container2 = container;
            synchronized (container2) {
                if (n == -1) {
                    switch (n3) {
                        case 0: {
                            n5 = 0;
                            break;
                        }
                        case 2: {
                            n5 = container.getHeight() - n2;
                            break;
                        }
                        case 1: {
                            n5 = (container.getHeight() - n2) / 2;
                        }
                    }
                } else {
                    switch (n4) {
                        case 0: 
                        case 3: 
                        case 6: {
                            n5 = n;
                            break;
                        }
                        case 1: 
                        case 4: 
                        case 7: {
                            n5 -= n2 / 2;
                            break;
                        }
                        case 2: 
                        case 5: 
                        case 8: {
                            n5 -= n2;
                            break;
                        }
                        default: {
                            n5 = n;
                        }
                    }
                }
            }
        }
        return n5;
    }

    public static HScene createHScene(int n, int n2, int n3, int n4, Color color) {
        Debug.logMethod("GUI", a, "createHScene");
        HScene hScene = HSceneFactory.getInstance().getDefaultHScene();
        if (hScene != null) {
            hScene.setLocation(n, n2);
            hScene.setSize(n3, n4);
            if (color != null) {
                hScene.setBackgroundMode(1);
                hScene.setBackground(color);
            }
        } else {
            Debug.log("GUI", 16, "Failed to acquire default scene.");
        }
        return hScene;
    }

    public static FontFactory getFontFactory(URL uRL) {
        Debug.logMethod("GUI", a, "getFontFactory");
        FontFactory fontFactory = null;
        if (uRL != null) {
            try {
                fontFactory = new FontFactory(uRL);
            }
            catch (FontFormatException fontFormatException) {
                Debug.log("GUI", 16, "Unable to load font - " + fontFormatException.getMessage());
            }
            catch (IOException iOException) {
                Debug.log("GUI", 16, "Unable to access font file - " + iOException.getMessage());
            }
        } else {
            try {
                fontFactory = new FontFactory();
            }
            catch (FontFormatException fontFormatException) {
                Debug.log("GUI", 16, "Unable to load font - " + fontFormatException.getMessage());
            }
            catch (IOException iOException) {
                Debug.log("GUI", 16, "Unable to access font file - " + iOException.getMessage());
            }
        }
        return fontFactory;
    }

    public static Font getFont(FontFactory fontFactory, String string, int n, int n2) {
        Debug.logMethod("GUI", a, "getFont");
        Font font = null;
        if (fontFactory == null) {
            fontFactory = GUI.getFontFactory(null);
        }
        if (fontFactory != null && string != null) {
            try {
                font = fontFactory.createFont(string, n, n2);
            }
            catch (FontFormatException fontFormatException) {
                Debug.log("GUI", 16, "Unable to load font - " + fontFormatException.getMessage());
            }
            catch (FontNotAvailableException fontNotAvailableException) {
                Debug.log("GUI", 16, "Font not available - " + fontNotAvailableException.getMessage());
            }
            catch (IOException iOException) {
                Debug.log("GUI", 16, "Unable to access font file - " + iOException.getMessage());
            }
        }
        return font;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Image getImageResource(URL uRL, Component component) {
        Debug.logMethod("GUI", a, "getImageResource");
        Image image = null;
        if (uRL != null && component != null) {
            Component component2 = component;
            synchronized (component2) {
                MediaTracker mediaTracker = new MediaTracker(component);
                image = Toolkit.getDefaultToolkit().createImage(uRL);
                if (image != null) {
                    try {
                        mediaTracker.addImage(image, 0);
                        mediaTracker.waitForAll();
                        if (image.getWidth(component) < 0) {
                            Debug.log("GUI", 16, "Failed to load image: " + Debug.quote(uRL.toString()));
                            image = null;
                        }
                    }
                    catch (Exception exception) {
                        Debug.log("GUI", 16, "Error while loading image: " + Debug.quote(uRL.toString()));
                        image = null;
                    }
                } else {
                    Debug.log("GUI", 16, "Unable to load image: " + Debug.quote(uRL.toString()));
                }
            }
        }
        return image;
    }

    public static Dimension getScreenResolution() {
        Debug.logMethod("GUI", a, "getScreenResolution");
        Dimension dimension = null;
        HScreen hScreen = HScreen.getDefaultHScreen();
        if (hScreen != null) {
            if ((hScreen = hScreen.getDefaultHGraphicsDevice()) != null) {
                if ((hScreen = hScreen.getCurrentConfiguration()) != null) {
                    if ((hScreen = hScreen.getConfigTemplate()) != null) {
                        dimension = (Dimension)hScreen.getPreferenceObject(8);
                        if (dimension != null) {
                            Debug.log("GUI", 4, "Current screen dimension is " + dimension.width + " x " + dimension.height);
                        } else {
                            Debug.log("GUI", 16, "Failed to acquire PIXEL_RESOLUTION preference.");
                        }
                    } else {
                        Debug.log("GUI", 16, "Failed to acquire configuration template.");
                    }
                } else {
                    Debug.log("GUI", 16, "Failed to acquire device configuration.");
                }
            } else {
                Debug.log("GUI", 16, "Failed to acquire default graphics device.");
            }
        } else {
            Debug.log("GUI", 16, "Failed to acquire default screen.");
        }
        return dimension;
    }
}

