/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package susj2me4;

import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.TextBox;
import javax.microedition.lcdui.TextField;
import javax.microedition.midlet.*;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;

/**
 * @author TAMHAN
 */
public class Midlet extends MIDlet implements CommandListener
{
    Form aForm;
    TextField txt;
    Command myCreateDB, myCreateRecord, myOutputAll;
    RecordStore myRS;
    TextBox myTextBox;
    Command myTextBoxOK;

    public Midlet()
    {
        aForm=new Form("Ohm-Calc");
        txt=new TextField("", "", 100, TextField.ANY);
        
        aForm.append(txt);
        
        myCreateDB=new Command("Create/open",Command.OK,0);
        myCreateRecord=new Command("Create record",Command.OK,0);
        myOutputAll=new Command("Output all",Command.OK,0);
        
        aForm.addCommand(myCreateDB);
        aForm.addCommand(myCreateRecord);
        aForm.addCommand(myOutputAll);
        aForm.setCommandListener(this);
    }
    
    public void startApp() 
    {
        Display.getDisplay(this).setCurrent(aForm);
    }
    
    public void pauseApp() {
    }
    
    public void destroyApp(boolean unconditional) 
    {
        if(myRS!=null)
        {
            try
            {
                myRS.closeRecordStore();
            }
            catch (Exception e)
            {
            }
        }
    }
    
    public void commandAction(Command c, Displayable d) 
    {
        System.out.println("Running evt handler");
        if(c==myCreateDB)
        {//Create or connect
            try
            {
                myRS=RecordStore.openRecordStore("TmgnStore", true);
                txt.setString("Record Store offen");
            }
            catch (Exception e)
            {
                myRS=null;
            }
        }
        else if (c==myCreateRecord)
        {
            myTextBox=new TextBox("New record", "", 50, TextField.ANY);
            myTextBoxOK=new Command("OK", Command.OK, 0);
            myTextBox.addCommand(myTextBoxOK);
            myTextBox.setCommandListener(this);
            Display.getDisplay(this).setCurrent(myTextBox);
        }
        else if(c==myTextBoxOK)
        {
            System.out.println("Running OK handler");
            String toStore=myTextBox.getString();
            byte[] myData=toStore.getBytes();
            try
            {
                int recordID=myRS.addRecord(myData, 0, myData.length);
                txt.setString("Successfully created record!" + Integer.toString(recordID));
            }
            catch (Exception e)
            {
                txt.setString("Error creating");
            }
            Display.getDisplay(this).setCurrent(aForm);
        }
        else if(c==myOutputAll)
        {
            try
            {
            StringBuffer outBuffer=new StringBuffer();
            RecordEnumeration anEnum=myRS.enumerateRecords(null, null, true);
            while (anEnum.hasNextElement())
            {
                outBuffer.append(new String(anEnum.nextRecord()));
                outBuffer.append("-");
            }
            txt.setString(outBuffer.toString());
            }
            catch (Exception e)
            {
            
            }
        }
    }
    
    
}
