/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package susj2me6;

import java.util.Enumeration;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.TextField;
import javax.microedition.midlet.*;
import javax.microedition.pim.Contact;
import javax.microedition.pim.ContactList;
import javax.microedition.pim.PIM;
import javax.microedition.pim.PIMException;
import javax.microedition.pim.PIMItem;
import javax.microedition.pim.PIMList;

/**
 * @author TAMHAN
 */
public class Midlet extends MIDlet implements CommandListener  
{
    Form aForm;
    TextField txt;
    List myLBox;
    Command myCheckJSR, myAddAdresses, myCountAdresses;

    public Midlet()
    {
        aForm=new Form("PIM-API");
        txt=new TextField("", "", 100, TextField.ANY);
        
        aForm.append(txt);
        
        myCheckJSR=new Command("JSR checken",Command.OK,0);
        myAddAdresses=new Command("Kontakt hinzu",Command.OK,0);
        myCountAdresses=new Command("Kontakt zählen",Command.OK,0);
                        
        aForm.addCommand(myCheckJSR);
        aForm.addCommand(myAddAdresses);
        aForm.addCommand(myCountAdresses);
        
        aForm.setCommandListener(this);
        
    }
    
    public void startApp() 
    {
        Display.getDisplay(this).setCurrent(aForm);
    }
    
    public void pauseApp() {
    }
    
    public void destroyApp(boolean unconditional) {
    }
    
    public void commandAction(Command c, Displayable d) 
    {
        if(c==myCheckJSR)
        {
            String versionId = System.getProperty("microedition.pim.version");
            if(versionId.equals("1.0"))
            {
                txt.setString("JSR gefunden");
            }
            else
            {
                txt.setString("JSR fehlt oder inkompatibel");        
            }
        } 
        else if (c==myAddAdresses)
        {
            PIM myAccessor=PIM.getInstance();
            PIMList aList;
            try 
            {
                aList = myAccessor.openPIMList(PIM.CONTACT_LIST, PIM.READ_WRITE);
                ContactList cList=(ContactList) aList;
                
                Contact newContact=cList.createContact();
                String[] name = new String[cList.stringArraySize(Contact.NAME)];
                if (cList.isSupportedArrayElement(Contact.NAME, Contact.NAME_FAMILY))
                    name[Contact.NAME_FAMILY] = "Hanna";
                if (cList.isSupportedArrayElement(Contact.NAME, Contact.NAME_GIVEN))
                    name[Contact.NAME_GIVEN] = "Tam";
                
                newContact.addStringArray(Contact.NAME, PIMItem.ATTR_NONE, name);
                newContact.commit();
                
                
                
                aList.close();
            } 
            catch (PIMException ex) {}
            
            
        }
        else if (c==myCountAdresses)
        {
            PIM myAccessor=PIM.getInstance();
            PIMList aList;
            try 
            {
                aList = myAccessor.openPIMList(PIM.CONTACT_LIST, PIM.READ_WRITE);
                ContactList cList=(ContactList) aList;
                
                Enumeration anEnumerator=cList.items();
                int counter=0;
                while(anEnumerator.hasMoreElements())
                {
                    counter++;
                    anEnumerator.nextElement();
                }
                txt.setString("Items: " + Integer.toString(counter));
                aList.close();
            } 
            catch (PIMException ex) 
            {
                txt.setString("PIM error");
            }        
        }
    }
        
}
