/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics;
import java.util.Date;
import java.util.Vector;

public class TimeGraph
extends Display {
    private boolean useUserSuppliedValues = false;
    int datacount;
    int initialTime;
    int hours;
    int minutes;
    int seconds;

    public TimeGraph(DoctorPanel doctorPanel) {
        super(doctorPanel);
        if (this.ymax != 0.0 && this.yticks != 0) {
            this.useUserSuppliedValues = true;
        }
    }

    public void readData(Vector vector) {
        int n = 0;
        if (this.dataList == null) {
            this.dataList = new Vector();
        }
        int n2 = this.numberOfRows();
        int n3 = 0;
        while (n3 < vector.size()) {
            String string;
            String string2 = (String)vector.elementAt(n3);
            Vector vector2 = this.doctor.app.utility.getListOfStrings(string2);
            if (vector2.size() > 0 && string2.length() > 0 && (string = (String)vector2.elementAt(0)) != null) {
                if (string.equals("title:")) {
                    this.title = new String((String)vector2.elementAt(1));
                } else if (string.equals("column:")) {
                    String string3 = (String)vector2.elementAt(1);
                    this.dataList.addElement(new Data(0, -1, n++, string3));
                } else if (string.equals("data:")) {
                    int n4;
                    int n5 = n4 = this.intValue(-1, (String)vector2.elementAt(1));
                    int n6 = this.intValue(-1, (String)vector2.elementAt(3));
                    String string4 = (String)vector2.elementAt(4);
                    String string5 = new String(string4);
                    int n7 = string5.indexOf("%");
                    if (n7 > 0) {
                        string4 = string4.substring(0, n7);
                    }
                    this.intValue(-1, string4);
                    if (this.firsttime) {
                        this.initialTime = n4;
                        n4 = 0;
                        this.xmin = n4;
                        this.xmax = this.xmin + (double)this.timeScale;
                        this.firsttime = false;
                        this.getTime((long)n5 * 1000L);
                    } else if ((double)(n4 -= this.initialTime) > this.xmax) {
                        this.xmax = n4;
                        this.xmin = this.xmax - (double)this.timeScale;
                    }
                    Data data = new Data(n4, n2, n6, string4);
                    this.dataList.addElement(data);
                    this.nrows = ++n2;
                }
            }
            ++n3;
        }
        this.scanData();
        this.valid = false;
    }

    public void getTime(long l) {
        Date date = new Date(l);
        this.hours = date.getHours();
        this.minutes = date.getMinutes();
        this.seconds = date.getSeconds();
    }

    public void scanData() {
        Graphics graphics = this.doctor.getGraphics();
        if (graphics == null) {
            return;
        }
        this.fontMetric = graphics.getFontMetrics(this.font);
        int n = this.fontMetric.getHeight();
        int n2 = this.nrows - 1;
        while (n2 >= 0) {
            this.dataAt(n2, 0);
            if ((double)this.dataAt((int)n2, (int)0).time < this.xmin) break;
            --n2;
        }
        if (n2 > 0) {
            int n3 = 0;
            while (n3 < n2) {
                this.removeDataAt(n3, 0);
                ++n3;
            }
            int n4 = 0;
            while (n4 < this.nrows) {
                Data data = this.dataAt(n4, 0);
                if (data != null) {
                    data.row -= n2;
                }
                ++n4;
            }
            this.nrows -= n2;
        }
        if (!this.useUserSuppliedValues) {
            Data data = this.dataAt(0, 0);
            this.ymax = this.ymin = this.doubleValue(0.0, data.value);
            n2 = 1;
            while (n2 < this.nrows) {
                data = this.dataAt(n2, 0);
                double d = this.doubleValue(0.0, data.value);
                if (d < this.ymin) {
                    this.ymin = d;
                } else if (d > this.ymax) {
                    this.ymax = d;
                }
                ++n2;
            }
            this.ymax += 0.1 * (this.ymax - this.ymin) + 10.0;
            this.ymin -= 0.1 * (this.ymax - this.ymin) - 10.0;
        }
        int n5 = 0;
        int n6 = 0;
        n2 = 0;
        while (n2 <= this.yticks) {
            int n7 = (int)(this.ymin + (this.ymax - this.ymin) * (double)n2 / (double)this.yticks);
            String string = Integer.toString(n7);
            if (this.ylabel != null) {
                string = String.valueOf(string) + this.ylabel;
            }
            if ((n5 = this.fontMetric.stringWidth(string)) > n6) {
                n6 = n5;
            }
            ++n2;
        }
        this.in.width = this.out.width - 3 * n6;
        this.in.x = 2 * n6;
        this.fontMetric = graphics.getFontMetrics(this.titlefont);
        int n8 = 3 * this.fontMetric.getHeight() / 2;
        this.in.height = this.out.height - (n8 + 2 * n);
        this.in.y = n8;
    }

    public String fetchTimeString(int n) {
        boolean bl = false;
        int n2 = n / 3600;
        int n3 = (n -= n2 * 3600) / 60;
        int n4 = n - n3 * 60;
        if ((n4 += this.seconds) > 59) {
            n4 -= 60;
            ++n3;
        }
        if ((n3 += this.minutes) > 59) {
            n3 -= 60;
            ++n2;
        }
        if ((n2 += this.hours) > 23) {
            n2 -= 24;
        }
        String string = new String();
        if (this.timeformat.indexOf("hh") >= 0) {
            string = String.valueOf(string) + Integer.toString(n2);
            bl = true;
        }
        if (this.timeformat.indexOf("mm") >= 0) {
            if (bl) {
                string = String.valueOf(string) + ":";
            }
            string = n3 > 9 ? String.valueOf(string) + Integer.toString(n3) : String.valueOf(string) + "0" + Integer.toString(n3);
            bl = true;
        }
        if (this.timeformat.indexOf("ss") >= 0) {
            if (bl) {
                string = String.valueOf(string) + ":";
            }
            string = n4 > 9 ? String.valueOf(string) + Integer.toString(n4) : String.valueOf(string) + "0" + Integer.toString(n4);
        }
        return string;
    }

    public void drawHorizontalAxis(Graphics graphics) {
        int n = this.out.x + this.in.x;
        int n2 = this.out.y + this.in.y;
        this.fontMetric = graphics.getFontMetrics(this.font);
        int n3 = this.fontMetric.stringWidth(this.xlabel);
        this.fontMetric.getHeight();
        double d = this.timeScale / this.xticks;
        double d2 = Math.floor(this.xmin / d) * d;
        int n4 = 0;
        while (n4 <= this.xticks) {
            if (d2 < this.xmin) {
                d2 += d;
            } else {
                if (d2 > this.xmax) break;
                int n5 = (int)((double)n + (double)this.in.width * (d2 - this.xmin) / (this.xmax - this.xmin));
                if (n5 > n + 1 && n5 < n + this.in.width) {
                    String string = this.fetchTimeString((int)d2);
                    if (this.xlabel != null) {
                        string = String.valueOf(string) + this.xlabel;
                    }
                    n3 = this.fontMetric.stringWidth(string);
                    graphics.setColor(this.fontcolor);
                    graphics.drawString(string, n5 - n3 / 2, n2 + this.in.height + 18);
                }
                if (n4 > 0 && n5 < n + this.in.width) {
                    graphics.setColor(this.gridcolor);
                    graphics.drawLine(n5, n2, n5, n2 + this.in.height);
                    graphics.setColor(this.axiscolor);
                    graphics.drawLine(n5, n2 + this.in.height, n5, n2 + this.in.height + 5);
                }
                d2 += d;
            }
            ++n4;
        }
    }

    public void drawVerticalAxis(Graphics graphics) {
        int n = 0;
        int n2 = this.out.x + this.in.x;
        int n3 = this.out.y + this.in.y;
        this.fontMetric = graphics.getFontMetrics(this.font);
        int n4 = this.fontMetric.getHeight() / 2;
        int n5 = 0;
        while (n5 <= this.yticks) {
            int n6;
            int n7 = n3 + this.in.height - this.in.height * n5 / this.yticks;
            int n8 = (int)(this.ymin + (this.ymax - this.ymin) * (double)n5 / (double)this.yticks);
            String string = Integer.toString(n8);
            if (this.ylabel != null) {
                string = String.valueOf(string) + this.ylabel;
            }
            if ((n6 = this.fontMetric.stringWidth(string)) > n) {
                n = n6;
            }
            graphics.setColor(this.fontcolor);
            graphics.drawString(string, n2 - n6 - 10, n7 + n4 - 2);
            if (n5 > 0 && n5 < this.yticks) {
                graphics.setColor(this.axiscolor);
                graphics.drawLine(n2, n7, n2 - 5, n7);
            }
            if (n5 > 0) {
                graphics.setColor(this.gridcolor);
                graphics.drawLine(n2 + 1, n7, n2 + this.in.width - 1, n7);
            }
            ++n5;
        }
    }

    public void drawIt(Graphics graphics) {
        graphics.setColor(this.backgroundcolor);
        graphics.fillRect(this.out.x, this.out.y, this.out.width, this.out.height);
        this.drawHorizontalAxis(graphics);
        this.drawVerticalAxis(graphics);
        graphics.setColor(this.axiscolor);
        graphics.drawRect(this.in.x, this.in.y, this.in.width, this.in.height);
        this.drawTitle(graphics);
        graphics.setColor(this.backgroundcolor);
        int n = this.out.x + this.in.x;
        int n2 = this.out.y + this.in.y;
        Data data = this.dataAt(0, 0);
        double d = data.time;
        double d2 = this.doubleValue(0.0, data.value);
        if (d2 > this.ymax) {
            d2 = this.ymax;
        }
        int n3 = (int)((double)n + (double)this.in.width * (d - this.xmin) / (this.xmax - this.xmin));
        int n4 = (int)((double)(n2 + this.in.height) - (double)this.in.height * (d2 - this.ymin) / (this.ymax - this.ymin));
        graphics.setColor(this.linecolor);
        int n5 = 1;
        while (n5 < this.nrows) {
            data = this.dataAt(n5, 0);
            d = data.time;
            d2 = this.doubleValue(0.0, data.value);
            if (d2 > this.ymax) {
                d2 = this.ymax;
            }
            int n6 = (int)((double)n + (double)this.in.width * (d - this.xmin) / (this.xmax - this.xmin));
            int n7 = (int)((double)(n2 + this.in.height) - (double)this.in.height * (d2 - this.ymin) / (this.ymax - this.ymin));
            if (n5 == 1 && n3 < n) {
                n4 = (n7 - n4) * (n - n3) / (n6 - n3) + n4;
                n3 = n;
            }
            graphics.drawLine(n3, n4, n6, n7);
            n3 = n6;
            n4 = n7;
            ++n5;
        }
    }
}

