#define THIS_APP "GetDhtPeers"

#define NODE_ID_PREFIX "-edhtgp001"
#define DEFAULT_TIMEOUT 300
#define DEFAULT_IDLE_TIMEOUT 60
#define MAX_BUFFER	8192
#define BT_MAX_DEPTH 32
#define BT_MAX_TOKEN 1500
#define MAX_DHT_NODE 500
#define GOOD_NODE_SERVER_IP "127.0.0.1"
//#define GOOD_NODE_SERVER_PORT 7999

#define SA struct sockaddr

// BT type
enum
{
	BT_TYPE_NULL,
	BT_TYPE_DIR,
	BT_TYPE_LIST,
	BT_TYPE_KEY,
	BT_TYPE_VALUE,
	BT_TYPE_INT,
	BT_TYPE_STR1,
	BT_TYPE_STR2,
	BT_TYPE_STR3,
	BT_TYPE_IP,
	BT_TYPE_PORT
};
/*
#define BT_TYPE_NULL 0
#define BT_TYPE_DIR	1
#define BT_TYPE_LIST	2
#define BT_TYPE_KEY	3
#define BT_TYPE_VALUE 4
#define BT_TYPE_INT	5
#define BT_TYPE_STR1	6
#define BT_TYPE_STR2	7
#define BT_TYPE_STR3	8
#define BT_TYPE_IP	9
#define BT_TYPE_PORT 10
*/

// BT DHT node status
enum
{
	BT_NODE_NULL,
	BT_NODE_NEW,
	BT_NODE_REQUEST,
	BT_NODE_RETURN_NODE,
	BT_NODE_RETURN_PEER
};
/*
#define BT_NODE_NULL 0
#define BT_NODE_NEW 1
#define BT_NODE_REQUEST 2
#define BT_NODE_RETURN_NODE 3
#define BT_NODE_RETURN_PEER 4
*/

// arguments of command
enum
{
	ARG_APP,
	ARG_TORRENT,
	ARG_INFO_HASH,
	ARG_PEERS_FILE,
	ARG_START_PORT,
	ARG_END_PORT,
	ARG_TIMEOUT,
	ARG_IDLE_TIMEOUT,
	ARG_NODE_PORT,
	ARG_NUMBER
};

typedef struct bt_dht_node
{
	unsigned long ip; /* IP address of node */
	unsigned short port; /* port no. of node */
	int status; /* status of node */
} BtDhtNode;

int ProcessArgument(int argc, char **argv);
void Init();
int ReadTorrent(char *strTorrent);
int AddDhtNode(char *strIP, unsigned short nPort);
int AddDhtResponseNode(char *buffer, int bufferLen);
int GetDhtPeers(unsigned char *pcInfoHash, char *strPeersFile, unsigned short nStartPort, unsigned short nEndPort,time_t nDueTime,time_t nIdleTimeout);
int GetMacAddress(unsigned char *macAddress);
int ProcessDhtResponse(char *buffer,int bufferLen,char *strPeersFile,unsigned long ip, unsigned short port, int transactionId);
int AddDhtPeer(char *peer,char *strPeersFile);
void SetDhtNodeStatus(unsigned long ip, unsigned short port, int status);
