#define THIS_APP "GoodDhtNodes"

#define NODE_ID_PREFIX "-edhtgp001"
#define DEFAULT_PORT 7999
#define DEFAULT_TIMEOUT 300
#define MAX_BUFFER	8192
#define BT_MAX_DEPTH 32
#define BT_MAX_TOKEN 1500
#define MAX_DHT_NODE 50
#define SAVE_INTERVAL 900
#define PING_NODE_INTERVAL 900

#define SA struct sockaddr

enum
{
	BT_PACKET_NULL,
	BT_PACKET_PING_RESPONSE,
	BT_PACKET_GET_PEERS_REQUEST,
	BT_PACKET_ADD_NODE
};

// BT type
enum
{
	BT_TYPE_NULL,
	BT_TYPE_DIR,
	BT_TYPE_LIST,
	BT_TYPE_KEY,
	BT_TYPE_VALUE,
	BT_TYPE_INT,
	BT_TYPE_STR1,
	BT_TYPE_STR2,
	BT_TYPE_STR3,
	BT_TYPE_IP,
	BT_TYPE_PORT
};
/*
// BT DHT node status
enum
{
	BT_NODE_NULL,
	BT_NODE_NEW,
	BT_NODE_REQUEST,
	BT_NODE_RETURN_NODE,
	BT_NODE_RETURN_PEER
};
*/
// arguments of command
enum
{
	ARG_APP,
	ARG_DEFAULT_NODES_FILE,
	ARG_NODES_FILE,
	ARG_PORT,
	ARG_TIMEOUT,
	ARG_NUMBER
};

typedef struct bt_dht_node
{
	unsigned long ip; //IP address of node
	unsigned short port; // port no. of node
	time_t time; // last response time of node
} BtDhtNode;

int ProcessArgument(int argc, char **argv);
void Init();
int ReadNodesFile(char *strDefaultNodesFile,char *strNodesFile);
int ReadNodesFile_0(char *strNodesFile,time_t time);
int SaveNodesFile(char *strNodesFile);
int AddDhtNode(char *strIP, unsigned short nPort, time_t time);
int RunNodeServer(char *strNodesFile,unsigned short nPort,time_t nTimeout);
int PrepareNodesResponse(char *response, int *nPacketLen);
void PreparePingRequest(char *buffer, int *nBufferLen);
int GetMacAddress(unsigned char *macAddress);
int ProcessPacket(char *buffer,int bufferLen);

/*
int ReadTorrent(char *strTorrent);
int AddDhtNode(char *strIP, unsigned short nPort);
int AddDhtResponseNode(char *buffer, int bufferLen);
int GetDhtPeers(unsigned char *pcInfoHash, char *strPeersFile, unsigned short nStartPort, unsigned short nEndPort,time_t nDueTime,time_t nIdleTimeout);
int ProcessDhtResponse(char *buffer,int bufferLen,char *strPeersFile,unsigned long ip, unsigned short port, int transactionId);
int AddDhtPeer(char *peer,char *strPeersFile);
void SetDhtNodeStatus(unsigned long ip, unsigned short port, int status);
*/
