/* 
 * Copyright 2003,2004,2005 Kevin Smathers, All Rights Reserved
 *
 * This file may be used or modified without the need for a license.
 *
 * Redistribution of this file in either its original form, or in an
 * updated form may be done under the terms of the GNU LIBRARY GENERAL
 * PUBLIC LICENSE.  If this license is unacceptable to you then you
 * may not redistribute this work.
 * 
 * See the file COPYING.LGPL for details.
 */

/* context.c */
#include "config.h"
#include "random.h"
#include "udpproto.h"

#include <curl/curl.h>
#include <curl/easy.h>
#include <openssl/sha.h>
#include <stdlib.h>
#include <string.h>
#ifdef HAVE_STRINGS_H
#include <strings.h>
#endif
#include <errno.h>
#include <stdio.h>
#include <sys/types.h>
#if WIN32
#   include <winsock2.h>
#else
#   include <sys/param.h>
#   include <sys/socket.h>
#   include <unistd.h>
#   include <netdb.h>
#endif
#include <time.h>
#include <signal.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#include "context.h"
#include "udpproto.h"
#include "bts.h"
#include "types.h"
#include "benc.h"
#include "random.h"
#include "peer.h"
#include "stream.h"
#include "util.h"
#include "segmenter.h"

#define MIN_PORT 6871   //Jack 20080504
#define MAX_PORT 6889
#define PORT_NUMBER	 11	//limeng. 2008.5.20
#define UNKNOWN_ID "--unknown--peer-id--"
#if WIN32
#   define snprintf _snprintf
#endif

#ifndef DEBUG_BT
//#define DEBUG_BT
#endif

#if 1 //John 2008/4/7
#ifndef TCP_REGISTER_INTERVAL
#define TCP_REGISTER_INTERVAL 900
#endif
#ifndef UDP_REGISTER_INTERVAL
#define UDP_REGISTER_INTERVAL 900
#endif

#define DEFAUL_TRACKER_FILE "/tmp/default_tracker"

int g_nGoodtracker = -1;
#endif

#ifdef DEBUG_BT
/*
typedef struct btStrStream {
#define BTSTRSTREAM 2
    struct btStream bts;
    int cur;
    unsigned char *buf;
    int len;
    int max;
} btStrStream;
*/
#endif

#if 1
//extern char * infohash_dht;
btPeer *peer_dht_add( const char*  peersFileName, btContext *ctx, unsigned download)
{
	//return NULL;

	#define bool	unsigned int
	#define false	0
	#define true	1

//	#define	PEERSFILE	"peersInput.txt"

//	printf("enter peer_dht_add !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! \n");

	FILE *peersfp=NULL;
	struct sockaddr_in target;
	bool invalid=false;
	char linebuf[256]={0}; 
	char ipaddrtxt[16]={0};
	char ipporttxt[6]={0};
	btPeer *p;
	
	
#ifdef DEBUG_BT
printf("Enter peer_dht_add()\n");
int nTotalReadPeers=0;
int nExistingPeers=0;
int nNGPeers=0;
int nAddedPeers=0;
#endif

	peersfp=fopen(peersFileName, "r");
	if (peersfp==NULL)
	{
		printf("open  peers file==[%s]  fail! \n", peersFileName);
		return NULL;
	}
	#if 0  //Jack 20080424
	if (NULL==fgets(linebuf,  sizeof(linebuf)-1, peersfp))
	{
		printf("get %s first line  Fail !\n", peersFileName);
		fclose(peersfp);
		return NULL;
	}
	#endif
    	do {
		memset(linebuf, 0, sizeof(linebuf));
		if (NULL==fgets(linebuf,  sizeof(linebuf)-1, peersfp)  &&  !feof(peersfp) ) 
		{
			invalid=true;
			printf("%s format is invalid ! \n", peersFileName);
			fclose(peersfp);
			return NULL;
		}
		/* Collect the address */
		char * tmpPointer =NULL;
		tmpPointer = strstr(linebuf,":");
		if(tmpPointer == NULL)
			continue;
		memset(ipaddrtxt, 0, sizeof(ipaddrtxt));
		memcpy(ipaddrtxt, linebuf, tmpPointer-linebuf);

		memset(ipporttxt, 0, sizeof(ipporttxt));
		memcpy(ipporttxt, tmpPointer+1, 5);

		//sscanf(linebuf,"%s:%s",ipaddrtxt,ipporttxt); //Jack 20080327
		#ifdef DEBUG_BT
			printf("linebuf= %s, ipaddrtxt= %s,ipporttxt =%s\n",linebuf,ipaddrtxt,ipporttxt);
			nTotalReadPeers++;
		#endif		
		memset(&target, 0, sizeof(target));
		target.sin_family=AF_INET;
		target.sin_addr.s_addr = inet_addr(ipaddrtxt);
		target.sin_port = htons(atoi(ipporttxt));
	
		/* modified by ericyuen, 2006.12.18 */
		//if( limit!=0 && computeGoodPeer(ctx) >= limit ) ;
		//else {
		#ifdef DEBUG_BT
			printf("<");
			nTotalReadPeers++;
		#endif
		#ifdef DEBUG_BT
			if (peer_seen( ctx, download, &target))
			{
				nExistingPeers++;
				continue;
			}
		#else
			if (peer_seen( ctx, download, &target)) continue;
		#endif
		#ifdef DEBUG_BT
			printf("=");
		#endif
			p = peer_add( ctx, download, UNKNOWN_ID, &target);
		#ifdef DEBUG_BT
			if(p==NULL)
				nNGPeers++;
			else
				nAddedPeers++;
			printf(">");
		#endif
		//}
	} while (!feof(peersfp) && !invalid) ;
	// added by Jack to del peersFileName
	sprintf(linebuf,"rm -f %s ",peersFileName);
	system(linebuf);
	
#ifdef DEBUG_BT
printf("\nLeave peer_dht_add(), nTotalReadPeers=%d, nExistingPeers=%d, nAddedPeers%d, nNGPeers=%d\n",nTotalReadPeers,nExistingPeers,nAddedPeers,nNGPeers);
#endif

}
#else

btPeer *peer_dht_add( const char*  peersFileName, btContext *ctx, unsigned download, char *id, struct sockaddr_in *sa)
{
	//return NULL;

	#define bool	unsigned int
	#define false	0
	#define true	1

	//#define	PEERSFILE	"peersInput.txt"
	#define PEERSFILE	peersFileName

	printf("enter peer_dht_add !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! \n");

	FILE *peersfp=NULL;
	struct sockaddr_in target;
	bool invalid=false;
	char linebuf[256]={0}; 
	char ipaddrtxt[16]={0};
	char ipporttxt[6]={0};
	btPeer *p;
	char *ipString=NULL;
	char *portString=NULL;
	int  i = 0;

	peersfp=fopen(PEERSFILE, "r");
	if (peersfp==NULL)
	{
		printf("open  peers file==[%s]  fail! \n", PEERSFILE);
		//exit(0);
		return NULL;
	}
/*
	if (NULL==fgets(linebuf,  sizeof(linebuf)-1, peersfp))
	{
		printf("get %s first line  Fail !\n", PEERSFILE);
		fclose(peersfp);
		//exit(0);
		return NULL;
	}
*/
    	do {
		memset(linebuf, 0, sizeof(linebuf));
		if (NULL==fgets(linebuf,  sizeof(linebuf)-1, peersfp)  ) 
		{
			invalid=true;
			printf("%s format is invalid ! \n", PEERSFILE);
			fclose(peersfp);
			break;
		}

		memset(ipaddrtxt, 0, sizeof(ipaddrtxt));
		memset(ipporttxt, 0, sizeof(ipporttxt));
/*
		if  (NULL==strstr(linebuf, "ip==["))
		{
			invalid=true;
			printf("%s format is invalid ! \n", PEERSFILE);
			fclose(peersfp);
			break;
		}

		ipString=strstr(linebuf, "ip==[");
		for (i=0 ; ipString[i]!=0 ; i++)
		{
			ipaddrtxt[i]=ipString[i+5];
			if (ipaddrtxt[i]==']')	
			{
				ipaddrtxt[i]=0;
				break;
			}
		}

		portString=strstr(ipString, "port==[");
		for (i=0 ; portString[i]!=0 ; i++)
		{
			ipporttxt[i]=portString[i+7];
			if (ipporttxt[i]==']')	
			{
				ipporttxt[i]=0;
				break;
			}
		}
*/
		sscanf(linebuf,"%s:%s",ipaddrtxt,ipporttxt); //Jack 20080327
		printf("ipaddrtxt==%s  ipporttxt==%s  \n", ipaddrtxt, ipporttxt);
		/* Collect the address */

		memset(&target, 0, sizeof(target));
		target.sin_family=AF_INET;
		target.sin_addr.s_addr = inet_addr(ipaddrtxt);
		target.sin_port = htons(atoi(ipporttxt));
	
		if (peer_seen( ctx, download, &target)) continue;
		p = peer_add( ctx, download, UNKNOWN_ID, &target);

	} while (!feof(peersfp)) ;
	
	printf("exit peer_dht_add ------------------------------------ \n");
	
	return NULL;
}

#endif
static int parse_config_digest( 
	const char *file, int lineno, const char *token, 
	unsigned char *digest, int len, 
	const char *linebuf) 
{
    int tlen = strlen(token);
    const char *line;
    int res=-1;
    if (strncmp( linebuf, token, tlen) == 0) {
	line = linebuf + tlen;
	line += strspn( line, " \t");
	res = hexdecode( digest, len, line, strlen(line));
	if (res) {
	    printf("In configuration file %s, line %d, the token %s failed to decode (%d)\n", file, lineno, token, res);
	    abort();
	}
    }
    return res;
}

btContext *btContext_create( btContext *ctx, float ulfactor, char *rcfile, int port) {
    FILE *config;
    char hexbuf[80];
    int lineno = 0;
#ifdef BROKEN_HOSTNAME_CODE
    char host[80];
    struct hostent* hent;
    char myaddr[16];
#endif
    int i;

    if (!ctx) {
        ctx = btmalloc( sizeof(*ctx));
    }
    /* default initialize the entire context */
    memset( ctx, 0, sizeof(*ctx));
    /* initialize the socket to status map */
    for (i=0; i<SOCKID_MAX; i++) {
	ctx->statmap[i] = -1;
    }

    /* read defaults */
    config=fopen(rcfile, "r");
    if (!config) {
        randomid( ctx->myid, IDSIZE);
        randomid( ctx->mykey, KEYSIZE);
        /* ericyuen, 2007.03.20: modify the ".libbtrc" to "bt.libbtrc" */
        config=fopen("bt.libbtrc", "w");

        hexencode( ctx->myid, IDSIZE, hexbuf, sizeof(hexbuf));
        fprintf( config, "myid: %s\n", hexbuf);
        hexencode( ctx->mykey, KEYSIZE, hexbuf, sizeof(hexbuf));
        fprintf( config, "mykey: %s\n", hexbuf);
        fclose( config);
    } else {
	int got_id=0, got_key=1;
        randomid( ctx->mykey, KEYSIZE);

        while (!feof(config)) {
            lineno++;
            fgets( hexbuf, sizeof(hexbuf), config);
            if (parse_config_digest( rcfile, lineno, "myid:", ctx->myid, IDSIZE, hexbuf)==0) {
                got_id=1;
            }
            if (parse_config_digest( rcfile, lineno, "mykey:", ctx->mykey, KEYSIZE, hexbuf)==0) {
                got_key=1;
            }
        } /* while */

	if (!got_id || !got_key) {
	    fprintf(stderr, "Please remove rcfile '%s'\n", rcfile);
	    DIE("Bad configuration file.");
        }

	fclose(config);
    }

    ctx->ulfactor = ulfactor;
    ctx->listenport = port;

#ifdef BROKEN_HOSTNAME_CODE
    /* look up my ip address */
    if (gethostname( host, sizeof(host)) != 0) {
	bts_perror(errno, "gethostname");
	exit(1);
    }
    hent = gethostbyname( host);
    if (!hent) {
	printf("Fatal error, unable to look up hostname '%s'\n", host);
	herror("Host look up failed");
	exit(1);
    }
    sprintf(myaddr, "%d.%d.%d.%d", 
	    hent->h_addr[0],
	    hent->h_addr[1],
	    hent->h_addr[2],
	    hent->h_addr[3]);
    ctx->ip = strdup(myaddr); 
#endif

    return ctx;
}

void ctx_closedownload(btContext *ctx, unsigned download) {
  int i;
  btDownload *dl=ctx->downloads[download];
  btPeerset *pset = &dl->peerset;

  for (i=0; i<pset->len; i++) {
      if (pset->peer[i] != NULL) {
	  peer_shutdown (ctx, pset->peer[i], "exiting");
	  btfree(pset->peer[i]);
	  pset->peer[i] = NULL;
      }
  }
  btfree(pset->peer);
  pset->peer = NULL;

  btfree (dl->url);
  btFileSet_destroy( &dl->fileset);
  kBitSet_finit( &dl->requested);
  kBitSet_finit( &dl->interested);
  if(dl->md)
    btObject_destroy( dl->md);
  ctx->downloads[download]=NULL;
  btfree(dl);
}

void btContext_destroy( btContext *ctx) {
    int i;

    for(i=0; i<ctx->downloadcount; i++) {
      if(ctx->downloads[i])
	ctx_closedownload(ctx, i);
    }

    /* Note: btfree(NULL) is a no-op */
    btfree (ctx->downloads);
    /* Shouldn't be necessary - one must recreate the context */
    ctx->downloads=NULL;
    ctx->downloadcount=0;
}

static char* hexdigest(unsigned char *digest, int len) {
    int i;
    char *buf = btmalloc(3*len+1);
    for (i=0; i<len; i++) {
	sprintf(buf+3*i, "%%%02x", digest[i]);
    }
    return buf;
}


int btresponse( btContext *ctx, int download, btObject *resp) {
    int ret = 0;
    btDownload *dl=ctx->downloads[download];
    btString *err;
    btPeer *p;
    int i,j, skip=0;
    struct sockaddr_in target;

	
#ifdef DEBUG_BT
printf("John: Enter btresponse()\n");
#endif

#if 1 // John 2008/4/3
     if(dl)
        dl->reregister_interval=TCP_REGISTER_INTERVAL;

     if(resp == NULL)
      {
#ifdef DEBUG_BT
     	printf("John: In btresponse() NULL resp pointer\n");
#endif
       return -1;
      }
#ifdef DEBUG_BT
      printf("John: In btresponse() before btObject_val()\n");
#endif
#endif

#if 1 //John 2008/4/7 for segmentation fault
	err=0;
#else
      err = BTSTRING(btObject_val( resp, "failure reason"));
#endif
    
#ifdef DEBUG_BT
printf("John: In btresponse() after btObject_val(failure reason)\n");
#endif

    if (err) {
		printf("Error from tracker: %s\n", err->buf);
		ret = -1;
    } else {
	    btObject *peersgen=0;
		btInteger *interval=0;
#ifdef DEBUG_BT
printf("John: In btresponse() before btObject_val(interval)\n");
#endif

		interval = BTINTEGER(btObject_val(resp, "interval"));
		
#ifdef DEBUG_BT
printf("interval = %X\n",interval);
if(interval)
printf("John: In btresponse() pdl->reregister_interval =%d\n",interval->ival);
else
printf("John: NULL interval\n");
#endif

		#if 1 //John 2008/4/3
		if(interval)
		{
		#endif
			dl->reregister_interval = (int)interval->ival;
			printf("Interval %lld\n", interval->ival);
		#if 1 //John 2008/4/3
		}
		else
		{
#ifdef DEBUG_BT
			printf("John: In btresponse()  NULL interval pointer\n");
#endif
			dl->reregister_interval = TCP_REGISTER_INTERVAL;
		}
		#endif
		peersgen = btObject_val(resp, "peers");
		
		#if 1 //John 2008/4/3
		if(peersgen == NULL)
		{
#ifdef DEBUG_BT
			printf("John: In btresponse()  NULL peersgen pointer\n");
#endif
			return -1;
		}
		#endif
		if(peersgen->t == BT_LIST) {
		    btList *peers = BTLIST(peersgen);
	
#ifdef DEBUG_BT
printf("John: In btresponse() peers->len=%d\n",peers->len);
#endif

		    for (i=0; i< peers->len; i++) {
				btObject *o = peers->list[i];
				btString *peerid = BTSTRING( btObject_val( o, "peer id"));
				btString *ip = BTSTRING( btObject_val( o, "ip"));
				btInteger *port = BTINTEGER( btObject_val( o, "port"));
				int iport = (int)port->ival;
				const struct addrinfo ai_template = {
				  .ai_family=AF_INET,	/* PF_INET */
				  .ai_socktype=SOCK_STREAM,
				  /*.ai_protocol=IPPROTO_TCP,*/
				};
				struct addrinfo *ai=NULL;

				skip=0;

				if (memcmp(ctx->myid, peerid->buf, IDSIZE)==0) {
				    printf("Skipping myself %s:%d\n", ip->buf, iport);
				    continue;
				}

				/* Detect collisions properly (incl. ourselves!) */
				for (j = 0; j < dl->peerset.len; j++) {
				    btPeer *p = dl->peerset.peer[j];
				    if ( memcmp( p->id, peerid->buf, IDSIZE)==0) {
						/* Simply tests by ID. */
						fprintf( stderr, 
						   "Skipping old peer: %s:%d", inet_ntoa(target.sin_addr), ntohs(target.sin_port));
						skip = 1;
						break;
				     }
				}
				if (skip) continue;

				printf( "Contacting peer %s:%d\n", ip->buf, iport);
				if(getaddrinfo(ip->buf, NULL, &ai_template, &ai)==0) {	
				    /* Just pick the first one, they are returned in varying order */
				    struct sockaddr_in sa;
				    if (ai->ai_addr->sa_family == AF_INET) {
					/*result of lookup is an IPV4 address */
					sa = *(struct sockaddr_in *)ai->ai_addr;
					sa.sin_port = htons(iport);
					p = peer_add( ctx, download, peerid->buf, &sa);
				    } else {
				        printf( "Peer lookup returned unsupported address type %d. \n", 
						ai->ai_addr->sa_family);
				    }
				}
				if(ai) {
				    freeaddrinfo(ai);
				}
            } /* for each peer */
		} else if (peersgen->t == BT_STRING) {
	    	btString *peers=BTSTRING(peersgen);

	    	fprintf( stderr, "Parsing compact peer list (%d)\n", peers->len/6);
	    	if (peers->len == 0) { ret = -1; }
	    	for (i=0; i<=peers->len - 6; i += 6) {
				struct sockaddr_in target;

				skip = 0;

				/* Collect the address */
				target.sin_family=AF_INET;
				memcpy(&target.sin_addr, peers->buf+i, 4);
				memcpy(&target.sin_port, peers->buf+i+4, 2); /* already nbo */
#ifdef DEBUG_BT
printf("John: In btresponse() before ericyuan\n");
#endif

				/* modified by ericyuen, 2006.12.18 */
				if( limit!=0 && computeGoodPeer(ctx) >= limit ) ;
				else {
					if (peer_seen( ctx, download, &target)) continue;
					p = peer_add( ctx, download, UNKNOWN_ID, &target);
			
				}
				/* modified by ericyuen, 2006.12.18 */
			
#ifdef DEBUG_BT
printf("John: In btresponse() after ericyuan\n");
#endif

				/*
				if (peer_seen( ctx, download, &target)) continue;
				p = peer_add( ctx, download, UNKNOWN_ID, &target);
				*/
	   	    } /* for */
        }
/*	peer_dump( &ctx->peerset); */
    }

	
#ifdef DEBUG_BT
printf("John: Reach btresponse() end\n");
#endif

    return ret;
}
int LINK_ERR_NUM = 0;
static btObject* btrequest( 
	char *announce,
	unsigned char myid[IDSIZE], 
	unsigned char mykey[KEYSIZE],
	unsigned char digest[SHA_DIGEST_LENGTH], 
	int port,
	_int64 downloaded, 
	_int64 uploaded,
	_int64 left,
	char *event) 
{
    /*
    * Tracker GET requests have the following keys urlencoded -
    *   req = {
    *REQUEST
    *      info_hash => 'hash'
    *      peer_id => 'random-20-character-name'
    *      port => '12345'
    *      ip => 'ip-address' -or- 'dns-name'  iff ip
    *      uploaded => '12345'
    *      downloaded => '12345'
    *      left => '12345'
    *
    *      last => last iff last
    *      trackerid => trackerid iff trackerid
    *      numwant => 0 iff howmany() >= maxpeers
    *      event => 'started', 'completed' -or- 'stopped' iff event != 'heartbeat'
    *
    *   }
    */

    /* contact tracker */
    CURL *hdl;
    char url[1024];
    char *dgurl;
    char *idurl;
    char *keyurl;
    btStream *io;
    btObject *result;
    int curlret;
    FILE *fp;
    char *btinfo;
    int i;
    
	
#ifdef DEBUG_BT
printf("John: Enter btrequest()\n");
#endif


    dgurl = hexdigest(digest, SHA_DIGEST_LENGTH);
    idurl = hexdigest(myid, IDSIZE);
    keyurl = hexdigest(mykey, KEYSIZE);
    hdl = curl_easy_init();
    if (event) {
		snprintf( url, sizeof(url)-1, "%s?info_hash=%s&peer_id=%s&key=%s&port=%d&uploaded=%lld&downloaded=%lld&left=%lld&event=%s&compact=1", 
			announce,
			dgurl,
			idurl,
			keyurl,
			port,
			uploaded, 
			downloaded,
			left,
			event
		    );
    } else {
		snprintf( url, sizeof(url)-1, "%s?info_hash=%s&peer_id=%s&key=%s&port=%d&uploaded=%lld&downloaded=%lld&left=%lld&compact=1", 
			announce,
			dgurl,
			idurl,
			keyurl,
			port,
			uploaded, 
			downloaded,
			left );
     }
    url[sizeof(url)-1]=0;
    btfree(idurl); btfree(dgurl); btfree(keyurl);
    printf("get %s\n", url);
    curl_easy_setopt( hdl, CURLOPT_URL, url);
    io = bts_create_strstream( BTS_OUTPUT);
    curl_easy_setopt( hdl, CURLOPT_FILE, io);
    curl_easy_setopt( hdl, CURLOPT_WRITEFUNCTION, writebts);
    if ( (curlret = curl_easy_perform(hdl)) != CURLE_OK ) {
    
#if 0 //John 2008/4/3
    	for(i = 0;i < 3;i++)
    	{
    		if ( (curlret = curl_easy_perform(hdl)) == CURLE_OK )
    			break;
    		else {
				switch (curlret) {
					case CURLE_COULDNT_CONNECT:
					fprintf(stderr, "Failed to transfer URL: could not connect (%d)\n", curlret);
				default:
					fprintf(stderr, "Failed to transfer URL for reason %d (see curl.h)\n", curlret);
				}
			}
    	}

		/*added by edimax 2006-12-27  */
		LINK_ERR_NUM++;
	
		if(LINK_ERR_NUM > 3)
		{
			if ((fp=fopen(filename,"w"))==NULL){
		    		printf("Error!can not creat %s!\n",filename);
			} else {
		    	btinfo="100";
		    	fwrite(btinfo,3,1,fp);
		    	fclose(fp);
			}
			//exit(1); //2008/4/3
		}   
		/*added by edimax 2006-12-27  */
#endif
	
#ifdef DEBUG_BT
printf("John: In btrequest(): return NULL, fail connect tracker\n");
#endif
		
		
		result=NULL;
    } else {
      /* parse the response */
		LINK_ERR_NUM = 0;
	
      //if ( bts_rewind( io, BTS_INPUT) ) DIE("bts_rewind");
      if ( bts_rewind( io, BTS_INPUT) ) return NULL;
      	
#ifdef DEBUG_BT
// John 2008/4/23 to save response from trackers
/*
	if ( (fp=fopen("tracker_res.txt","w")) == NULL )
	{
		printf("John: In btrequest(): fail to open tracker_res.txt");
	}
	else
	{
		btStrStream *ss = (btStrStream *)io;
		printf("John: In btrequest(): tracker response length= %d\n",ss->len);
		if(ss->len>0)
			fwrite(ss->buf,ss->len,1,fp);
		fclose(fp);
	}
	
	if ( bts_rewind( io, BTS_INPUT) )
	{
		printf("John: In btrequest(): fail in my own bts_rewind()\n");
		return NULL;
	}
*/
#endif
      
      if ( benc_get_object( io, &result) ) {
#if 1 //John 2008/4/23 for rejecting tracker make segmenation fault
		result=NULL;
#endif
      	
#ifdef DEBUG_BT
printf("Bad response from tracker\n");
#endif

          if ( (fp=fopen(filename,"w")) == NULL ){
              printf("Error!can not creat %s!\n",filename);
          } else {
              btinfo="100";
              fwrite(btinfo,3,1,fp);
              fclose(fp);
             }
         // DIE("bad response");
        }
    }
   bts_destroy (io);
   curl_easy_cleanup( hdl);

	
#ifdef DEBUG_BT
printf("John: Leave btrequest(): successful\n");
#endif

   return result;
}

static btObject* btannounce(
	btContext *ctx, btDownload *dl, char *state, int err)
{
    btObject *resp = NULL;
    int i;

#if 1 //John 2008/4/23
	static char nGoodTrackerFailCount=0;
#endif
	
#ifdef DEBUG_BT
printf("John: Enter btannounce()\n");
#endif


    if (err) dl->tracker++;

#if 1 //John 2008/4/22
/*
 #if 1 //Jack 20080409
 if(state == NULL) 
 {
 		if (g_nGoodtracker != -1)
 			dl->tracker = g_nGoodtracker ;  
 		else
 			return NULL;
 	      if (strncmp(dl->url[dl->tracker], "udp://", 6) == 0) {
	    int err;
	    if (!dl->cxid) {
		err = udp_connect( ctx, dl);
		
#ifdef DEBUG_BT
printf("John: set UDP dl->reregister_interval=UDP_REGISTER_INTERVAL\n");
#endif

		dl->reregister_interval=UDP_REGISTER_INTERVAL;
		if (err) {
		    printf("udp connect failed %d\n", err);
		}
	    } else {

	        err = udp_announce( ctx, dl, state);
		if (err) {
		    dl->cxid = 0;
		    printf("udp_announce failed %d\n", err);
		}

	    }
	    
#ifdef DEBUG_BT
printf("John: In btannounce(), return NULL 1\n");
#endif

	    return NULL;
	} else {
	    resp = btrequest( 
		dl->url[dl->tracker], ctx->myid, ctx->mykey, dl->infohash, 
		ctx->listenport, dl->fileset.dl, 
		dl->fileset.ul * ctx->ulfactor, dl->fileset.left, 
		state
	    );
	}

	
#ifdef DEBUG_BT
printf("John: In btannounce(), btrequest() return NULL\n");
#endif
 }
 else
 #endif
*/
#endif

#if 1 //John 2008/4/22 for reregister try good tracker only if any, otherwise still try all remaining trackers
	if(state == NULL) 
	{ // reregister
		if (g_nGoodtracker != -1)
			dl->tracker = g_nGoodtracker;
	}
#endif

    for (;dl->tracker < dl->nurl; dl->tracker++) {
        if (strncmp(dl->url[dl->tracker], "udp://", 6) == 0) {
	    int err;
	    if (!dl->cxid) {
		err = udp_connect( ctx, dl);
		
#ifdef DEBUG_BT
printf("John: set UDP dl->reregister_interval=UDP_REGISTER_INTERVAL\n");
#endif

		dl->reregister_interval=UDP_REGISTER_INTERVAL;
		if (err) {
		    printf("udp connect failed %d\n", err);
		    continue;
		}
	    } else {

	        err = udp_announce( ctx, dl, state);
		if (err) {
		    dl->cxid = 0;
		    printf("udp_announce failed %d\n", err);
		    continue;
		}
		g_nGoodtracker = dl->tracker;  //Jack 20080409
	    }
	    
#ifdef DEBUG_BT
printf("John: In btannounce(), return NULL 1\n");
#endif

	    return NULL;
	} else {
	    resp = btrequest( 
		dl->url[dl->tracker], ctx->myid, ctx->mykey, dl->infohash, 
		ctx->listenport, dl->fileset.dl, 
		dl->fileset.ul * ctx->ulfactor, dl->fileset.left, 
		state
	    );
	}
	
	if (resp) break;
		
#if 1 //John 2008/4/22 for reregister try good tracker only if any, otherwise still try all remaining trackers
	//if(state==NULL && g_nGoodtracker!=-1) break; // try the last good tracker only even it fails this time
	
	// failed to register current tracker if you reach here
	
	if(state==NULL)
	{
		if(g_nGoodtracker!=-1)
		{
			nGoodTrackerFailCount++;
			if(nGoodTrackerFailCount>=3)
			{
				g_nGoodtracker=-1;
			}
			/*dl->tracker++;
			if(dl->tracker > dl->nurl)
				dl->tracker=0; // back to the first
			*/
		}
		break; // try the last good tracker only even it fails this time
	}
	
	// Improve: we should consider to set g_nGoodtracker=-1 if tood tracker fails too many times
#else
	else
	{
		g_nGoodtracker = dl->tracker; //Jack 20080409
	}
#endif
	
#ifdef DEBUG_BT
printf("John: In btannounce(), btrequest() return NULL\n");
#endif
    } //for (;dl->tracker < dl->nurl; dl->tracker++)

    if (!resp) {
        dl->tracker=0;
	    
#ifdef DEBUG_BT
printf("John: In btannounce(), return NULL 2\n");
#endif
	return NULL;
    }

#ifdef DEBUG_BT
printf("John: In btannounce(), end for(;dl->tracker < dl->nurl; dl->tracker++)\n");
#endif

#if 1 //John 2008/4/22 for reregister try good tracker only if any, otherwise still try all remaining trackers
    if (resp && dl->tracker >= 0 && dl->tracker < dl->nurl)
    { // tracker responds, check respones content
#else
    if (resp && dl->tracker != 0 && dl->tracker < dl->nurl) {
#endif
    
#ifdef DEBUG_BT
printf("John: In btannounce() before btObject_val(), resp=%X\n",resp);
#endif

	btString *err = BTSTRING(btObject_val( resp, "failure reason"));
#ifdef DEBUG_BT
printf("John: In btannounce() after btObject_val(), err=%X\n",err);
#endif

#if 1 //John 2008/4/22 for reregister try good tracker only if any, otherwise still try all remaining trackers
	if (!err)
	{
	    g_nGoodtracker=0;
	    nGoodTrackerFailCount=0;
	    if(dl->tracker != 0)
	    { // move good tracker to the first position
#else
	if (!err) {
#endif
		    char *url = dl->url[dl->tracker];
		    for (i = dl->tracker; i>0; i--) {
			dl->url[i] = dl->url[i-1];
		    }
		    dl->url[0] = url;
		    dl->tracker=0;
	    }
#if 1 //John 2008/4/22 for reregister try good tracker only if any, otherwise still try all remaining trackers
        }
#endif
    }
    
#ifdef DEBUG_BT
printf("John: In btannounce() before btObject_dump(), resp=%X\n",resp);
#endif

#if 0 // John 2008/4/3 (remove it)
    if (resp) {
	btObject_dump( 0, resp);
    }
#endif

	    
#ifdef DEBUG_BT
printf("John: Leave btannounce() at the end\n");
#endif

    return resp;
}

int ctx_addstatus( btContext *ctx, int fd) {
    int statblock;

    DIE_UNLESS( fd >= 0 && fd <= SOCKID_MAX ); /* include TMPLOC */

    /* allocate status bits */
    statblock = ctx->nstatus;
    if (statblock >= MAXCONN) {
		 return -1;
     }
    ctx->nstatus++;

    ctx->statmap[fd] = statblock;
    ctx->status[statblock].fd = fd;
    ctx->status[statblock].events = 0;
    return 0;
}

void 
ctx_setevents( btContext *ctx, int fd, int events) {
    int statblock;

    DIE_UNLESS(fd>=0 && fd<SOCKID_MAX);

    statblock = ctx->statmap[ fd];
    ctx->status[ statblock].events |= events;
}

void 
ctx_clrevents( btContext *ctx, int fd, int events) {
    int statblock;

    DIE_UNLESS(fd>=0 && fd<SOCKID_MAX);

    statblock = ctx->statmap[ fd];
    ctx->status[ statblock].events &= ~events;
}

void
ctx_delstatus( btContext *ctx, int fd) {
    /* free up the status slot */
    int sid;
    int i;

    DIE_UNLESS(fd>=0 && fd<=SOCKID_MAX);

    sid = ctx->statmap[fd];
    for (i=sid; i<ctx->nstatus; i++) {
        ctx->status[i] = ctx->status[i+1];
    }
    ctx->nstatus--;
    for (i=0; i<SOCKID_MAX; i++) {
	if (ctx->statmap[i] > sid) ctx->statmap[i]--;
    }
}

void
ctx_fixtmp( btContext *ctx, int fd) {
    int statblock;
    
    DIE_UNLESS(fd>=0 && fd<SOCKID_MAX);

    statblock = ctx->statmap[ TMPLOC];

    DIE_UNLESS(statblock >= 0 && statblock < MAXCONN);
    DIE_UNLESS(ctx->status[ statblock].fd == TMPLOC);

    /* relink the status block to the statmap */
    ctx->statmap[ fd] = statblock;
    ctx->status[ statblock].fd = fd;
    ctx->statmap[ TMPLOC] = -1;
}

int ctx_register( struct btContext *ctx, unsigned download)
    /*
     * Contact the tracker and update it on our status.  Also
     * add any new peers that the tracker reports back to us.
     */
{
    btDownload *dl=ctx->downloads[download];
    btObject *resp;
    int nok=0;

    DIE_UNLESS(download<ctx->downloadcount);
    do {
	/* contact tracker */

	
#ifdef DEBUG_BT
printf("John: In ctx_register(): before btannounce()\n");
#endif


	resp = btannounce( ctx, dl, "started", nok);
#if 1 //Jack 20080403, John 2008/4/7 turn on
	if(!resp)
	    return -EAGAIN;
#endif

#ifdef DEBUG_BT
printf("John: In ctx_register(): before btresponse()\n");
#endif

	nok = btresponse( ctx, download, resp);
	

#ifdef DEBUG_BT
printf("John: In ctx_register(): after btresponse(), nok=%d\n",nok);
#endif
#if 1 //John 2008/4/3
      if((resp != NULL) && (nok == 0))
	{
#ifdef DEBUG_BT
		printf("resp=%X, nok=%d\n",resp,nok);
#endif
#endif
	btObject_destroy( resp);
	
#if 1 //John 2008/4/3
	}
#endif
#ifdef DEBUG_BT
printf("John: In ctx_register(): after btObject_destroy()\n");
#endif

	//#if 1 //John 2008/4/7, only register trackers once in the first session of registration
	//break;
	//#endif

    } while (nok);
    return 0;
}

int ctx_startserver( btContext *ctx, int port) {
    struct sockaddr_in sin;

    /* open server socket */
    ctx->ss = socket( PF_INET, SOCK_STREAM, IPPROTO_TCP);
#if 0
    reuse = 1;
    if (setsockopt( ctx->ss, SOL_SOCKET, SO_REUSEADDR, &reuse, sizeof(reuse))) {
        bts_perror(errno, "setsockopt"); abort();
    }
#endif
    for ( ctx->listenport = port;
          ctx->listenport <= port+PORT_NUMBER; 
          ctx->listenport++) 
    {
	sin.sin_family = AF_INET;
	sin.sin_port = htons( ctx->listenport);
	sin.sin_addr.s_addr = INADDR_ANY;
	if (!bind( ctx->ss, (struct sockaddr *)&sin, sizeof(sin))) { 
	    ctx->udpsock = udp_init( ctx->listenport);
	    if ( ctx->udpsock > 0) {
		break;
	    }
	}
    }
    if (ctx->listenport > port+PORT_NUMBER) {
        bts_perror(errno, "bind"); abort();
    }
    if (listen( ctx->ss, 10)) { bts_perror(errno, "listen"); abort(); }

    /* setup for select */
    ctx_addstatus( ctx, ctx->ss);
    ctx_setevents( ctx, ctx->ss, POLLIN);

    ctx_addstatus( ctx, ctx->udpsock);
    ctx_setevents( ctx, ctx->udpsock, POLLIN);
    return 0;    
}

int ctx_shutdown( btContext *ctx, unsigned download) {
    int result;
    btString *err;
    btObject *resp;
    btDownload *dl=ctx->downloads[download];

    DIE_UNLESS(download<ctx->downloadcount);
    /* contact tracker */
    resp = btannounce( ctx, dl, "stopped", 0);
#if 0
    btObject_dump( 0, resp);
#endif
    if(resp) {
	err = BTSTRING(btObject_val( resp, "failure reason"));
	if (err) {
	    printf("Error in shutdown from tracker: %s\n", err->buf);
	    result=-1;
	} else {
	    printf("Tracker shutdown complete\n");
	    result=0;
	}
	btObject_destroy( resp);
    } else {
#if 0
	/* TODO: check if UDP and don't emit error if so */
        printf("Failed to tell tracker we've stopped\n");
#endif
        result=-1;
    }
    return result; 
}

int ctx_complete( btContext *ctx, unsigned download) {
    btString *err;
    btObject *resp;
    btDownload *dl=ctx->downloads[download];

    DIE_UNLESS(download<ctx->downloadcount);

    dl->complete=1;
    if(dl->fileset.dl==0)	/* don't send complete if we seeded */
        return 0;

    /* contact tracker */
    resp = btannounce( ctx, dl, "completed", 0);
    if(!resp) {
		printf("Failed to tell tracker we completed\n");
		return -EAGAIN;
     }
#if 0
    btObject_dump( 0, resp);
#endif
    err = BTSTRING(btObject_val( resp, "failure reason"));
    if (err) {
	printf("Error in complete from tracker: %s\n", err->buf);
	btObject_destroy( resp);
	return -1;
    } else {
	printf("Tracker notified of complete\n");
    }
    btObject_destroy( resp);
    return 0; 
}

int ctx_reregister( btContext *ctx, unsigned download) {
    btObject *resp;
    int nok = 0;
    btDownload *dl=ctx->downloads[download];
    
#ifdef DEBUG_BT
printf("===== John: enter ctx_reregister() =====)\n");
#endif

#ifdef SEG_FAULT
	if(g_nGoodTracker==-1)
		return 0;
#endif

    DIE_UNLESS(download<ctx->downloadcount);
    do {
	/* contact tracker */
	

#ifdef DEBUG_BT
printf("John: In ctx_reregister(): before tannounce()\n");
#endif

	
	resp = btannounce( ctx, dl, NULL, nok);
#if 1 //Jack 20080403, John 2008/4/7 turn on
	if(!resp)
	    return -EAGAIN;
#endif
#if 0
    btObject_dump( 0, resp);
#endif


#ifdef DEBUG_BT
printf("John: In ctx_reregister(): before btresponse()\n");
#endif
	#if 1 //Jack 20080409
		nok = btresponse( ctx, download, resp);

	#endif
#ifdef DEBUG_BT
printf("John: In ctx_reregister(): after btresponse(), nok=%d\n",nok);
#endif
#if 1 //John 2008/4/3
      if((resp != NULL) && (nok==0))
	{
#ifdef DEBUG_BT
		printf("nok=%d\n",nok);
#endif
#endif

	btObject_destroy( resp);
	
#if 1 //John 2008/4/3
	}	
	sleep(5);
#endif

    } while (nok);

    
#ifdef DEBUG_BT
printf("	===== John: leave ctx_reregister() =====)\n");
#endif

    return 0; 
}

void ctx_exit( int exitcode, void *arg) {
    btContext *ctx=arg;
    int i=ctx->downloadcount;
    
    while (i) {
		ctx_shutdown( arg, --i);
     }
    btContext_destroy( arg);
}

static int addurl( btDownload *dl, btString *a, int rank, char *ignorepattern) {
    if (!a) return 1;
    if (ignorepattern && strstr(a->buf, ignorepattern)) return 0;
    if (dl->nurl >= TRACKER_MAX) {
#ifndef NDEBUG
	DIE("Too many announce urls.");
#endif
    	return 0;
    }
    dl->url[dl->nurl] = btmalloc( a->len+1);
    memcpy( dl->url[dl->nurl], a->buf, a->len);
    dl->url[dl->nurl][a->len] = '\0';
    dl->urlrank[dl->nurl] = rank;
#if 0
    printf("url[%d]=%s\n", dl->nurl, dl->url[dl->nurl]);
#endif
    dl->nurl++;
    return 0;
}

static void shuffle( btDownload *dl) {
    int rank = 0;
    int start = 0;
    int count = 0;
    int i, pick;
    char *tmp;
    while (start < dl->nurl) {
        rank = dl->urlrank[ start];
        for (count = 0; dl->urlrank[ start+count] == rank && start+count < dl->nurl; count++);
	for (i=0; i<count; i++) {
	    pick = rnd(count);
	    tmp = dl->url[ start+pick];
	    dl->url[ start+pick] = dl->url[ start+i];
	    dl->url[ start+i] = tmp;
	}
	start += count;
    }
}

int ctx_loadfile( btStream *bts, struct btContext *ctx, int assumeok, char *ignorepattern,int optquit) {
    btStream *infostr;
    btString *announce;
    btList *announcelist;
    btInteger *size;
    struct btstrbuf strbuf;
    btString *hashdata;
    btInteger *piecelen;
    int npieces;
    int igood=0;
    int i, j, dlid;
    btDownload *dl;
    FILE *fp;    
    /*added by ericyuen, 20061226*/
    int blocksize = 0, partsize = 0;
	/*added by ericyuen, 20061226*/

#ifdef DEBUG_BT
printf("Beginning of ctx_loadfile(), ctx->downloadcount=%d\n",ctx->downloadcount);
#endif

    /* Allocate the new download */
    for(dlid=0; dlid < ctx->downloadcount; dlid++)
        if(!ctx->downloads[dlid]) break;

    if( dlid == ctx->downloadcount ) {
      btDownload **l = btrealloc(ctx->downloads, sizeof(btDownload*)*++ctx->downloadcount);
      if( l == NULL ) {
        --ctx->downloadcount;
        return -ENOMEM;
      }
      ctx->downloads = l;
    }
#ifdef DEBUG_BT
printf("In ctx_loadfile() after btrealloc(), ctx->downloadcount=%d\n",ctx->downloadcount);
#endif

    dl = btcalloc(1, sizeof(btDownload));
    if( !dl )
      return -ENOMEM;

    /* load the metadata file */
    if (benc_get_object( bts, &dl->md)) {
      btfree(dl);
      return -EINVAL;
      /*DIE("Load metadata failed");*/
     }

    /* calculate infohash */
    infostr = bts_create_strstream( BTS_OUTPUT );
    benc_put_object( infostr, btObject_val( dl->md, "info"));
    strbuf = bts_get_buf( infostr);
    // ericyuen: dl->infohash -  string of infohash value
    SHA1( strbuf.buf, strbuf.len, dl->infohash);
    // added by ericyuen, 2006.12.29
    
    bts_destroy( infostr);

    /* copy out url */
    announcelist = BTLIST( btObject_val( dl->md, "announce-list"));
    if (announcelist) {
        for (i = 0; i < announcelist->len; i++) {
	    btObject *o = btList_index( announcelist, i);
	    btString *a;
	    if (o->t == BT_LIST) {
	        btList *l = BTLIST( o);
	    	for (j = 0; j < l->len; j++) {
		    a = BTSTRING( btList_index( l, j));
		    addurl( dl, a, i, ignorepattern);
		}
	    } else if (o->t == BT_STRING) {
	        a = BTSTRING( o);
		addurl( dl, a, i, ignorepattern);
	    } else {
	        //DIE( "Bad metadata: 'announce-list' is corrupt");
	    }
	}
	shuffle( dl);
    } else {
	announce = BTSTRING( btObject_val( dl->md, "announce"));
	if (addurl( dl, announce, 0, NULL))
		;	//DIE( "Bad metadata file: 'announce' missing.");
    } 
#if 1 //Jack 20080409 add for default tracker
	fp = fopen(DEFAUL_TRACKER_FILE,"r");
	if( fp == NULL )
		printf("cannot open the file: %s \n",DEFAUL_TRACKER_FILE);
	else
	{
		btString defaultTracker;
		char trackerUrl[100]={0};	
		char * p = NULL;
		i = dl->nurl;
		while(!feof(fp))
		{
			fgets(trackerUrl, 100, fp);
			if ( (p = strchr(trackerUrl, '\n')) != NULL )
			    *p = '\0';
			defaultTracker.len = strlen(trackerUrl);
			defaultTracker.buf = trackerUrl;
			#ifdef DEBUG_BT
				printf("In ctx_loadfile(), load default tracker: default_tracker= %s",defaultTracker.buf);
			#endif 
			addurl( dl, &defaultTracker, i, ignorepattern);
			i++;
		}
		fclose(fp);
		shuffle( dl);
	}
#endif
    /* set up the fileset and
     * calculate download size */
    dl->fileset.tsize = 0;
    size = BTINTEGER( btObject_val( dl->md, "info/length"));
    hashdata = BTSTRING( btObject_val( dl->md, "info/pieces"));
    piecelen = BTINTEGER( btObject_val( dl->md, "info/piece length"));
    // ericyuen: piece number !
    npieces = hashdata->len / SHA_DIGEST_LENGTH;
    btFileSet_create( &dl->fileset, npieces, (int)piecelen->ival, hashdata->buf);
    kBitSet_create( &dl->requested, npieces);
    kBitSet_create( &dl->interested, npieces);
    for (i=0; i<npieces; i++) bs_set( &dl->interested, i);

    if (size) {
		/* single file mode */
		btString *file = BTSTRING( btObject_val( dl->md, "info/name"));
		dl->fileset.tsize=size->ival;
		btFileSet_addfile( &dl->fileset, file->buf, dl->fileset.tsize);
   } else {
		/* directory mode */
		btList *files;
		btFileSet *fs = &dl->fileset;
		btString *dir;

		dir = BTSTRING( btObject_val( dl->md, "info/name"));
		files = BTLIST( btObject_val( dl->md, "info/files"));
		if (!files) DIE( "Bad metadata file: no files.");
		for (i=0; i<files->len; i++) {
		    btInteger *fsize;
		    btList *filepath;
		    kStringBuffer path;
		    int j;

		    /* get file size */
		    fsize = BTINTEGER( btObject_val( files->list[i], "length") );
		    dl->fileset.tsize += fsize->ival;

		    /* get file path */
		    kStringBuffer_create( &path);
		    sbcat( &path, dir->buf, dir->len);
		    filepath = BTLIST( btObject_val( files->list[i], "path"));
		    for (j=0; j<filepath->len; j++) {
		        btString *el = BTSTRING( filepath->list[j]);
			sbputc( &path, '/');
			sbcat( &path, el->buf, el->len);
		    }

		    /* add the file */
		    btFileSet_addfile( fs, path.buf, fsize->ival);

		    /* clean up */
		    kStringBuffer_finit( &path);
		}
    }
    dl->fileset.left = dl->fileset.tsize;
    for (i=0; i<npieces; i++) {
    	int ok;
    	if (assumeok) { 
    	    bs_set(&dl->fileset.completed, i);
    	    ok = 1;
    	} else {
    	    ok = seg_review( &dl->fileset, i, optquit);
    	}
    	if (i%10==0 || i > npieces-5) {
    	    printf("\r%d of %d completed (%d ok)", i, npieces, igood);
    	    fflush(stdout);
    	}
    	if (ok < 0) {
    	    if (errno == ENOENT) {
    	        int ni;
    	        btFile *f = seg_findFile( &dl->fileset, i);
    			if (!f) {
    			    printf("couldn't find block %d\n", i);
    			    continue;
    			}
    			ni = (int)((f->start + f->len) / dl->fileset.blocksize);
    			if (ni > i) {
    			    i = ni;
    	        #if 1
    			    printf("Skipping %d blocks\n", ni-i);
    	        #endif
    			}
    	    }
        #if 0
    	    bts_perror(errno, "seg_review");
        #endif
    	    continue;
    	}
    	if (ok) {
    	    igood++;
    	    dl->fileset.left -= seg_piecelen( &dl->fileset, i);
    	    /* seg_review already sets completed */
    	    /* TODO: for unordered resumes, allow seg_review to return real piece number */
    	    bs_set( &dl->requested, i);
    	    bs_clr( &dl->interested, i);
    	}
    }
    printf("\n");
    printf("Total good pieces %d (%d%%)\n", igood, igood * 100 / npieces);
    printf("Total archive size %lld\n", dl->fileset.tsize);
    bs_dump( "completed", &dl->fileset.completed);
    ctx->downloads[dlid]=dl;
    
    /* added by ericyuen 2006.10.24 */
    if( optquit == 1 ){
	   char info[SHA_DIGEST_LENGTH*2];
    	fp = fopen("/tmp/nasbturl", "a");
    	if( fp == NULL )	printf("cannot open the filestream to write totalsize/percent\n");
    	else{
         blocksize = piecelen->ival / 1024;
         partsize = (dl->fileset.tsize % piecelen->ival) / 1024;
         fprintf(fp, "Schedule=%d\n", igood*100 / npieces);
         fprintf(fp, "TotalSize=%lld\n", dl->fileset.tsize);
         //added by ericyuen, 2006.12.26
         fprintf(fp, "Tracker: %s\n", dl->url[0]);
         hexencode(dl->infohash, SHA_DIGEST_LENGTH, info, SHA_DIGEST_LENGTH*2);
         fprintf(fp, "Infohash: %s\n", info);
         #if 0 // Jack 20080327
         strcpy(infohash_dht,info);
         #endif
         fprintf(fp, "Pieces: %d x %dKB + %dKB\n", npieces, blocksize, partsize);
         
         fclose(fp);
         exit(0);
     	}
     }
    return dlid;
}

