# shadow-utils.spec generated automatically from shadow-utils.spec.in
# $Id: shadow.spec.in,v 1.1 2002/02/17 20:58:34 kloczek Exp $

Summary:	Shadow password file utilities for Linux
Name:		shadow-utils
Version:	4.0.18
Release:	1
Copyright:	Free
Group:		Utilities/System
Source:		ftp://ftp.pld.org.pl/software/shadow/%{name}-%{version}.tar.gz
BuildRoot:	%{_tmppath}/%{name}-%{version}-root
Obsoletes:	adduser

%description
This package includes the programs necessary to convert traditional
V7 UNIX password files to the SVR4 shadow password format and additional
tools to work with shadow passwords.
	- 'pwconv' converts everything to the shadow password format.
	- 'pwunconv' converts back to non-shadow passwords.
	- 'pwck' checks the integrity of the password and shadow files.
	- 'lastlog' prints out the last login times of all users.
	- 'useradd', 'userdel', 'usermod' to manage user accounts.
	- 'groupadd', 'groupdel', 'groupmod' to manage groups.

A number of man pages are also included that relate to these utilities,
and shadow passwords in general.

%prep
%setup

%build
%configure \
	--disable-shared \
	--prefix=/usr \
	--exec-prefix=/usr
make

%install
rm -rf $RPM_BUILD_ROOT

make install DESTDIR=$RPM_BUILD_ROOT

mkdir -p $RPM_BUILD_ROOT/etc/default

%clean
rm -rf $RPM_BUILD_ROOT

%files
%doc doc/ANNOUNCE doc/CHANGES doc/HOWTO
%doc doc/LICENSE doc/README doc/README.linux
%dir /etc/default
%config /etc/default/useradd
%config /etc/login.defs
%{_bindir}/chage
%{_bindir}/gpasswd
%{_bindir}/lastlog
%{_mandir}/man1/chage.1*
%{_mandir}/man1/gpasswd.1*
%{_mandir}/man3/shadow.3*
%{_mandir}/man5/shadow.5*
%{_mandir}/man8/chpasswd.8*
%{_mandir}/man8/groupadd.8*
%{_mandir}/man8/groupdel.8*
%{_mandir}/man8/groupmod.8*
%{_mandir}/man8/grpck.8*
%{_mandir}/man8/lastlog.8*
%{_mandir}/man8/newusers.8*
%{_mandir}/man8/pwck.8*
%{_mandir}/man8/pwconv.8*
%{_mandir}/man8/useradd.8*
%{_mandir}/man8/userdel.8*
%{_mandir}/man8/usermod.8*
%{_sbindir}/chpasswd
%{_sbindir}/groupadd
%{_sbindir}/groupdel
%{_sbindir}/groupmod
%{_sbindir}/grpck
%{_sbindir}/grpconv
%{_sbindir}/grpunconv
%{_sbindir}/newusers
%{_sbindir}/pwck
%{_sbindir}/pwconv
%{_sbindir}/pwunconv
%{_sbindir}/useradd
%{_sbindir}/userdel
%{_sbindir}/usermod

%changelog
* Sun Dec 14 1997 Marek Michalkiewicz <marekm@piast.t19.ds.pwr.wroc.pl>
- Lots of changes, see doc/CHANGES for more details

* Sun Jun 08 1997 Timo Karjalainen <timok@iki.fi>
- Initial release
