/*
 * dlna.h : GeeXboX uShare Digital Network Living Alliance (DLNA) informations
 * Originally developped for the GeeXboX project.
 * Copyright (C) 2007 Benjamin Zores <ben@geexbox.org>
 * Thanks to Jason Woodward for DLNA specification.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef _DLNA_H_
#define _DLNA_H_

/* DLNA options are appended to the end of the protocol information.
 * Each option is a key=value pair with multiple options separated by a
 * semicolon.
 * These options expose the functionality provided by the application.
 */

/* DLNA.ORG_PS: play speed parameter (integer)
 *     1 normal play speed
 *     0 invalid play speed
 */

#define DLNA_ORG_PS     "DLNA.ORG_PS"
#define DLNA_ORG_PS_VAL "1"

/* DLNA.ORG_CI: conversion indicator parameter (integer)
 *     1 transcoded
 *     0 not transcoded
 */

#define DLNA_ORG_CI     "DLNA.ORG_CI"
#define DLNA_ORG_CI_VAL "0"

/* DLNA.ORG_OP: operations parameter (string)
 *     "00" (or "0") neither time seek range nor range supported
 *     "11" both time seek range and range supported
 *     "10" time seek range supported
 *     "01" range supported
 */

#define DLNA_ORG_OP     "DLNA.ORG_OP"
#define DLNA_ORG_OP_VAL "11"

/* DLNA.ORG_FLAGS, padded with 24 trailing 0s
 *     80000000  31  senderPaced
 *     40000000  30  lsopTimeBasedSeekSupported
 *     20000000  29  lsopByteBasedSeekSupported
 *     10000000  28  playcontainerSupported
 *      8000000  27  s0IncreasingSupported
 *      4000000  26  sNIncreasingSupported
 *      2000000  25  rtspPauseSupported
 *      1000000  24  streamingTransferModeSupported
 *       800000  23  interactiveTransferModeSupported
 *       400000  22  backgroundTransferModeSupported
 *       200000  21  connectionStallingSupported
 *       100000  20  dlnaVersion15Supported
 *
 *     Example: (1 << 24) | (1 << 22) | (1 << 21) | (1 << 20)
 *       DLNA.ORG_FLAGS=01700000[000000000000000000000000] // [] show padding
 */

#define DLNA_ORG_FLAGS     "DLNA.ORG_FLAGS"
#define DLNA_ORG_FLAGS_VAL "01700000000000000000000000000000"

/* DLNA.ORG_PN: media format parameter (constant)
 *     Example: DLNA.ORG_PN=MP3
 *
 *     Images Formats
 *        JPEG_SM|JPEG_MED|JPEG_LRG|JPEG_TN|JPG_SM_ICO|JPG_LRG_ICO
 *        PNG_TN|PNG_SM_ICO|PNG_LRG_ICO|PNG_LRG
 *
 *     Audio Formats
 *        AC3
 *        AMR_3GPP|AMR_WBplus
 *        ATRAC3plus
 *        LPCM
 *        MP3|MP3X
 *        AAC_ADTS|AAC_ISO|AAC_ISO_320|AAC_ADTS_320|AAC_MULT5_ADTS|AAC_MULT5_ISO|AAC_LTP_ISO|AAC_LTP_MULT5_ISO|AAC_LTP_MULT7_ISO
 *        HEAAC_L2_ADTS|HEAAC_L2_ISO|HEAAC_L2_ADTS_320|HEAAC_L3_ADTS|HEAAC_L3_ISO|HEAAC_MULT5_ADTS|HEAAC_MULT5_ISO
 *        BSAC_ISO|BSAC_MULT5_ISO
 *        WMABASE|WMAFULL|WMAPRO
 *
 *     Video Formats
 *        MPEG1
 *        MPEG_PS_NTSC|MPEG_PS_PAL
 *        MPEG_TS_SD_NA|MPEG_TS_SD_NA_T|MPEG_TS_SD_NA_ISO|MPEG_TS_HD_NA|MPEG_TS_HD_NA_T|MPEG_TS_HD_NA_ISO|MPEG_TS_SD_EU|MPEG_TS_SD_EU_T|MPEG_TS_SD_EU_ISO|MPEG_TS_SD_KO|MPEG_TS_SD_KO_T|MPEG_TS_SD_KO_ISO|MPEG_TS_HD_KO|MPEG_TS_HD_KO_T|MPEG_TS_HD_KO_ISO|MPEG_TS_MP_LL_AAC|MPEG_TS_MP_LL_AAC_T|MPEG_TS_MP_LL_AAC_ISO
 *        MPEG4_P2_MP4_SP_AAC|MPEG4_P2_MP4_SP_HEAAC|MPEG4_P2_MP4_SP_ATRAC3plus|MPEG4_P2_MP4_SP_AAC_LTP|MPEG4_P2_MP4_SP_L2_AAC|MPEG4_P2_MP4_SP_L2_AMR|MPEG4_P2_TS_SP_AAC|MPEG4_P2_TS_SP_AAC_T|MPEG4_P2_TS_SP_AAC_ISO|MPEG4_P2_TS_SP_MPEG1_L3|MPEG4_P2_TS_SP_MPEG1_L3_T|MPEG4_P2_TS_SP_MPEG1_L3_ISO|MPEG4_P2_TS_SP_AC3|MPEG4_P2_TS_SP_AC3_T|MPEG4_P2_TS_SP_AC3_ISO|MPEG4_P2_TS_SP_MPEG2_L2|MPEG4_P2_TS_SP_MPEG2_L2_T|MPEG4_P2_TS_SP_MPEG2_L2_ISO|MPEG4_P2_ASF_SP_G726|MPEG4_P2_MP4_SP_VGA_AAC|MPEG4_P2_MP4_SP_VGA_HEAAC|MPEG4_P2_MP4_ASP_AAC|MPEG4_P2_MP4_ASP_HEAAC|MPEG4_P2_MP4_ASP_HEAAC_MULT5|MPEG4_P2_MP4_ASP_ATRAC3plus|MPEG4_P2_TS_ASP_AAC|MPEG4_P2_TS_ASP_AAC_T|MPEG4_P2_TS_ASP_AAC_ISO|MPEG4_P2_TS_ASP_MPEG1_L3|MPEG4_P2_TS_ASP_MPEG1_L3_T|MPEG4_P2_TS_ASP_MPEG1_L3_ISO|MPEG4_P2_TS_ASP_AC3|MPEG4_P2_TS_ASP_AC3_T|MPEG4_P2_TS_ASP_AC3_ISO|MPEG4_P2_MP4_ASP_L5_SO_AAC|MPEG4_P2_MP4_ASP_L5_SO_HEAAC|MPEG4_P2_MP4_ASP_L5_SO_HEAAC_MULT5|MPEG4_P2_ASF_ASP_L5_SO_G726|MPEG4_P2_MP4_ASP_L4_SO_AAC|MPEG4_P2_MP4_ASP_L4_SO_HEAAC|MPEG4_P2_MP4_ASP_L4_SO_HEAAC_MULT5|MPEG4_P2_ASF_ASP_L4_SO_G726|MPEG4_H263_MP4_P0_L10_AAC|MPEG4_H263_MP4_P0_L10_AAC_LTP|MPEG4_H263_3GPP_P0_L10_AMR_WBplus|MPEG4_P2_TS_CO_AC3|MPEG4_P2_TS_CO_AC3_T|MPEG4_P2_TS_CO_AC3_ISO|MPEG4_P2_TS_CO_MPEG2_L2|MPEG4_P2_TS_CO_MPEG2_L2_T|MPEG4_P2_TS_CO_MPEG2_L2_ISO|MPEG4_P2_3GPP_SP_L0B_AAC|MPEG4_P2_3GPP_SP_L0B_AMR|MPEG4_H263_3GPP_P3_L10_AMR
 *        AVC_TS_MP_HD_AAC_MULT5|AVC_TS_MP_HD_AAC_MULT5_T|AVC_TS_MP_HD_AAC_MULT5_ISO|AVC_TS_MP_HD_HEAAC_L2|AVC_TS_MP_HD_HEAAC_L2_T|AVC_TS_MP_HD_HEAAC_L2_ISO|AVC_TS_MP_HD_MPEG1_L3|AVC_TS_MP_HD_MPEG1_L3_T|AVC_TS_MP_HD_MPEG1_L3_ISO|AVC_TS_MP_HD_AC3|AVC_TS_MP_HD_AC3_T|AVC_TS_MP_HD_AC3_ISO|AVC_TS_MP_HD_AAC_LTP|AVC_TS_MP_HD_AAC_LTP_T|AVC_TS_MP_HD_AAC_LTP_ISO|AVC_TS_MP_HD_AAC_LTP_MULT5|AVC_TS_MP_HD_AAC_LTP_MULT5_T|AVC_TS_MP_HD_AAC_LTP_MULT5_ISO|AVC_TS_MP_HD_AAC_LTP_MULT7|AVC_TS_MP_HD_AAC_LTP_MULT7_T|AVC_TS_MP_HD_AAC_LTP_MULT7_ISO|AVC_TS_MP_SD_AAC_MULT5|AVC_TS_MP_SD_AAC_MULT5_T|AVC_TS_MP_SD_AAC_MULT5_ISO|AVC_TS_MP_SD_HEAAC_L2|AVC_TS_MP_SD_HEAAC_L2_T|AVC_TS_MP_SD_HEAAC_L2_ISO|AVC_TS_MP_SD_BSAC|AVC_TS_MP_SD_BSAC_T|AVC_TS_MP_SD_BSAC_ISO|AVC_TS_MP_SD_MPEG1_L3|AVC_TS_MP_SD_MPEG1_L3_T|AVC_TS_MP_SD_MPEG1_L3_ISO|AVC_TS_MP_SD_AC3|AVC_TS_MP_SD_AC3_T|AVC_TS_MP_SD_AC3_ISO|AVC_TS_MP_SD_AAC_LTP|AVC_TS_MP_SD_AAC_LTP_T|AVC_TS_MP_SD_AAC_LTP_ISO|AVC_TS_MP_SD_AAC_LTP_MULT5|AVC_TS_MP_SD_AAC_LTP_MULT5_T|AVC_TS_MP_SD_AAC_LTP_MULT5_ISO|AVC_TS_MP_SD_AAC_LTP_MULT7|AVC_TS_MP_SD_AAC_LTP_MULT7_T|AVC_TS_MP_SD_AAC_LTP_MULT7_ISO|AVC_MP4_MP_SD_AAC_MULT5|AVC_MP4_MP_SD_HEAAC_L2|AVC_MP4_MP_SD_MPEG1_L3|AVC_MP4_MP_SD_AC3|AVC_MP4_MP_SD_AAC_LTP|AVC_MP4_MP_SD_AAC_LTP_MULT5|AVC_MP4_MP_SD_AAC_LTP_MULT7|AVC_MP4_MP_SD_ATRAC3plus|AVC_MP4_MP_SD_BSAC|AVC_MP4_BL_L3_SD_AAC|AVC_MP4_BL_L3L_SD_AAC|AVC_MP4_BL_L3L_SD_HEAAC|AVC_TS_BL_CIF30_AAC_MULT5|AVC_TS_BL_CIF30_AAC_MULT5_T|AVC_TS_BL_CIF30_AAC_MULT5_ISO|AVC_TS_BL_CIF30_HEAAC_L2|AVC_TS_BL_CIF30_HEAAC_L2_T|AVC_TS_BL_CIF30_HEAAC_L2_ISO|AVC_TS_BL_CIF30_MPEG1_L3|AVC_TS_BL_CIF30_MPEG1_L3_T|AVC_TS_BL_CIF30_MPEG1_L3_ISO|AVC_TS_BL_CIF30_AC3|AVC_TS_BL_CIF30_AC3_T|AVC_TS_BL_CIF30_AC3_ISO|AVC_TS_BL_CIF30_AAC_940|AVC_TS_BL_CIF30_AAC_940_T|AVC_TS_BL_CIF30_AAC_940_ISO|AVC_TS_BL_CIF30_AAC_LTP|AVC_TS_BL_CIF30_AAC_LTP_T|AVC_TS_BL_CIF30_AAC_LTP_ISO|AVC_TS_BL_CIF30_AAC_LTP_MULT5|AVC_TS_BL_CIF30_AAC_LTP_MULT5_T|AVC_TS_BL_CIF30_AAC_LTP_MULT5_ISO|AVC_MP4_BL_L2_CIF30_AAC|AVC_MP4_BL_CIF30_AAC_MULT5|AVC_MP4_BL_CIF30_HEAAC_L2|AVC_MP4_BL_CIF30_MPEG1_L3|AVC_MP4_BL_CIF30_AC3|AVC_MP4_BL_CIF30_AAC_LTP|AVC_MP4_BL_CIF30_AAC_LTP_MULT5|AVC_MP4_BL_CIF30_BSAC|AVC_MP4_BL_CIF30_BSAC_MULT5|AVC_TS_BL_CIF15_AAC|AVC_TS_BL_CIF15_AAC_T|AVC_TS_BL_CIF15_AAC_ISO|AVC_TS_BL_CIF15_AAC_540|AVC_TS_BL_CIF15_AAC_540_T|AVC_TS_BL_CIF15_AAC_540_ISO|AVC_TS_BL_CIF15_AAC_LTP|AVC_TS_BL_CIF15_AAC_LTP_T|AVC_TS_BL_CIF15_AAC_LTP_ISO|AVC_TS_BL_CIF15_BSAC|AVC_TS_BL_CIF15_BSAC_T|AVC_TS_BL_CIF15_BSAC_ISO|AVC_MP4_BL_CIF15_AAC|AVC_MP4_BL_CIF15_AAC_520|AVC_MP4_BL_CIF15_AAC_LTP|AVC_MP4_BL_CIF15_AAC_LTP_520|AVC_MP4_BL_CIF15_HEAAC|AVC_MP4_BL_L12_CIF15_HEAAC|AVC_MP4_BL_CIF15_BSAC|AVC_MP4_BL_CIF15_AMR|AVC_MP4_BL_L1B_QCIF15_HEAAC|AVC_3GPP_BL_QCIF15_AAC|AVC_3GPP_BL_QCIF15_AAC_LTP|AVC_3GPP_BL_QCIF15_HEAAC|AVC_3GPP_BL_QCIF15_AMR|AVC_3GPP_BL_QCIF15_AMR_WBplus|AVC_3GPP_BL_CIF15_AMR_WBplus|AVC_3GPP_BL_CIF30_AMR_WBplus
 *        WMVMED_BASE|WMVMED_FULL|WMVMED_PRO|WMVHIGH_FULL|WMVHIGH_PRO|WMVHM_BASE|WMVSPLL_BASE|WMVSPML_BASE|WMVSPML_MP3
 *
 */
        
#define DLNA_ORG_PN     "DLNA.ORG_PN"

#endif /* _DLNA_H_ */
