#ifndef _ASM_M32R_SEMBUF_H
#define _ASM_M32R_SEMBUF_H

/* $Id: sembuf.h,v 1.1.1.1 2006/04/03 08:41:12 amos_lee Exp $ */

/* orig : i386 2.4.18 */

/*
 * The semid64_ds structure for m32r architecture.
 * Note extra padding because this structure is passed back and forth
 * between kernel and user space.
 *
 * Pad space is left for:
 * - 64-bit time_t to solve y2038 problem
 * - 2 miscellaneous 32-bit values
 */

struct semid64_ds {
	struct ipc64_perm sem_perm;		/* permissions .. see ipc.h */
	__kernel_time_t	sem_otime;		/* last semop time */
	unsigned long	__unused1;
	__kernel_time_t	sem_ctime;		/* last change time */
	unsigned long	__unused2;
	unsigned long	sem_nsems;		/* no. of semaphores in array */
	unsigned long	__unused3;
	unsigned long	__unused4;
};

#endif /* _ASM_M32R_SEMBUF_H */
