/*
 Copyright (c) 2012 G. Bartsch

 Permission is hereby granted, free of charge, to any person
 obtaining a copy of this software and associated documentation
 files (the "Software"), to deal in the Software without
 restriction, including without limitation the rights to use,
 copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the
 Software is furnished to do so, subject to the following
 conditions:

 The above copyright notice and this permission notice shall be
 included in all copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
 OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 OTHER DEALINGS IN THE SOFTWARE.
*/


#include <avr/io.h>	
#include <avr/interrupt.h> 
#include <util/delay.h>
#include <stdlib.h>
#include <inttypes.h>

#include "ir/ir.h"

#include "uart/uart.h"

/*
 * Simple IR demo program 
 *
 * uC: ATmega48 16Mhz
 *
 * Port usage:
 *
 * PB1 IN  IR
 *
 * PB6 XTAL
 * PB7 XTAL
 *
 * PC6 RESET
 *
 * PD0 IN  RXD
 * PD1 OUT TXD
 */

static void init (void) {

	// port directions

	DDRB = 0 ;
	DDRD = (1<<1) ; // TX

        // UART (debug output)
	
	uart_init();

	// IR 

	// timer1 will be used basically as a real time clock
	
	TCCR1A  = 0; // normal mode
        TCCR1B  = (1 << CS12) | (0 << CS11) | (0 << CS10); // prescaler: 256, normal mode

	// IR trigger interrupt

 	PCMSK0  = (1<<PCINT1);     // enable pin change interrupt on PINB1
 	PCICR   = (1<<PCIE0);

}

ISR(PCINT0_vect) { 
	ir_ISR();
} 

int main(void) {

	init();

	sei();

	uart_println();
	uart_println();
	uart_println();
	uart_puts ("IR test\r\n");
	uart_println();

	while (1) {
		IR_DATA ird;

		if (ir_get_data(&ird)) {

			uart_puts ("IR: ");
			uart_puts (" adr=");
			uart_print16h(ird.address);
			uart_puts (" cmd=");
			uart_print16h(ird.command);
			uart_puts (" flags=");
			uart_print8(ird.flags);
			uart_puts (" cnt=");
			uart_print8(ird.cnt);
			uart_puts (" data=");
			uart_print32h(ird.data);
			uart_println ();

		}
	}	
}		


