/**********************************************************
 *(c) by Knobloch GmbH
 *       Weedgasse 14 
 *       D-55234 Erbes-Bdesheim                                    
 *
 *  File:           Msg_50.c        Messageroutines 
 *
 *  Version:        0.01
 *
 *  Revision:
 *          0.01:   20.11.2005
 *                  Start
 *
 **********************************************************/
                  
#include    "..\TA_Firmware\TAF_00D.h"
#include    "..\Message\Msg_00D.h"
#include    "..\Message\Msg_00P.h"

extern  struct  s_Message    sMsg;      // declare: Msg_10.c


// This Procedure is calling from the Interface Firmware
// We write the message into the internal buffer
void WriteMessageToBuffer(SMESSAGE near *pMsg)
{
    if (sMsg.ucCountMsg < ANZ_MESSAGE)
    {
        // Write message to Buffer
        sMsg.Msg[sMsg.ucPInMsg].B.ucHwId = pMsg->B.ucHwId;
        sMsg.Msg[sMsg.ucPInMsg].B.ucSubId = pMsg->B.ucSubId;
        sMsg.Msg[sMsg.ucPInMsg].L.ulMsg = pMsg->L.ulMsg;

        sMsg.ucPInMsg++;
        if (sMsg.ucPInMsg >= ANZ_MESSAGE)
        {
            sMsg.ucPInMsg = 0;
        }

        sMsg.ucCountMsg++;
    }
}


/************************************************
 *  GetMessageFromBuffer()
 *
 *  Calling:    Pointer of SMESSAGE-Struct
 *  Return:     0 = ERROR_SUCCESS 
 *            <>0 = ERROR, no Message saved
 ************************************************/
UCHAR GetMessageFromBuffer(SMESSAGE *pMsg)
{
    UCHAR   ucRetValue;

    if (sMsg.ucCountMsg)
    {
        // Copy message from Buffer
        pMsg->B.ucHwId = sMsg.Msg[sMsg.ucPOutMsg].B.ucHwId;
        pMsg->B.ucSubId = sMsg.Msg[sMsg.ucPOutMsg].B.ucSubId;
        pMsg->L.ulMsg = sMsg.Msg[sMsg.ucPOutMsg].L.ulMsg;

        sMsg.ucPOutMsg++;
        if (sMsg.ucPOutMsg >= ANZ_MESSAGE)
        {
            sMsg.ucPOutMsg = 0;
        }

        sMsg.ucCountMsg--;
        ucRetValue = (UCHAR) ERROR_SUCCESS;
    }
    else
    {
        ucRetValue = (UCHAR) !ERROR_SUCCESS;
    }
    return ucRetValue;
}



// End of File
