/**********************************************************
 *(c) by Knobloch GmbH
 *       Weedgasse 14
 *       D-55234 Erbes-Bdesheim                                    
 *
 *  Datei:          TAF_00.c    Robo-Interface
 *                              Section: Transfer-Area and Firmware
 *                              Typ:     Declaration of Structures and Variables and Library Functions
 *
 *  Version:        0.02
 *
 *  Revision:
 *          0.01:   16.11.2005
 *                  Start
 *          0.02:   13.02.2006
 *                  - SetFtDistanceSensorMode()
 **********************************************************/


/**** Header Files ***************************************/
#include    "..\TA_Firmware\ke_c.h"
#include    "..\TA_Firmware\TAF_00D.h"              // Definitions of Datastructures and Firmware Constants
#include    "..\TA_Firmware\TAF_00P.h"              // Definitions of Firmware Prototypes


    #pragma SECTION bss    TA_COMMUNICATION

    near    struct  sFtTransferArea sTrans;



// Library Functions
void SetFtDistanceSensorMode(UCHAR ucMode, UCHAR ucTol1, UCHAR ucTol2, UINT uiLevel1, 
                             UINT uiLevel2, UCHAR ucRepeat1, UCHAR ucRepeat2)
{
    asm ("  mov.b       $$[FB], r1l", ucMode);
    asm ("  push.b      $$[FB]  ",ucRepeat2);
    asm ("  push.b      $$[FB]  ",ucRepeat1);
    asm ("  push.w      $$[FB]  ",uiLevel2);
    asm ("  push.w      $$[FB]  ",uiLevel1);
    asm ("  push.b      $$[FB]  ",ucTol2);
    asm ("  push.b      $$[FB]  ",ucTol1);
    asm ("  jsrs        #31     ");
    asm ("  add.b       #8h,sp  ");
}

