/**********************************************************
 *(c) by Knobloch GmbH
 *       Weedgasse 14 
 *       D-55234 Erbes-Bdesheim                                    
 *
 *  File:           TimerTick1.c        Sampleprogram for Robo-Interface C-Compiler
 *                                      Using 1ms TimerTick()
 *  Version:        0.01
 *
 *  Revision:
 *          0.01:   08.02.2006 
 *                  Start
 *
 *  This Sample counts every 10ms Output O1..O8.
 *  The program stops, if Input I1 ist set to "1".
 *
 *  Then it jumps with a "return(x)" back to the Robo-If firmware.
 *  The firmware checks the value of "x" and the red "Error-Led"
 *  counts the x-value. With "0", the LED isnt blinking.
 *  You can use this function for testing your program.
 **********************************************************/
                  
#include    "TA_Firmware\TAF_00D.h"
#include    "TA_Firmware\TAF_00P.h"
 


UCHAR   ucTimerTick;

// This procedure is calling every 1ms from the Firmware
void TimerTick1ms(void)
{
    ucTimerTick++;                      // +1ms

    if (ucTimerTick >= 10)
    {
        ucTimerTick = 0;
        sTrans.M_Main = ++sTrans.M_Main;

        // New Value for Outputs
        // Output PWM update (0x01=always, 0x02=once)
        // Base+0xE1: | 0  | 0  | 0  | 0  | 0  | 0  |ONCE|ALWA|
        sTrans.MPWM_Update = 0x02;      // Update PWM OneTime
    }
}


UCHAR main(void)
{
    // New PWM for Outputs
    sTrans.MPWM_Main[0] = 8;    // PWM for Output O1
    sTrans.MPWM_Main[1] = 8;    // PWM for Output O2
    sTrans.MPWM_Main[2] = 8;    // PWM for Output O3
    sTrans.MPWM_Main[3] = 8;    // PWM for Output O4
    sTrans.MPWM_Main[4] = 8;    // PWM for Output O5
    sTrans.MPWM_Main[5] = 8;    // PWM for Output O6
    sTrans.MPWM_Main[6] = 8;    // PWM for Output O7
    sTrans.MPWM_Main[7] = 8;    // PWM for Output O8

    ucTimerTick = 0;
    SetFt1msTimerTickAddress( (void far *) &TimerTick1ms );

    do
    {
        ;   // TimerTick1ms() is switching the output
    }
    while ( (sTrans.E_Main & 0x01) == 0);    

    SetFt1msTimerTickAddress(NULL);     // Stop TimerTick1ms() calling

    return (0);     // number of "Error - LED" blink times (0..5) after 
                    // program is finished
                    // With >5, the ERROR Led starts continously blinking. 
                    // You can stop this with pressing the Interface PROG Switch.
}
