/* $Id: head.S,v 1.1.1.1 2004/04/08 02:57:37 ysc Exp $
 *
 * arch/mips/kernel/head.S
 *
 * This file is subject to the terms and conditions of the GNU General Public
 * License.  See the file "COPYING" in the main directory of this archive
 * for more details.
 *
 * Copyright (C) 1994, 1995 Waldorf Electronics
 * Written by Ralf Baechle and Andreas Busse
 * Copyright (C) 1995 - 1999 Ralf Baechle
 * Copyright (C) 1996 Paul M. Antoine
 * Modified for DECStation and hence R3000 support by Paul M. Antoine
 * Further modifications by David S. Miller and Harald Koerfgen
 * Copyright (C) 1999 Silicon Graphics, Inc.
 *
 * Head.S contains the MIPS exception handler and startup code.
 */

#include <linux/config.h>
/*Cyrus Tsai*/
#include <linux/init.h>
/*Cyrus Tsai*/

#include <linux/threads.h>

#include <asm/asm.h>
#include <asm/cacheops.h>
#include <asm/current.h>
#include <asm/offset.h>
#include <asm/processor.h>
#include <asm/regdef.h>
#include <asm/cachectl.h>
#include <asm/mipsregs.h>
#include <asm/stackframe.h>
#include <asm/bootinfo.h>
#include <asm/cpu.h>
#ifdef CONFIG_PM_SUSPEND_WAKEUP
#include <asm/power.h>
#endif

__INIT
	.text
	/*
	 * Reserved space for exception handlers.
	 * Necessary for machines which link their kernels at KSEG0.
	 * FIXME: Use the initcode feature to get rid of unused handler
	 * variants.
	 */
	.fill	0x400




	NESTED(start, 16, sp)
	.set	noreorder
	/* The following two symbols are used for kernel profiling. */
	EXPORT(stext)
	EXPORT(_stext)


	/*
	 * Stack for kernel and init, current variable
	 */

	/*mfc0 k0, $6
	nop
	nop*/
	la	k0, head_start
 	jr	k0
	nop
	
head_start:
	la	$28, init_task_union
	addiu	t0, $28, KERNEL_STACK_SIZE-32
	//sw	t0, kernelsp
	subu	sp, t0, 4*SZREG

	/* The firmware/bootloader passes argc/argp/envp
	 * to us as arguments.  But clear bss first because
	 * the romvec and other important info is stored there
	 * by prom_init().
	 */
	la	t0, _fbss
	sw	zero, (t0)
	la	t1, (_end - 4)
	la	k0, _end
1:
	addiu	t0, 4
	bne	t0, t1, 1b
	sw	zero, (t0)

	jal	init_arch	
	nop
	END(start)


	/* General exception vector. */
		/* TLB refill, EXL == 0, R[23]00 version */

	.set	at
	.set	reorder	   
 /* General exception vector.*/
/*Cyrus Tsai*/
/*This is the direction of exception toward their handlers*/
		NESTED(exception_matrix, 0, sp)

		mfc0	k1, CP0_CAUSE
		la	k0, exception_handlers
		andi	k1, k1, 0x7c
		addu	k0, k0, k1
		lw	k0, (k0)
		jr	k0
		END(exception_matrix)
/*Cyrus Tsai*/




/*
 * This buffer is reserved for the use of the cache error handler.
 */

__FINIT