/*
 * This file is subject to the terms and conditions of the GNU General Public
 * License.  See the file "COPYING" in the main directory of this archive
 * for more details.
 *
 * Copyright (C) 1994 - 1999 by Ralf Baechle
 * Modified for R3000 by Paul M. Antoine, 1995, 1996
 * Complete output from die() by Ulf Carlsson, 1998
 * Copyright (C) 1999 Silicon Graphics, Inc.
 */

#include <linux/linkage.h>
#include <asm/ptrace.h>
#include <asm/mipsregs.h>
#include <asm/addrspace.h>
#include <asm/system.h>

#define PROM_DEBUG

#ifdef PROM_DEBUG
extern int prom_printf(char *, ...);
#endif

/*Cyrus Tsai*/
void flush_cache(void);
void flush_icache(void);
void flush_dcache(void);
/*Cyrus Tsai*/


void flush_cache(void)
{
	
	int s;
	s = read_32bit_cp0_register(CP0_XCONTEXT);
	s = (s >> 2) << 2;
	write_32bit_cp0_register(CP0_XCONTEXT, s);
	s |= 0x3;
	write_32bit_cp0_register(CP0_XCONTEXT, s);
	s = (s >> 2) << 2;
	write_32bit_cp0_register(CP0_XCONTEXT, s);	
}


/*Cyrus Tsai*/
void flush_icache()
{
   unsigned long flags;
   volatile unsigned int reg;
 
   save_flags(flags);cli();	// david
 
   reg=read_32bit_cp0_register(CP0_XCONTEXT);
   
   __asm__ volatile("nop");	// david
   __asm__ volatile("nop");   
   
   write_32bit_cp0_register(CP0_XCONTEXT, (reg &(~0x2))); //write '0' to bit 0,1
   
   __asm__ volatile("nop");
   __asm__ volatile("nop");    
   
   write_32bit_cp0_register(CP0_XCONTEXT, (reg | 0x2)); //wirte '1' to bit 0, 1
   
   __asm__ volatile("nop");	// david
   __asm__ volatile("nop");  
   
   restore_flags(flags); 
   
}

void flush_dcache()
{
   unsigned long flags;
   volatile unsigned int reg;
   
   save_flags(flags);cli();	// david
   
   reg=read_32bit_cp0_register(CP0_XCONTEXT);
   
   __asm__ volatile("nop");	// david
   __asm__ volatile("nop");      
   
   write_32bit_cp0_register(CP0_XCONTEXT, (reg &(~0x1))); //write '0' to bit 0,1
   
   __asm__ volatile("nop");	// david
   __asm__ volatile("nop");      
   
   write_32bit_cp0_register(CP0_XCONTEXT, (reg | 0x1)); //wirte '1' to bit 0, 1
   
   __asm__ volatile("nop");	// david
   __asm__ volatile("nop");  
   
   restore_flags(flags);    
}
/*Cyrus Tsai*/



void trap_init(void)
{
	flush_cache();
//	flush_icache_range(KSEG0, KSEG0 + 0x200);
}
