/* --------------------------------------------------------------------
 *
 * Copyright 2002 by Realtek Semiconductor Corp.
 *
 * --------------------------------------------------------------------*/

#include <asm/io.h>
#include <asm/rtl8181.h>

//#define FLASH_BASE 		0x2bf0000
#define FLASH_BASE 		0x00ff0000
/*Cyrus Tsai*/
/*mips_io_port_base + FLASH_BASE =0xbfc0 0000   */
/*mips_io_port_base = 0xbd01 0000               */
/*Replace the 0xbfc0 0000 with 0xbe00 0000      */
/*so FLASH_BASE should be changed to 0x00ff 0000*/
/*if support large size FLASH                   */
/*Cyrus Tsai*/

#define MAX_SEC_SIZE		64*1024		// 64K bytes

#define MEM_CONTROLLER_REG	0xBD011000	// memory contoller register
#define FLASH_MASK		0x3fffffff

/*Cyrus Tsai*/
/*#define FLASH_1M		0x80000000	// 1M bytes*/
/*#define FLASH_2M		0xC0000000	// 2M bytes*/
/*Cyrus Tsai*/

#define FLASH_1M		0x00000000	// 1M bytes
#define FLASH_2M		0x40000000	// 2M bytes
#define FLASH_4M		0x80000000	// 4M bytes
#define FLASH_8M		0xC0000000	// 8M bytes


//#define CPU_CLOCK		(20*1024*1024)		// CPU 20MHZ
//#define WAIT_TIME_FLASH_ERASE 	(20*CPU_CLOCK)		// 20 seconds
//#define WAIT_TIME_FLASH_WRITE 	(1*CPU_CLOCK)		// 1 seconds

/* Manufacturers */
#define MANUFACTURER_MXIC	0x00C2
#define MANUFACTURER_AMD    0x0001
#define MANUFACTURER_ST     0x0020
#define MANUFACTURER_INTEL  	0x0089	

/* MXIC deivce id */
#define MX29LV800B		0x225B
#define MX29LV160AB		0x2249
#define MX29LV320AB		0x22A8
#define MX29LV640AB		0x22CB//Add by vin

/* AMD deivce id */
#define AM29LV800BB     0x225B
#define AM29LV160DB     0x2249
#define AM29LV320DB     0x22F9

/* ST device id */             
#define M29W160DB       0X2249 

/* Intel device id */
#define TE28F160C3      	0x88C3 


/* SST deivce id */
//#define MANUFACTURER_SST    0x00BF
//#define SST39VF800     0x2781
//#define SST39VF160     0x2782
//#define SST39VF320     0x2783


struct erase_region_info {
	int offset;
	int erasesize;
	int numblocks;
};

struct flash_desc {
	unsigned short mfr_id;
	unsigned short dev_id;
	int size;
	int shift;
	int numregion;
	struct erase_region_info regions[4];
};

struct flash_map {
	int totalsize;
	int chipnum;
	int chipshift;
	int numregion;
	struct erase_region_info regions[8];
};


static struct flash_desc table[]=
{
	  {
		mfr_id: MANUFACTURER_MXIC,
		dev_id: MX29LV800B,
		size: 0x00100000,
		shift: 20,/*20 bit=> that is 1 MByte size*/
		numregion: 4,
		regions: {
			{ offset: 0x000000, erasesize: 0x04000, numblocks:  1 },
			{ offset: 0x004000, erasesize: 0x02000, numblocks:  2 },
			{ offset: 0x008000, erasesize: 0x08000, numblocks:  1 },
			{ offset: 0x010000, erasesize: 0x10000, numblocks: 15 }
		}
	  },
	  {
		mfr_id: MANUFACTURER_AMD,
		dev_id: AM29LV800BB,
		size: 0x00100000,
		shift: 20,/*20 bit=> that is 1 MByte size*/
		numregion: 4,
		regions: {
			{ offset: 0x000000, erasesize: 0x04000, numblocks:  1 },
			{ offset: 0x004000, erasesize: 0x02000, numblocks:  2 },
			{ offset: 0x008000, erasesize: 0x08000, numblocks:  1 },
			{ offset: 0x010000, erasesize: 0x10000, numblocks: 15 }
		}
	  },
	  {
		mfr_id: MANUFACTURER_MXIC,
		dev_id: MX29LV160AB,
		size: 0x00200000,
		shift: 21,/*21 bit=> that is 2 MByte size*/
		numregion: 4,
		regions: {
			{ offset: 0x000000, erasesize: 0x04000, numblocks:  1 },
			{ offset: 0x004000, erasesize: 0x02000, numblocks:  2 },
			{ offset: 0x008000, erasesize: 0x08000, numblocks:  1 },
			{ offset: 0x010000, erasesize: 0x10000, numblocks: 31 }
		}
	},	  {
		mfr_id: MANUFACTURER_AMD,
		dev_id: AM29LV160DB,
		size: 0x00200000,
		shift: 21,/*21 bit=> that is 2 MByte size*/
		numregion: 4,
		regions: {
			{ offset: 0x000000, erasesize: 0x04000, numblocks:  1 },
			{ offset: 0x004000, erasesize: 0x02000, numblocks:  2 },
			{ offset: 0x008000, erasesize: 0x08000, numblocks:  1 },
			{ offset: 0x010000, erasesize: 0x10000, numblocks: 31 }
		}
	},
	        {                                                               
		mfr_id: MANUFACTURER_ST,                                        
		dev_id: M29W160DB,                                              
	        size: 0x00200000,                                               
		shift: 21,/*21 bit=> that is 2 MByte size*/                     
		numregion: 4,                                                   
		regions: {                                                      
			{ offset: 0x000000, erasesize: 0x04000, numblocks:  1 },
			{ offset: 0x004000, erasesize: 0x02000, numblocks:  2 },
			{ offset: 0x008000, erasesize: 0x08000, numblocks:  1 },
			{ offset: 0x010000, erasesize: 0x10000, numblocks: 31 } 
		}                                                               
	},                                                                      
	        {
		mfr_id: MANUFACTURER_MXIC,
		dev_id: MX29LV320AB,
		size: 0x00400000,
		shift: 22,/*22 bit=> that is 4 MByte size*/
		numregion: 2,
		regions: {
			{ offset: 0x000000, erasesize: 0x02000, numblocks:  8 },
			{ offset: 0x010000, erasesize: 0x10000, numblocks:  63}
		}
	  },
	  		  {
		mfr_id: MANUFACTURER_AMD,
		dev_id: AM29LV320DB,
		size: 0x00400000,
		shift: 22,/*22 bit=> that is 4 MByte size*/
		numregion: 2,
		regions: {
			{ offset: 0x000000, erasesize: 0x02000, numblocks:  8 },
			{ offset: 0x010000, erasesize: 0x10000, numblocks:  63}
		}
	  }
		//Intel table
	       ,{                                                               
		mfr_id: MANUFACTURER_INTEL,                                        
		dev_id: TE28F160C3,                                              
	        size: 0x00200000,                                               
		shift: 21,/*21 bit=> that is 2 MByte size*/                     
		numregion: 2,                                                   
		regions: {                                                      
			{ offset: 0x000000, erasesize: 0x02000, numblocks:  8 },
			{ offset: 0x010000, erasesize: 0x10000, numblocks: 31 } 
		}                                                               
	}       
	  #if 0
	  ,
	    {
		mfr_id: MANUFACTURER_SST,
		dev_id: SST39VF800,
		size: 0x00100000,
		shift: 20,/*22 bit=> that is 1 MByte size*/
		numregion: 1,
		regions: {
			{ offset: 0x000000, erasesize: 0x00800, numblocks:  512 }
		}
	  },
	  	  		  {
		mfr_id: MANUFACTURER_SST,
		dev_id: SST39VF160,
		size: 0x00200000,
		shift: 21,/*21 bit=> that is 2 MByte size*/
		numregion: 1,
		regions: {
			{ offset: 0x000000, erasesize: 0x00800, numblocks:  1024 }
		}
	  },
	  {
		mfr_id: MANUFACTURER_SST,
		dev_id: SST39VF320,
		size: 0x00400000,
		shift: 22,/*22 bit=> that is 4 MByte size*/
		numregion: 1,
		regions: {
			{ offset: 0x000000, erasesize: 0x00800, numblocks:  2048 }
		}
	  }
     #endif

		,{
		mfr_id: MANUFACTURER_MXIC,
		dev_id: MX29LV640AB,
		size: 0x00800000,
		shift: 23,/*22 bit=> that is 8 MByte size*/
		numregion: 2,
		regions: {
			{ offset: 0x000000, erasesize: 0x02000, numblocks:  8 },
			{ offset: 0x010000, erasesize: 0x10000, numblocks:  127}
		}
		}
};



static struct flash_map map;
static unsigned short mfid, devid;
unsigned int flash_buf[MAX_SEC_SIZE>>2];

static unsigned long  get_sector(unsigned long addr);
static unsigned int get_size_by_sector(unsigned long addr);
static int flash_sector_erase(unsigned long addr);
static int flash_sector_program(unsigned long addr , unsigned char *buf, unsigned int size);
static int program_word(unsigned long addr, unsigned short prog_data, unsigned int offset);

/*-----------------------------------------------------------------------
  flasinit(): probe flash memory by reading manufacture and device id. If
	found, try to probe 2nd flash to see if it exists or not. Last,
	map the flash table to determine size, offset, and erase block.
-------------------------------------------------------------------------*/

int flashinit()    
{
	int i, j, k, interleave=1, chipsize;
	unsigned short mfid_2nd, devid_2nd;
	unsigned long tmp;


	// issue reset and auto-selection command
	rtl_outw(FLASH_BASE, 0xf0);

	rtl_outw(FLASH_BASE + 0x555 * 2, 0xaa);
	rtl_outw(FLASH_BASE + 0x2aa * 2, 0x55);
	rtl_outw(FLASH_BASE + 0x555 * 2, 0x90);

	mfid = rtl_inw(FLASH_BASE);
	devid = rtl_inw(FLASH_BASE + 1*2);

	prom_printf("mfid=%x devid=%x\n",mfid,devid);
	rtl_outw(FLASH_BASE, 0xf0);


	for (i=0; i< sizeof(table)/sizeof(table[0]); i++) {
		if ( mfid==table[i].mfr_id && devid==table[i].dev_id)
			break;
	}
	if ( i == sizeof(table)/sizeof(table[0]) ) {
		prom_printf("Probe flash memory failed!\n");
		return 0;
	}

	// Set flash size into memory controller
	tmp = *((volatile unsigned long *)MEM_CONTROLLER_REG);
        
        /*Cyrus Tsai change to switch case for higher flash size*/
#if 0
	if ( table[i].size == 0x100000 )
		tmp = (tmp & FLASH_MASK) | FLASH_1M;
	else
		tmp = (tmp & FLASH_MASK) | FLASH_2M;
#endif

	switch (table[i].size) {	
	case (1*1024*1024):
		tmp = (tmp & FLASH_MASK) | FLASH_1M;
		break;
	case (2*1024*1024):
		tmp = (tmp & FLASH_MASK) | FLASH_2M;
		break;
	case (4*1024*1024):
		tmp = (tmp & FLASH_MASK) | FLASH_4M;
		break;
	case (8*1024*1024):
		tmp = (tmp & FLASH_MASK) | FLASH_8M;
		break;
			}	

	*((volatile unsigned long *)MEM_CONTROLLER_REG) = tmp;

	// Look for 2nd flash
	rtl_outw(FLASH_BASE + table[i].size, 0xf0);

	rtl_outw(FLASH_BASE + table[i].size + 0x555 * 2, 0xaa);
	rtl_outw(FLASH_BASE + table[i].size + 0x2aa * 2, 0x55);
	rtl_outw(FLASH_BASE + table[i].size + 0x555 * 2, 0x90);

	mfid_2nd = rtl_inw(FLASH_BASE + table[i].size);
	devid_2nd = rtl_inw(FLASH_BASE + table[i].size + 1*2);

	rtl_outw(FLASH_BASE + table[i].size, 0xf0);

	if ( mfid_2nd==table[i].mfr_id && devid_2nd==table[i].dev_id) {
		interleave++;
	}
        /*here add a return for an un-proper case*/
        //else
        //return 0;

	prom_printf("Found %d x %dM flash memory\n", interleave, table[i].size/0x100000);

	map.totalsize = table[i].size*interleave;
	map.numregion = table[i].numregion*interleave;
	map.chipnum = interleave;
	map.chipshift = table[i].shift;

	for (k=0, chipsize=0; interleave>0; interleave--, chipsize+=table[i].size) {
		for (j=0; j<table[i].numregion; j++, k++) {
			map.regions[k].offset = table[i].regions[j].offset+chipsize;
			map.regions[k].erasesize = table[i].regions[j].erasesize;
			map.regions[k].numblocks = table[i].regions[j].numblocks;
		}
	}
	return 1;
}


/*-----------------------------------------------------------------------
flashread: read from flash (src) to (dst) with byte counts==length
since flash can only be accessed by 16-bits mode, therefore, we set limits
on dst/src to be 16-bits alignment.
------------------------------------------------------------------------*/

/*Cyrus Tsai*/
/*dst at SDRAM, src at FLASH, when using SDRAM, only Byte access,or memcpy*/
/*dst at SDRAM, src at FLASH, when using FLASH, only 16Bit access         */

int flashread (unsigned long dst, unsigned int src, unsigned long length)
{
 Int16 tmp=0;
 if (length==0)
 return 1;
                                           /* It is the first byte              */
 if (src & 0x01)                          /* FLASH should be 16Bit alignment   */
    {
  					  /* FLASH 16bit alignment             */
     tmp = rtl_inw(FLASH_BASE + src - 1); /* FLASH 16bit access                */
     tmp = tmp & 0x00ff;
     *(Int8*)(dst) = (Int8)tmp;           /* Byte access SDRAM                 */  
     
     //prom_printf("%X,%X,%X,%X\n",dst,src,length,*(Int8*)(dst));

     dst=dst+1;                           /* Finish the First Byte             */
     src=src+1;                           /* Finish the First Byte             */
     length=length-1;                     /* Finish the First Byte             */
    }

   while(length)
      {
       if(length == 1)                    
         {
	  tmp = rtl_inw(FLASH_BASE + src);
	  *(Int8*)(dst)=(Int8)( ((tmp >> 8) & 0x00ff) );
	//  prom_printf("%X,%X,%X,%X\n",dst,src,length,*(Int8*)(dst));
          break;
         }

       tmp=rtl_inw(FLASH_BASE + src);     // From now on, src 16Bit aligned
                                          // FLASH 16bit access                 
                                          //if(src&0x01)
                                          //prom_printf("error");
                                          //if(length<2)
                                          //prom_printf("error");                                            
       memcpy((Int8*)dst,&tmp,2);         //use memcpy, avoid SDRAM alignement 
     
       //prom_printf("%X,%X,%X,%X\n",dst,src,length,*(unsigned short*)(dst));
     
       dst=dst+2;
       src=src+2;
       length=length-2;
      }
   return 1;
}


/*-----------------------------------------------------------------------
For flash_write operation, we don't set any limit on dst/src to be 16-bits
alignment.
------------------------------------------------------------------------*/
/*dst at FLASH, src at SDRAM*/
/*when using SDRAM, we must use Byte access or memcpy  */
/*when using FLASH, we must use 16Bit access           */

//int flashwrite(unsigned long FLASH, unsigned long SDRAM, unsigned long length)
int flashwrite(unsigned long dst, unsigned long src, unsigned long length)
{
	unsigned int sec_size,offset;
	unsigned long sec_addr;
	int res=0;
        
        if (length==0)
 	return 1;
/**********************************************************************************/	
	while(length)
	{
 	    sec_addr = get_sector(dst);/*Now dst must equal sec_addr*/
  	    sec_size = get_size_by_sector(sec_addr);

            if (dst != sec_addr)
  	       offset = dst - sec_addr;
 	    else
	       offset = 0;

	   //prom_printf("program offset at %X\n", offset);

            if ((flashread ((unsigned long)(flash_buf), sec_addr, sec_size)) == 0)
			goto write_end;

 	    if (length < (sec_size-offset))
		{
	         memcpy((void *)((int)flash_buf+(int)offset), (unsigned char *)src, length);
		 length = 0; /*last sector to deal with*/
		}
   	    else
		{/*still need to deal with next sector*/
 		 memcpy((void *)((int)flash_buf+(int)offset), (unsigned char *)src, sec_size-offset);
		 length = length-(sec_size-offset);;
		 src += sec_size-offset;
		 dst += sec_size-offset;
		}
		
		if (!(flash_sector_erase(sec_addr)))
		{
			//prom_printf("sector_erase fails! at sec_addr=%X\n");			
			goto write_end;
		}	
		if (!(flash_sector_program(sec_addr , (unsigned char *)flash_buf, sec_size)))
		{
			//prom_printf("sector_program fails! at sec_addr=%X, sec_size=%X\n", sec_addr, sec_size);
			goto write_end;
		}
	}

	res=1;	
	
write_end:
        return res;	

}




/*-------------------------------------------------------------
 *  Local routines
 *-------------------------------------------------------------*/

static unsigned long  get_sector(unsigned long addr)
{
	int i,j;

	unsigned long saddr = 0;

	if (addr >= map.totalsize)
		goto sect_find;

	i=0;
	while(i < map.numregion)
	{
		for(j=0; j< map.regions[i].numblocks; j++)
		{
			if ((addr >= (map.regions[i].offset +
			    ((j) * map.regions[i].erasesize))) &&
			    (addr < (map.regions[i].offset +
			    ((j+1) * map.regions[i].erasesize))))
				goto sect_find;

			saddr += map.regions[i].erasesize;
		}
		i++;
	}


	if ( i == map.numregion )
		saddr = (unsigned long)-1;
sect_find:
	return saddr;
}


static unsigned int get_size_by_sector(unsigned long addr)
{

	int i,j;
	unsigned int saddr ;
	for(i=0,saddr=0; i< map.numregion; i++)
	{
		for(j=0; j< map.regions[i].numblocks;j++)
		{
			if (saddr == addr)
				return	map.regions[i].erasesize;
			saddr += map.regions[i].erasesize;
		}
	}

	return 0;
}


static int flash_sector_erase(unsigned long addr)
{
	unsigned long i, j;
	int res=0, offset;

	if (addr >= map.totalsize)
		goto erase_end;

	offset = (addr >> map.chipshift) * (1 << map.chipshift);

	prom_printf(".");

	if(mfid==MANUFACTURER_INTEL && devid==TE28F160C3) {
		//do unlock for all blocks 
		rtl_outw(FLASH_BASE+offset, 0x60);
		rtl_outw(FLASH_BASE+addr, 0xd0);
		//block erase command
		rtl_outw(FLASH_BASE + offset, 0x20);
		rtl_outw(FLASH_BASE + addr, 0xd0);
	
	// + start + this is for INTEL flash
	        i=0xffffff0;
		while(!(rtl_inw(FLASH_BASE+addr) & 0x80)) 
			i -- ;
		if(!i)
			return 0;
		// issue read command
		rtl_outw(FLASH_BASE + addr, 0xff);
	// - end - 
	} else {

		rtl_outw(FLASH_BASE + offset + 0x555*2, 0xf0); // for reset
	for(i=0; i< 0x100; i++);
		
		rtl_outw(FLASH_BASE + offset + 0x555*2, 0xaa);
		rtl_outw(FLASH_BASE + offset + 0x2aa*2, 0x55);
		rtl_outw(FLASH_BASE + offset + 0x555*2, 0x80);
		rtl_outw(FLASH_BASE + offset + 0x555*2, 0xaa);
		rtl_outw(FLASH_BASE + offset + 0x2aa*2, 0x55);

		rtl_outw(FLASH_BASE + addr, 0x30);
	}
        i=0xffffff0;
	while (i)
	{
		j=rtl_inw(FLASH_BASE +  addr);
  		if (j == 0xffff)
			break;
	}
	if (i)
		res = 1;
erase_end:

	return res;
}

/*--------------------------------------------------------/
addr is the starting addr of a given sector,
and buf will be the source address for programming.
size is the byte count to be programmed.
---------------------------------------------------------*/
static int flash_sector_program(unsigned long addr , unsigned char *buf, unsigned int size)
{
	unsigned int  i;
	unsigned int status;
	unsigned int res=0, offset;

	if (addr >= map.totalsize)
		goto program_end;

	offset = (addr >> map.chipshift) * (1 << map.chipshift);

//	rtl_outw(FLASH_BASE + offset + 0x555*2, 0xf0); // for reset
//	for(i=0; i< 0x100; i++);

	for(i=0;i< size; i+=2,addr+=2,buf+=2) // our flash is implemented as 16-bits mode
	{

		status=program_word(addr,*(unsigned short*)(buf), offset);
		if(!status)
		{
//			prom_printf("program_word fails! at addr=%X, data=%X\n", addr,*(unsigned short*)(buf));
			goto program_end;
		}

	}
	res=1;
program_end:
	return res;
}

static int program_word(unsigned long addr, unsigned short prog_data, unsigned int offset)
{
	unsigned short j;
	unsigned long flags,i;
         

	if(mfid==MANUFACTURER_INTEL && devid==TE28F160C3) {
		//program command
		rtl_outw(FLASH_BASE + offset , 0x40);
		rtl_outw(FLASH_BASE + addr, prog_data);
	// + start + this is for INTEL flash
		i=0xffffff0;
		while(i) {
			if(rtl_inw(FLASH_BASE+offset) & 0x80)
				break;
			i --;
        }
		if(!i)
			return 0;
		// issue read command
       		rtl_outw(FLASH_BASE + offset , 0xff);
	// - end -
	} else {
		rtl_outw(FLASH_BASE + offset + 0x555*2, 0xaa);
		rtl_outw(FLASH_BASE + offset + 0x2aa*2, 0x55);
		rtl_outw(FLASH_BASE + offset + 0x555*2, 0xa0);
		rtl_outw(FLASH_BASE + addr, prog_data);
	}

	i=0xffffff0;
	
	while(i)
	{
		j=rtl_inw(FLASH_BASE	+addr);

		if (j == prog_data )
		{
			//prom_printf("i=%X\n",i);
			break;
		}
          i--;
	}

	if (i)
		return 1;
	else
		return 0; //fail
}


 

 
void check_eth_setting();
//extern int ETH0_IRQ=4;
//extern unsigned long ETH0_ADD=0x1F0000;
extern int ETH0_IRQ;
extern unsigned long ETH0_ADD;

void check_eth_setting()
{
#if 0
		//prom_printf("This is eth 0 interrupt \n");
        ETH0_IRQ=4;
        ETH0_ADD=0x1F0000;

        *(volatile unsigned long *)(0xbd200038)= 0x16000;
 
        //*(volatile unsigned long *)(0xbd200038)= 0x1e010;
        *(volatile unsigned long *)(0xbd300038)= 0x46000;
#endif

#ifndef RTL8186
	if (((*(volatile unsigned short *)(0xbfc06006)) >> 8) & 0x02)
	{
		prom_printf("This is eth 1 interrupt \n");
        ETH0_IRQ=5;
        ETH0_ADD=0x2F0000;
	}
	else 
	{  
		prom_printf("This is eth 0 interrupt \n");
        ETH0_IRQ=4;
        ETH0_ADD=0x1F0000;
	}	
	
	if (((*(volatile unsigned short *)(0xbfc06006)) >> 8) & 0x01)
	{
		prom_printf("This is 8305SB\n");
		// This is 8305SB
        *(volatile unsigned long *)(0xbd200038)= 0x1e010;
        *(volatile unsigned long *)(0xbd300038)= 0x46000;
	}
	else
	{
		// This is 8201BL
		prom_printf("This is 8201BL\n");
        *(volatile unsigned long *)(0xbd200038)= 0x16000;
        *(volatile unsigned long *)(0xbd300038)= 0x16000;
	}	
#endif	
}

/*Cyrus Tsai*/
/*we have total up to 16 MB flash*/
/*orignal 4MB, that is bfc-->bff*/
/*now up 16MB, that is be0-->bef*/
/*Cyrus Tsai*/
