//#define NIC1

#ifndef _RTL8181_H
#define _RTL8181_H

//#define mips_io_port_base 0xBD010000


#define TRUE	0x01
#define FALSE	0x0

#define BIT(x)	(1 << (x))

#define rtl_inb(offset)	(*(volatile unsigned char *)(mips_io_port_base + offset))
#define rtl_inw(offset)	(*(volatile unsigned short *)(mips_io_port_base + offset))
#define rtl_inl(offset)	(*(volatile unsigned long *)(mips_io_port_base + offset))

#define rtl_outb(offset,val)	(*(volatile unsigned char *)(mips_io_port_base + offset) = val)
#define rtl_outw(offset,val)	(*(volatile unsigned short *)(mips_io_port_base + offset) = val)
#define rtl_outl(offset,val)	(*(volatile unsigned long *)(mips_io_port_base + offset) = val)


// For BUS_MASTER



// For Uart1 Controller
#define UART_RBR	0xC3
#define UART_THR	0xC3
#define UART_DLL	0xC3
#define	UART_IER	0xC7
#define	UART_DLM	0xC7
#define	UART_IIR	0xCB
#define	UART_FCR	0xCB
#define UART_LCR	0xCF
#define	UART_MCR	0xD3
#define	UART_LSR	0xD7
#define	UART_MSR	0xDB
#define	UART_SCR	0xDF

// For Uart1 Flags
#define UART_RXFULL	BIT(0)
#define UART_TXEMPTY	(BIT(6) | BIT(5))
#define UART_RXFULL_MASK	BIT(0)
#define UART_TXEMPTY_MASK	BIT(1)



// For Interrupt Controller
#define	GIMR0		0x00
#define GISR		0x04
#define IRR0		0x08


// For General Purpose Timer/Counter

#define	TC0DATA		0x60
#define TC1DATA		0x64
#define	TC2DATA		0x68
#define TC3DATA		0x6C
#define	TC0CNT		0x70
#define TC1CNT		0x74
#define	TC2CNT		0x78
#define TC3CNT		0x7C
#define TCCNR		0x50
#define	TCIR		0x54
#define	BTDATA		0x58
#define	WDTCNR		0x5C




// For NIC

#ifndef NIC1
#define NIC0_CNR1	0x2000
#define NIC0_ID		0x2004
#define	NIC0_MAR	0x200C
#define NIC0_TSAD	0x2014
#define	NIC0_RSAD	0x2018
#define NIC0_IMTR	0x201C
#define NIC0_IMR	0x2020
#define NIC0_ISR	0x2024
#define	NIC0_TMF0	0x2028
#define	NIC0_TMF1	0x202C
#define NIC0_TMF2	0x2030
#define	NIC0_TMF3	0x2034
#define	NIC0_MII	0x2038
#define	NIC0_CNR2	0x203C
#define NIC0_MPC	0x2080
#define NIC0_TXCOL	0x2084
#define NIC0_RXER	0x2088
#define	NIC0_BIST	0x208C

#else
#define NIC0_CNR1	0x3000
#define NIC0_ID		0x3004
#define	NIC0_MAR	0x300C
#define NIC0_TSAD	0x3014
#define	NIC0_RSAD	0x3018
#define NIC0_IMTR	0x301C
#define NIC0_IMR	0x3020
#define NIC0_ISR	0x3024
#define	NIC0_TMF0	0x3028
#define	NIC0_TMF1	0x302C
#define NIC0_TMF2	0x3030
#define	NIC0_TMF3	0x3034
#define	NIC0_MII	0x3038
#define	NIC0_CNR2	0x303C
#define NIC0_MPC	0x3080
#define NIC0_TXCOL	0x3084
#define NIC0_RXER	0x3088
#define	NIC0_BIST	0x308C


#endif

#define NIC1_CNR1	0x3000
#define NIC1_ID		0x3004
#define	NIC1_MAR	0x300C
#define NIC1_TSAD	0x3014
#define	NIC1_RSAD	0x3018
#define NIC1_IMTR	0x301C
#define NIC1_IMR	0x3020
#define NIC1_ISR	0x3024
#define	NIC1_TMF0	0x3028
#define	NIC1_TMF1	0x302C
#define NIC1_TMF2	0x3030
#define	NIC1_TMF3	0x3034
#define	NIC1_MII	0x3038
#define	NIC1_CNR2	0x303C
#define NIC1_MPC	0x3080
#define NIC1_TXCOL	0x3084
#define NIC1_RXER	0x3088
#define	NIC1_BIST	0x308C


#endif

#define FLASH_BASE 0x2bf0000
