#include <linux/errno.h>
#include <linux/init.h>
#include <linux/kernel_stat.h>
#include <linux/types.h>
#include <linux/interrupt.h>
#include <linux/random.h>
#include <asm/bitops.h>
#include <asm/bootinfo.h>
#include <asm/irq.h>
#include <asm/mipsregs.h>
#include <asm/system.h>
#include <linux/circ_buf.h>
#include <asm/rtl8181.h>
#include <asm/io.h>

#include "etherboot.h"

#include "nic.h"

#include "eth8670.h"  

#define BUF_OFFSET 	4	// descriptor offset of data BUFFER
#define DATA_OFFSET	2	// real data offset of Rx packet in buffer
				// why? don't ask me

int ETH0_IRQ=4;
unsigned long ETH0_ADD=0x1F0000;

/*ETH0 start address is 0xbd20 0000*/
/*in asm/io.h, #define mips_io_port_base 0xbd010000 */
/*so ETH0 base address is 0x1f0000*/

/*As in the eth.c, David changed them into ethernet address base rtl_in,out*/
/*Except we define #undef rtl_inb,rtl_inw...*/
/*here is the general rtl_in..just defined in rtl8181.h*/

//#define ETH0_ADD 0x2F0000
//#define ETH0_IRQ 5

#define NUM_DESC	0x8
#define BUF_SIZE	1600	// Byte Counts

static Int32 ETH0_DESC_BASE[2048];/*that is 8k*/
static Int8 ETH0_rx_buf[NUM_DESC][BUF_SIZE];
static Int8 ETH0_tx_buf[NUM_DESC][BUF_SIZE];

char eth0_mac[6]={0x56, 0xaa, 0xa5, 0x5a, 0x7d, 0xe8};


typedef struct
{
	Int32 header;
	Int32 tag;
	Int32 addr;
	Int32 dummy;
}desc_t;



struct statistics
{
	unsigned int txpkt;
	unsigned int rxpkt;
	unsigned int txerr;
	unsigned int rxerr;
	unsigned int rxffov;
		
};

struct eth_private
{
	unsigned int nr;
	unsigned int io_addr;
	unsigned int irq;
	unsigned int num_desc;
	Int32 rx_descaddr;
	Int32 tx_descaddr;
	Int32 tx_skbaddr[NUM_DESC];	
	Int32 rx_skbaddr[NUM_DESC];
	struct statistics  res;
	unsigned int cur_rx;
	unsigned int cur_tx;
};


extern void flush_cache(void);
struct eth_private ETH[2];

void eth_interrupt(int irq, void *dev_id, struct pt_regs *regs);
void rtl8139_rx_interrupt (struct eth_private *p_ETH, Int32 ioaddr);
void rtl8139_tx_interrupt (struct eth_private *p_ETH, Int32 ioaddr);
struct irqaction irq_eth4 = {eth_interrupt, NULL, 4,"eth0", NULL, NULL};                                   
struct irqaction irq_eth5 = {eth_interrupt, NULL, 5,"eth1", NULL, NULL};                                   

void eth_startup(int etherport);
void eth_desc_init(int etherport);
void eth_hw_reset(int etherport);
void eth_hw_test(int etherport);
void eth_driver_object_init(void);
void eth_polltx(int etherport);
void SetOwnByNic(Int32* header, int len, int own,int index);

void parse_rxpkt(Int32 payload_start,Int32 length);
void prepare_txpkt(int etherport,Int16 type,Int8* destaddr,Int8* data ,Int16 len); 


/*Share by tftpd, and ethernet driver*/
extern void kick_tftpd(void);

extern struct nic nic;

extern struct arptable_t  arptable_tftp[3];

/*The key here is the private driver object for each nic.*/
/*When Interrupt occurs, we will part the object with the INT to driver*/
void eth_interrupt(int irq, void *dev_id, struct pt_regs *regs)
{
 /*From dev_id, we will understand which ethernet functions.*/
 Int32 ioaddr;
 Int32 status;
 struct eth_private *p_ETH; /*this is the ethernet port object*/
 p_ETH = (struct eth_private *)dev_id;
 ioaddr = p_ETH->io_addr;
 
 status = rtl_inw(ioaddr + NIC_ISR);
 rtl_outw(ioaddr+NIC_ISR, status);   /*This is ACK the NIC INTERRUPT*/

 /*status kept here is the REGISTER*/
        	
	if (status & (RxOk |  RxDescUn | RxFIFOFULL | RxERRUNT ))/* Rx interrupt */       
		rtl8139_rx_interrupt (p_ETH, ioaddr);                                          
	if (status & (TxOk |  TxDescUn | TxErr))                                           
		rtl8139_tx_interrupt (p_ETH, ioaddr);                                          
}



void rtl8139_rx_interrupt (struct eth_private *p_ETH, Int32 ioaddr)
{
 Int32 addr,i,status,payaddr;
 Int32 rx_size;
 	
 
 for(i=0; i< NUM_DESC; i++)
 {
   /*First flush cache*/ 
   flush_cache();

   addr    = (p_ETH->rx_descaddr) + (p_ETH->cur_rx) * 16;
   payaddr = (Int32) p_ETH->rx_skbaddr[(p_ETH->cur_rx)];
                     
   status = *(volatile Int32*)(addr); 
   if (status & OWNBYNIC)
	break;/*Due to fake interrupt, perhaps already done the job*/
   if (status & (RXFAE | RXWT | RXES | RXUNT | RXCRC))
	{
	 prom_printf("rx err %X\n", status);
         SetOwnByNic((Int32*)(Virtual2NonCache(addr))
                ,BUF_SIZE
                ,OWNBYNIC
                ,p_ETH->cur_rx);	
         *(volatile Int32 *)(Virtual2NonCache(addr+BUF_OFFSET))= Virtual2Physical(payaddr);
         p_ETH->cur_rx++;
         if (p_ETH->cur_rx==p_ETH->num_desc)
             p_ETH->cur_rx=0;
         continue;
	}		
   /*From here, below is the RxOK INT case*/
   /*IF the packet size ok, we will parse the packet.*/
   rx_size = status & RXLENMASK;    

   if ((rx_size < 60) || (rx_size > 1514 + 4)) /*minimum size 60, maximum size 1518*/
        {
	 prom_printf("size err!\n");
         SetOwnByNic((Int32*)(Virtual2NonCache(addr))
                ,BUF_SIZE
                ,OWNBYNIC
                ,p_ETH->cur_rx);	
         *(volatile Int32 *)(Virtual2NonCache(addr+BUF_OFFSET))= Virtual2Physical(payaddr);
         p_ETH->cur_rx++;
         if (p_ETH->cur_rx==p_ETH->num_desc)
             p_ETH->cur_rx=0;
         continue;
	}
   //prom_printf("pkt size = %d\n",rx_size); 
   parse_rxpkt(payaddr+DATA_OFFSET,rx_size);    
    

   /*after parsing, Clean and Refill to release this descriptor*/  
   SetOwnByNic((Int32*)(Virtual2NonCache(addr))
                ,BUF_SIZE
                ,OWNBYNIC
                ,p_ETH->cur_rx);	
   *(volatile Int32 *)(Virtual2NonCache(addr+BUF_OFFSET))= Virtual2Physical(payaddr);
   
   /*Update descriptor index*/
   p_ETH->cur_rx++;
   if (p_ETH->cur_rx==p_ETH->num_desc)
   p_ETH->cur_rx=0;

 }/*For total checks*/

}

void rtl8139_tx_interrupt (struct eth_private *p_ETH, Int32 ioaddr)
{
/*Tx interrupt, check descriptor state only */	
}

void eth_driver_object_init(void)
{
/*Initialize the private driver object of each ethernet port*/
 int i;
/*----------------------------------------------------------------*/
 ETH[0].nr=0;	
 ETH[0].io_addr=ETH0_ADD;
 ETH[0].irq=ETH0_IRQ;
 ETH[0].num_desc=NUM_DESC; 
 /*First despritor address must 256byte alignment*/
 ETH[0].rx_descaddr = (((Int32)ETH0_DESC_BASE & (~255)) + 256);
 ETH[0].tx_descaddr = (((Int32)ETH0_DESC_BASE & (~255)) + 1024);
 
 //prom_printf("ETH0_tx_buf =%x\n",(Int32)ETH0_tx_buf);	 
 //prom_printf("ETH0_rx_buf =%x\n",(Int32)ETH0_rx_buf);	 
 
 ETH[0].rx_skbaddr[0]=(Int32)ETH0_rx_buf;
 ETH[0].tx_skbaddr[0]=(Int32)ETH0_tx_buf;
 
 for(i=1; i< ETH[0].num_desc; i++)
    {
     ETH[0].rx_skbaddr[i]=(ETH[0].rx_skbaddr[0] + i*1600);
     ETH[0].tx_skbaddr[i]=(ETH[0].tx_skbaddr[0] + i*1600);   
    }	

 memset(ETH0_rx_buf, 0x0, NUM_DESC*BUF_SIZE);
 memset(ETH0_tx_buf, 0x0, NUM_DESC*BUF_SIZE);
 
 ETH[0].cur_rx=0;
 ETH[0].cur_tx=0;
}

void eth_hw_reset(int etherport)
{
/*Call ethernet registers*/	
/*Different ports just with different base*/
	Int8 *mac;
	Int32 val;
	Int32 ioaddr;
	int i ;
	ioaddr = ETH[etherport].io_addr;
	mac=eth0_mac;
	memcpy(&val, mac, 4);	
	//setup NIC_ID first:
	val = (val >> 24) | (val << 24) | (((val << 8) >> 24) << 8) | (((val << 16) >> 24) << 16);
	rtl_outl(ioaddr + NIC_ID1, (val));

	memcpy(&val, mac+4, 2);	
	val = (val >> 16) << 16;
	val = (val >> 24) | (val << 24) | (((val << 8) >> 24) << 8) | (((val << 16) >> 24) << 16);
	rtl_outw(ioaddr + NIC_ID2, (val));
	 
	rtl_outb (ioaddr + NIC_CR, (rtl_inb (ioaddr + NIC_CR)) | BIT(0));
        /* Check that the chip has finished the reset. */
	for (i = 0xffff; i > 0; i--);
	 
	rtl_outl(ioaddr + NIC_MAR1, 0xffffffff);  /*MAR multicase, 8 byte*/
	rtl_outl(ioaddr + NIC_MAR2, 0xffffffff);
	rtl_outl(ioaddr + NIC_TCR, TXNORMAL );
	rtl_outl(ioaddr + NIC_RCR, RXNORMAL );
	
	//rtl_outl(ioaddr + NIC_IOCMD, CMD_CONFIG);
#if 0	
	prom_printf("Run (1)10M or (2)100M \n");
	val = WaitKey();
	val = val - '0';	
	if(val == 2) 
	rtl_outl(ioaddr + NIC_MII,SETPHY100FULL); 
	else
#endif
//	rtl_outl(ioaddr + NIC_MII,SETPHY10FULL); 
	rtl_outl(ioaddr + NIC_MII,SETPHY100FULL); 

	// set 64 descriptors
	rtl_outb(ioaddr + NIC_RXRINGNO, 2);

	// here we use low-queue only
	rtl_outl(ioaddr + NIC_TXFDPL, Virtual2Physical(ETH[etherport].tx_descaddr));

	rtl_outl(ioaddr + NIC_RXFDP, Virtual2Physical(ETH[etherport].rx_descaddr));
	/*Enable Ethernet Mask for different events.*/
	/*If one does not enable GIMR, still no interrupt happened to our CPU*/
	rtl_outw(ioaddr + NIC_IMR,WITHALLINT); 
	
	rtl_outw(ioaddr + NIC_ISR,WITHALLINT);
        
	rtl_outl(ioaddr + NIC_IOCMD, CMD_CONFIG);
}
#if 0	
void eth_hw_test(int etherport)
{
/*Call ethernet registers*/	
/*Different ports just with different base*/

	Int32 val,val_in;
	Int8* mac;
	/*here we only compare the first 4 bytes of our mac address*/
	Int32 ioaddr;

	ioaddr = ETH[etherport].io_addr;
        mac=eth0_mac;
	memcpy(&val, mac, 4);	
	val = (val >> 24) | (val << 24) | (((val << 8) >> 24) << 8) | (((val << 16) >> 24) << 16);
	val_in = rtl_inl(ioaddr + NIC_ID1);/*this is first 4 bytes.*/
	if( val_in == val )
	  {
	    memcpy(&val, mac+4, 2);	
	    val = (val >> 16) << 16;
	    val = (val >> 24) | (val << 24) | (((val << 8) >> 24) << 8) | (((val << 16) >> 24) << 16);
	    val_in= rtl_inw(ioaddr + NIC_ID2);
            if( val_in != val )
               {
                goto NICerror;
                }
          }
	else
          {
           goto NICerror;
          }
       
       if (rtl_inl(ioaddr + NIC_MAR1)!=0xffffffff)
         {	 
	   goto NICerror;
         }
       val_in= rtl_inl(ioaddr + NIC_IOCMD);
       val_in &= 0x1fffff;
       if(!( val_in == CMD_CONFIG ))
           {
            goto NICerror;
           } 
       
       val_in= rtl_inl(ioaddr + NIC_TXFDPL);
       if( val_in!= Virtual2Physical(ETH[etherport].tx_descaddr))
	  {
           goto NICerror;
	  }
       
       val_in= rtl_inl(ioaddr + NIC_RXFDP);
       if( val_in!= Virtual2Physical(ETH[etherport].rx_descaddr))
	  {
           goto NICerror;
	  }
       
       val_in= rtl_inw(ioaddr + NIC_IMR);	      	  
	if(val_in != WITHALLINT)
           {
            goto NICerror;
           }
return;
NICerror:            
  prom_printf("NIC register setting error\n");
}
#endif
void eth_desc_init(int etherport)
{
 int i;
 Int32 addr_rx;

 addr_rx=ETH[0].rx_descaddr;
  
 for(i=0; i< ETH[0].num_desc; i++)
    {
     /*First 4 bytes are despritor header   0*/	
     /*Next  4 bytes are set 0              4*/	
     /*Next  4 bytes are set buffer address 8*/	
     /*Next  4 bytes are set 0             12*/	
     *(volatile Int32 *)(Virtual2NonCache(addr_rx+8)  )=0x00000000;
     *(volatile Int32 *)(Virtual2NonCache(addr_rx+12) )=0x00000000;
     *(volatile Int32 *)(Virtual2NonCache(addr_rx+BUF_OFFSET))
     = Virtual2Physical(ETH[0].rx_skbaddr[i]);         
     SetOwnByNic((Int32*)(Virtual2NonCache(addr_rx))
                                        ,BUF_SIZE
                                        ,OWNBYNIC
                                        ,i);	
     addr_rx += 16;/*16 byte for 1 descriptor. so go next 16 bytes.*/
   
    }
}

void eth_polltx(int etherport)
{
/*This function is to kick ethernet to transmit low queue data*/
 rtl_outl( (ETH[0].io_addr+NIC_IOCMD)
           ,rtl_inl(ETH[0].io_addr + NIC_IOCMD)|TXFNL  );
}

void SetOwnByNic(Int32* header, int len, int own,int index)
{
  int tmp = (own | FIRSTSEG | LASTSEG | WCRC | len) ;
  if ( index == NUM_DESC - 1)	
      tmp |= ENDOFRING;
  *(volatile Int32 *)header = tmp;
}

void eth_startup(int etherport)
{
 Int32 val;
 eth_hw_reset(0);
// eth_hw_test(0);
 eth_desc_init(0);
 if(ETH0_IRQ==4)
 request_IRQ(ETH0_IRQ, &irq_eth4,&(ETH[0]));
#if 0
 else if (ETH0_IRQ==5)
 request_IRQ(ETH0_IRQ, &irq_eth5,&(ETH[0]));
#endif
 
}


/*Just a start address, and the data length*/
void prepare_txpkt(int etherport,Int16 type,Int8* destaddr,Int8* data ,Int16 len) 
{
 Int32 addr,current_tx;
 Int8* tx_buffer;
 Int16 nstype;
 
 current_tx= ETH[0].cur_tx;
 
 addr = ETH[0].tx_descaddr + 16*current_tx; /*Fill descriptor*/
 
 
 /*Fill Payload*/
 tx_buffer = (Int8*)ETH[0].tx_skbaddr[current_tx];

 *(volatile Int32 *)(addr + BUF_OFFSET) =  Virtual2Physical(tx_buffer);
 *(volatile Int32 *)(addr + 8) =  0;
 *(volatile Int32 *)(addr + 12)=  0;
 
 /*Destination Address*/
 memcpy(tx_buffer,destaddr,6);
 /*Source Address*/
 memcpy(tx_buffer+6,eth0_mac,6);
 /*Payload type*/
 nstype = htons(type);
 memcpy(tx_buffer + 12,(Int8*)&nstype,2);
 /*Payload */
 memcpy(tx_buffer + 14,(Int8*)data,len);
 len += 14;
 /*Padding */
 while (len < 60) /*minimum packet length*/
       {
        tx_buffer[len++] = '\0';
        }
 SetOwnByNic((Int32*)(Virtual2NonCache(addr))
             ,len
             ,OWNBYNIC
             ,current_tx);
  /*kick the ethernet to tx*/
  eth_polltx(0);
 /*Update descriptor index*/
  ETH[0].cur_tx++;
  if (ETH[0].cur_tx==ETH[0].num_desc)
  ETH[0].cur_tx=0;
}
extern void flush_cache();
void parse_rxpkt(Int32 payload_start,Int32 length)
{  
 int i;
 memcpy(nic.packet,(payload_start),length);
 nic.packetlen=length;
 kick_tftpd();
}

