/*
 *  linux/init/main.c
 *
 *  Copyright (C) 1991, 1992  Linus Torvalds
 *
 *  GK 2/5/95  -  Changed to support mounting root fs via NFS
 *  Added initrd & change_root: Werner Almesberger & Hans Lermen, Feb '96
 *  Moan early if gcc is old, avoiding bogus kernels - Paul Gortmaker, May '96
 *  Simplified starting of init:  Michael A. Griffith <grif@acm.org>
 */

#include <linux/errno.h>
#include <linux/init.h>
#include <linux/kernel_stat.h>
#include <linux/types.h>
#include <linux/interrupt.h>
#include <linux/random.h>
#include <linux/string.h>

#include <asm/bitops.h>
#include <asm/bootinfo.h>
#include <asm/irq.h>
#include <asm/mipsregs.h>
#include <asm/system.h>
#include <linux/circ_buf.h>
#include <asm/rtl8181.h>
#include <asm/io.h>

#include "etherboot.h"
#include "./banner/mk_time"
#include "./rtk.h"

#define __KERNEL_SYSCALLS__

#define SYS_STACK_SIZE		(4096 * 2)
#define SERIAL_XMIT_SIZE	4096

#define VERSION				"1.4a"

#define HS_IMAGE_OFFSET		(24*1024)	//0x6000
#define DS_IMAGE_OFFSET		(25*1024)	//0x6400
#define CS_IMAGE_OFFSET		(32*1024)	//0x8000

#define CODE_IMAGE_OFFSET	(64*1024)	//0x10000
#define CODE_IMAGE_OFFSET2	(128*1024)	//0x20000
#define CODE_IMAGE_OFFSET3	(192*1024)	//0x30000
#define CODE_IMAGE_OFFSET4	(0x8000)

#define IS_32BIT			(rtl_inl(0x1000)&0x100000)

/*Cyrus Tsai*/
Int16  DSversion;
Int16  CSversion;
/*Cyrus Tsai*/

#define FLASH_BASE	 		0x2bf0000
/*Cyrus Tsai*/
/*mips_io_port_base + FLASH_BASE =0xbfc0 0000   */
/*mips_io_port_base = 0xbd01 0000               */
/*Replace the 0xbfc0 0000 with 0xbe00 0000      */
/*so FLASH_BASE should be changed to 0x00ff 0000*/
/*if support large size FLASH                   */
/*Cyrus Tsai*/

#define CPU_CLOCK			(22*1000*1000)
#define WAIT_TIME_USER_INTERRUPT	(3*CPU_CLOCK)


/* Setting image header */
typedef struct _setting_header_ {
	Int8  Tag[2];
	Int8  Version[2];
	Int16 len;
} SETTING_HEADER_T, *SETTING_HEADER_Tp;


/* Timer macro */
#define SET_TIMER(time) { 	\
	rtl_outl(TCCNR, 0x10);	\
	rtl_outl(TCIR, 0);	\
	rtl_outl(TC2DATA, time);\
}

#define RTL_TIMEOUT() (!rtl_inl(TC2CNT))

static int check_system_image(unsigned long addr, IMG_HEADER_Tp pHeader,SETTING_HEADER_Tp sHeader);
int user_interrupt(unsigned long time);

/*in flash.c*/
extern int flashread (unsigned long dst, unsigned int src, unsigned long length);
extern int flashinit();


unsigned char init_task_union[SYS_STACK_SIZE];

/*Cyrus Tsai*/
unsigned long kernelsp;
extern void __init exception_init(void);
/*in trap.c*/
extern void flush_cache(void);
extern void flush_icache();	//david
extern void flush_dcache();	//david

/*in irq.c*/
extern void init_IRQ(void);
extern void eth_startup(int etherport);
extern void eth_driver_object_init(void);
/*in eth_tftpd.c*/
extern void tftpd_entry(void);
unsigned long self_test(void);

/*in flash.c*/
extern void check_eth_setting();

/*in monitor.c*/
extern int check_cpu_speed(void);

void set_bridge_clock(int bus_clk)
{
	int reg_value = 0;
	unsigned int version = 0;

	version = *(volatile unsigned int *)(0xbd01010c);
	version &= 0xf0000000;

	if(bus_clk >= 100) {
		if(!version || (version == 0x80000000))
			reg_value = 0x9D;	// Bridge1 clock/4 for 'B' or 'C'
		else
			reg_value = 0x99;     // Bridge0,1 clock/2 for other

		if(bus_clk >= 120)
			reg_value |= 0x800 | 0x500; // PCI, divided by 6
		else
			reg_value |= 0x800 | 0x300; // PCI, divided by 4
	}
	else
		reg_value = 0x88 | 0x800 | 0x300;   // not divided
	*(volatile unsigned int *)(0xbd010100) = reg_value;
}

void uart1_init(int cpu_clock)
{
	int i;
	rtl_outb( UART_LCR,0x83);
#ifndef RTL8186
	rtl_outb( UART_DLL, 0x22);	//38400  IC
#else
	/*
	   default baud rate = 38400 bps
	 */
	rtl_outb(UART_DLM, ((cpu_clock >> 4)*10000/384) >> 8);
	rtl_outb(UART_DLL, ((cpu_clock >> 4)*10000/384) & 0xff);
#endif
	rtl_outb( UART_LCR,0x03);
	rtl_outb( UART_FCR,0x06);

	for(i=0; i<=0x1000; i++);

	rtl_outb(UART_FCR,0x0);
	//disable flow control
	rtl_outb(UART_MCR,0x00);
	prom_printf("\nUART1 output test ok\n");
	prom_printf("Uart init\n");
}

void start_kernel(void)
{
	int i;
	unsigned long flags;
	unsigned char* str[80];
	char* ptr;
	unsigned long start_addr;
	void	(*jump)(void);
	unsigned long error_code;
	unsigned long return_addr;
	unsigned short *word_ptr;
	volatile int cpu_speed = 0;

	/*Cyrus Tsai*/
	IMG_HEADER_T header;
	SETTING_HEADER_T setting_header;
	/*Cyrus Tsai*/

	flush_icache(); // david
	flush_dcache(); // david

	setup_arch();    /*setup the BEV0,and IRQ */
	exception_init();/*Copy handler to 0x80000080*/
	init_IRQ();      /*Allocate IRQfinder to Exception 0*/
	sti();
	rtl_outl(0x140,0); /* set GPIO F0=0 */
	cpu_speed = check_cpu_speed();
	set_bridge_clock(cpu_speed);
	rtl_outl(0x140,1); /* set GPIO F0=1, ~ 228ms */
	cli();
	uart1_init(cpu_speed);
	flashinit();
	check_eth_setting();

#ifndef RTL8186
	prom_printf("\n---RealTek(RTL8181)at %s version %s [%s]\n",BOOT_CODE_TIME,
		VERSION, (IS_32BIT ? "32bit" : "16bit") );
#else
	return_addr=*(volatile unsigned int *)0xbd011000;
	prom_printf("\n---RealTek(RTL8186)at %s version %s [%s](%dMHz)\n",
		BOOT_CODE_TIME,VERSION, (IS_32BIT ? "32bit" : "16bit"),
		cpu_speed);
#endif

	return_addr=check_system_image((unsigned long)FLASH_BASE+CODE_IMAGE_OFFSET,&header, &setting_header);
	if(return_addr==0)
		return_addr=check_system_image((unsigned long)FLASH_BASE+CODE_IMAGE_OFFSET2,  &header, &setting_header);
	if(return_addr==0)
		return_addr=check_system_image((unsigned long)FLASH_BASE+CODE_IMAGE_OFFSET3,  &header, &setting_header);
	//if(return_addr==0)
	//	return_addr=check_system_image((unsigned long)FLASH_BASE+CODE_IMAGE_OFFSET4,  &header, &setting_header);

	if(return_addr)
	{
		switch(user_interrupt(WAIT_TIME_USER_INTERRUPT))
		{
		default:
			//prom_printf("\n---%X\n",return_addr);
			word_ptr = (unsigned short *)&header;
			for (i=0; i<sizeof(IMG_HEADER_T); i+=2, word_ptr++)
				*word_ptr = rtl_inw(return_addr + i);
			// move image to SDRAM
			flashread( header.startAddr,
				(unsigned int)(return_addr-FLASH_BASE+sizeof(header)),
				header.len-2);
			if ( !user_interrupt(0) )  // See if user escape during copy image
			{
				outl(0,GIMR0); // mask all interrupt
				//set LED0 off
				rtl_outl(0x124, (1<<2)); //pin2 as ouput
				rtl_outl(0x120, (rtl_inl(0x120)|(1<<2)));
				prom_printf("Jump to image start=0x%x...\n", header.startAddr);
				jump = (void *)(header.startAddr);
				
				cli();
				flush_icache(); // david
				flush_dcache(); // david
				jump();				 // jump to start
			}
			/*i think i can comment this break*/
			/*if user_interrupt, then go to case 1 is ok too*/
			/*if user_not interrupt, then jump() to start linux image.*/
			//break;
		case 1:
			prom_printf("\n---Escape booting by user\n");
			//set LED0 On
			rtl_outl(0x124, (1<<2)); // pin2 as ouput
			rtl_outl(0x120, (rtl_inl(0x120)&(~(1<<2))));
			eth_driver_object_init();
			eth_startup(0);
			sti();
			tftpd_entry();
			monitor();
			break;
		}/*switch case */
	}/*if image correct*/
	else
	{
		eth_driver_object_init();
		eth_startup(0);
		sti();
		tftpd_entry();
		//prom_printf("\n---TFTP Server Running\n");
		monitor();
	}
}

unsigned char tempBuffer[8*1024];

// david --------------------------------------------------------------------
// Cyrus Tsai merge into one function----------------------------------------
static int check_system_image(unsigned long addr,IMG_HEADER_Tp pHeader,SETTING_HEADER_Tp setting_header)
{
	// Read header, heck signature and checksum
	int i;
	unsigned short sum=0, *word_ptr;
	unsigned short length=0;
	unsigned short temp16=0;
/*******************************************************************************/
        // check the setting image, hardware setting,default setting.
#if 0
        if(check_setting_image((unsigned long)FLASH_BASE+HS_IMAGE_OFFSET,&setting_header,HW_SIGNATURE)
            &&
            check_setting_image((unsigned long)FLASH_BASE+DS_IMAGE_OFFSET,&setting_header,SW_SIGNATURE_D)
            )
           {
            DSversion=rtl_inw((unsigned long)FLASH_BASE+DS_IMAGE_OFFSET+2);
           }
         else
           {
            prom_printf("critical error, hw/default setting \n");
            return 0;
            }
        // check the setting image, current setting.

        if(!check_setting_image((unsigned long)FLASH_BASE+CS_IMAGE_OFFSET,&setting_header,SW_SIGNATURE_C))
           //prom_printf("current software setting ok\n");
        //else
          {
       	   prom_printf("\n error! restore default setting\n");
       	   //prom_printf("copy backup from default\n");
           /*remember we have SETTING_HEADER_t setting_header, so we can have length.*/
           /*remember we have come here, so default setting is correct-format*/
           /*Get the Header back from FLASH, and we have to use 16-bit access*/
	   length = rtl_inw((unsigned long)FLASH_BASE+DS_IMAGE_OFFSET + 4);
           /*now setting_header is the default sw setting value.*/
           flashread(tempBuffer,DS_IMAGE_OFFSET+2,length+2+2);
  	   flashwrite(CS_IMAGE_OFFSET+2,tempBuffer,length+2+2);
           flashwrite(CS_IMAGE_OFFSET,"CS",2);
          }
#endif
/*******************************************************************************/

        /*check firmware image.*/
	word_ptr = (unsigned short *)pHeader;
	for (i=0; i<sizeof(IMG_HEADER_T); i+=2, word_ptr++)
		*word_ptr = rtl_inw(addr + i);

	if ( memcmp(pHeader->signature, FW_SIGNATURE, SIG_LEN)) {
		prom_printf("no sys signature at %X!\n",addr-FLASH_BASE);
		return 0;
	}

	for (i=0; i<pHeader->len; i+=2) {
		sum += rtl_inw(addr + sizeof(IMG_HEADER_T) + i);

	}
	if ( sum ) {
		prom_printf("sys checksum error at %X!\n",addr-FLASH_BASE);
		return 0;
	}
	return ((unsigned long)(addr));
}

int user_interrupt(unsigned long time)
{
	int i;
#ifdef RTL8186
	int button_press_detected=-1;
	rtl_outl(0x124, rtl_inl(0x124) & ~(1<<0)); // set GPIOA-0 as input
#endif
	SET_TIMER(time);

	do {
		if  (rtl_inb(UART_LSR) & 0x1) {
	   		i=rtl_inb(UART_RBR) & 0xff;
			rtl_inb(UART_RBR);
            		if( i == ESC )
		        	return 1;
		}
#ifdef RTL8186
		// polling if button is pressed --------------------------------------
                if (button_press_detected == -1 ||
                                button_press_detected == 1) {
                                if ((rtl_inl(0x120) & (1<<0)) == 0) {// button pressed
                                        if (button_press_detected == -1) {
                                                SET_TIMER(1*CPU_CLOCK); // wait 1 sec
                                        }
                                        button_press_detected = 1;
                                }
                                else
                                        button_press_detected = 0;
                }
                //---------------------------------------------------
#endif
	} while ( !RTL_TIMEOUT());
#ifdef RTL8186
        if (button_press_detected>0)
                return 1;
#endif
	return 0;
}

 /*Boot Code*/
 /******region 0x0000******/
 /**********************/
 /*16k                 */
 /*            0x4000  */
 /**********************/
 /* 8k                 */
 /*            0x6000  */
 /**********************/
 /******region 0x6000******/

 /**********************/
 /* 8k                 */
 /*            0x8000  */
 /**********************/


 /*            from   0x6000*/
 /*First 1K      to   0x6400*/
 /***************************/
 /*            from   0x6400*/
 /*Next  7K      to   0x8000*/
 /***************************/


 /***************************/
 /* 32k        from   0x8000*/
 /*              to   0x10000*/
 /****************************/

// Cyrus: now check system image will become 3 steps...
// Cyrus: first: first sector, second second sector.
// Cyrus --------------------------------------------------------------------
/*this 8K sector will be Hardware and Default Software setting*/
int check_setting_image(unsigned long addr, SETTING_HEADER_Tp pHeader,char * type)
{
	int i;
	unsigned short *word_ptr;

	unsigned char TARGET;
	unsigned char sum=0;
	word_ptr = (unsigned short *)pHeader;
        /*Get the Header back from FLASH, and we have to use 16-bit access*/
	for (i=0; i<sizeof(SETTING_HEADER_T); i+=2, word_ptr++)
		{
		 *word_ptr = rtl_inw(addr + i);
		 //prom_printf("Read %X\n",*word_ptr);
                 }

	/*Check the Header signature */
	if (memcmp(pHeader->Tag, type,2)) {
		prom_printf("no tag! type %X,%X\n",*type,*(type+1));
		return 0;
	}

	/*Check the setting checksum*/
	for(i=0;i<pHeader->len;i++)/*plus the last byte checksum*/
	   {
	    if ( flashread((unsigned long)&TARGET,addr-(unsigned long)FLASH_BASE+sizeof(SETTING_HEADER_T)+i,1) )
	        {
	         sum=sum+TARGET;
	        //prom_printf("%X,%X,%X\n",TARGET,i,sum);
	        }

	    else
	        return 0;
	   }

            //prom_printf("%X\n",sum);

	if (sum) {
		prom_printf("data checksum error! type %X,%X\n",*type,*(type+1));
		return 0;
	}
        //prom_printf("OK\n");
        if( type == SW_SIGNATURE_C)
          {
           /*Go get the version number.*/
           CSversion=rtl_inw((unsigned long)FLASH_BASE+CS_IMAGE_OFFSET+2);
           //prom_printf("additional check for CSversion %X!\n",CSversion);
           if(DSversion!=CSversion)
              {
               prom_printf("current version error, restore default setting\n");
               return 0;
              }
          }
	return 1;
}
