#include <asm/rtl8181.h>
#include <linux/interrupt.h>
#include <asm/system.h>
#include "monitor.h"
#include "etherboot.h"
#include "nic.h"
#ifdef RTL8186
//#define SUPPORT_NAND 1 
#endif

extern unsigned int	_end;

extern unsigned char 	ethfile[20];
extern struct arptable_t	arptable[MAX_ARP];
#define MAIN_PROMPT						"<RealTek>"
#define printf	prom_printf
#define putchar(x)	serial_outc(x)
#define IPTOUL(a,b,c,d)	((a << 24)| (b << 16) | (c << 8) | d )

int YesOrNo(void);
int CmdHelp( int argc, char* argv[] );
int CmdDumpWord( int argc, char* argv[] );
int CmdWriteWord( int argc, char* argv[] );
int CmdWriteByte( int argc, char* argv[] );
int CmdWriteHword( int argc, char* argv[] );
int CmdWriteAll( int argc, char* argv[] );
int CmdCmp(int argc, char* argv[]);
//int CmdEDl(int argc, char* argv[]);
//int CmdEUl(int argc, char* argv[]);
int CmdCfn(int argc, char* argv[]);

int CmdIp(int argc, char* argv[]);
//int CmdFle(int argc, char* argv[]);
int CmdFlw(int argc, char* argv[]);
int CmdFlr(int argc, char* argv[]);
int CmdLoad(int argc, char* argv[]);
int CmdAuto(int argc, char* argv[]);

int CmdNFlr(int argc, char* argv[]);
int CmdNFlw(int argc, char* argv[]);

//Ziv
#ifdef WRAPPER
//write bootcode to flash from my content
int CmdWB(int argc, char* argv[]);
extern char _bootimg_start, _bootimg_end;
#endif

/*Cyrus Tsai*/
#define TFTP_SERVER 0
#define TFTP_CLIENT 1
extern struct arptable_t  arptable_tftp[3];
/*Cyrus Tsai*/

extern int flasherase(unsigned long src, unsigned int length);
extern int flashwrite(unsigned long dst, unsigned long src, unsigned long length);
extern int flashread (unsigned long dst, unsigned long src, unsigned long length);

extern int write_data(unsigned long dst, unsigned long length, unsigned char *target);
extern int read_data (unsigned long src, unsigned long length, unsigned char *target);

/*Cyrus Tsai*/
extern unsigned long file_length_to_server;
extern unsigned long file_length_to_client;
extern unsigned long image_address; 
/*this is the file length, should extern to flash driver*/
/*Cyrus Tsai*/

 
COMMAND_TABLE	MainCmdTable[] =
{
	{ "?"	  ,0, CmdHelp			, "HELP (?)				    : Print this help message"					},
	{ "HELP"  ,0, CmdHelp			, NULL																	},
	{ "D"	  ,2, CmdDumpWord		, "D <Address> <Len>"},
	{ "EW",2, CmdWriteWord, "EW <Address> <Value1> <Value2>..."},
	{ "EH",2, CmdWriteHword, "EH <Address> <Value1> <Value2>..."},
	{ "EB",2, CmdWriteByte, "EB <Address> <Value1> <Value2>..."},
	{ "EC",2, CmdWriteAll, "EC <Address> <Value1> <Length>..."},
	{ "CMP",3, CmdCmp, "CMP: CMP <dst><src><length>"},
	{ "IPCONFIG",2, CmdIp, "IPCONFIG:<TargetAddress>"},

	{ "J"  ,1, CmdCfn			, "J: Jump to <TargetAddress>"											},
	{ "FLW"   ,3, CmdFlw			, "FLW: FLW <dst><src><length>"					},
	{ "FLR"   ,3, CmdFlr			, "FLR: FLR <dst><src><length>"					},
	{ "LOADADDR"   ,1, CmdLoad			, "LOADADDR: <Load Address>"					},
	{ "AUTOBURN"   ,1, CmdAuto			, "AUTOBURN: 0/1"					},
#ifdef SUPPORT_NAND
	{ "NFLR",3, CmdNFlr, "NFLR: NFLR <dst><src><length>"},
	{ "NFLW",3, CmdNFlw, "NFLW: NFLW <dst><src><length>"},
#endif

#ifdef WRAPPER
	{ "WB", 0, CmdWB, "WB: WB"},
#endif
};

static unsigned long	CurrentDumpAddress;
static unsigned long   sys_ipaddress;

/********   caculate CPU clock   ************/
static void timer_interrupt(void);
int check_cpu_speed(void);
void timer_init(void);
struct irqaction irq_timer = {timer_interrupt, NULL, 0,"timer", NULL, NULL};                                   
static volatile unsigned int jiffies=0;
static void timer_interrupt(void)
{
	rtl_outl(TCIR,rtl_inl(TCIR));
	jiffies ++;
}

__inline__ void
__delay(unsigned long loops)
{
	__asm__ __volatile__ (
		".set\tnoreorder\n"
		"1:\tbnez\t%0,1b\n\t"
		"subu\t%0,1\n\t"
		".set\treorder"
		:"=r" (loops)
		:"0" (loops));
}


static unsigned long loops_per_jiffy = (1<<12);
#define LPS_PREC 8
#define HZ 100
int check_cpu_speed(void)
{
	unsigned long ticks, loopbit;
	int lps_precision = LPS_PREC;

	request_IRQ(0, &irq_timer, NULL);
	timer_init();

	loops_per_jiffy = (1<<12);
	while (loops_per_jiffy <<= 1) {
		/* wait for "start of" clock tick */
		ticks = jiffies;
		while (ticks == jiffies)
			/* nothing */;
		/* Go .. */
		ticks = jiffies;
		__delay(loops_per_jiffy);
		ticks = jiffies - ticks;
		if (ticks)
			break;
	}
/* Do a binary approximation to get loops_per_jiffy set to equal one clock
   (up to lps_precision bits) */
	loops_per_jiffy >>= 1;
	loopbit = loops_per_jiffy;
	while ( lps_precision-- && (loopbit >>= 1) ) {
		loops_per_jiffy |= loopbit;
		ticks = jiffies;
		while (ticks == jiffies);
		ticks = jiffies;
		__delay(loops_per_jiffy);
		if (jiffies != ticks)	/* longer than 1 tick */
			loops_per_jiffy &= ~loopbit;
	}
	// disable timer interrupt
	rtl_outl(TCCNR,0);
	rtl_outl(TCIR,0);
	free_IRQ(0);
/* Round the value and print it */	
	//prom_printf("cpu run %d.%d MIPS\n", loops_per_jiffy/(500000/HZ),
	//				      (loops_per_jiffy/(5000/HZ)) % 100);
	return ((loops_per_jiffy/(500000/HZ))+1);
	
}
void timer_init(void)
{

    rtl_outl(TCCNR,0x03);
    rtl_outl(TC0DATA,0x35B60); // timer clock is fixed 22MHz, int per 10ms 
    rtl_outl(TCIR,0x01);

}
/*
---------------------------------------------------------------------------
;				Monitor
---------------------------------------------------------------------------
*/
void monitor(void)
{
	char		buffer[ MAX_MONITOR_BUFFER +1 ];
	int		argc ;
	char**		argv ;
	int		i, retval ;
	i = &_end;
	i = (i & (~4095)) + 4096;
	//printf("Free Mem Start=%X\n", i);
	while(1)
	{
		printf( "%s", MAIN_PROMPT );
		memset( buffer, 0, MAX_MONITOR_BUFFER );
		GetLine( buffer, MAX_MONITOR_BUFFER,1);
		printf( "\n" );
		argc = GetArgc( (const char *)buffer );
		argv = GetArgv( (const char *)buffer );
		if( argc < 1 ) continue ;
		StrUpr( argv[0] );
		for( i=0 ; i < (sizeof(MainCmdTable) / sizeof(COMMAND_TABLE)) ; i++ )
		{
			if( ! strcmp( argv[0], MainCmdTable[i].cmd ) )
			{
#if 0
				if (MainCmdTable[i].n_arg != (argc - 1))
					printf("%s\n", MainCmdTable[i].msg);
				else
					retval = MainCmdTable[i].func( argc - 1 , argv+1 );
#endif
				retval = MainCmdTable[i].func( argc - 1 , argv+1 );
				memset(argv[0],0,sizeof(argv[0]));
				break;
			}
		}
		if(i==sizeof(MainCmdTable) / sizeof(COMMAND_TABLE)) printf("Unknown command !\r\n");
	}
}


#ifdef WRAPPER
int CmdWB(int argc, char* argv[])
{
        char* start = &_bootimg_start;
	char* end  = &_bootimg_end;
	unsigned int length = end - start;
	
	printf("Flash wille write %X length of embedded boot code at %X to %X\n", length, start, end);
	printf("(Y)es, (N)o->");
	if (YesOrNo())
		if (flashwrite(0, (unsigned long)start, length))
			printf("Flash Write Successed!\n");
		else
			printf("Flash Write Failed!\n");
	else
		printf("Abort!\n");

}
#endif


/*/
---------------------------------------------------------------------------
; Ethernet Download
---------------------------------------------------------------------------
*/




extern unsigned long ETH0_ADD;
int CmdCfn(int argc, char* argv[])
{
	unsigned long		Address;
	void	(*jump)(void);
	if( argc > 0 )
	{
		if(!Hex2Val( argv[0], &Address ))
		{
			printf(" Invalid Address(HEX) value.\n");
			return FALSE ;
		}
	}

	printf("Jump to address=%X\n",Address);
	jump = (void *)(Address);
	outl(0,GIMR0); // mask all interrupt
	cli(); 
#ifndef RTL8186				  
	rtl_outl(ETH0_ADD+ NIC_CNR1, 0 ); //sc_yang
#else
// add by arthur
// prevent from ethernet disturb Linux kernel booting
	{
		//printf("Disable eth0 before rebooting.....\n");
		unsigned int value;
		value = *(volatile unsigned int *)(0xbd201434);
		value = value & 0xffffff00;
		*(volatile unsigned int *)(0xbd201434) = value;
	}
#endif
       flush_icache(); // david
	flush_dcache(); // david 	
	jump();	
	
}
/* This command can be used to configure host ip and target ip	*/
extern char eth0_mac[6];
int CmdIp(int argc, char* argv[])
{
	unsigned char  *ptr;
	unsigned int i;
	int  ip[4];
	
	if (argc==0)
	{	
		printf(" Target Address=%d.%d.%d.%d\n",
		arptable_tftp[TFTP_SERVER].ipaddr.ip[0], arptable_tftp[TFTP_SERVER].ipaddr.ip[1], 
		arptable_tftp[TFTP_SERVER].ipaddr.ip[2], arptable_tftp[TFTP_SERVER].ipaddr.ip[3]);
		return;	 
	}			
	
	ptr = argv[0];

	for(i=0; i< 4; i++)
	{
		ip[i]=strtol((const char *)ptr,(char **)NULL, 10);		
		ptr = strchr(ptr, '.');
		ptr++;
	}
	arptable_tftp[TFTP_SERVER].ipaddr.ip[0]=ip[0];
	arptable_tftp[TFTP_SERVER].ipaddr.ip[1]=ip[1];
	arptable_tftp[TFTP_SERVER].ipaddr.ip[2]=ip[2];
	arptable_tftp[TFTP_SERVER].ipaddr.ip[3]=ip[3];
/*replace the MAC address middle 4 bytes.*/
	eth0_mac[1]=ip[0];
	eth0_mac[2]=ip[1];
	eth0_mac[3]=ip[2];
	eth0_mac[4]=ip[3];

	prom_printf("Now your Target IP is %d.%d.%d.%d\n", ip[0],ip[1],ip[2],ip[3]);
#if 0	
	ptr = argv[1];
	//prom_printf("You want to setup Host new ip as %s \n", ptr);	
	
	for(i=0; i< 4; i++)
	{
		ip[i]=strtol((const char *)ptr,(char **)NULL, 10);		
		ptr = strchr(ptr, '.');
		ptr++;
	}
	arptable[ARP_SERVER].ipaddr.ip[0]=ip[0];
	arptable[ARP_SERVER].ipaddr.ip[1]=ip[1];
	arptable[ARP_SERVER].ipaddr.ip[2]=ip[2];
	arptable[ARP_SERVER].ipaddr.ip[3]=ip[3];
	prom_printf("Now your Host IP is %d.%d.%d.%d\n", ip[0],ip[1],ip[2],ip[3]);
#endif	
		
}
/*int CmdEDl( int argc, char* argv[] )
{

	int			address;
	unsigned char 		iChar[2];
	int 	bytecount=0;
	
//	address = strtoul((const char*)(argv[1]), (char **)NULL, 16);	
//	prom_printf("Ethernet download %s to addr=%X\n? (Y/y/N/n)", argv[0], address);
	
		
//	GetLine( iChar, 2,1); 
//	if ((iChar[0] == 'Y') || (iChar[0] == 'y'))
//		printf("download! \n");
//	else
		printf("abort! \n");
	return TRUE;

}*/

/*int CmdEUl(int argc, char* argv[])
{

//	unsigned long		address;
//	unsigned long		bytecount;

//	unsigned char 		iChar[2];





//	address = strtoul((const char*)(argv[1]), (char **)NULL, 16);		
//	bytecount= strtoul((const char*)(argv[2]), (char **)NULL, 16);		

	
//	prom_printf("Ethernet upload %s from addr=%X with bytecount:%X\n? (Y/y/N/n)", 
//	argv[0], address,bytecount);	
	
//	GetLine( iChar, 2,1); 
//	if ((iChar[0] == 'Y') || (iChar[0] == 'y'))
//	        printf("\nUpload !\n");
//	else
	printf("abort! \n");
	
	
	return TRUE;
	
	
}*/


int CmdDumpWord( int argc, char* argv[] )
{
	
	unsigned long src;
	unsigned int len,i;
	
	src = strtoul((const char*)(argv[0]), (char **)NULL, 16);		
	if(!argv[1])
		len = 1;
	else
	len= strtoul((const char*)(argv[1]), (char **)NULL, 10);			
	while ( (src) & 0x03)
		src++;

	for(i=0; i< len ; i+=4,src+=16)
	{	
		printf("%X:	%X	%X	%X	%X\n",
		src, *(unsigned long *)(src), *(unsigned long *)(src+4), 
		*(unsigned long *)(src+8), *(unsigned long *)(src+12));
	}

}

int CmdWriteWord( int argc, char* argv[] )
{
	
	unsigned long src;
	unsigned int value,i;
	
	src = strtoul((const char*)(argv[0]), (char **)NULL, 16);		
	while ( (src) & 0x03)
		src++;

	for(i=0;i<argc-1;i++,src+=4)
	{
		value= strtoul((const char*)(argv[i+1]), (char **)NULL, 16);	
		*(volatile unsigned int *)(src) = value;
	}
	
}


int CmdWriteAll( int argc, char* argv[] )
{
	
	unsigned long src;
	unsigned int value,i;
	unsigned int length;
	
	src = strtoul((const char*)(argv[0]), (char **)NULL, 16);		
	while ( (src) & 0x03)
		src++;

	i = 0;
	value = strtoul((const char*)(argv[1]), (char **)NULL, 16);	
	length = strtoul((const char*)(argv[2]), (char **)NULL, 16);	
	printf("Write %x to %x for length %d\n",value,src,length);
	for(i=0;i<length;i+=4,src+=4)
	{
		*(volatile unsigned int *)(src) = value;
	}
	
}

int CmdWriteHword( int argc, char* argv[] )
{
	
	unsigned long src;
	unsigned short value,i;
	
	src = strtoul((const char*)(argv[0]), (char **)NULL, 16);		
	
	src &= 0xfffffffe;	

	for(i=0;i<argc-1;i++,src+=2)
	{
		value= strtoul((const char*)(argv[i+1]), (char **)NULL, 16);	
		*(volatile unsigned short *)(src) = value;
	}
	
}


int CmdWriteByte( int argc, char* argv[] )
{
	
	unsigned long src;
	unsigned char value,i;
	
	src = strtoul((const char*)(argv[0]), (char **)NULL, 16);		


	for(i=0;i<argc-1;i++,src++)
	{
		value= strtoul((const char*)(argv[i+1]), (char **)NULL, 16);	
		*(volatile unsigned char *)(src) = value;
	}
	
}
/*
--------------------------------------------------------------------------
Flash Utility
--------------------------------------------------------------------------
*/


int CmdFlw(int argc, char* argv[])
{
	unsigned long dst,src;
	unsigned long length;

#define FLASH_WRITE_BYTE 4096

	dst = strtoul((const char*)(argv[0]), (char **)NULL, 16);		
	src = strtoul((const char*)(argv[1]), (char **)NULL, 16);		
	length= strtoul((const char*)(argv[2]), (char **)NULL, 16);		
//	length= (length + (FLASH_WRITE_BYTE - 1)) & FLASH_WRITE_BYTE;

/*Cyrus Tsai*/
/*file_length_to_server;*/
//length=file_length_to_server;
//length=length & (~0xffff)+0x10000;
/*Cyrus Tsai*/

	
	printf("Flash Program from %X to %X with %X bytes	?\n",src,dst,length);
	printf("(Y)es, (N)o->");
	if (YesOrNo())
		if (flashwrite(dst, src, length))
			printf("Flash Write Successed!\n");
		else
			printf("Flash Write Failed!\n");
	else
		printf("Abort!\n");
#undef FLASH_WRITE_BYTE //4096
				
}


int CmdFlr(int argc, char* argv[])
{
	int i;
	unsigned long dst,src;
	unsigned int length;
	//unsigned char TARGET;
//#define  FLASH_READ_BYTE	4096

	dst = strtoul((const char*)(argv[0]), (char **)NULL, 16);
	src = strtoul((const char*)(argv[1]), (char **)NULL, 16);
	length= strtoul((const char*)(argv[2]), (char **)NULL, 16);		
	//length= (length + (FLASH_READ_BYTE - 1)) & FLASH_READ_BYTE;

/*Cyrus Tsai*/
/*file_length_to_server;*/
//length=file_length_to_client;
//length=length & (~0xffff)+0x10000;
//dst=image_address;
file_length_to_client=length;
/*Cyrus Tsai*/

	printf("Flash read from %X to %X with %X bytes	?\n",src,dst,length);
	printf("(Y)es , (N)o ? --> ");

	if (YesOrNo())
	        //for(i=0;i<length;i++)
	        //   {
		//    if ( flashread(&TARGET, src+i,1) )
		//	printf("Flash Read Successed!, target %X\n",TARGET);
		//    else
		//	printf("Flash Read Failed!\n");
		//  }	
		    if (flashread(dst, src, length))
			printf("Flash Read Successed!\n");
		    else
			printf("Flash Read Failed!\n");
	else
		printf("Abort!\n");
//#undef	FLASH_READ_BYTE		4096

}
int CmdLoad(int argc, char* argv[])
{
	unsigned long addr;


	image_address= strtoul((const char*)(argv[0]), (char **)NULL, 16);		
	printf("Set TFTP Load Addr 0x%x\n",image_address);
}
extern int autoBurn;
int CmdAuto(int argc, char* argv[])
{
	unsigned long addr;


	if(argv[0][0] == '0')
		autoBurn = 0 ;
	else
		autoBurn = 1 ;
	printf("AutoBurning=%d\n",autoBurn);
}


/*
------------------------------------------  ---------------------------------
; Command Help
---------------------------------------------------------------------------
*/
  

#if 0
extern int flash_test(void);
#endif

int CmdHelp( int argc, char* argv[] )
{
	int	i, LineCount ;

    printf("----------------- COMMAND MODE HELP ------------------\n");
	for( i=0, LineCount = 0 ; i < (sizeof(MainCmdTable) / sizeof(COMMAND_TABLE)) ; i++ )
	{
		if( MainCmdTable[i].msg )
		{
			LineCount++ ;
			printf( "%s\n", MainCmdTable[i].msg );
			if( LineCount == PAGE_ECHO_HEIGHT )
			{
				printf("[Hit any key]\r");
				WaitKey();
				printf("	     \r");
				LineCount = 0 ;
			}
		}
	}
	/*Cyrus Tsai*/
#if 0
 	/*Cyrus Tsai*/
    flash_test();   
#endif    
    
	return TRUE ;
}






int YesOrNo(void)
{
	unsigned char iChar[2];

	GetLine( iChar, 2,1);
	printf("\n");//vicadd
	if ((iChar[0] == 'Y') || (iChar[0] == 'y'))
		return 1;
	else
		return 0;
}
int CmdCmp(int argc, char* argv[])
{
	int i;
	unsigned long dst,src;
	unsigned long dst_value, src_value;
	unsigned int length;
	unsigned long error;

	if(argc < 3) {
		printf("Parameters not enough!\n");
		return 1;
	}
	dst = strtoul((const char*)(argv[0]), (char **)NULL, 16);
	src = strtoul((const char*)(argv[1]), (char **)NULL, 16);
	length= strtoul((const char*)(argv[2]), (char **)NULL, 16);		
	error = 0;
	for(i=0;i<length;i+=4) {
		dst_value = *(volatile unsigned int *)(dst+i);
		src_value = *(volatile unsigned int *)(src+i);
		if(dst_value != src_value) {		
			printf("%dth data(%x %x) error\n",i, dst_value, src_value);
			error = 1;
		}
	}
	if(!error)
		printf("No error found\n");

}
#ifdef SUPPORT_NAND 

int CmdNFlr(int argc, char* argv[])
{
	int i;
	unsigned long dst,src;
	unsigned int length;

	if(argc < 3) {
		printf("Parameters not enough!\n");
		return 1;
	}

	dst = strtoul((const char*)(argv[0]), (char **)NULL, 16);
	src = strtoul((const char*)(argv[1]), (char **)NULL, 16);
	length= strtoul((const char*)(argv[2]), (char **)NULL, 16);		

	file_length_to_client=length;

	printf("Read NAND Flash from %X to %X with %X bytes	?\n",src,dst,length);
	printf("(Y)es , (N)o ? --> ");

	if (YesOrNo())
		    if (read_data(src,length,(unsigned char *)dst))
			printf("Read NAND Flash Successed!\n");
		    else
			printf("Read NAND Flash Failed!\n");
	else
		printf("Abort!\n");

}
int CmdNFlw(int argc, char* argv[])
{
	unsigned long dst,src;
	unsigned long length;


	if(argc < 3) {
		printf("Parameters not enough!\n");
		return 1;
	}
	dst = strtoul((const char*)(argv[0]), (char **)NULL, 16);		
	src = strtoul((const char*)(argv[1]), (char **)NULL, 16);		
	length= strtoul((const char*)(argv[2]), (char **)NULL, 16);		

	printf("Program NAND flash from %X to %X with %X bytes	?\n",src,dst,length);
	printf("(Y)es, (N)o->");
	if (YesOrNo())
		if (write_data(dst, length, src))
			printf("Write Nand Flash Successed!\n");
		else
			printf("Write Nand Flash Failed!\n");
	else
		printf("Abort!\n");
				
}
#endif
