#include <asm/asm.h>
#include <asm/regdef.h>
#include <asm/mipsregs.h>
#include "start.h"

		.text
		.set noreorder
		.globl __start
__start:

#ifdef RTL8186
		// Set PLLMNR and SYSCLKR
		jal		clock_setting
		nop
#endif

		// zero status reg
		move 	t0, zero
		mtc0 	t0, $12
		nop

		// modify CPU/SDRAM timing
#ifndef RTL8186
//		li   	t0, 0x0cc7       // this is for 200/100 setting
		li   	t0, 0x886	     // david, better sdram timing

		li   	t1, 0xbd011008
		sw   	t0, 0(t1)

		li		t0, 0xffff0000
		li		t1, 0xbd011004
		sw		t0, 0(t1)

#ifdef MEMORY_32_BIT_MODE
		li		t0, 0xd2900000  // this is for 32-bit mode
#else
		li		t0, 0xd2800000  // this is for 16-bit mode
#endif
		li		t1, 0xbd011000
		sw		t0, 0(t1)
		lw		t0, 0(t1)
		nop

#else // RTL8186

		//Flash timing setting
		la		t0, VAL_FLASH_TIMING
		la		t1, REG_MTCR0
		sw		t0, 0(t1)

#ifdef MEMORY_32_BIT_MODE
		la		t0, 0xee110000  // this is for 32-bit mode---- 8M flash, 16M SDRAM
#else
		la		t0, 0xee010000  // this is for 16-bit mode---- 8M flash, 16M SDRAM
#endif
		la		t1, REG_MCR
		sw		t0, 0(t1)

		// SDRAM controller timing
		li		t0, 0x8a8		// more aggressive, for MEM=123M
//		li		t0, 0xcc8		// more aggressive, for MEM=100M
		la		t1, REG_MTCR1
		sw		t0, 0(t1)

		// modify arbiter settings
		la		t1, REG_TKNR
		la		t0, 0x82828282
		sw		t0, 0(t1)

		// ack all interrupts at first
		la		t1, REG_GISR
		la		t0, 0xffffffff
		sw		t0, 0(t1)

#endif // RTL8186

		// flush all cache
		mtc0	zero, $20
		nop
		nop
		li		t0, 0x3
		mtc0	t0, $20
		nop
		nop
		mtc0	zero, $20

load_boot:
		// initialize GPIO F1 for PCI reset. Reset : Low to high.
		li		t1, REG_GPEFDIR
		li		t0, 2
		sw		t0, 0(t1)       		// set F1 as output port(direction)
		li		t1, REG_GPEFDATA
		sw		zero, 0(t1)				// make PCI low (reset PCI)
		move	s0, zero
1:
		bne		s0, PCI_LOW_COUNTER, 1b	// Let PCI low for enough time.
		addiu	s0, s0, 1

		sw		t0, 0(t1)       		// set F1 as '1' (data, PCI high)

		// Due to this is the bootloader, we prefer not to
		// use stackframe
		// now copy __boot_start to BOOT_ADDR
		la		k0, __boot_start
		la		k1, (__boot_end + 4)
		la		t1, BOOT_ADDR
1:
		lw		t0, 0(k0)
		sw		t0, 0(t1)
		addu	t1, 4
		bne		k1, k0, 1b
		addu	k0, 4

		la		k0, BOOT_ADDR
		jr		k0
		nop

clock_setting:
		// Check chip version to set divider register
		li		t1, REG_REVISION
		lw		t0, 0(t1)
		li		t1, 0xf0000000
		and		t0, t0, t1
		srl		t0, t0, 0x1c			// Right shift 28 bits

		// watch dog reset for stability
		beq		t0, VERSION_D, version_8186_C
		nop

//		bne		t0, VERSION_D, 1f
//		nop
//		j		ra						// 8186 D cut doesn't need watch dog reset.
//		nop

1:
		beq		t0, VERSION_C, version_8186_C
		nop

version_8186_B:
		// Check PLLMNR and SYSCLKR Registers.
		la   	a0, REG_PLLMNR
		lw		t0, 0(a0)
		and		t0, t0, 0x3FFFF			// You must mask other bits!!
		li   	t1, VAL_PLLMNR_8186B
		bne		t0, t1, set_B
		nop

		la   	a0, REG_SYSCLKR
		lw		t0, 0(a0)
		and		t0, t0, 0xFFF			// You must mask other bits!!
		li   	t1, VAL_SYSCLKR_8186B
		bne		t0, t1, set_B
		nop

		j		ra						// PLLMNR and SYSCLKR are set already.
		nop

set_B:
		// Set CPU/MEM Clock and Watch Dog Reset.
		li		t0, VAL_PLLMNR_8186B
		la		a0, REG_PLLMNR
		sw		t0, 0(a0)

		li		t0, VAL_SYSCLKR_8186B
		la		a0, REG_SYSCLKR
		sw		t0, 0(a0)

		j		start_watch_dog
		nop

version_8186_C:
		// Check PLLMNR and SYSCLKR Registers.
		la   	a0, REG_PLLMNR
		lw		t0, 0(a0)
		and		t0, t0, 0x3FFFF			// You must mask other bits!!
		li   	t1, VAL_PLLMNR_8186C
		bne		t0, t1, set_C
		nop

		la   	a0, REG_SYSCLKR
		lw		t0, 0(a0)
		and		t0, t0, 0xFFF			// You must mask other bits!!
		li   	t1, VAL_SYSCLKR_8186C
		bne		t0, t1, set_C
		nop

		j		ra						// PLLMNR and SYSCLKR are set already.
		nop

set_C:
		// Set CPU/MEM Clock and Watch Dog Reset.
		li		t0, VAL_PLLMNR_8186C
		la		a0, REG_PLLMNR
		sw		t0, 0(a0)

		li		t0, VAL_SYSCLKR_8186C
		la		a0, REG_SYSCLKR
		sw		t0, 0(a0)

		j		start_watch_dog
		nop

start_watch_dog:
		// start WDTDOG
		la		a0, REG_CDBR
		la		t0, 0x2
		sw		t0, 0(a0)
		la		t0, 0x100
		la		a0, REG_WDTCNR
		sw		t0, 0(a0)
1:
		b		1b
		nop


