/*
 *      Web server handler routines for wlan stuffs
 *
 *      Authors: David Hsu	<davidhsu@realtek.com.tw>
 *
 *      $Id: fmwlan.c,v 1.38 2008/07/21 07:02:08 bradhuang Exp $
 *
 */

#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <unistd.h>
#ifdef WIFI_SIMPLE_CONFIG
#include <sys/time.h>
#endif

#include "../webs.h"
#include "apmib.h"
#include "apform.h"
#include "utility.h"

#ifdef WLAN_EASY_CONFIG
#include "../md5.h"
#endif

#ifdef WLAN_EASY_CONFIG
#define DO_CONFIG_WAIT_TIME	60
#define CONFIG_SUCCESS		0
#define AUTOCONF_PID_FILENAME	("/var/run/autoconf.pid")

static int wait_config = CONFIG_SUCCESS;
#endif

static SS_STATUS_Tp pStatus=NULL;

#ifdef WIFI_SIMPLE_CONFIG
enum {	CALLED_FROM_WLANHANDLER=1, CALLED_FROM_WEPHANDLER=2, CALLED_FROM_WPAHANDLER=3, CALLED_FROM_ADVANCEHANDLER=4};
struct wps_config_info_struct {
	int caller_id;
	int wlan_mode;
	int auth;
	int shared_type;
	int wep_enc;
	int wpa_enc;
	int wpa2_enc;
	unsigned char ssid[MAX_SSID_LEN];
	int KeyId;
	unsigned char wep64Key1[WEP64_KEY_LEN];
	unsigned char wep64Key2[WEP64_KEY_LEN];
	unsigned char wep64Key3[WEP64_KEY_LEN];
	unsigned char wep64Key4[WEP64_KEY_LEN];
	unsigned char wep128Key1[WEP128_KEY_LEN];
	unsigned char wep128Key2[WEP128_KEY_LEN];
	unsigned char wep128Key3[WEP128_KEY_LEN];
	unsigned char wep128Key4[WEP128_KEY_LEN];
	unsigned char wpaPSK[MAX_PSK_LEN+1];
};
static struct wps_config_info_struct wps_config_info;
static void update_wps_configured(int reset_flag);
#endif

/////////////////////////////////////////////////////////////////////////////
#ifndef NO_ACTION
void run_init_script(char *arg)
{
	int pid;
	char tmpBuf[100];
	
	snprintf(tmpBuf, 100, "%s/%s.pid", "/var/run", "udhcpd");
	pid = getPid(tmpBuf);
	if ( pid > 0)
		kill(pid, SIGUSR1);
		
	usleep(1000);
	
	if ( pid > 0){
		system("killall -9 udhcpd 2> /dev/null");
		system("rm -f /var/run/udhcpd.pid 2> /dev/null");
	}
	
	system("killsh.sh");	// kill all running script	
	
	pid = fork();
/*	
       	if (pid)
               	waitpid(pid, NULL, 0);
   	else 
*/ 
	if (pid == 0) {
		snprintf(tmpBuf, 100, "%s/%s", _CONFIG_SCRIPT_PATH, _CONFIG_SCRIPT_PROG);
#ifdef HOME_GATEWAY
		execl( tmpBuf, _CONFIG_SCRIPT_PROG, "gw", arg, NULL);
#else
		execl( tmpBuf, _CONFIG_SCRIPT_PROG, "ap", arg, NULL);
#endif
		exit(1);
	}
}
#endif

/////////////////////////////////////////////////////////////////////////////
static inline int isAllStar(char *data)
{
	int i;
	for (i=0; i<strlen(data); i++) {
		if (data[i] != '*')
			return 0;
	}
	return 1;
}

int wlanHandler(webs_t wp, char *tmpBuf, int *mode, int wlan_id)
{
   	char_t *strSSID, *strChan, *strDisabled, *strVal;
	int chan, disabled ;
	NETWORK_TYPE_T net;
	char_t *strRate;
	int val;
	char varName[20];
	sprintf(varName, "wlanDisabled%d", wlan_id);
	strDisabled = websGetVar(wp, varName, T(""));
	if ( !gstrcmp(strDisabled, T("ON")))
		disabled = 1;
	else
		disabled = 0;
	if ( apmib_set( MIB_WLAN_DISABLED, (void *)&disabled) == 0) {
  		strcpy(tmpBuf, T("Set disabled flag error!"));
		goto setErr_wlan;
	}

	if ( disabled )
		return 0;

#ifdef WIFI_SIMPLE_CONFIG
	memset(&wps_config_info, 0, sizeof(struct wps_config_info_struct));
	wps_config_info.caller_id = CALLED_FROM_WLANHANDLER;
	apmib_get(MIB_WLAN_SSID, (void *)wps_config_info.ssid);
	apmib_get(MIB_WLAN_MODE, (void *)&wps_config_info.wlan_mode);
#endif

	sprintf(varName, "mode%d", wlan_id);
	strVal = websGetVar(wp, varName, T(""));
	if ( strVal[0] ) {
		if (strVal[0]!= '0' && strVal[0]!= '1' && strVal[0]!= '2' &&  strVal[0]!= '3') {
  			strcpy(tmpBuf, T("Invalid mode value!"));
			goto setErr_wlan;
		}
		*mode = strVal[0] - '0';

		if (*mode == CLIENT_MODE) {
			ENCRYPT_T encrypt;
              		apmib_get( MIB_WLAN_ENCRYPT,  (void *)&encrypt);
			if (encrypt &  ENCRYPT_WPA2_MIXED) {
				int format;
				apmib_get( MIB_WLAN_WPA_AUTH, (void *)&format);
				if (format & 1) { // radius
					strcpy(tmpBuf, T("You cannot set client mode with Enterprise (RADIUS) !<br><br>Please change the encryption method in security page first."));
					goto setErr_wlan;
				}
			}
			else if (encrypt == ENCRYPT_WEP) {
				int use1x;
				apmib_get( MIB_WLAN_ENABLE_1X, (void *)&use1x);
				if (use1x & 1) {
					strcpy(tmpBuf, T("You cannot set client mode with WEP-802.1x!<br><br>Please change the encryption method in security page first."));
					goto setErr_wlan;
				}
			}
			sprintf(varName, "wlanMacClone%d", wlan_id);
			strVal = websGetVar(wp, varName, T(""));
			if ( !gstrcmp(strVal, T("ON")))
				val = 1 ;
			else
				val = 0 ;
			if ( apmib_set( MIB_WLAN_NAT25_MAC_CLONE, (void *)&val) == 0) {
				strcpy(tmpBuf, T("Set wlan Mac clone error!"));
				goto setErr_wlan;
			}
		}

		if ( apmib_set( MIB_WLAN_MODE, (void *)mode) == 0) {
   			strcpy(tmpBuf, T("Set MIB_WLAN_MODE error!"));
			goto setErr_wlan;
		}

#ifdef WLAN_EASY_CONFIG
		apmib_set( MIB_WLAN_EASYCFG_WLAN_MODE, (void *)mode);
#endif

	}

	sprintf(varName, "ssid%d", wlan_id);
   	strSSID = websGetVar(wp, varName, T(""));
	if ( strSSID[0] ) {
		if ( apmib_set(MIB_WLAN_SSID, (void *)strSSID) == 0) {
   	 			strcpy(tmpBuf, T("Set SSID error!"));
				goto setErr_wlan;
		}
	}
	else if ( *mode == 1 && !strSSID[0] ) { // client and NULL SSID
		if ( apmib_set(MIB_WLAN_SSID, (void *)strSSID) == 0) {
   	 			strcpy(tmpBuf, T("Set SSID error!"));
				goto setErr_wlan;
		}
	}

	sprintf(varName, "chan%d", wlan_id);
	strChan = websGetVar(wp, varName, T(""));
	if ( strChan[0] ) {
		errno=0;
		chan = strtol( strChan, (char **)NULL, 10);
		if (errno) {
   			strcpy(tmpBuf, T("Invalid channel number!"));
			goto setErr_wlan;
		}
		if ( apmib_set( MIB_WLAN_CHAN_NUM, (void *)&chan) == 0) {
   			strcpy(tmpBuf, T("Set channel number error!"));
			goto setErr_wlan;
		}
	}

	sprintf(varName, "type%d", wlan_id);
	strVal = websGetVar(wp, varName, T(""));
	if (strVal[0]) {
		if (strVal[0]!= '0' && strVal[0]!= '1') {
  			strcpy(tmpBuf, T("Invalid network type value!"));
			goto setErr_wlan;
		}
		if (strVal[0] == '0')
			net = INFRASTRUCTURE;
		else
			net = ADHOC;
		if ( apmib_set(MIB_WLAN_NETWORK_TYPE, (void *)&net) == 0) {
			strcpy(tmpBuf, T("Set MIB_WLAN_NETWORK_TYPE failed!"));
			goto setErr_wlan;
		}
	}

	sprintf(varName, "band%d", wlan_id);
	strVal = websGetVar(wp, varName, T(""));
	if ( strVal[0] ) {
		if (strVal[0] < '0' || strVal[0] > '6') {
  			strcpy(tmpBuf, T("Invalid band value!"));
			goto setErr_wlan;
		}
		val = (strVal[0] - '0' + 1);
		if ( apmib_set( MIB_WLAN_BAND, (void *)&val) == 0) {
   			strcpy(tmpBuf, T("Set band error!"));
			goto setErr_wlan;
		}
	}

	sprintf(varName, "basicrates%d", wlan_id);
	strRate = websGetVar(wp, varName, T(""));
	if ( strRate[0] ) {
		val = atoi(strRate);
		if ( val && apmib_set(MIB_WLAN_BASIC_RATE, (void *)&val) == 0) {
			strcpy(tmpBuf, T("Set Tx basic rate failed!"));
			goto setErr_wlan;
		}
	}

	sprintf(varName, "operrates%d", wlan_id);
	strRate = websGetVar(wp, varName, T(""));
	if ( strRate[0] ) {
		val = atoi(strRate);
		if ( val && apmib_set(MIB_WLAN_SUPPORTED_RATE, (void *)&val) == 0) {
			strcpy(tmpBuf, T("Set Tx operation rate failed!"));
			goto setErr_wlan;
		}
	}

#ifdef UNIVERSAL_REPEATER
{	int id;
	sprintf(varName, "repeaterEnabled%d", wlan_id);
	strVal = websGetVar(wp, T("lan_ip"), T(""));
	
	if ((strVal==NULL || strVal[0]==0) &&  // not called from wizard	
				(*mode != WDS_MODE) &&
			!(*mode == CLIENT_MODE && net == ADHOC)) {
		strVal = websGetVar(wp, varName, "");
		if ( !gstrcmp(strVal, T("ON")))
			val = 1 ;
		else
			val = 0 ;
		if (wlan_id == 0)
			id = MIB_REPEATER_ENABLED1;
		else
			id = MIB_REPEATER_ENABLED2;
		apmib_set(id, (void *)&val);

		if (val == 1) {
			sprintf(varName, "repeaterSSID%d", wlan_id);
			strVal = websGetVar(wp, varName, NULL);
			if (strVal){
				if (wlan_id == 0)
					id = MIB_REPEATER_SSID1;
				else
					id = MIB_REPEATER_SSID2;
				apmib_set(id, (void *)strVal);
			}
		}
	}
}
#endif

#ifdef WIFI_SIMPLE_CONFIG
	sprintf(varName, "wps_clear_configure_by_reg%d", wlan_id);
	strVal = websGetVar(wp, varName, NULL);
	val = 0;
	if (strVal[0])
		val = atoi(strVal);
	update_wps_configured(val);
#endif

	return  0;
setErr_wlan:
	return -1 ;
}

/////////////////////////////////////////////////////////////////////////////
void formWlanSetup(webs_t wp, char_t *path, char_t *query)
{
	char_t *submitUrl;
	char tmpBuf[100];
	int mode=-1;
	int warn=0;

	if(wlanHandler(wp, tmpBuf, &mode, wlan_idx) < 0)
		goto setErr_wlan ;
	if (mode == 1) { // not AP mode
		//set cipher suit to AES and encryption to wpa2 only if wpa2 mixed mode is set
		ENCRYPT_T encrypt;
		int intVal;
		apmib_get( MIB_WLAN_ENCRYPT, (void *)&encrypt);
		if(encrypt == ENCRYPT_WPA2_MIXED){
			intVal =   WPA_CIPHER_AES ;
			if ( apmib_set(MIB_WLAN_WPA2_CIPHER_SUITE, (void *)&intVal) == 0) {
				strcpy(tmpBuf, T("Set MIB_WLAN_WPA2_UNICIPHER failed!"));
				goto setErr_wlan;
			}
			encrypt = ENCRYPT_WPA2;
			if ( apmib_set(MIB_WLAN_ENCRYPT, (void *)&encrypt) == 0) {
				strcpy(tmpBuf, T("Set MIB_WLAN_WPA2_UNICIPHER failed!"));
				goto setErr_wlan;
			}

			intVal =   0;
			if ( apmib_set(MIB_WLAN_WPA_CIPHER_SUITE, (void *)&intVal) == 0) {
				strcpy(tmpBuf, T("Set MIB_WLAN_WPA_CIPHER_SUITE failed!"));
				goto setErr_wlan;
			}
			strcpy(tmpBuf, T("Warning! WPA2 Mixed encryption is not supported in client Mode. <BR> Change to WPA2 Encryption."));
			warn = 1;
		}
	}
	apmib_update_web(CURRENT_SETTING);

#ifndef NO_ACTION
	run_init_script("bridge");
#endif

	submitUrl = websGetVar(wp, T("wlan-url"), T(""));   // hidden page
	if (warn) {
		OK_MSG1(tmpBuf, submitUrl);
	}
	else {
		OK_MSG(submitUrl);
	}
	return;

setErr_wlan:
	ERR_MSG(tmpBuf);
}

int wepHandler(webs_t wp, char *tmpBuf, int wlan_id)
{
   	char_t  *wepKey;
   	char_t *strKeyLen, *strFormat, *strKeyId, *strEnabled;
	char key[30];
	int enabled, keyLen, ret, i;
	WEP_T wep;
	ENCRYPT_T encrypt=ENCRYPT_WEP;
	char varName[20];

#ifdef WIFI_SIMPLE_CONFIG
	memset(&wps_config_info, 0, sizeof(struct wps_config_info_struct));
	wps_config_info.caller_id = CALLED_FROM_WEPHANDLER;
	apmib_get(MIB_WLAN_ENCRYPT, (void *)&wps_config_info.auth);
	apmib_get(MIB_WLAN_WEP, (void *)&wps_config_info.wep_enc);
	apmib_get(MIB_WLAN_WEP_DEFAULT_KEY, (void *)&wps_config_info.KeyId);
	apmib_get(MIB_WLAN_WEP64_KEY1, (void *)wps_config_info.wep64Key1);
	apmib_get(MIB_WLAN_WEP64_KEY2, (void *)wps_config_info.wep64Key2);
	apmib_get(MIB_WLAN_WEP64_KEY3, (void *)wps_config_info.wep64Key3);
	apmib_get(MIB_WLAN_WEP64_KEY4, (void *)wps_config_info.wep64Key4);
	apmib_get(MIB_WLAN_WEP128_KEY1, (void *)wps_config_info.wep128Key1);
	apmib_get(MIB_WLAN_WEP128_KEY2, (void *)wps_config_info.wep128Key2);
	apmib_get(MIB_WLAN_WEP128_KEY3, (void *)wps_config_info.wep128Key3);
	apmib_get(MIB_WLAN_WEP128_KEY4, (void *)wps_config_info.wep128Key4);
#endif

	sprintf(varName, "wepEnabled%d", wlan_id);
	strEnabled = websGetVar(wp, varName, T(""));
	if ( !gstrcmp(strEnabled, T("ON")))
		enabled = 1;
	else
		enabled = 0;

	if ( enabled ) {
		sprintf(varName, "length%d", wlan_id);
		strKeyLen = websGetVar(wp, varName, T(""));
		if (!strKeyLen[0]) {
 			strcpy(tmpBuf, T("Key length must exist!"));
			goto setErr_wep;
		}
		if (strKeyLen[0]!='1' && strKeyLen[0]!='2') {
 			strcpy(tmpBuf, T("Invalid key length value!"));
			goto setErr_wep;
		}
		if (strKeyLen[0] == '1')
			wep = WEP64;
		else
			wep = WEP128;
	}
	else
		wep = WEP_DISABLED;

	if ( apmib_set( MIB_WLAN_WEP, (void *)&wep) == 0) {
  		strcpy(tmpBuf, T("Set WEP MIB error!"));
		goto setErr_wep;
	}

	if (wep == WEP_DISABLED)
		encrypt = ENCRYPT_DISABLED;

	if (apmib_set( MIB_WLAN_ENCRYPT, (void *)&encrypt) == 0) {
		strcpy(tmpBuf, T("Set MIB_WLAN_ENCRYPT mib error!"));
		goto setErr_wep;
	}

	if (wep == WEP_DISABLED)
		return 0 ;

	sprintf(varName, "format%d", wlan_id);
	strFormat = websGetVar(wp, varName, T(""));
	if (!strFormat[0]) {
 		strcpy(tmpBuf, T("Key type must exist!"));
		goto setErr_wep;
	}

	if (strFormat[0]!='1' && strFormat[0]!='2') {
		strcpy(tmpBuf, T("Invalid key type value!"));
		goto setErr_wep;
	}

	i = strFormat[0] - '0' - 1;
	if ( apmib_set( MIB_WLAN_WEP_KEY_TYPE, (void *)&i) == 0) {
  		strcpy(tmpBuf, T("Set WEP key type error!"));
		goto setErr_wep;
	}

	if (wep == WEP64) {
		if (strFormat[0]=='1')
			keyLen = WEP64_KEY_LEN;
		else
			keyLen = WEP64_KEY_LEN*2;
	}
	else {
		if (strFormat[0]=='1')
			keyLen = WEP128_KEY_LEN;
		else
			keyLen = WEP128_KEY_LEN*2;
	}

	sprintf(varName, "defaultTxKeyId%d", wlan_id);
	strKeyId = websGetVar(wp, varName, T(""));
	if ( strKeyId[0] ) {
		if ( strKeyId[0]!='1' && strKeyId[0]!='2' && strKeyId[0]!='3' && strKeyId[0]!='4' ) {
	 		strcpy(tmpBuf, T("Invalid default tx key id!"));
   			goto setErr_wep;
		}
		i = strKeyId[0] - '0' - 1;
		if ( !apmib_set( MIB_WLAN_WEP_DEFAULT_KEY, (void *)&i ) ) {
	 		strcpy(tmpBuf, T("Set default tx key id error!"));
   			goto setErr_wep;
		}
	}

	sprintf(varName, "key1%d", wlan_id);
	wepKey = websGetVar(wp, varName, T(""));
	if  (wepKey[0]) {
		if (strlen(wepKey) != keyLen) {
			strcpy(tmpBuf, T("Invalid key 1 length!"));
			goto setErr_wep;
		}
		if ( !isAllStar(wepKey) ) {
			if (strFormat[0] == '1') // ascii
				strcpy(key, wepKey);
			else { // hex
				if ( !string_to_hex(wepKey, key, keyLen)) {
	   				strcpy(tmpBuf, T("Invalid wep-key1 value!"));
					goto setErr_wep;
				}
			}
			if (wep == WEP64)
				ret=apmib_set(MIB_WLAN_WEP64_KEY1, (void *)key);
			else
				ret=apmib_set(MIB_WLAN_WEP128_KEY1, (void *)key);
			if (!ret) {
	 			strcpy(tmpBuf, T("Set wep-key1 error!"));
				goto setErr_wep;
			}
		}
	}
	sprintf(varName, "key2%d", wlan_id);
	wepKey = websGetVar(wp, varName, T(""));
	if  (wepKey[0]) {
		if (strlen(wepKey) != keyLen) {
			strcpy(tmpBuf, T("Invalid key 2 length!"));
			goto setErr_wep;
		}
		if ( !isAllStar(wepKey) ) {
			if (strFormat[0] == '1') // ascii
				strcpy(key, wepKey);
			else { // hex
				if ( !string_to_hex(wepKey, key, keyLen)) {
	   				strcpy(tmpBuf, T("Invalid wep-key2 value!"));
   					goto setErr_wep;
				}
			}
			if (wep == WEP64)
				ret=apmib_set(MIB_WLAN_WEP64_KEY2, (void *)key);
			else
				ret=apmib_set(MIB_WLAN_WEP128_KEY2, (void *)key);
			if (!ret) {
	 			strcpy(tmpBuf, T("Set wep-key2 error!"));
				goto setErr_wep;
			}
		}
	}

	sprintf(varName, "key3%d", wlan_id);
	wepKey = websGetVar(wp, varName, T(""));
	if  (wepKey[0]) {
		if (strlen(wepKey) != keyLen) {
			strcpy(tmpBuf, T("Invalid key 3 length!"));
			goto setErr_wep;
		}
		if ( !isAllStar(wepKey) ) {
			if (strFormat[0] == '1') // ascii
				strcpy(key, wepKey);
			else { // hex
				if ( !string_to_hex(wepKey, key, keyLen)) {
	   				strcpy(tmpBuf, T("Invalid wep-key3 value!"));
   					goto setErr_wep;
				}
			}
			if (wep == WEP64)
				ret=apmib_set(MIB_WLAN_WEP64_KEY3, (void *)key);
			else
				ret=apmib_set(MIB_WLAN_WEP128_KEY3, (void *)key);
			if (!ret) {
	 			strcpy(tmpBuf, T("Set wep-key3 error!"));
				goto setErr_wep;
			}
		}
	}

	sprintf(varName, "key4%d", wlan_id);
	wepKey = websGetVar(wp, varName, T(""));
	if  (wepKey[0]) {
		if (strlen(wepKey) != keyLen) {
			strcpy(tmpBuf, T("Invalid key 1 length!"));
			goto setErr_wep;
		}
		if ( !isAllStar(wepKey) ) {
			if (strFormat[0] == '1') // ascii
				strcpy(key, wepKey);
			else { // hex
				if ( !string_to_hex(wepKey, key, keyLen)) {
	   				strcpy(tmpBuf, T("Invalid wep-key4 value!"));
   					goto setErr_wep;
				}
			}
			if (wep == WEP64)
				ret=apmib_set(MIB_WLAN_WEP64_KEY4, (void *)key);
			else
				ret=apmib_set(MIB_WLAN_WEP128_KEY4, (void *)key);
			if (!ret) {
	 			strcpy(tmpBuf, T("Set wep-key4 error!"));
				goto setErr_wep;
			}
		}
	}	

#ifdef WIFI_SIMPLE_CONFIG
	sprintf(varName, "wps_clear_configure_by_reg%d", wlan_id);
	wepKey = websGetVar(wp, varName, NULL);
	ret = 0;
	if (wepKey[0])
		ret = atoi(wepKey);
	update_wps_configured(ret);
#endif

	return 0 ;
setErr_wep:
	return -1 ;	
}	
/////////////////////////////////////////////////////////////////////////////
void formWep(webs_t wp, char_t *path, char_t *query)
{
	char_t *submitUrl;
	char tmpBuf[100];


	if(wepHandler(wp, tmpBuf, wlan_idx) < 0 )
		goto setErr_end ;

	apmib_update_web(CURRENT_SETTING);

#ifndef NO_ACTION
	run_init_script("bridge");
#endif

	submitUrl = websGetVar(wp, T("submit-url"), T(""));   // hidden page
	OK_MSG(submitUrl);

	return;

setErr_end:
	ERR_MSG(tmpBuf);
}


int wpaHandler(webs_t wp, char *tmpBuf, int wlan_id)
{
   	char_t *strEncrypt, *strVal;
	ENCRYPT_T encrypt;
	int enableRS=0, intVal, getPSK=0, len, val;
	unsigned long reKeyTime;
	SUPP_NONWAP_T suppNonWPA;
	struct in_addr inIp;
	char varName[20];

	sprintf(varName, "method%d", wlan_id);
   	strEncrypt = websGetVar(wp, varName, T(""));
	if (!strEncrypt[0]) {
 		strcpy(tmpBuf, T("Error! no encryption method."));
		goto setErr_encrypt;
	}
	encrypt = (ENCRYPT_T) strEncrypt[0] - '0';
	if (encrypt!=ENCRYPT_DISABLED && encrypt!=ENCRYPT_WEP && encrypt!=ENCRYPT_WPA
		&& encrypt != ENCRYPT_WPA2 && encrypt != ENCRYPT_WPA2_MIXED) {
		strcpy(tmpBuf, T("Invalid encryption method!"));
		goto setErr_encrypt;
	}

#ifdef WIFI_SIMPLE_CONFIG
	memset(&wps_config_info, 0, sizeof(struct wps_config_info_struct));
	wps_config_info.caller_id = CALLED_FROM_WPAHANDLER;
	apmib_get(MIB_WLAN_ENCRYPT, (void *)&wps_config_info.auth);
	apmib_get(MIB_WLAN_WPA_CIPHER_SUITE, (void *)&wps_config_info.wpa_enc);
	apmib_get(MIB_WLAN_WPA2_CIPHER_SUITE, (void *)&wps_config_info.wpa2_enc);
	apmib_get(MIB_WLAN_WPA_PSK, (void *)wps_config_info.wpaPSK);
#endif

	if (apmib_set( MIB_WLAN_ENCRYPT, (void *)&encrypt) == 0) {
  		strcpy(tmpBuf, T("Set MIB_WLAN_ENCRYPT mib error!"));
		goto setErr_encrypt;
	}

	if (encrypt == ENCRYPT_DISABLED || encrypt == ENCRYPT_WEP) {
		sprintf(varName, "use1x%d", wlan_id);
		strVal = websGetVar(wp, varName, T(""));
		if ( !gstrcmp(strVal, T("ON"))) {
			apmib_get( MIB_WLAN_MODE, (void *)&intVal);
			if (intVal !=0 && intVal != AP_WDS_MODE) { // not AP mode
				strcpy(tmpBuf, T("Error! 802.1x authentication cannot be used when device is set to client mode."));
				goto setErr_encrypt;
			}
			intVal = 1;
			enableRS = 1;
		}
		else
			intVal = 0;

		if ( apmib_set( MIB_WLAN_ENABLE_1X, (void *)&intVal) == 0) {
  			strcpy(tmpBuf, T("Set 1x enable flag error!"));
			goto setErr_encrypt;
		}

		if (encrypt == ENCRYPT_WEP) {
	 		WEP_T wep;
			if ( !apmib_get( MIB_WLAN_WEP,  (void *)&wep) ) {
				strcpy(tmpBuf, T("Get MIB_WLAN_WEP MIB error!"));
				goto setErr_encrypt;
			}
			if (wep == WEP_DISABLED) {
				wep = WEP64;
				if ( apmib_set( MIB_WLAN_WEP, (void *)&wep) == 0) {
		  			strcpy(tmpBuf, T("Set WEP MIB error!"));
					goto setErr_encrypt;
				}
			}
		}
		else {
			sprintf(varName, "useMacAuth%d", wlan_id);
			strVal = websGetVar(wp, varName, T(""));
			if ( !gstrcmp(strVal, T("ON"))) {
				intVal = 1;
				enableRS = 1;
			}
			else
				intVal = 0;
			if ( apmib_set( MIB_WLAN_ENABLE_MAC_AUTH, (void *)&intVal) == 0) {
  				strcpy(tmpBuf, T("Set MIB_WLAN_ENABLE_MAC_AUTH MIB error!"));
				goto setErr_encrypt;
			}
		}
	}
	else {
		// support nonWPA client

		sprintf(varName, "nonWpaSupp%d", wlan_id);
 		strVal = websGetVar(wp, varName, T(""));
		if ( !gstrcmp(strVal, T("ON")))
			intVal = 1;
		else
			intVal = 0;
		if ( apmib_set( MIB_WLAN_ENABLE_SUPP_NONWPA, (void *)&intVal) == 0) {
  			strcpy(tmpBuf, T("Set MIB_WLAN_ENABLE_SUPP_NONWPA mib error!"));
			goto setErr_encrypt;
		}
		if ( intVal ) {
			suppNonWPA = SUPP_NONWPA_NONE;
			sprintf(varName, "nonWpaWep%d", wlan_id);
			strVal = websGetVar(wp, varName, T(""));
			if ( !gstrcmp(strVal, T("ON")))
				suppNonWPA |= SUPP_NONWPA_WEP;

			sprintf(varName, "nonWpa1x%d", wlan_id);
			strVal = websGetVar(wp, varName, T(""));
			if ( !gstrcmp(strVal, T("ON"))) {
				suppNonWPA |= SUPP_NONWPA_1X;
				enableRS = 1;
			}

			if ( apmib_set( MIB_WLAN_SUPP_NONWPA, (void *)&suppNonWPA) == 0) {
  				strcpy(tmpBuf, T("Set MIB_WLAN_SUPP_NONWPA mib error!"));
				goto setErr_encrypt;
			}
		}

		// WPA authentication
		sprintf(varName, "wpaAuth%d", wlan_id);
		strVal = websGetVar(wp, varName, T(""));
		if (strVal[0]) {
			if ( !gstrcmp(strVal, T("eap"))) {
				apmib_get( MIB_WLAN_MODE, (void *)&intVal);
#ifndef TLS_CLIENT
				if (intVal!=AP_MODE && intVal!=AP_WDS_MODE) { // not AP mode
					strcpy(tmpBuf, T("Error! WPA-RADIUS cannot be used when device is set to client mode."));
					goto setErr_encrypt;
				}
#endif
				intVal = WPA_AUTH_AUTO;
				enableRS = 1;
			}
			else if ( !gstrcmp(strVal, T("psk"))) {
				intVal = WPA_AUTH_PSK;
				getPSK = 1;

			}
			else {
				strcpy(tmpBuf, T("Error! Invalid wpa authentication value."));
				goto setErr_encrypt;
			}
			if ( apmib_set(MIB_WLAN_WPA_AUTH, (void *)&intVal) == 0) {
				strcpy(tmpBuf, T("Set MIB_WLAN_AUTH_TYPE failed!"));
				goto setErr_encrypt;
			}
		}

		// cipher suite		
		// sc_yang write the ciphersuite according to  encrypt for wpa
		// wpa mixed mode is not implemented yet.
		
// get cipher suite from user setting, for wpa-aes -------------------		
#if 0				
		intVal = 0 ;
		if( (encrypt ==  ENCRYPT_WPA) || (encrypt == ENCRYPT_WPA2_MIXED) )
			intVal =   WPA_CIPHER_TKIP ;
		if ( apmib_set(MIB_WLAN_WPA_CIPHER_SUITE, (void *)&intVal) == 0) {
				strcpy(tmpBuf, T("Set MIB_WLAN_WPA_CIPHER_SUITE failed!"));
				goto setErr_encrypt;
		}
		//set wpa2UniCipher  for wpa2
		// wpa2 mixed mode is not implemented yet.
		intVal = 0 ;
		if( (encrypt ==  ENCRYPT_WPA2) || (encrypt == ENCRYPT_WPA2_MIXED) )
			intVal =   WPA_CIPHER_AES ;
		if ( apmib_set(MIB_WLAN_WPA2_CIPHER_SUITE, (void *)&intVal) == 0) {
				strcpy(tmpBuf, T("Set MIB_WLAN_WPA2_UNICIPHER failed!"));
				goto setErr_encrypt;
		}
#endif	
		if ((encrypt == ENCRYPT_WPA) || (encrypt == ENCRYPT_WPA2_MIXED)) {
			sprintf(varName, "ciphersuite%d", wlan_id);
			strVal = websGetVar(wp, varName, T(""));	 	
			if (strVal[0]) {
				intVal = 0;				
				if ( gstrstr(strVal, T("tkip"))) 
					intVal |= WPA_CIPHER_TKIP;
				if ( gstrstr(strVal, T("aes"))) 
					intVal |= WPA_CIPHER_AES;
				if (intVal == 0) {
					strcpy(tmpBuf, T("Invalid value of cipher suite!"));
					goto setErr_encrypt;
				}
			}
			else
				intVal = WPA_CIPHER_TKIP;	

			// check if both TKIP and AES cipher are selected in client mode
			apmib_get(MIB_WLAN_MODE, (void *)&val);
			if (val == CLIENT_MODE) {
				apmib_get(MIB_WLAN_NETWORK_TYPE, &val);
				if (val == INFRASTRUCTURE && intVal == WPA_CIPHER_MIXED) {
					strcpy(tmpBuf, T("Error! Can't set cipher to TKIP + AES when device is set to client mode."));
					goto setErr_encrypt;							
				}
			}	// david+2006-1-11
					
			if ( apmib_set(MIB_WLAN_WPA_CIPHER_SUITE, (void *)&intVal) == 0) {
				strcpy(tmpBuf, T("Set MIB_WLAN_WPA_CIPHER_SUITE failed!"));
				goto setErr_encrypt;							
			}				
		}		
		if ((encrypt == ENCRYPT_WPA2) || (encrypt == ENCRYPT_WPA2_MIXED)) {
			sprintf(varName, "wpa2ciphersuite%d", wlan_id);
			strVal = websGetVar(wp, varName, T(""));	 	
			if (strVal[0]) {
				intVal = 0;				
				if ( gstrstr(strVal, T("tkip"))) 
					intVal |= WPA_CIPHER_TKIP;
				if ( gstrstr(strVal, T("aes"))) 
					intVal |= WPA_CIPHER_AES;
				if (intVal == 0) {
					strcpy(tmpBuf, T("Invalid value of wpa2 cipher suite!"));
					goto setErr_encrypt;
				}
			}
			else
				intVal = WPA_CIPHER_AES;			

			// check if both TKIP and AES cipher are selected in client mode
			apmib_get(MIB_WLAN_MODE, (void *)&val);
			if (val == CLIENT_MODE) {
				apmib_get(MIB_WLAN_NETWORK_TYPE, &val);
				if (val == INFRASTRUCTURE && intVal == WPA_CIPHER_MIXED) {
					strcpy(tmpBuf, T("Error! Can't set cipher to TKIP + AES when device is set to client mode."));
					goto setErr_encrypt;							
				}
			}	// david+2006-1-11
				
			if ( apmib_set(MIB_WLAN_WPA2_CIPHER_SUITE, (void *)&intVal) == 0) {
				strcpy(tmpBuf, T("Set MIB_WLAN_WPA2_CIPHER_SUITE failed!"));
				goto setErr_encrypt;							
			}
		}
//-------------------------------------------------- david, 2005-8-03	
	
		if( ((encrypt ==  ENCRYPT_WPA2) || (encrypt == ENCRYPT_WPA2_MIXED)) &&
		    enableRS == 1){
			sprintf(varName, "preAuth%d", wlan_id);
			strVal = websGetVar(wp, varName, T(""));
			if ( !gstrcmp(strVal, T("ON")))
				intVal = 1 ;
			else
				intVal = 0 ;
			if ( apmib_set(MIB_WLAN_WPA2_PRE_AUTH, (void *)&intVal) == 0) {
				strcpy(tmpBuf, T("Set MIB_WLAN_WPA_CIPHER_SUITE failed!"));
				goto setErr_encrypt;
			}					
		}

		// pre-shared key
		if ( getPSK ) {
			int oldFormat, oldPskLen, i;

			sprintf(varName, "pskFormat%d", wlan_id);
   			strVal = websGetVar(wp, varName, T(""));
			if (!strVal[0]) {
	 			strcpy(tmpBuf, T("Error! no psk format."));
				goto setErr_encrypt;
			}
			intVal = strVal[0] - '0';
			if (intVal != 0 && intVal != 1) {
	 			strcpy(tmpBuf, T("Error! invalid psk format."));
				goto setErr_encrypt;
			}

			// remember current psk format and length to compare to default case "****"
			apmib_get(MIB_WLAN_WPA_PSK_FORMAT, (void *)&oldFormat);
			apmib_get(MIB_WLAN_WPA_PSK, (void *)tmpBuf);
			oldPskLen = strlen(tmpBuf);

			sprintf(varName, "pskValue%d", wlan_id);
			strVal = websGetVar(wp, varName, T(""));
			len = strlen(strVal);

			if (oldFormat == intVal && len == oldPskLen ) {
				for (i=0; i<len; i++) {
					if ( strVal[i] != '*' )
						break;
				}
				if (i == len)
					goto rekey_time;
			}

			if ( apmib_set(MIB_WLAN_WPA_PSK_FORMAT, (void *)&intVal) == 0) {
				strcpy(tmpBuf, T("Set MIB_WLAN_WPA_PSK_FORMAT failed!"));
				goto setErr_encrypt;
			}

			if (intVal==1) { // hex
				if (len!=MAX_PSK_LEN || !string_to_hex(strVal, tmpBuf, MAX_PSK_LEN)) {
	 				strcpy(tmpBuf, T("Error! invalid psk value."));
					goto setErr_encrypt;
				}
			}
			else { // passphras
				if (len==0 || len > (MAX_PSK_LEN-1) ) {
	 				strcpy(tmpBuf, T("Error! invalid psk value."));
					goto setErr_encrypt;
				}
			}
			if ( !apmib_set(MIB_WLAN_WPA_PSK, (void *)strVal)) {
				strcpy(tmpBuf, T("Set MIB_WLAN_WPA_PSK error!"));
				goto setErr_encrypt;
			}
		}
rekey_time:
		// group key rekey time
		reKeyTime = 0;
		sprintf(varName, "groupKeyTimeDay%d", wlan_id);
		strVal = websGetVar(wp, varName, T(""));
		if (strVal[0]) {
			if ( !string_to_dec(strVal, &intVal) ) {
				strcpy(tmpBuf, T("Error! Invalid value of rekey day."));
				goto setErr_encrypt;
			}
			reKeyTime += intVal*86400;
		}
		sprintf(varName, "groupKeyTimeHr%d", wlan_id);
		strVal = websGetVar(wp, varName, T(""));
		if (strVal[0]) {
			if ( !string_to_dec(strVal, &intVal) ) {
				strcpy(tmpBuf, T("Error! Invalid value of rekey hr."));
				goto setErr_encrypt;
			}
			reKeyTime += intVal*3600;
		}
		sprintf(varName, "groupKeyTimeMin%d", wlan_id);
		strVal = websGetVar(wp, varName, T(""));
		if (strVal[0]) {
			if ( !string_to_dec(strVal, &intVal) ) {
				strcpy(tmpBuf, T("Error! Invalid value of rekey min."));
				goto setErr_encrypt;
			}
			reKeyTime += intVal*60;
		}

		sprintf(varName, "groupKeyTimeSec%d", wlan_id);
		strVal = websGetVar(wp, varName, T(""));
		if (strVal[0]) {
			if ( !string_to_dec(strVal, &intVal) ) {
				strcpy(tmpBuf, T("Error! Invalid value of rekey sec."));
				goto setErr_encrypt;
			}
			reKeyTime += intVal;
		}
		if (reKeyTime) {
			if ( !apmib_set(MIB_WLAN_WPA_GROUP_REKEY_TIME, (void *)&reKeyTime)) {
				strcpy(tmpBuf, T("Set MIB_WLAN_WPA_GROUP_REKEY_TIME error!"));
				goto setErr_encrypt;
			}
		}
	}

	if (enableRS == 1) { // if 1x enabled, get RADIUS server info
		sprintf(varName, "radiusPort%d", wlan_id);
		strVal = websGetVar(wp, varName, T(""));
		if (!strVal[0]) {
			strcpy(tmpBuf, T("No RS port number!"));
			goto setErr_encrypt;
		}
		if (!string_to_dec(strVal, &intVal) || intVal<=0 || intVal>65535) {
			strcpy(tmpBuf, T("Error! Invalid value of RS port number."));
			goto setErr_encrypt;
		}
		if ( !apmib_set(MIB_WLAN_RS_PORT, (void *)&intVal)) {
			strcpy(tmpBuf, T("Set RS port error!"));
			goto setErr_encrypt;
		}
		sprintf(varName, "radiusIP%d", wlan_id);
		strVal = websGetVar(wp, varName, T(""));
		if (!strVal[0]) {
			strcpy(tmpBuf, T("No RS IP address!"));
			goto setErr_encrypt;
		}
		if ( !inet_aton(strVal, &inIp) ) {
			strcpy(tmpBuf, T("Invalid RS IP-address value!"));
			goto setErr_encrypt;
		}
		if ( !apmib_set(MIB_WLAN_RS_IP, (void *)&inIp)) {
			strcpy(tmpBuf, T("Set RS IP-address error!"));
			goto setErr_encrypt;
		}
		sprintf(varName, "radiusPass%d", wlan_id);
		strVal = websGetVar(wp, varName, T(""));
		if (strlen(strVal) > (MAX_RS_PASS_LEN -1) ) {
			strcpy(tmpBuf, T("RS password length too long!"));
			goto setErr_encrypt;
		}
		if ( !apmib_set(MIB_WLAN_RS_PASSWORD, (void *)strVal)) {
			strcpy(tmpBuf, T("Set RS password error!"));
			goto setErr_encrypt;
		}

		sprintf(varName, "radiusRetry%d", wlan_id);
		strVal = websGetVar(wp, varName, T(""));
		if (strVal[0]) {
			if ( !string_to_dec(strVal, &intVal) ) {
				strcpy(tmpBuf, T("Invalid RS retry value!"));
				goto setErr_encrypt;
			}
			if ( !apmib_set(MIB_WLAN_RS_RETRY, (void *)&intVal)) {
				strcpy(tmpBuf, T("Set MIB_WLAN_RS_RETRY error!"));
				goto setErr_encrypt;
			}
		}
		sprintf(varName, "radiusTime%d", wlan_id);
		strVal = websGetVar(wp, varName, T(""));
		if (strVal[0]) {
			if ( !string_to_dec(strVal, &intVal) ) {
				strcpy(tmpBuf, T("Invalid RS time value!"));
				goto setErr_encrypt;
			}
			if ( !apmib_set(MIB_WLAN_RS_INTERVAL_TIME, (void *)&intVal)) {
				strcpy(tmpBuf, T("Set MIB_WLAN_RS_INTERVAL_TIME error!"));
				goto setErr_encrypt;
			}
		}
		sprintf(varName, "useAccount%d", wlan_id);
		strVal = websGetVar(wp, varName, T(""));
		if ( !gstrcmp(strVal, T("ON")))
			intVal = 1;
		else
			intVal = 0;
		if ( apmib_set( MIB_WLAN_ACCOUNT_RS_ENABLED, (void *)&intVal) == 0) {
  			strcpy(tmpBuf, T("Set MIB_WLAN_ACCOUNT_RS_ENABLED mib error!"));
			goto setErr_encrypt;
		}
		if (intVal == 0)
			goto get_wepkey;

		sprintf(varName, "accountPort%d", wlan_id);
		strVal = websGetVar(wp, varName, T(""));
		if (!strVal[0]) {
			strcpy(tmpBuf, T("No account RS port number!"));
			goto setErr_encrypt;
		}
		if (!string_to_dec(strVal, &intVal) || intVal<=0 || intVal>65535) {
			strcpy(tmpBuf, T("Error! Invalid value of account RS port number."));
			goto setErr_encrypt;
		}
		if ( !apmib_set(MIB_WLAN_ACCOUNT_RS_PORT, (void *)&intVal)) {
			strcpy(tmpBuf, T("Set account RS port error!"));
			goto setErr_encrypt;
		}
		sprintf(varName, "accountIP%d", wlan_id);
		strVal = websGetVar(wp, varName, T(""));
		if (!strVal[0]) {
			strcpy(tmpBuf, T("No account RS IP address!"));
			goto setErr_encrypt;
		}
		if ( !inet_aton(strVal, &inIp) ) {
			strcpy(tmpBuf, T("Invalid account RS IP-address value!"));
			goto setErr_encrypt;
		}
		if ( !apmib_set(MIB_WLAN_ACCOUNT_RS_IP, (void *)&inIp)) {
			strcpy(tmpBuf, T("Set account RS IP-address error!"));
			goto setErr_encrypt;
		}
		sprintf(varName, "accountPass%d", wlan_id);
		strVal = websGetVar(wp, varName, T(""));
		if (strlen(strVal) > (MAX_RS_PASS_LEN -1) ) {
			strcpy(tmpBuf, T("Account RS password length too long!"));
			goto setErr_encrypt;
		}
		if ( !apmib_set(MIB_WLAN_ACCOUNT_RS_PASSWORD, (void *)strVal)) {
			strcpy(tmpBuf, T("Set account RS password error!"));
			goto setErr_encrypt;
		}
		sprintf(varName, "accountRetry%d", wlan_id);
		strVal = websGetVar(wp, varName, T(""));
		if (strVal[0]) {
			if ( !string_to_dec(strVal, &intVal) ) {
				strcpy(tmpBuf, T("Invalid account RS retry value!"));
				goto setErr_encrypt;
			}
			if ( !apmib_set(MIB_WLAN_ACCOUNT_RS_RETRY, (void *)&intVal)) {
				strcpy(tmpBuf, T("Set MIB_WLAN_ACCOUNT_RS_RETRY error!"));
				goto setErr_encrypt;
			}
		}
		sprintf(varName, "accountTime%d", wlan_id);
		strVal = websGetVar(wp, varName, T(""));
		if (strVal[0]) {
			if ( !string_to_dec(strVal, &intVal) ) {
				strcpy(tmpBuf, T("Invalid account RS time value!"));
				goto setErr_encrypt;
			}
			if ( !apmib_set(MIB_WLAN_ACCOUNT_RS_INTERVAL_TIME, (void *)&intVal)) {
				strcpy(tmpBuf, T("Set MIB_WLAN_ACCOUNT_RS_INTERVAL_TIME error!"));
				goto setErr_encrypt;
			}
		}
		sprintf(varName, "accountUpdateEnabled%d", wlan_id);
		strVal = websGetVar(wp, varName, T(""));
		if ( !gstrcmp(strVal, T("ON")))
			intVal = 1;
		else
			intVal = 0;
		if ( apmib_set( MIB_WLAN_ACCOUNT_UPDATE_ENABLED, (void *)&intVal) == 0) {
			strcpy(tmpBuf, T("Set MIB_WLAN_ACCOUNT_UPDATE_ENABLED mib error!"));
			goto setErr_encrypt;
		}
		sprintf(varName, "accountUpdateTime%d", wlan_id);
		strVal = websGetVar(wp, varName, T(""));
		if (strVal[0]) {
			if ( !string_to_dec(strVal, &intVal) ) {
				strcpy(tmpBuf, T("Error! Invalid value of update time"));
				goto setErr_encrypt;
			}
			if ( !apmib_set(MIB_WLAN_ACCOUNT_UPDATE_DELAY, (void *)&intVal)) {
				strcpy(tmpBuf, T("Set MIB_WLAN_ACCOUNT_UPDATE_DELAY mib error!"));
				goto setErr_encrypt;
			}
		}

get_wepkey:
		// get 802.1x WEP key length
		sprintf(varName, "wepKeyLen%d", wlan_id);
		strVal = websGetVar(wp, varName, T(""));
		if (strVal[0]) {
			if ( !gstrcmp(strVal, T("wep64")))
				intVal = WEP64;
			else if ( !gstrcmp(strVal, T("wep128")))
				intVal = WEP128;
			else {
				strcpy(tmpBuf, T("Error! Invalid wepkeylen value."));
				goto setErr_encrypt;
			}
			if ( apmib_set(MIB_WLAN_WEP, (void *)&intVal) == 0) {
				strcpy(tmpBuf, T("Set MIB_WLAN_WEP failed!"));
				goto setErr_encrypt;
			}
		}
	}

#ifdef WIFI_SIMPLE_CONFIG
	sprintf(varName, "wps_clear_configure_by_reg%d", wlan_id);
	strVal = websGetVar(wp, varName, NULL);
	val = 0;
	if (strVal[0])
		val = atoi(strVal);
	update_wps_configured(val);
#endif

	return 0 ;
setErr_encrypt:
	return -1 ;		
}	
/////////////////////////////////////////////////////////////////////////////
void formWlEncrypt(webs_t wp, char_t *path, char_t *query)
{

	char_t *submitUrl;
	char tmpBuf[100];
	
	if(wpaHandler(wp, tmpBuf, wlan_idx) < 0)
		goto setErr_end ;

	apmib_update_web(CURRENT_SETTING);

#ifndef NO_ACTION
	run_init_script("bridge");
#endif

	submitUrl = websGetVar(wp, T("submit-url"), T(""));   // hidden page
	OK_MSG(submitUrl);

	return;

setErr_end:
	ERR_MSG(tmpBuf);
}

/////////////////////////////////////////////////////////////////////////////
int wlAcList(int eid, webs_t wp, int argc, char_t **argv)
{
	int nBytesSent=0, entryNum, i;
	MACFILTER_T entry;
	char tmpBuf[100];

	if ( !apmib_get(MIB_WLAN_AC_NUM, (void *)&entryNum)) {
  		websError(wp, 400, T("Get table entry error!\n"));
		return -1;
	}

	nBytesSent += websWrite(wp, T("<tr>"
      	"<td align=center width=\"45%%\" bgcolor=\"#808080\"><font size=\"2\"><b>MAC Address</b></font></td>\n"
      	"<td align=center width=\"35%%\" bgcolor=\"#808080\"><font size=\"2\"><b>Comment</b></font></td>\n"
      	"<td align=center width=\"20%%\" bgcolor=\"#808080\"><font size=\"2\"><b>Select</b></font></td></tr>\n"));

	for (i=1; i<=entryNum; i++) {
		*((char *)&entry) = (char)i;
		if ( !apmib_get(MIB_WLAN_AC_ADDR, (void *)&entry))
			return -1;

		snprintf(tmpBuf, 100, T("%02x:%02x:%02x:%02x:%02x:%02x"),
			entry.macAddr[0], entry.macAddr[1], entry.macAddr[2],
			entry.macAddr[3], entry.macAddr[4], entry.macAddr[5]);

		nBytesSent += websWrite(wp, T("<tr>"
			"<td align=center width=\"45%%\" bgcolor=\"#C0C0C0\"><font size=\"2\">%s</td>\n"
      			"<td align=center width=\"35%%\" bgcolor=\"#C0C0C0\"><font size=\"2\">%s</td>\n"
       			"<td align=center width=\"20%%\" bgcolor=\"#C0C0C0\"><input type=\"checkbox\" name=\"select%d\" value=\"ON\"></td></tr>\n"),
				tmpBuf, entry.comment, i);
	}
	return nBytesSent;
}

/////////////////////////////////////////////////////////////////////////////
void formWlAc(webs_t wp, char_t *path, char_t *query)
{
	char_t *strAddMac, *strDelMac, *strDelAllMac, *strVal, *submitUrl, *strEnabled;
	char tmpBuf[100];
	int entryNum, i, enabled;
	MACFILTER_T macEntry;

	strAddMac = websGetVar(wp, T("addFilterMac"), T(""));
	strDelMac = websGetVar(wp, T("deleteSelFilterMac"), T(""));
	strDelAllMac = websGetVar(wp, T("deleteAllFilterMac"), T(""));
	strEnabled = websGetVar(wp, T("wlanAcEnabled"), T(""));

	if (strAddMac[0]) {
		/*if ( !gstrcmp(strEnabled, T("ON")))
			enabled = 1;
		else
			enabled = 0; */ //by sc_yang
		 enabled = strEnabled[0] - '0';
		if ( apmib_set( MIB_WLAN_AC_ENABLED, (void *)&enabled) == 0) {
  			strcpy(tmpBuf, T("Set enabled flag error!"));
			goto setErr_ac;
		}

		strVal = websGetVar(wp, T("mac"), T(""));
		if ( !strVal[0] ) {
//			strcpy(tmpBuf, T("Error! No mac address to set."));
			goto setac_ret;
		}
		if (strlen(strVal)!=12 || !string_to_hex(strVal, macEntry.macAddr, 12)) {
			strcpy(tmpBuf, T("Error! Invalid MAC address."));
			goto setErr_ac;
		}

		strVal = websGetVar(wp, T("comment"), T(""));
		if ( strVal[0] ) {
			if (strlen(strVal) > COMMENT_LEN-1) {
				strcpy(tmpBuf, T("Error! Comment length too long."));
				goto setErr_ac;
			}
			strcpy(macEntry.comment, strVal);
		}
		else
			macEntry.comment[0] = '\0';

		if ( !apmib_get(MIB_WLAN_AC_NUM, (void *)&entryNum)) {
			strcpy(tmpBuf, T("Get entry number error!"));
			goto setErr_ac;
		}
		if ( (entryNum + 1) > MAX_WLAN_AC_NUM) {
			strcpy(tmpBuf, T("Cannot add new entry because table is full!"));
			goto setErr_ac;
		}

		// set to MIB. try to delete it first to avoid duplicate case
		apmib_set(MIB_WLAN_AC_ADDR_DEL, (void *)&macEntry);
		if ( apmib_set(MIB_WLAN_AC_ADDR_ADD, (void *)&macEntry) == 0) {
			strcpy(tmpBuf, T("Add table entry error!"));
			goto setErr_ac;
		}
	}

	/* Delete entry */
	if (strDelMac[0]) {
		if ( !apmib_get(MIB_WLAN_AC_NUM, (void *)&entryNum)) {
			strcpy(tmpBuf, T("Get entry number error!"));
			goto setErr_ac;
		}
		for (i=entryNum; i>0; i--) {
			snprintf(tmpBuf, 20, "select%d", i);

			strVal = websGetVar(wp, tmpBuf, T(""));
			if ( !gstrcmp(strVal, T("ON")) ) {

				*((char *)&macEntry) = (char)i;
				if ( !apmib_get(MIB_WLAN_AC_ADDR, (void *)&macEntry)) {
					strcpy(tmpBuf, T("Get table entry error!"));
					goto setErr_ac;
				}
				if ( !apmib_set(MIB_WLAN_AC_ADDR_DEL, (void *)&macEntry)) {
					strcpy(tmpBuf, T("Delete table entry error!"));
					goto setErr_ac;
				}
			}
		}
	}

	/* Delete all entry */
	if ( strDelAllMac[0]) {
		if ( !apmib_set(MIB_WLAN_AC_ADDR_DELALL, (void *)&macEntry)) {
			strcpy(tmpBuf, T("Delete all table error!"));
			goto setErr_ac;
		}
	}

setac_ret:
	apmib_update_web(CURRENT_SETTING);

#ifndef NO_ACTION
	run_init_script("bridge");
#endif

	submitUrl = websGetVar(wp, T("submit-url"), T(""));   // hidden page
	OK_MSG( submitUrl );
  	return;

setErr_ac:
	ERR_MSG(tmpBuf);
}

int advanceHander(webs_t wp ,char *tmpBuf)
{
	char_t *strAuth, *strFragTh, *strRtsTh, *strBeacon, *strPreamble;
	char_t *strRate, *strHiddenSSID, *strDtim, *strIapp, *strProtection;
	char_t *strTurbo, *strPower;
	AUTH_TYPE_T authType;
	PREAMBLE_T preamble;
	int val;

#ifdef WIFI_SIMPLE_CONFIG
	memset(&wps_config_info, 0, sizeof(struct wps_config_info_struct));
	wps_config_info.caller_id = CALLED_FROM_ADVANCEHANDLER;
	apmib_get(MIB_WLAN_AUTH_TYPE, (void *)&wps_config_info.shared_type);
#endif

	strAuth = websGetVar(wp, T("authType"), T(""));
	if (strAuth[0]) {
		if ( !gstrcmp(strAuth, T("open")))
			authType = AUTH_OPEN;
		else if ( !gstrcmp(strAuth, T("shared")))
			authType = AUTH_SHARED;
		else if ( !gstrcmp(strAuth, T("both")))
			authType = AUTH_BOTH;
		else {
			strcpy(tmpBuf, T("Error! Invalid authentication value."));
			goto setErr_advance;
		}
		if ( apmib_set(MIB_WLAN_AUTH_TYPE, (void *)&authType) == 0) {
			strcpy(tmpBuf, T("Set authentication failed!"));
			goto setErr_advance;
		}
	}
	strFragTh = websGetVar(wp, T("fragThreshold"), T(""));
	if (strFragTh[0]) {
		if ( !string_to_dec(strFragTh, &val) || val<256 || val>2346) {
			strcpy(tmpBuf, T("Error! Invalid value of fragment threshold."));
			goto setErr_advance;
		}
		if ( apmib_set(MIB_WLAN_FRAG_THRESHOLD, (void *)&val) == 0) {
			strcpy(tmpBuf, T("Set fragment threshold failed!"));
			goto setErr_advance;
		}
	}
	strRtsTh = websGetVar(wp, T("rtsThreshold"), T(""));
	if (strRtsTh[0]) {
		if ( !string_to_dec(strRtsTh, &val) || val<0 || val>2347) {
			strcpy(tmpBuf, T("Error! Invalid value of RTS threshold."));
			goto setErr_advance;
		}
		if ( apmib_set(MIB_WLAN_RTS_THRESHOLD, (void *)&val) == 0) {
			strcpy(tmpBuf, T("Set RTS threshold failed!"));
			goto setErr_advance;
		}
	}

	strBeacon = websGetVar(wp, T("beaconInterval"), T(""));
	if (strBeacon[0]) {
		if ( !string_to_dec(strBeacon, &val) || val<20 || val>1024) {
			strcpy(tmpBuf, T("Error! Invalid value of Beacon Interval."));
			goto setErr_advance;
		}
		if ( apmib_set(MIB_WLAN_BEACON_INTERVAL, (void *)&val) == 0) {
			strcpy(tmpBuf, T("Set Beacon interval failed!"));
			goto setErr_advance;
		}
	}

	// set tx rate
	strRate = websGetVar(wp, T("txRate"), T(""));
	if ( strRate[0] ) {
		if ( strRate[0] == '0' ) { // auto
			val = 1;
			if ( apmib_set(MIB_WLAN_RATE_ADAPTIVE_ENABLED, (void *)&val) == 0) {
				strcpy(tmpBuf, T("Set rate adaptive failed!"));
				goto setErr_advance;
			}
		}
		else  {
			val = 0;
			if ( apmib_set(MIB_WLAN_RATE_ADAPTIVE_ENABLED, (void *)&val) == 0) {
				strcpy(tmpBuf, T("Set rate adaptive failed!"));
				goto setErr_advance;
			}
			val = atoi(strRate);
			val = 1 << (val-1);
			if ( apmib_set(MIB_WLAN_FIX_RATE, (void *)&val) == 0) {
				strcpy(tmpBuf, T("Set fix rate failed!"));
				goto setErr_advance;
			}
			strRate = websGetVar(wp, T("basicrates"), T(""));
			if ( strRate[0] ) {
				val = atoi(strRate);
				if ( apmib_set(MIB_WLAN_BASIC_RATE, (void *)&val) == 0) {
					strcpy(tmpBuf, T("Set Tx basic rate failed!"));
					goto setErr_advance;
				}
			}

			strRate = websGetVar(wp, T("operrates"), T(""));
			if ( strRate[0] ) {
				val = atoi(strRate);
				if ( apmib_set(MIB_WLAN_SUPPORTED_RATE, (void *)&val) == 0) {
					strcpy(tmpBuf, T("Set Tx operation rate failed!"));
					goto setErr_advance;
				}
			}	
		}
	}

	val = 0;
	strRate = websGetVar(wp, T("operRate1M"), T(""));
	if (strRate==NULL || strRate[0]==0)
		goto skip_rate_setting;
	if ( !gstrcmp(strRate, T("1M")))
		val |= TX_RATE_1M;
	strRate = websGetVar(wp, T("operRate2M"), T(""));
	if ( !gstrcmp(strRate, T("2M")))
		val |= TX_RATE_2M;
	strRate = websGetVar(wp, T("operRate5M"), T(""));
	if ( !gstrcmp(strRate, T("5M")))
		val |= TX_RATE_5M;
	strRate = websGetVar(wp, T("operRate11M"), T(""));
	if ( !gstrcmp(strRate, T("11M")))
		val |= TX_RATE_11M;
	strRate = websGetVar(wp, T("operRate6M"), T(""));
	if ( !gstrcmp(strRate, T("6M")))
		val |= TX_RATE_6M;
	strRate = websGetVar(wp, T("operRate9M"), T(""));
	if ( !gstrcmp(strRate, T("9M")))
		val |= TX_RATE_9M;
	strRate = websGetVar(wp, T("operRate12M"), T(""));
	if ( !gstrcmp(strRate, T("12M")))
		val |= TX_RATE_12M;
	strRate = websGetVar(wp, T("operRate18M"), T(""));
	if ( !gstrcmp(strRate, T("18M")))
		val |= TX_RATE_18M;			
	strRate = websGetVar(wp, T("operRate24M"), T(""));
	if ( !gstrcmp(strRate, T("24M")))
		val |= TX_RATE_24M;			
	strRate = websGetVar(wp, T("operRate36M"), T(""));
	if ( !gstrcmp(strRate, T("36M")))
		val |= TX_RATE_36M;			
	strRate = websGetVar(wp, T("operRate48M"), T(""));
	if ( !gstrcmp(strRate, T("48M")))
		val |= TX_RATE_48M;			
	strRate = websGetVar(wp, T("operRate54M"), T(""));
	if ( !gstrcmp(strRate, T("54M")))
		val |= TX_RATE_54M;
	if ( apmib_set(MIB_WLAN_SUPPORTED_RATE, (void *)&val) == 0) {
		strcpy(tmpBuf, T("Set Tx operation rate failed!"));
		goto setErr_advance;
	}

	// set basic tx rate
	val = 0;
	strRate = websGetVar(wp, T("basicRate1M"), T(""));
	if (strRate==NULL || strRate[0]==0)
		goto skip_rate_setting;	
	if ( !gstrcmp(strRate, T("1M")))
		val |= TX_RATE_1M;
	strRate = websGetVar(wp, T("basicRate2M"), T(""));
	if ( !gstrcmp(strRate, T("2M")))
		val |= TX_RATE_2M;
	strRate = websGetVar(wp, T("basicRate5M"), T(""));
	if ( !gstrcmp(strRate, T("5M")))
		val |= TX_RATE_5M;
	strRate = websGetVar(wp, T("basicRate11M"), T(""));
	if ( !gstrcmp(strRate, T("11M")))
		val |= TX_RATE_11M;
	strRate = websGetVar(wp, T("basicRate6M"), T(""));
	if ( !gstrcmp(strRate, T("6M")))
		val |= TX_RATE_6M;
	strRate = websGetVar(wp, T("basicRate9M"), T(""));
	if ( !gstrcmp(strRate, T("9M")))
		val |= TX_RATE_9M;
	strRate = websGetVar(wp, T("basicRate12M"), T(""));
	if ( !gstrcmp(strRate, T("12M")))
		val |= TX_RATE_12M;
	strRate = websGetVar(wp, T("basicRate18M"), T(""));
	if ( !gstrcmp(strRate, T("18M")))
		val |= TX_RATE_18M;			
	strRate = websGetVar(wp, T("basicRate24M"), T(""));
	if ( !gstrcmp(strRate, T("24M")))
		val |= TX_RATE_24M;			
	strRate = websGetVar(wp, T("basicRate36M"), T(""));
	if ( !gstrcmp(strRate, T("36M")))
		val |= TX_RATE_36M;			
	strRate = websGetVar(wp, T("basicRate48M"), T(""));
	if ( !gstrcmp(strRate, T("48M")))
		val |= TX_RATE_48M;			
	strRate = websGetVar(wp, T("basicRate54M"), T(""));
	if ( !gstrcmp(strRate, T("54M")))
		val |= TX_RATE_54M;			
	if ( apmib_set(MIB_WLAN_BASIC_RATE, (void *)&val) == 0) {
		strcpy(tmpBuf, T("Set Tx basic rate failed!"));
		goto setErr_advance;
	}		
skip_rate_setting:
	// set preamble
	strPreamble = websGetVar(wp, T("preamble"), T(""));
	if (strPreamble[0]) {
		if (!gstrcmp(strPreamble, T("long")))
			preamble = LONG_PREAMBLE;
		else if (!gstrcmp(strPreamble, T("short")))
			preamble = SHORT_PREAMBLE;
		else {
			strcpy(tmpBuf, T("Error! Invalid Preamble value."));
			goto setErr_advance;
		}
		if ( apmib_set(MIB_WLAN_PREAMBLE_TYPE, (void *)&preamble) == 0) {
			strcpy(tmpBuf, T("Set Preamble failed!"));
			goto setErr_advance;
		}
	}

	// set hidden SSID
	strHiddenSSID = websGetVar(wp, T("hiddenSSID"), T(""));
	if (strHiddenSSID[0]) {
		if (!gstrcmp(strHiddenSSID, T("no")))
			val = 0;
		else if (!gstrcmp(strHiddenSSID, T("yes")))
			val = 1;
		else {
			strcpy(tmpBuf, T("Error! Invalid hiddenSSID value."));
			goto setErr_advance;
		}
		if ( apmib_set(MIB_WLAN_HIDDEN_SSID, (void *)&val) == 0) {
			strcpy(tmpBuf, T("Set hidden ssid failed!"));
			goto setErr_advance;
		}
	}

	strDtim = websGetVar(wp, T("dtimPeriod"), T(""));
	if (strDtim[0]) {
		if ( !string_to_dec(strDtim, &val) || val<1 || val>255) {
			strcpy(tmpBuf, T("Error! Invalid value of DTIM period."));
			goto setErr_advance;
		}
		if ( apmib_set(MIB_WLAN_DTIM_PERIOD, (void *)&val) == 0) {
			strcpy(tmpBuf, T("Set DTIM period failed!"));
			goto setErr_advance;
		}
	}

	strIapp = websGetVar(wp, T("iapp"), T(""));
	if (strIapp[0]) {
		if (!gstrcmp(strIapp, T("no")))
			val = 1;
		else if (!gstrcmp(strIapp, T("yes")))
			val = 0;
		else {
			strcpy(tmpBuf, T("Error! Invalid IAPP value."));
			goto setErr_advance;
		}
		if ( apmib_set(MIB_WLAN_IAPP_DISABLED, (void *)&val) == 0) {
			strcpy(tmpBuf, T("Set MIB_WLAN_IAPP_DISABLED failed!"));
			goto setErr_advance;
		}
	}
	strProtection= websGetVar(wp, T("11g_protection"), T(""));
	if (strProtection[0]) {
		if (!gstrcmp(strProtection, T("no")))
			val = 1;
		else if (!gstrcmp(strProtection, T("yes")))
			val = 0;
		else {
			strcpy(tmpBuf, T("Error! Invalid 11g Protection value."));
			goto setErr_advance;
		}
		if ( apmib_set(MIB_WLAN_PROTECTION_DISABLED, (void *)&val) == 0) {
			strcpy(tmpBuf, T("Set MIB_WLAN_PROTECTION_DISABLED failed!"));
			goto setErr_advance;
		}
	}
// for WMM
	strProtection= websGetVar(wp, T("wmm"), T(""));
	if (strProtection[0]) {
		if (!gstrcmp(strProtection, T("on")))
			val = 1;
		else if (!gstrcmp(strProtection, T("off")))
			val = 0;
		else {
			strcpy(tmpBuf, T("Error! Invalid WMM value."));
			goto setErr_advance;
		}
		if ( apmib_set(MIB_WLAN_WMM_ENABLED, (void *)&val) == 0) {
			strcpy(tmpBuf, T("Set MIB_WLAN_WMM_ENABLED failed!"));
			goto setErr_advance;
		}
	}
	
	strTurbo = websGetVar(wp, T("turbo"), T(""));
	if (strTurbo[0]) {
		if (!gstrcmp(strTurbo, T("off")))
			val = 2;
		else if (!gstrcmp(strTurbo, T("always")))
			val = 1;
		else if (!gstrcmp(strTurbo, T("auto")))
			val = 0;
		else {
			strcpy(tmpBuf, T("Error! Invalid turbo mode value."));
			goto setErr_advance;
		}
		if ( apmib_set(MIB_TURBO_MODE, (void *)&val) == 0) {
			strcpy(tmpBuf, T("Set MIB_TURBO_MODE failed!"));
			goto setErr_advance;
		}
	}

	strPower= websGetVar(wp, T("RFPower"), T(""));
	if (strPower[0]) {		
		if (!gstrcmp(strPower, T("0")))
			val = 0;
		else if (!gstrcmp(strPower, T("1")))
			val = 1;
		else if (!gstrcmp(strPower, T("2")))
			val = 2;
		else if (!gstrcmp(strPower, T("3")))
			val = 3;
		else if (!gstrcmp(strPower, T("4")))
			val = 4;
		else {
			strcpy(tmpBuf, T("Error! Invalid RF output power value."));
			goto setErr_advance;
		}
		if ( apmib_set(MIB_WLAN_RF_POWER, (void *)&val) == 0) {
			strcpy(tmpBuf, T("Set MIB_WLAN_RF_POWER failed!"));
			goto setErr_advance;
		}
	}

#ifdef WIFI_SIMPLE_CONFIG
	update_wps_configured(1);
#endif

	return 0;
setErr_advance:
	return -1 ;		
}	
/////////////////////////////////////////////////////////////////////////////
void formAdvanceSetup(webs_t wp, char_t *path, char_t *query)
{

	char tmpBuf[100];
	char_t *submitUrl;

	if(advanceHander(wp ,tmpBuf) < 0)
		goto setErr_end;
	apmib_update_web(CURRENT_SETTING);

#ifndef NO_ACTION
	run_init_script("bridge");
#endif

	submitUrl = websGetVar(wp, T("submit-url"), T(""));   // hidden page

//	websRedirect(wp, submitUrl);
	OK_MSG(submitUrl);
  	return;

setErr_end:
	ERR_MSG(tmpBuf);
}

/////////////////////////////////////////////////////////////////////////////
int wirelessClientList(int eid, webs_t wp, int argc, char_t **argv)
{
	int nBytesSent=0, i, found=0;
	WLAN_STA_INFO_Tp pInfo;
	char *buff;

	buff = calloc(1, sizeof(WLAN_STA_INFO_T) * (MAX_STA_NUM+1));
	if ( buff == 0 ) {
		printf("Allocate buffer failed!\n");
		return 0;
	}

	if ( getWlStaInfo(WLAN_IF,  (WLAN_STA_INFO_Tp)buff ) < 0 ) {
		printf("Read wlan sta info failed!\n");
		return 0;
	}

	for (i=1; i<=MAX_STA_NUM; i++) {
		pInfo = (WLAN_STA_INFO_Tp)&buff[i*sizeof(WLAN_STA_INFO_T)];
		if (pInfo->aid && (pInfo->flag & STA_INFO_FLAG_ASOC)) {
			nBytesSent += websWrite(wp,
#ifdef NEW_STA_INFO
	   		T("<tr bgcolor=#b7b7b7><td><font size=2>%02x:%02x:%02x:%02x:%02x:%02x</td>"
			"<td><font size=2>%d</td>"
	     		"<td><font size=2>%d</td>"
			"<td><font size=2>%d%s</td>"
			"<td><font size=2>%s</td>"
			"<td><font size=2>%d</td>"
			"<td><font size=2>%d</td>"
			"</tr>"),
#else			
	   		T("<tr bgcolor=#b7b7b7><td><font size=2>%02x:%02x:%02x:%02x:%02x:%02x</td>"
			"<td><font size=2>%d</td>"
	     		"<td><font size=2>%d</td>"
			"<td><font size=2>%d%s</td>"
			"<td><font size=2>%s</td>"
			"<td><font size=2>%d</td>"		
			"</tr>"),
#endif // NEW_STA_INFO			
			
			pInfo->addr[0],pInfo->addr[1],pInfo->addr[2],pInfo->addr[3],pInfo->addr[4],pInfo->addr[5],
			pInfo->tx_packets, pInfo->rx_packets,
			pInfo->txOperaRates/2, ((pInfo->txOperaRates%2) ? ".5" : "" ),
			( (pInfo->flag & STA_INFO_FLAG_ASLEEP) ? "yes" : "no"),
			pInfo->expired_time/100
#ifdef NEW_STA_INFO
			,pInfo->link_time
#endif			
			);
			found++;
		}
	}
	if (found == 0) {
		nBytesSent += websWrite(wp,
#ifdef NEW_STA_INFO
	   		T("<tr bgcolor=#b7b7b7><td><font size=2>None</td>"
			"<td><font size=2>---</td>"
	     		"<td><font size=2>---</td>"
			"<td><font size=2>---</td>"
			"<td><font size=2>---</td>"
			"<td><font size=2>---</td>"
			"<td><font size=2>---</td>"
			"</tr>"));
#else		
	   		T("<tr bgcolor=#b7b7b7><td><font size=2>None</td>"
			"<td><font size=2>---</td>"
	     		"<td><font size=2>---</td>"
			"<td><font size=2>---</td>"
			"<td><font size=2>---</td>"
			"<td><font size=2>---</td>"
			"</tr>"));
#endif	// NEW_STA_INFO
	}

	free(buff);

	return nBytesSent;
}

/////////////////////////////////////////////////////////////////////////////
void formWirelessTbl(webs_t wp, char_t *path, char_t *query)
{
	char_t *submitUrl;

	submitUrl = websGetVar(wp, T("submit-url"), T(""));
	if (submitUrl[0])
		websRedirect(wp, submitUrl);
}


/////////////////////////////////////////////////////////////////////////////
void formWlSiteSurvey(webs_t wp, char_t *path, char_t *query)
{
 	char_t *submitUrl, *refresh, *connect, *strSel;
	int status, idx, encrypt;
	unsigned char res, *pMsg=NULL;
	int wait_time;
	char tmpBuf[100];

	submitUrl = websGetVar(wp, T("submit-url"), T(""));

	refresh = websGetVar(wp, T("refresh"), T(""));
	if ( refresh[0] ) {
		// issue scan request
		wait_time = 0;
		while (1) {
			if ( getWlSiteSurveyRequest(WLAN_IF,  &status) < 0 ) {
				strcpy(tmpBuf, T("Site-survey request failed!"));
				goto ss_err;
			}
			if (status != 0) {	// not ready
				if (wait_time++ > 5) {
					strcpy(tmpBuf, T("scan request timeout!"));
					goto ss_err;
				}
				sleep(1);
			}
			else
				break;
		}

		// wait until scan completely
		wait_time = 0;
		while (1) {
			res = 1;	// only request request status
			if ( getWlSiteSurveyResult(WLAN_IF, (SS_STATUS_Tp)&res) < 0 ) {
				strcpy(tmpBuf, T("Read site-survey status failed!"));
				free(pStatus);
				pStatus = NULL;
				goto ss_err;
			}
			if (res == 0xff) {   // in progress
				if (wait_time++ > 10) {
					strcpy(tmpBuf, T("scan timeout!"));
					free(pStatus);
					pStatus = NULL;
					goto ss_err;
				}
				sleep(1);
			}
			else
				break;
		}

		if (submitUrl[0])
			websRedirect(wp, submitUrl);

		return;
	}

	connect = websGetVar(wp, T("connect"), T(""));
	if ( connect[0] ) {
		strSel = websGetVar(wp, T("select"), T(""));
		if (strSel[0]) {
			unsigned char res;
			NETWORK_TYPE_T net;
			int chan;

			if (pStatus == NULL) {
				strcpy(tmpBuf, T("Please refresh again!"));
				goto ss_err;

			}
			sscanf(strSel, "sel%d", &idx);
			if ( idx >= pStatus->number ) { // invalid index
				strcpy(tmpBuf, T("Connect failed!"));
				goto ss_err;
			}

			// check encryption type match or not
			if ( !apmib_get( MIB_WLAN_ENCRYPT, (void *)&encrypt) ) {
				strcpy(tmpBuf, T("Check encryption error!"));
				goto ss_err;
			}
			else {
				// no encryption
				if (encrypt == ENCRYPT_DISABLED)
				{
					if (pStatus->bssdb[idx].bdCap & 0x00000010) {
						strcpy(tmpBuf, T("Encryption type mismatch!"));
						goto ss_err;
					}
					else
						; // success
				}
				// legacy encryption
				else if (encrypt == ENCRYPT_WEP)
				{
					if ((pStatus->bssdb[idx].bdCap & 0x00000010) == 0) {
						strcpy(tmpBuf, T("Encryption type mismatch!"));
						goto ss_err;
					}
					else if (pStatus->bssdb[idx].bdTstamp[0] != 0) {
						strcpy(tmpBuf, T("Encryption type mismatch!"));
						goto ss_err;
					}
					else
						; // success
				}
				// WPA/WPA2
				else
				{
					int isPSK, auth;
					apmib_get(MIB_WLAN_WPA_AUTH, (void *)&auth);
					if (auth == WPA_AUTH_PSK)
						isPSK = 1;
					else
						isPSK = 0;					
								
					if ((pStatus->bssdb[idx].bdCap & 0x00000010) == 0) {
						strcpy(tmpBuf, T("Encryption type mismatch!"));
						goto ss_err;
					}
					else if (pStatus->bssdb[idx].bdTstamp[0] == 0) {
						strcpy(tmpBuf, T("Encryption type mismatch!"));
						goto ss_err;
					}
					else if (encrypt == ENCRYPT_WPA) {
						if (((pStatus->bssdb[idx].bdTstamp[0] & 0x0000ffff) == 0) || 
								(isPSK && !(pStatus->bssdb[idx].bdTstamp[0] & 0x4000)) ||
								(!isPSK && (pStatus->bssdb[idx].bdTstamp[0] & 0x4000)) ) {						
						strcpy(tmpBuf, T("Encryption type mismatch!"));
						goto ss_err;
					}
					}
					else if (encrypt == ENCRYPT_WPA2) {
						if (((pStatus->bssdb[idx].bdTstamp[0] & 0xffff0000) == 0) ||
								(isPSK && !(pStatus->bssdb[idx].bdTstamp[0] & 0x40000000)) ||
								(!isPSK && (pStatus->bssdb[idx].bdTstamp[0] & 0x40000000)) ) {
							strcpy(tmpBuf, T("Encryption type mismatch!"));
							goto ss_err;
						}
					}	
					else
						; // success
				}
			}

			// Set SSID, network type to MIB
			memcpy(tmpBuf, pStatus->bssdb[idx].bdSsIdBuf, pStatus->bssdb[idx].bdSsId.Length);
			tmpBuf[pStatus->bssdb[idx].bdSsId.Length] = '\0';
			if ( apmib_set(MIB_WLAN_SSID, (void *)tmpBuf) == 0) {
				strcpy(tmpBuf, T("Set SSID error!"));
				goto ss_err;
			}

			if ( pStatus->bssdb[idx].bdCap & cESS )
				net = INFRASTRUCTURE;
			else
				net = ADHOC;
			
			if ( apmib_set(MIB_WLAN_NETWORK_TYPE, (void *)&net) == 0) {
				strcpy(tmpBuf, T("Set MIB_WLAN_NETWORK_TYPE failed!"));
				goto ss_err;
			}

			if (net == ADHOC) {
				chan = pStatus->bssdb[idx].ChannelNumber;
				if ( apmib_set( MIB_WLAN_CHAN_NUM, (void *)&chan) == 0) {
   					strcpy(tmpBuf, T("Set channel number error!"));
					goto ss_err;
				}
			}

			apmib_update_web(CURRENT_SETTING);

			res = idx;
			wait_time = 0;
			while (1) {
				if ( getWlJoinRequest(WLAN_IF, &pStatus->bssdb[idx], &res) < 0 ) {
					strcpy(tmpBuf, T("Join request failed!"));
					goto ss_err;
				}
				if ( res == 1 ) { // wait
					if (wait_time++ > 5) {
						strcpy(tmpBuf, T("connect-request timeout!"));
						goto ss_err;
					}
					sleep(1);
					continue;
				}
				break;
			}

			if ( res == 2 ) // invalid index
				pMsg = "Connect failed!";
			else {
				wait_time = 0;
				while (1) {
					if ( getWlJoinResult(WLAN_IF, &res) < 0 ) {
						strcpy(tmpBuf, T("Get Join result failed!"));
						goto ss_err;
					}
					if ( res != 0xff ) { // completed
						if (wait_time++ > 10) {
							strcpy(tmpBuf, T("connect timeout!"));
							goto ss_err;
						}
						break;
					}
					sleep(1);
				}

				if ( res!=STATE_Bss && res!=STATE_Ibss_Idle && res!=STATE_Ibss_Active )
					pMsg = "Connect failed!";
				else {					
					status = 0;
					if (encrypt == ENCRYPT_WPA || encrypt == ENCRYPT_WPA2) {
						bss_info bss;
						wait_time = 0;
						while (wait_time++ < 5) {
							getWlBssInfo(WLAN_IF, &bss);
							if (bss.state == STATE_CONNECTED)			
								break;
							sleep(1);
						}
						if (wait_time >= 5)						
							status = 1;
					}
					if (status)
						pMsg = "Connect failed!";
					else
						pMsg = "Connect successfully!";
				}
			}
			OK_MSG1(pMsg, submitUrl);
		}
	}
	return;

ss_err:
	ERR_MSG(tmpBuf);
}

/////////////////////////////////////////////////////////////////////////////
int wlSiteSurveyTbl(int eid, webs_t wp, int argc, char_t **argv)
{
	int nBytesSent=0, i;
	BssDscr *pBss;
	char tmpBuf[100], ssidbuf[40], tmp1Buf[10], tmp2Buf[20];

	WLAN_MODE_T mode;
	bss_info bss;

	if (pStatus==NULL) {
		pStatus = calloc(1, sizeof(SS_STATUS_T));
		if ( pStatus == NULL ) {
			printf("Allocate buffer failed!\n");
			return 0;
		}
	}

	pStatus->number = 0; // request BSS DB

	if ( getWlSiteSurveyResult(WLAN_IF, pStatus) < 0 ) {
		//ERR_MSG("Read site-survey status failed!");
		websWrite(wp, "Read site-survey status failed!");
		free(pStatus); //sc_yang
		pStatus = NULL;
		return 0;
	}

	if ( !apmib_get( MIB_WLAN_MODE, (void *)&mode) ) {
		printf("Get MIB_WLAN_MODE MIB failed!");
		return 0;
	}

	if ( getWlBssInfo(WLAN_IF, &bss) < 0) {
		printf("Get bssinfo failed!");
		return 0;
	}

	nBytesSent += websWrite(wp, T("<tr>"
	"<td align=center width=\"30%%\" bgcolor=\"#808080\"><font size=\"2\"><b>SSID</b></font></td>\n"
	"<td align=center width=\"20%%\" bgcolor=\"#808080\"><font size=\"2\"><b>BSSID</b></font></td>\n"
	"<td align=center width=\"10%%\" bgcolor=\"#808080\"><font size=\"2\"><b>Channel</b></font></td>\n"
      	"<td align=center width=\"10%%\" bgcolor=\"#808080\"><font size=\"2\"><b>Type</b></font></td>\n"
      	"<td align=center width=\"10%%\" bgcolor=\"#808080\"><font size=\"2\"><b>Encrypt</b></font></td>\n"
	"<td align=center width=\"10%%\" bgcolor=\"#808080\"><font size=\"2\"><b>Signal</b></font></td>\n"));
	if ( mode == CLIENT_MODE )
		nBytesSent += websWrite(wp, T("<td align=center width=\"10%%\" bgcolor=\"#808080\"><font size=\"2\"><b>Select</b></font></td></tr>\n"));
	else
		nBytesSent += websWrite(wp, T("</tr>\n"));

	for (i=0; i<pStatus->number && pStatus->number!=0xff; i++) {
		pBss = &pStatus->bssdb[i];
		snprintf(tmpBuf, 200, T("%02x:%02x:%02x:%02x:%02x:%02x"),
			pBss->bdBssId[0], pBss->bdBssId[1], pBss->bdBssId[2],
			pBss->bdBssId[3], pBss->bdBssId[4], pBss->bdBssId[5]);

		memcpy(ssidbuf, pBss->bdSsIdBuf, pBss->bdSsId.Length);
		ssidbuf[pBss->bdSsId.Length] = '\0';

		if (pBss->network==BAND_11B)
			strcpy(tmp1Buf, T(" (B)"));
		else if (pBss->network==BAND_11G)
			strcpy(tmp1Buf, T(" (G)"));	
		else if (pBss->network==(BAND_11G|BAND_11B))
			strcpy(tmp1Buf, T(" (B+G)"));
		else
			strcpy(tmp1Buf, T(" (A)"));	

		if ((pBss->bdCap & cPrivacy) == 0)
			sprintf(tmp2Buf, "no");
		else {
			if (pBss->bdTstamp[0] == 0)
				sprintf(tmp2Buf, "WEP");
			else {
				int wpa_exist = 0, idx = 0;
				if (pBss->bdTstamp[0] & 0x0000ffff) {
					idx = sprintf(tmp2Buf, "WPA");
					if (((pBss->bdTstamp[0] & 0x0000f000) >> 12) == 0x4)
						idx += sprintf(tmp2Buf+idx, "-PSK");
					wpa_exist = 1;
				}
				if (pBss->bdTstamp[0] & 0xffff0000) {
					if (wpa_exist)
						idx += sprintf(tmp2Buf+idx, "/");
					idx += sprintf(tmp2Buf+idx, "WPA2");
					if (((pBss->bdTstamp[0] & 0xf0000000) >> 28) == 0x4)
						idx += sprintf(tmp2Buf+idx, "-PSK");
				}
			}
		}

		nBytesSent += websWrite(wp, T("<tr>"
			"<td align=left width=\"20%%\" bgcolor=\"#C0C0C0\"><pre><font size=\"2\">%s</td>\n"
			"<td align=center width=\"20%%\" bgcolor=\"#C0C0C0\"><font size=\"2\">%s</td>\n"
			"<td align=center width=\"10%%\" bgcolor=\"#C0C0C0\"><font size=\"2\">%d%s</td>\n"     
      			"<td align=center width=\"10%%\" bgcolor=\"#C0C0C0\"><font size=\"2\">%s</td>\n"
			"<td align=center width=\"10%%\" bgcolor=\"#C0C0C0\"><font size=\"2\">%s</td>\n"
			"<td align=center width=\"10%%\" bgcolor=\"#C0C0C0\"><font size=\"2\">%d</td>\n"),
			ssidbuf, tmpBuf, pBss->ChannelNumber, tmp1Buf,			
			((pBss->bdCap & cIBSS) ? "Ad hoc" : "AP"), tmp2Buf, pBss->rssi);

		if ( mode == CLIENT_MODE )
			nBytesSent += websWrite(wp,
			T("<td align=center width=\"10%%\" bgcolor=\"#C0C0C0\"><input type=\"radio\" name="
			"\"select\" value=\"sel%d\" onClick=\"enableConnect()\"></td></tr>\n"), i);
		else
			nBytesSent += websWrite(wp, T("</tr>\n"));
	}

	return nBytesSent;
}


/////////////////////////////////////////////////////////////////////////////
void formWlWds(webs_t wp, char_t *path, char_t *query)
{
	char_t *strAddMac, *strDelMac, *strDelAllMac, *strVal, *submitUrl, *strEnabled;
	char tmpBuf[100];
	int entryNum, i, enabled;
	WDS_T macEntry;

	strAddMac = websGetVar(wp, T("addWdsMac"), T(""));
	strDelMac = websGetVar(wp, T("deleteSelWdsMac"), T(""));
	strDelAllMac = websGetVar(wp, T("deleteAllWdsMac"), T(""));
	strEnabled = websGetVar(wp, T("wlanWdsEnabled"), T(""));

	if (strAddMac[0]) {
		if ( !gstrcmp(strEnabled, T("ON")))
			enabled = 1;
		else
			enabled = 0;
		if ( apmib_set( MIB_WLAN_WDS_ENABLED, (void *)&enabled) == 0) {
  			strcpy(tmpBuf, T("Set enabled flag error!"));
			goto setErr_wds;
		}

		strVal = websGetVar(wp, T("mac"), T(""));
		if ( !strVal[0] )
			goto setWds_ret;

		if (strlen(strVal)!=12 || !string_to_hex(strVal, macEntry.macAddr, 12)) {
			strcpy(tmpBuf, T("Error! Invalid MAC address."));
			goto setErr_wds;
		}

		strVal = websGetVar(wp, T("comment"), T(""));
		if ( strVal[0] ) {
			if (strlen(strVal) > COMMENT_LEN-1) {
				strcpy(tmpBuf, T("Error! Comment length too long."));
				goto setErr_wds;
			}
			strcpy(macEntry.comment, strVal);
		}
		else
			macEntry.comment[0] = '\0';

		if ( !apmib_get(MIB_WLAN_WDS_NUM, (void *)&entryNum)) {
			strcpy(tmpBuf, T("Get entry number error!"));
			goto setErr_wds;
		}
		if ( (entryNum + 1) > MAX_WDS_NUM) {
			strcpy(tmpBuf, T("Cannot add new entry because table is full!"));
			goto setErr_wds;
		}

		// set to MIB. try to delete it first to avoid duplicate case
		apmib_set(MIB_WLAN_WDS_DEL, (void *)&macEntry);
		if ( apmib_set(MIB_WLAN_WDS_ADD, (void *)&macEntry) == 0) {
			strcpy(tmpBuf, T("Add table entry error!"));
			goto setErr_wds;
		}
	}

	/* Delete entry */
	if (strDelMac[0]) {
		if ( !apmib_get(MIB_WLAN_WDS_NUM, (void *)&entryNum)) {
			strcpy(tmpBuf, T("Get entry number error!"));
			goto setErr_wds;
		}
		for (i=entryNum; i>0; i--) {
			snprintf(tmpBuf, 20, "select%d", i);

			strVal = websGetVar(wp, tmpBuf, T(""));
			if ( !gstrcmp(strVal, T("ON")) ) {

				*((char *)&macEntry) = (char)i;
				if ( !apmib_get(MIB_WLAN_WDS, (void *)&macEntry)) {
					strcpy(tmpBuf, T("Get table entry error!"));
					goto setErr_wds;
				}
				if ( !apmib_set(MIB_WLAN_WDS_DEL, (void *)&macEntry)) {
					strcpy(tmpBuf, T("Delete table entry error!"));
					goto setErr_wds;
				}
			}
		}
	}

	/* Delete all entry */
	if ( strDelAllMac[0]) {
		if ( !apmib_set(MIB_WLAN_WDS_DELALL, (void *)&macEntry)) {
			strcpy(tmpBuf, T("Delete all table error!"));
			goto setErr_wds;
		}
	}

setWds_ret:
	apmib_update_web(CURRENT_SETTING);

#ifndef NO_ACTION
	run_init_script("bridge");
#endif

	submitUrl = websGetVar(wp, T("submit-url"), T(""));   // hidden page
	OK_MSG( submitUrl );
  	return;

setErr_wds:
	ERR_MSG(tmpBuf);
}


/////////////////////////////////////////////////////////////////////////////
int wlWdsList(int eid, webs_t wp, int argc, char_t **argv)
{
	int nBytesSent=0, entryNum, i;
	WDS_T entry;
	char tmpBuf[100];

	if ( !apmib_get(MIB_WLAN_WDS_NUM, (void *)&entryNum)) {
  		websError(wp, 400, T("Get table entry error!\n"));
		return -1;
	}

	nBytesSent += websWrite(wp, T("<tr>"
      	"<td align=center width=\"45%%\" bgcolor=\"#808080\"><font size=\"2\"><b>MAC Address</b></font></td>\n"
      	"<td align=center width=\"35%%\" bgcolor=\"#808080\"><font size=\"2\"><b>Comment</b></font></td>\n"
      	"<td align=center width=\"20%%\" bgcolor=\"#808080\"><font size=\"2\"><b>Select</b></font></td></tr>\n"));

	for (i=1; i<=entryNum; i++) {
		*((char *)&entry) = (char)i;
		if ( !apmib_get(MIB_WLAN_WDS, (void *)&entry))
			return -1;

		snprintf(tmpBuf, 100, T("%02x:%02x:%02x:%02x:%02x:%02x"),
			entry.macAddr[0], entry.macAddr[1], entry.macAddr[2],
			entry.macAddr[3], entry.macAddr[4], entry.macAddr[5]);

		nBytesSent += websWrite(wp, T("<tr>"
			"<td align=center width=\"45%%\" bgcolor=\"#C0C0C0\"><font size=\"2\">%s</td>\n"
      			"<td align=center width=\"35%%\" bgcolor=\"#C0C0C0\"><font size=\"2\">%s</td>\n"
       			"<td align=center width=\"20%%\" bgcolor=\"#C0C0C0\"><input type=\"checkbox\" name=\"select%d\" value=\"ON\"></td></tr>\n"),
				tmpBuf, entry.comment, i);
	}
	return nBytesSent;
}


/////////////////////////////////////////////////////////////////////////////
void formWdsEncrypt(webs_t wp, char_t *path, char_t *query)
{
   	char_t *strVal, *submitUrl;
	char tmpBuf[100];
	WDS_ENCRYPT_T encrypt;
	int intVal, keyLen=0, oldFormat, oldPskLen, len, i;
	char charArray[16]={'0' ,'1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
	char key[100];
	char varName[20];

	sprintf(varName, "encrypt%d", wlan_idx);
	strVal = websGetVar(wp, varName, T(""));
	if (strVal[0]) {
		encrypt = strVal[0] - '0';
		if (encrypt != WDS_ENCRYPT_DISABLED && encrypt != WDS_ENCRYPT_WEP64 &&
			encrypt != WDS_ENCRYPT_WEP128 && encrypt != WDS_ENCRYPT_TKIP &&
				encrypt != WDS_ENCRYPT_AES) {
 			strcpy(tmpBuf, T("encrypt value not validt!"));
			goto setErr_wdsEncrypt;
		}
		apmib_set( MIB_WLAN_WDS_ENCRYPT, (void *)&encrypt);
	}
	else
		apmib_get( MIB_WLAN_WDS_ENCRYPT, (void *)&encrypt);

	if (encrypt == WDS_ENCRYPT_WEP64 || encrypt == WDS_ENCRYPT_WEP128) {
		sprintf(varName, "format%d", wlan_idx);
		strVal = websGetVar(wp, varName, T(""));
		if (strVal[0]) {
			if (strVal[0]!='0' && strVal[0]!='1') {
				strcpy(tmpBuf, T("Invalid wep key format value!"));
				goto setErr_wdsEncrypt;
		}
			intVal = strVal[0] - '0';
			apmib_set( MIB_WLAN_WDS_WEP_FORMAT, (void *)&intVal);
		}
		else
			apmib_get( MIB_WLAN_WDS_WEP_FORMAT, (void *)&intVal);

		if (encrypt == WDS_ENCRYPT_WEP64)
			keyLen = WEP64_KEY_LEN;
		else if (encrypt == WDS_ENCRYPT_WEP128)
			keyLen = WEP128_KEY_LEN;

		if (intVal == 1) // hex
			keyLen <<= 1;

		sprintf(varName, "wepKey%d", wlan_idx);
		strVal = websGetVar(wp, varName, T(""));
		if  (strVal[0]) {
			if (strlen(strVal) != keyLen) {
				strcpy(tmpBuf, T("Invalid wep key length!"));
				goto setErr_wdsEncrypt;
		}
			if ( !isAllStar(strVal) ) {
				if (intVal == 0) { // ascii
					for (i=0; i<keyLen; i++) {
						key[i*2] = charArray[(strVal[i]>>4)&0xf];
						key[i*2+1] = charArray[strVal[i]&0xf];
				}
					key[i*2] = '\0';
			}
				else  // hex
					strcpy(key, strVal);
				apmib_set( MIB_WLAN_WDS_WEP_KEY, (void *)key);
			}
		}
	}
	if (encrypt == WDS_ENCRYPT_TKIP || encrypt == WDS_ENCRYPT_AES) {
		sprintf(varName, "pskFormat%d", wlan_idx);
		strVal = websGetVar(wp, varName, T(""));
		if (strVal[0]) {
			if (strVal[0]!='0' && strVal[0]!='1') {
				strcpy(tmpBuf, T("Invalid wep key format value!"));
				goto setErr_wdsEncrypt;
				}
			intVal = strVal[0] - '0';
			}
			else
			apmib_get( MIB_WLAN_WDS_PSK_FORMAT, (void *)&intVal);


		// remember current psk format and length to compare to default case "****"
		apmib_get(MIB_WLAN_WDS_PSK_FORMAT, (void *)&oldFormat);
		apmib_get(MIB_WLAN_WDS_PSK, (void *)tmpBuf);
		oldPskLen = strlen(tmpBuf);

		sprintf(varName, "pskValue%d", wlan_idx);
		strVal = websGetVar(wp, varName, T(""));
		len = strlen(strVal);
		if (len > 0 && oldFormat == intVal && len == oldPskLen ) {
			for (i=0; i<len; i++) {
				if ( strVal[i] != '*' )
				break;
			}
			if (i == len)
				goto save_wdsEcrypt;
		}
		if (intVal==1) { // hex
			if (len!=MAX_PSK_LEN || !string_to_hex(strVal, tmpBuf, MAX_PSK_LEN)) {
				strcpy(tmpBuf, T("Error! invalid psk value."));
				goto setErr_wdsEncrypt;
	}
				}
		else { // passphras
			if (len==0 || len > (MAX_PSK_LEN-1) ) {
				strcpy(tmpBuf, T("Error! invalid psk value."));
				goto setErr_wdsEncrypt;
			}
		}
		apmib_set( MIB_WLAN_WDS_PSK_FORMAT, (void *)&intVal);
		apmib_set( MIB_WLAN_WDS_PSK, (void *)strVal);
	}

save_wdsEcrypt:
	intVal = 1;
	apmib_set( MIB_WLAN_WDS_ENABLED, (void *)&intVal);

	apmib_update_web(CURRENT_SETTING);

#ifndef NO_ACTION
	run_init_script("bridge");
#endif

	submitUrl = websGetVar(wp, T("submit-url"), T(""));   // hidden page
	OK_MSG(submitUrl);

	return;

setErr_wdsEncrypt:
	ERR_MSG(tmpBuf);
}


/////////////////////////////////////////////////////////////////////////////
int wdsList(int eid, webs_t wp, int argc, char_t **argv)
{
	int nBytesSent=0, i;
	WDS_INFO_Tp pInfo;
	char *buff;

	buff = calloc(1, sizeof(WDS_INFO_T)*MAX_STA_NUM);
	if ( buff == 0 ) {
		printf("Allocate buffer failed!\n");
		return 0;
	}

	if ( getWdsInfo(WLAN_IF, buff) < 0 ) {
		printf("Read wlan sta info failed!\n");
		return 0;
	}

	for (i=0; i<MAX_WDS_NUM; i++) {
		pInfo = (WDS_INFO_Tp)&buff[i*sizeof(WDS_INFO_T)];

		if (pInfo->state == STATE_WDS_EMPTY)
			break;

		nBytesSent += websWrite(wp,
	   		"<tr bgcolor=#b7b7b7><td><font size=2>%02x:%02x:%02x:%02x:%02x:%02x</td>"
			"<td><font size=2>%d</td>"
	     		"<td><font size=2>%d</td>"
			"<td><font size=2>%d</td>"
			"<td><font size=2>%d%s</td>",
			pInfo->addr[0],pInfo->addr[1],pInfo->addr[2],pInfo->addr[3],pInfo->addr[4],pInfo->addr[5],
			pInfo->tx_packets, pInfo->tx_errors, pInfo->rx_packets,
			pInfo->txOperaRate/2, ((pInfo->txOperaRate%2) ? ".5" : "" ));
	}

	free(buff);

	return nBytesSent;
}

#ifdef WLAN_EASY_CONFIG
/////////////////////////////////////////////////////////////////////////////
void sigHandler_autoconf(int signo)
{
	int val, reinit=1;
	char tmpbuf[100];	
	
	apmib_get( MIB_WLAN_MODE, (void *)&val);	
	if (val == AP_MODE || val == AP_WDS_MODE) {	
		apmib_get(MIB_WLAN_EASYCFG_KEY, (void *)tmpbuf);	
		if (strlen(tmpbuf) > 0) // key already installed
			reinit = 0;		
	}

#ifdef WIFI_SIMPLE_CONFIG	
{
	#define REINIT_WEB_FILE		T("/tmp/reinit_web")
	struct stat status;

	if (stat(REINIT_WEB_FILE, &status) == 0) { // file existed
        unlink(REINIT_WEB_FILE);
		reinit = 0;		
	}
}
#endif
	
	if (reinit) { // re-init system
		wait_config = 1;
#ifndef NO_ACTION
		run_init_script("all");
#endif		
		wait_config = CONFIG_SUCCESS;
	}
	if (apmib_reinit() == 0) 
		printf(T("Re-initialize AP MIB failed!\n"));	
}

/////////////////////////////////////////////////////////////////////////////
void formAutoCfg(webs_t wp, char_t *path, char_t *query)
{
   	char_t *strVal, *submitUrl;
 	int isButtonPress=0, isSave=0, isDelete=0, isDoConfigButton=0, isDoConfigQuestion=0;
	int mode, val, isAP, mode_old, enable, enable_old, wlan_disabled, i, isAdhoc, first=0;
	char tmpBuf[200], wlan_interface_set[100]={0}, hashBuf[33];
	
	strVal = websGetVar(wp, T("cfgEnabled"), T(""));
	if ( !gstrcmp(strVal, T("ON")))
		enable = 1;
	else
		enable = 0;

	apmib_get( MIB_WLAN_EASYCFG_ENABLED, (void *)&enable_old);
	apmib_get( MIB_WLAN_DISABLED, (void *)&wlan_disabled);

	strVal = websGetVar(wp, T("buttonClicked"), T(""));
	if (strVal[0])
		isButtonPress = 1;
	else {
		strVal = websGetVar(wp, T("save"), T(""));
		if (strVal[0])
			isSave = 1;
		else {
			strVal = websGetVar(wp, T("deletekey"), T(""));
			if (strVal[0])
				isDelete = 1;
			else {
				strVal = websGetVar(wp, T("doConfigButton"), T(""));
				if (strVal[0])
					isDoConfigButton = 1;
				else {
					strVal = websGetVar(wp, T("doConfigQuestion"), T(""));
					if (strVal[0])
						isDoConfigQuestion = 1;		
					else {
						strcpy(tmpBuf, T("Error, no action is defined!"));
						goto setErr_autocfg;
					}
				}
			}
		}
	}

	apmib_get( MIB_WLAN_MODE, (void *)&val);
	if (val == AP_MODE || val == AP_WDS_MODE) 
		isAP = 1;
	else 
		isAP = 0;

	apmib_set( MIB_WLAN_EASYCFG_WLAN_MODE, (void *)&val);

	apmib_get( MIB_WLAN_EASYCFG_MODE, (void *)&mode_old);
	
	if (isAP && isDoConfigQuestion) {
		strcpy(tmpBuf, T("Error, invalid action request!"));
		goto setErr_autocfg;
	}

	if (!isAP && isButtonPress ) {
		strcpy(tmpBuf, T("Error, invalid action request!"));
		goto setErr_autocfg;
	}

	for (i=0; i<wlan_num; i++) {
		sprintf(tmpBuf, "wlan%d ", i);
		strcat(wlan_interface_set, tmpBuf);
	}

	strVal = websGetVar(wp, T("mode"), T(""));
	if ( strVal[0] ) {
		if (strVal[0]!= '1' && strVal[0]!= '2' && strVal[0]!= '3') {
  			strcpy(tmpBuf, T("Invalid mode value!"));
			goto setErr_autocfg;
		}
		mode = strVal[0] - '0';
	}
	else
		mode = mode_old;

	if (enable != enable_old) {
		int modify=0, aval, cipher;
		unsigned char tmp1[100], tmp2[100];
		
		apmib_set( MIB_WLAN_EASYCFG_ENABLED, (void *)&enable);
		
		apmib_get( MIB_WLAN_EASYCFG_KEY, (void *)&tmpBuf);	
		if (enable && strlen(tmpBuf) > 0) { /* key installed */
			/* see if current setting diff with AUTOCFG value. */
			/* if modify, flush AUTOCFG value */
			apmib_get( MIB_WLAN_WPA_AUTH, (void *)&val);			
			if (val != WPA_AUTH_PSK) 
				modify = 1;
		
			apmib_get( MIB_WLAN_EASYCFG_SSID, (void *)&tmp1);
			apmib_get( MIB_WLAN_SSID, (void *)&tmp2);		
			if ( gstrcmp(tmp1, tmp2))
				modify = 1;			
		
			if (!modify ) {		
				apmib_get( MIB_WLAN_ENCRYPT, (void *)&val);
				apmib_get( MIB_WLAN_EASYCFG_ALG_REQ, (void *)&aval);	
				apmib_get( MIB_WLAN_WPA_CIPHER_SUITE, (void *)&cipher);
				
				if ( !(val & ENCRYPT_WPA) && !(val & ENCRYPT_WPA2)) 
					modify = 1;		
				if (val & ENCRYPT_WPA) {
					if ((aval & ACF_ALGORITHM_WPA_TKIP) && !(cipher & WPA_CIPHER_TKIP))
						modify = 1;
					if ((aval & ACF_ALGORITHM_WPA_AES) && !(cipher & WPA_CIPHER_AES))
						modify = 1;					
				}
			 	if (val & ENCRYPT_WPA2) {
					if ((aval & ACF_ALGORITHM_WPA2_TKIP) && !(cipher & WPA_CIPHER_TKIP))
						modify = 1;
					if ((aval & ACF_ALGORITHM_WPA2_AES) && !(cipher & WPA_CIPHER_AES))
						modify = 1;					
				}
			}		
			if (!modify) {
				apmib_get( MIB_WLAN_EASYCFG_ROLE, (void *)&val);	
				if (isAP) {
					if (val != ROLE_SERVER)
						modify = 1;
				}
				else {					
					apmib_get( MIB_WLAN_NETWORK_TYPE, (void *)&isAdhoc);
					if (val == ROLE_SERVER)
						modify = 1;
					else {
						if ((val == ROLE_CLIENT) && isAdhoc)
							modify = 1;
						else if ((val == ROLE_ADHOC) && !isAdhoc)
							modify = 1;
					}
				}				
			}			
			
			if (modify) {
				tmpBuf[0] = '\0';
				apmib_set(MIB_WLAN_EASYCFG_KEY, (void *)tmpBuf);
				apmib_set(MIB_WLAN_EASYCFG_DIGEST, (void *)tmpBuf);	
			}
		}
	}

	if ((isDoConfigButton || isDoConfigQuestion) && !wlan_disabled) {
		if ((mode & MODE_QUESTION) && isDoConfigQuestion ) {
			MD5_CONTEXT md5ctx;
			unsigned char hash[16];
			int i;
			const char *hex = "0123456789abcdef";
			char *r;

			strVal = websGetVar(wp, T("firstCfg"), T(""));
			if ( !gstrcmp(strVal, T("ON")))
				first = 1;
			else
				first = 0;

			tmpBuf[0]='\0';
			strVal = websGetVar(wp, T("q1"), T(""));
			strcat(tmpBuf, strVal);
			strVal = websGetVar(wp, T("q1ans"), T(""));
			strcat(tmpBuf, strVal);

			strVal = websGetVar(wp, T("q2"), T(""));
			strcat(tmpBuf, strVal);
			strVal = websGetVar(wp, T("q2ans"), T(""));
			strcat(tmpBuf, strVal);

			MD5Init(&md5ctx);
			MD5Update(&md5ctx, tmpBuf, (unsigned int)strlen(tmpBuf));
			MD5Final(hash, &md5ctx);

			/*
 			 *  Prepare the resulting hash string
 			 */
   			for (i = 0, r = hashBuf; i < 16; i++) {
             		*r++ = toupper(hex[hash[i] >> 4]);
               		*r++ = toupper(hex[hash[i] & 0xF]);
   			}
			*r = '\0';
			apmib_get( MIB_WLAN_NETWORK_TYPE, (void *)&isAdhoc);
#if 0			
			if (!isAP && isAdhoc) {
				char tmpBuf1[100];
				apmib_get( MIB_WLAN_EASYCFG_KEY, (void *)tmpBuf1);
				apmib_get( MIB_WLAN_EASYCFG_DIGEST, (void *)tmpBuf);
				if (tmpBuf1[0] && tmpBuf[0] && strcmp(hashBuf, tmpBuf)) {
		  			strcpy(tmpBuf, T("The question selection or answer of Q&A mode is not matched with installed value!"));
					goto setErr_autocfg;					
				}				
			}
#endif			
		}
	}
	
	if (mode != mode_old)
		apmib_set( MIB_WLAN_EASYCFG_MODE, (void *)&mode);

	if (isDelete) {
		tmpBuf[0] = '\0';
		apmib_set(MIB_WLAN_EASYCFG_KEY, (void *)tmpBuf);
		apmib_set(MIB_WLAN_EASYCFG_DIGEST, (void *)tmpBuf);
	}

	if (enable != enable_old || mode != mode_old || isDelete) {
		apmib_update_web(CURRENT_SETTING);
#ifndef NO_ACTION
		if (!wlan_disabled) {	
			sprintf(tmpBuf, "%s/%s start %s %s", _CONFIG_SCRIPT_PATH, 
				_WLAN_APP_SCRIPT_PROG, wlan_interface_set, BRIDGE_IF);
			system( tmpBuf );			
			sleep(2);
		}
#endif		
	}
	
#ifndef NO_ACTION	
	if (isButtonPress && !wlan_disabled) {
		sprintf(tmpBuf, "%s/%s -w wlan%d -press_button", _CONFIG_SCRIPT_PATH, 
			_AUTO_CONFIG_DAEMON_PROG, wlan_idx);
		system( tmpBuf );
	}

	if ((isDoConfigButton || isDoConfigQuestion) && !wlan_disabled) {
		if ((mode & MODE_QUESTION) && isDoConfigQuestion ) {
			sprintf(tmpBuf, "%s/%s start %s %s %s", _CONFIG_SCRIPT_PATH,
				_WLAN_APP_SCRIPT_PROG, wlan_interface_set, BRIDGE_IF, hashBuf);
			if (first)
				strcat(tmpBuf, " qfirst");
			system( tmpBuf );				
			sleep(2);
		}
		else {
			
			sprintf(tmpBuf, "%s/%s -w wlan%d -press_button", _CONFIG_SCRIPT_PATH, 
				_AUTO_CONFIG_DAEMON_PROG, wlan_idx);
			system( tmpBuf );
		}

		wait_config = 1;		
		while (wait_config <= DO_CONFIG_WAIT_TIME &&
					wait_config != CONFIG_SUCCESS) {
			wait_config++;						
			sleep(1);			
		}
		
		submitUrl = websGetVar(wp, T("submit-url"), T(""));   // hidden page
		
		if (wait_config == CONFIG_SUCCESS) {
			OK_MSG1(T("Do Auto-Config successfully!"), submitUrl);
		}
		else {
			sprintf(tmpBuf, "%s/%s -w wlan%d -release_button", _CONFIG_SCRIPT_PATH, 
				_AUTO_CONFIG_DAEMON_PROG, wlan_idx);
			system( tmpBuf );
			
			OK_MSG1(T("Do Auto-Config failed!"), submitUrl);			
			
			if (!isAP) {
				sprintf(tmpBuf, "%s/%s start %s %s", _CONFIG_SCRIPT_PATH,
					_WLAN_APP_SCRIPT_PROG, wlan_interface_set, BRIDGE_IF);		
				system( tmpBuf );	
			}						
		}
		
		wait_config = CONFIG_SUCCESS;		

		return;
	}
#endif

	submitUrl = websGetVar(wp, T("submit-url"), T(""));   // hidden page
	
	if (wlan_disabled && (isButtonPress || isDoConfigButton || isDoConfigQuestion)) {
		OK_MSG1(T("The wireless interface is disabled, can't proceed the request!"), submitUrl);	
	}
	else {	
		if (isButtonPress) {
			OK_MSG1(T("Waiting for client Auto-Config request..."), submitUrl);
		}
		else {		
			OK_MSG(submitUrl);
		}
	}
	return;

setErr_autocfg:
	ERR_MSG(tmpBuf);
}
#endif // WLAN_EASY_CONFIG


#ifdef WIFI_SIMPLE_CONFIG
#ifndef WLAN_EASY_CONFIG
void sigHandler_autoconf(int signo)
{
	#define REINIT_WEB_FILE		T("/tmp/reinit_web")
	struct stat status;
	int reinit=1;

	if (stat(REINIT_WEB_FILE, &status) == 0) { // file existed
        unlink(REINIT_WEB_FILE);
		reinit = 0;		
	}	
	if (reinit) { // re-init system
#ifndef NO_ACTION
		run_init_script("all");
#endif		
	}
	apmib_reinit();
}
#endif //!WLAN_EASY_CONFIG

static void update_wps_configured(int reset_flag)
{
	int is_configured, encrypt1, encrypt2, auth, disabled, iVal, format, shared_type;
	char ssid1[100];
	unsigned char tmpbuf[100];	
	
	if (wps_config_info.caller_id == CALLED_FROM_WLANHANDLER) {
		apmib_get(MIB_WLAN_SSID, (void *)ssid1);
		apmib_get(MIB_WLAN_MODE, (void *)&iVal);
		if (strcmp(ssid1, wps_config_info.ssid) || (iVal != wps_config_info.wlan_mode)) {
			apmib_set(MIB_WSC_SSID, (void *)ssid1);
			goto configuration_changed;
		}

		return;
	}
	else if (wps_config_info.caller_id == CALLED_FROM_ADVANCEHANDLER) {
		apmib_get(MIB_WLAN_AUTH_TYPE, (void *)&shared_type);
		apmib_get(MIB_WLAN_ENCRYPT, (void *)&encrypt1);
		if (encrypt1 == ENCRYPT_WEP && 
			shared_type != wps_config_info.shared_type) {
			if (shared_type == AUTH_OPEN || shared_type == AUTH_BOTH) {
				if (wps_config_info.shared_type == AUTH_SHARED) {
					auth = WSC_AUTH_OPEN;
					apmib_set(MIB_WSC_AUTH, (void *)&auth);
					goto configuration_changed;
				}
			}
			else {
				if (wps_config_info.shared_type == AUTH_OPEN ||
					wps_config_info.shared_type == AUTH_BOTH) {
					auth = WSC_AUTH_SHARED;
					apmib_set(MIB_WSC_AUTH, (void *)&auth);
					goto configuration_changed;
				}
			}
		}

		return;
	}

	apmib_get(MIB_WLAN_ENCRYPT, (void *)&encrypt1);
	if (encrypt1 == ENCRYPT_DISABLED) {
		auth = WSC_AUTH_OPEN;
		encrypt2 = WSC_ENCRYPT_NONE;
	}
	else if (encrypt1 == ENCRYPT_WEP) {
		apmib_get(MIB_WLAN_AUTH_TYPE, (void *)&shared_type);
		if (shared_type == AUTH_OPEN || shared_type == AUTH_BOTH)
			auth = WSC_AUTH_OPEN;
		else
			auth = WSC_AUTH_SHARED;
		encrypt2 = WSC_ENCRYPT_WEP;		
	}
	else if (encrypt1 == ENCRYPT_WPA) {
		auth = WSC_AUTH_WPAPSK;
		apmib_get(MIB_WLAN_WPA_CIPHER_SUITE, (void *)&encrypt1);
		if (encrypt1 == WPA_CIPHER_TKIP)
			encrypt2 = WSC_ENCRYPT_TKIP;		
		else if (encrypt1 == WPA_CIPHER_AES)
			encrypt2 = WSC_ENCRYPT_AES;		
		else 
			encrypt2 = WSC_ENCRYPT_TKIPAES;				
	}
	else if (encrypt1 == ENCRYPT_WPA2) {
		auth = WSC_AUTH_WPA2PSK;
		apmib_get(MIB_WLAN_WPA2_CIPHER_SUITE, (void *)&encrypt1);
		if (encrypt1 == WPA_CIPHER_TKIP)
			encrypt2 = WSC_ENCRYPT_TKIP;		
		else if (encrypt1 == WPA_CIPHER_AES)
			encrypt2 = WSC_ENCRYPT_AES;		
		else 
			encrypt2 = WSC_ENCRYPT_TKIPAES;				
	}
	else {
		auth = WSC_AUTH_WPA2PSKMIXED;
		encrypt2 = WSC_ENCRYPT_TKIPAES;			
	}
	apmib_set(MIB_WSC_AUTH, (void *)&auth);
	apmib_set(MIB_WSC_ENC, (void *)&encrypt2);

	apmib_get(MIB_WLAN_ENCRYPT, (void *)&encrypt1);
	if (encrypt1 == ENCRYPT_WPA || encrypt1 == ENCRYPT_WPA2 || encrypt1 == ENCRYPT_WPA2_MIXED) {
		apmib_get(MIB_WLAN_WPA_AUTH, (void *)&format);
		if (format & 2) { // PSK
			apmib_get(MIB_WLAN_WPA_PSK, (void *)tmpbuf);
			apmib_set(MIB_WSC_PSK, (void *)tmpbuf);					
		}		
	}
	if (reset_flag) {
		reset_flag = 0;
		apmib_set(MIB_WSC_CONFIG_BY_EXT_REG, (void *)&reset_flag);		
	}	

	if (wps_config_info.caller_id == CALLED_FROM_WEPHANDLER) {
		apmib_get(MIB_WLAN_ENCRYPT, (void *)&auth);
		if (wps_config_info.auth != auth)
			goto configuration_changed;

		apmib_get(MIB_WLAN_WEP, (void *)&encrypt2);
		if (wps_config_info.wep_enc != encrypt2)
			goto configuration_changed;
		
		apmib_get(MIB_WLAN_WEP_DEFAULT_KEY, (void *)&iVal);
		if (wps_config_info.KeyId != iVal)
			goto configuration_changed;
		
		apmib_get(MIB_WLAN_WEP64_KEY1, (void *)tmpbuf);
		if (strcmp(wps_config_info.wep64Key1, tmpbuf))
			goto configuration_changed;

		apmib_get(MIB_WLAN_WEP64_KEY2, (void *)tmpbuf);
		if (strcmp(wps_config_info.wep64Key2, tmpbuf))
			goto configuration_changed;

		apmib_get(MIB_WLAN_WEP64_KEY3, (void *)tmpbuf);
		if (strcmp(wps_config_info.wep64Key3, tmpbuf))
			goto configuration_changed;

		apmib_get(MIB_WLAN_WEP64_KEY4, (void *)tmpbuf);
		if (strcmp(wps_config_info.wep64Key4, tmpbuf))
			goto configuration_changed;

		apmib_get(MIB_WLAN_WEP128_KEY1, (void *)tmpbuf);
		if (strcmp(wps_config_info.wep128Key1, tmpbuf))
			goto configuration_changed;

		apmib_get(MIB_WLAN_WEP128_KEY2, (void *)tmpbuf);
		if (strcmp(wps_config_info.wep128Key2, tmpbuf))
			goto configuration_changed;

		apmib_get(MIB_WLAN_WEP128_KEY3, (void *)tmpbuf);
		if (strcmp(wps_config_info.wep128Key3, tmpbuf))
			goto configuration_changed;

		apmib_get(MIB_WLAN_WEP128_KEY4, (void *)tmpbuf);
		if (strcmp(wps_config_info.wep128Key4, tmpbuf))
			goto configuration_changed;

		return;
	}
	else if (wps_config_info.caller_id == CALLED_FROM_WPAHANDLER) {
		apmib_get(MIB_WLAN_ENCRYPT, (void *)&auth);
		if (wps_config_info.auth != auth)
			goto configuration_changed;
		
		apmib_get(MIB_WLAN_WPA_CIPHER_SUITE, (void *)&encrypt1);
		if (wps_config_info.wpa_enc != encrypt1)
			goto configuration_changed;
		
		apmib_get(MIB_WLAN_WPA2_CIPHER_SUITE, (void *)&encrypt2);
		if (wps_config_info.wpa2_enc != encrypt2)
			goto configuration_changed;
		
		apmib_get(MIB_WLAN_WPA_PSK, (void *)tmpbuf);
		if (strcmp(wps_config_info.wpaPSK, tmpbuf))
			goto configuration_changed;

		return;
	}
	else
		return;
	
configuration_changed:	
	reset_flag = 0;
	apmib_set(MIB_WSC_CONFIG_BY_EXT_REG, (void *)&reset_flag);
	apmib_get(MIB_WSC_DISABLE, (void *)&disabled);	
	apmib_get(MIB_WSC_CONFIGURED, (void *)&is_configured);
	if (!is_configured && !disabled) {
		is_configured = 1;
		apmib_set(MIB_WSC_CONFIGURED, (void *)&is_configured);
	}
}

#if 0
static void convert_hex_to_ascii(unsigned long code, char *out)
{
	*out++ = '0' + ((code / 10000000) % 10);  
	*out++ = '0' + ((code / 1000000) % 10);
	*out++ = '0' + ((code / 100000) % 10);
	*out++ = '0' + ((code / 10000) % 10);
	*out++ = '0' + ((code / 1000) % 10);
	*out++ = '0' + ((code / 100) % 10);
	*out++ = '0' + ((code / 10) % 10);
	*out++ = '0' + ((code / 1) % 10);
	*out = '\0';
}

static int compute_pin_checksum(unsigned long int PIN)
{
	unsigned long int accum = 0;
	int digit;
	
	PIN *= 10;
	accum += 3 * ((PIN / 10000000) % 10); 	
	accum += 1 * ((PIN / 1000000) % 10);
	accum += 3 * ((PIN / 100000) % 10);
	accum += 1 * ((PIN / 10000) % 10); 
	accum += 3 * ((PIN / 1000) % 10); 
	accum += 1 * ((PIN / 100) % 10); 
	accum += 3 * ((PIN / 10) % 10);

	digit = (accum % 10);
	return (10 - digit) % 10;
}
#endif

void formWsc(webs_t wp, char_t *path, char_t *query)
{
	char_t *strVal, *submitUrl;
	int intVal;
	char tmpbuf[200];
	int mode;
	
	apmib_get(MIB_WLAN_MODE, (void *)&mode);	
	submitUrl = websGetVar(wp, T("submit-url"), T(""));
	strVal = websGetVar(wp, T("triggerPBC"), T(""));
	if (strVal[0]) {
		apmib_get(MIB_WSC_DISABLE, (void *)&intVal);
		if (intVal) {
			intVal = 0;
			apmib_set(MIB_WSC_DISABLE, (void *)&intVal);
			apmib_update_web(CURRENT_SETTING);	// update to flash	
			system("echo 1 > /var/wps_start_pbc");
#ifndef NO_ACTION
			run_init_script("bridge");
#endif			
		}
		else {		
#ifndef NO_ACTION		
			sprintf(tmpbuf, "%s -sig_pbc", _WSC_DAEMON_PROG);
			system(tmpbuf);
#endif
		}
		OK_MSG2(START_PBC_MSG, ((mode==AP_MODE) ? "client" : "AP"), submitUrl);
		return;
	}

	strVal = websGetVar(wp, T("triggerPIN"), T(""));
	if (strVal[0]) {
		int local_pin_changed = 0;		
		strVal = websGetVar(wp, T("localPin"), T(""));
		if (strVal[0]) {
			apmib_get(MIB_WSC_PIN, (void *)tmpbuf);
			if (strcmp(tmpbuf, strVal)) {
				apmib_set(MIB_WSC_PIN, (void *)strVal);
				local_pin_changed = 1;				
			}			
		}		
		apmib_get(MIB_WSC_DISABLE, (void *)&intVal);
		if (intVal) {
			char localpin[100];
			intVal = 0;			
			apmib_set(MIB_WSC_DISABLE, (void *)&intVal);
			apmib_update_web(CURRENT_SETTING);	// update to flash	
			system("echo 1 > /var/wps_start_pin");

#ifndef NO_ACTION
			if (local_pin_changed) {
				apmib_get(MIB_WSC_PIN, (void *)localpin);
				sprintf(tmpbuf, "echo %s > /var/wps_local_pin", localpin);
				system(tmpbuf);
			}
			run_init_script("bridge");			
#endif			
		}
		else {		
#ifndef NO_ACTION		
			if (local_pin_changed) {
				system("echo 1 > /var/wps_start_pin");
				
				apmib_update_web(CURRENT_SETTING);					
				run_init_script("bridge");
			}
			else {
				sprintf(tmpbuf, "%s -sig_start", _WSC_DAEMON_PROG);
				system(tmpbuf);
			}			
#endif
		}
		OK_MSG2(START_PIN_MSG, ((mode==AP_MODE) ? "client" : "AP"), submitUrl);
		return;
	}
	
	strVal = websGetVar(wp, T("setPIN"), T(""));
	if (strVal[0]) {		
		strVal = websGetVar(wp, T("peerPin"), T(""));
		if (strVal[0]) {
			apmib_get(MIB_WSC_DISABLE, (void *)&intVal);
			if (intVal) {
				intVal = 0;
				apmib_set(MIB_WSC_DISABLE, (void *)&intVal);
				apmib_update_web(CURRENT_SETTING);	

				sprintf(tmpbuf, "echo %s > /var/wps_peer_pin", strVal);
				system(tmpbuf);

#ifndef NO_ACTION
				run_init_script("bridge");
#endif					
			}
			else {			
#ifndef NO_ACTION
				sprintf(tmpbuf, "iwpriv %s set_mib pin=%s", WLAN_IF, strVal);
				system(tmpbuf);
#endif
			}
			OK_MSG1(SET_PIN_MSG, submitUrl);			
			return;
		}
	}

	strVal = websGetVar(wp, T("disableWPS"), T(""));
	if ( !gstrcmp(strVal, T("ON")))
		intVal = 1;
	else
		intVal = 0;
	apmib_set(MIB_WSC_DISABLE, (void *)&intVal);
	
	strVal = websGetVar(wp, T("localPin"), T(""));
	if (strVal[0])
		apmib_set(MIB_WSC_PIN, (void *)strVal);

//	update_wps_configured(0);
		
	apmib_update_web(CURRENT_SETTING);	// update to flash
	
#ifndef NO_ACTION
	run_init_script("bridge");
#endif

	OK_MSG(submitUrl);
}
////////////////////////////////////////////////////////////////////////
#endif // WIFI_SIMPLE_CONFIG


void formWlanRedirect(webs_t wp, char_t *path, char_t *query)
{
	char_t *redirectUrl;
	char_t *strWlanId;
	
        redirectUrl= websGetVar(wp, T("redirect-url"), T(""));   // hidden page
        strWlanId= websGetVar(wp, T("wlan_id"), T(""));   // hidden page
	if(strWlanId[0]){
		wlan_idx = atoi(strWlanId);
		sprintf(WLAN_IF, "wlan%d", wlan_idx);
	}

        if (redirectUrl[0])
                websRedirect(wp,redirectUrl);
}
#ifdef TLS_CLIENT
#define MAXFNAME	60
#undef WEB_PAGE_OFFSET
#define WEB_PAGE_OFFSET 0x10000

//#define DWORD_SWAP(v) (v)
//#define WORD_SWAP(v) (v)
#define __PACK__	__attribute__ ((packed))
char *tag="CERT";
/////////////////////////////////////////////////////////////////////////////
static int compress(char *inFile, char *outFile)
{
	char tmpBuf[100];

	//sprintf(tmpBuf, "bzip2 -9 -c %s > %s", inFile, outFile);
	sprintf(tmpBuf, "cat %s > %s", inFile, outFile);
	system(tmpBuf);
	return 0;
}

//////////////////////////////////////////////////////////////////////////////
#if 0
static unsigned char CHECKSUM(unsigned char *data, int len)
{
	int i;
	unsigned char sum=0;

	for (i=0; i<len; i++)
		sum += data[i];

	sum = ~sum + 1;
	return sum;
}
#endif

/////////////////////////////////////////////////////////////////////////////
#if 0
static int lookfor_cert_dir(FILE *lp, char *dirpath, int is_for_web)
{
	char file[MAXFNAME];
	char *p;
	struct stat sbuf;

	fseek(lp, 0L, SEEK_SET);
	dirpath[0] = '\0';

	while (fgets(file, sizeof(file), lp) != NULL) {
		if ((p = strchr(file, '\n')) || (p = strchr(file, '\r'))) {
			*p = '\0';
		}
		if (*file == '\0') {
			continue;
		}
		if (stat(file, &sbuf) == 0 && sbuf.st_mode & S_IFDIR) {
			continue;
		}
		if (is_for_web)
			p=strstr(file, "home.asp");

		else
			p=strrchr(file, '/');
		if (p) {

			*p = '\0';
			strcpy(dirpath, file);
// for debug
//printf("Found dir=%s\n", dirpath);
			return 0;
		}
	}
	//printf("error\n");
	return -1;
}
#endif
/////////////////////////////////////////////////////////////////////////////
static void strip_dirpath(char *file, char *dirpath)
{
	char *p, tmpBuf[MAXFNAME];

	if ((p=strstr(file, dirpath))) {
		strcpy(tmpBuf, &p[strlen(dirpath)]);
		strcpy(file, tmpBuf);
	}
// for debug
//printf("adding file %s\n", file);
}
int makeCertImage(char *outFile, char *fileList)
{
	int fh;
	struct stat sbuf;
	FILE *lp;
	char file[MAXFNAME];
	char tmpFile[100], dirpath[100];
	char buf[512];
	FILE_ENTRY_T entry;
	unsigned char	*p;
	int i, len, fd, nFile, pad=0;
	IMG_HEADER_T head;
	char *tmpFile1 = "/tmp/cert" ;
	
	fh = open(tmpFile1, O_RDWR|O_CREAT|O_TRUNC);
	if (fh == -1) {
		printf("Create output file error %s!\n", tmpFile1);
		return 0;
	}
	lseek(fh, 0L, SEEK_SET);

	if ((lp = fopen(fileList, "r")) == NULL) {
		printf("Can't open file list %s\n!", fileList);
		return 0;
	}
#if 0	
	if (lookfor_cert_dir(lp, dirpath, 0)<0) {
		printf("Can't find cert dir\n");
		fclose(lp);
		return 0;
	}
#else
	strcpy(dirpath, "/etc/1x");
#endif	
	fseek(lp, 0L, SEEK_SET);
	nFile = 0;
	while (fgets(file, sizeof(file), lp) != NULL) {
		if ((p = strchr(file, '\n')) || (p = strchr(file, '\r'))) {
			*p = '\0';
		}
		if (*file == '\0') {
			continue;
		}
		if (stat(file, &sbuf) == 0 && sbuf.st_mode & S_IFDIR) {
			continue;
		}

		if ((fd = open(file, O_RDONLY)) < 0) {
			printf("Can't open file %s\n", file);
			exit(1);
		}
		lseek(fd, 0L, SEEK_SET);

		strip_dirpath(file, dirpath);

		strcpy(entry.name, file);
#ifndef __mips__	
		entry.size = DWORD_SWAP(sbuf.st_size);
#else		
		entry.size = (sbuf.st_size);
#endif		

		if ( write(fh, (const void *)&entry, sizeof(entry))!=sizeof(entry) ) {
			printf("Write file failed!\n");
			return 0;
		}

		i = 0;
		while ((len = read(fd, buf, sizeof(buf))) > 0) {
			if ( write(fh, (const void *)buf, len)!=len ) {
				printf("Write file failed!\n");
				exit(1);
			}
			i += len;
		}
		close(fd);
		if ( i != sbuf.st_size ) {
			printf("Size mismatch in file %s!\n", file );
		}

		nFile++;
	}

	fclose(lp);
	close(fh);
	sync();

// for debug -------------
#if 0
sprintf(tmpFile, "cp %s web.lst -f", outFile);
system(tmpFile);
#endif
//-------------------------

	sprintf(tmpFile, "%sXXXXXX",  tmpFile1);
	mkstemp(tmpFile);

	if ( compress(tmpFile1, tmpFile) < 0) {
		printf("compress file error!\n");
		return 0;
	}

	// append header
	if (stat(tmpFile, &sbuf) != 0) {
		printf("Create file error!\n");
		return 0;
	}
	if((sbuf.st_size+1)%2)
		pad = 1;
	p = malloc(sbuf.st_size + 1 + pad);
	memset(p, 0 , sbuf.st_size + 1);
	if ( p == NULL ) {
		printf("allocate buffer failed!\n");
		return 0;
	}

	memcpy(head.signature, tag, 4);
	head.len = sbuf.st_size + 1 + pad;
#ifndef __mips__	
	head.len = DWORD_SWAP(head.len);
	head.startAddr = DWORD_SWAP(WEB_PAGE_OFFSET);
	head.burnAddr = DWORD_SWAP(WEB_PAGE_OFFSET);
#else
	head.len = (head.len);
	head.startAddr = (WEB_PAGE_OFFSET);
	head.burnAddr = (WEB_PAGE_OFFSET);
#endif		

	if ((fd = open(tmpFile, O_RDONLY)) < 0) {
		printf("Can't open file %s\n", tmpFile);
		return 0;
	}
	lseek(fd, 0L, SEEK_SET);
	if ( read(fd, p, sbuf.st_size) != sbuf.st_size ) {
		printf("read file error!\n");
		return 0;;
	}
	close(fd);

	p[sbuf.st_size + pad] = CHECKSUM(p, (sbuf.st_size+pad));

	fh = open(outFile, O_RDWR|O_CREAT|O_TRUNC);
	if (fh == -1) {
		printf("Create output file error %s!\n", outFile );
		return 0;
	}
#ifdef __mips__
	lseek(fh, CERT_PAGE_OFFSET , SEEK_SET);
#endif
	if ( write(fh, &head, sizeof(head)) != sizeof(head)) {
		printf("write header failed!\n");
		return 0;
	}

	if ( write(fh, p, (sbuf.st_size+1+pad) ) != (sbuf.st_size+1+pad)) {
		printf("write data failed!\n");
		return 0;
	}

	close(fh);
	chmod(outFile,  DEFFILEMODE);

	sync();

	free(p);
	unlink(tmpFile);

	return 0;
}


#define CERT_PATH "/etc/1x/"
void formCertUpload(webs_t wp, char_t * path, char_t * query)
{
    FILE *       fp;
    int          numWrite;
    char tmpBuf[200];
    int intVal, entryNum, i=0, add_entry=0, update_image=1;
    char_t *submitUrl, *strVal, *loadroot, *name, *loaduser, *strDelRoot, 
    		*strDelAllRoot,*strDelUser, *strDelAllUser, *strSelectCa;
    char fileName[50];
    int num_id, get_id, add_id, del_id, delall_id, max_num,index_id;
    CERTROOT_T rootEntry;
    CERTUSER_T userEntry;
    void *pEntry;

     	submitUrl = websGetVar(wp, T("url"), T(""));   // hidden page
     	loadroot =  websGetVar(wp, T("loadroot"), T("")); 
     	loaduser =  websGetVar(wp, T("loaduser"), T("")); 
     	name =  websGetVar(wp, T("name"), T(""));
     	strDelRoot =   websGetVar(wp, T("deleteSelRoot"), T(""));
     	strDelAllRoot =   websGetVar(wp, T("deleteAllRoot"), T(""));
	strDelUser =   websGetVar(wp, T("deleteSelUser"), T(""));
     	strDelAllUser =   websGetVar(wp, T("deleteAllUser"), T(""));     	
     	strSelectCa =   websGetVar(wp, T("selectca"), T("")); 
     	memset(&rootEntry, '\0', sizeof(rootEntry));
     	
     	if(loadroot[0] || strDelRoot[0] || strDelAllRoot[0] || strSelectCa[0]){
		num_id = MIB_CERTROOT_NUM;
		max_num = MAX_CERTROOT_NUM;
		add_id = MIB_CERTROOT_ADD;
		del_id = MIB_CERTROOT_DEL ;
		delall_id = MIB_CERTROOT_DELALL ;
		get_id = MIB_CERTROOT ;
		index_id = MIB_ROOT_IDX;
		memset(&rootEntry, '\0', sizeof(rootEntry));
		pEntry = (void *) & rootEntry ;
			
	}
	else if(loaduser[0] || strDelUser[0] || strDelAllUser[0]){
		num_id = MIB_CERTUSER_NUM;
		max_num = MAX_CERTUSER_NUM;
		add_id = MIB_CERTUSER_ADD;
		del_id = MIB_CERTUSER_DEL ;
		delall_id = MIB_CERTUSER_DELALL ;
		get_id = MIB_CERTUSER ;
		index_id = MIB_USER_IDX;
		memset(&userEntry, '\0', sizeof(userEntry));
		pEntry = (void *) & userEntry ;
	}
	else{
		strcpy(tmpBuf, "error handle\n");
		goto  ret_upload;
	}

	if(strSelectCa[0]){ //set ca index
		
		strVal = websGetVar(wp, "rootSelect", T(""));
		if ( !apmib_get(MIB_CERTROOT_NUM, (void *)&entryNum)) {
				strcpy(tmpBuf, T("Get entry number error!"));
				goto ret_upload;
		}
		if ( strVal[0] ) {
			intVal =  atoi(strVal) ;
			if ( !apmib_set(MIB_ROOT_IDX, (void *)&intVal)) {
				strcpy(tmpBuf, T("Set CA select error!"));
				goto ret_upload;
			}
			if( intVal <= entryNum){
				pEntry = (void *) &rootEntry ;
				*((char *)pEntry) = (char)intVal;
				if ( !apmib_get(MIB_CERTROOT, (void *)pEntry)){
					sprintf(tmpBuf, "Get Mib Root CA  entry %d error\n", intVal);
					goto ret_upload;      
				}
			}
			else{
					sprintf(tmpBuf, "invalid Root CA entry %d select\n",intVal );
					goto ret_upload;      
			}
		}
		strVal = websGetVar(wp, "userSelect", T(""));
		if ( !apmib_get(MIB_CERTUSER_NUM, (void *)&entryNum)) {
				strcpy(tmpBuf, T("Get entry number error!"));
				goto ret_upload;
		}
		if ( strVal[0] ) {
			intVal =  atoi(strVal) ;
			if ( !apmib_set(MIB_USER_IDX, (void *)&intVal)) {
				strcpy(tmpBuf, T("Set User select error!"));
				goto ret_upload;
			}
			if( intVal <= entryNum){
				pEntry = (void *) &userEntry ;
				*((char *)pEntry) = (char)intVal;
				if ( !apmib_get(MIB_CERTUSER, (void *)pEntry)){
					sprintf(tmpBuf, "Get Mib User entry entry %d error\n",i );
					goto ret_upload;      
				}
			}
			else{
					sprintf(tmpBuf, "invalid User entry select %d\n", i);
					goto ret_upload;      
			}
		}	
#if 0
		//printf(" ca files %s %s\n", rootEntry.comment, userEntry.comment); //for debug
		sprintf(tmpBuf, "openssl pkcs12 -des3 -in /etc/1x/%s.pfx -out /etc/1x/user.pem   -passout pass:realtek -passin pass:realtek", userEntry.comment);
		system(tmpBuf);
		sprintf(tmpBuf, "openssl x509 -inform PEM -outform DER -in /etc/1x/user.pem -out /etc/1x/user.der");
		system(tmpBuf);
		sprintf(tmpBuf, "openssl x509 -inform DER -in /etc/1x/%s.cer -outform PEM -out /etc/1x/root.pem", rootEntry.comment);
		system(tmpBuf);
#endif
		update_image=0;
	}
	
     	if(loadroot[0] || loaduser[0]){		//Add entry
		// get entry number to see if it exceeds max
		
		if ( !apmib_get(num_id, (void *)&intVal)) {
				strcpy(tmpBuf, T("Get entry number error!"));
				goto ret_upload;
		}
		if ( (intVal + 1) > max_num) {
			strcpy(tmpBuf, T("Cannot add new entry because table is full!"));
			goto ret_upload;
		}     		
		if(wp->lenPostData == 0){
			strcpy(tmpBuf, T("Error ! Upload file length is 0 !"));
			goto  ret_upload;
		 }
		 
		 for(i=1 ; i <= intVal ; i++) //check the duplicate entry
		 {
		 	*((char *)pEntry) = (char)i;
			if ( !apmib_get(get_id, (void *)pEntry)){
				sprintf(tmpBuf, "Get Mib CA entry %d error\n", i);
				goto ret_upload;      
			}
			if(loadroot[0] && !strcmp(rootEntry.comment,name)){
				sprintf(tmpBuf, "Error! Duplicate Root CA name %s with entry %d\n", name, i);
				goto ret_upload;
			}
			if(loaduser[0] && !strcmp(userEntry.comment,name)){
				sprintf(tmpBuf, "Error! Duplicate User CA name %s with entry %d\n", name, i);
				goto ret_upload;
			}
		 }
		 if(loaduser[0]){
			strVal = websGetVar(wp, "pass", T(""));
			if(strVal[0])
				strcpy(userEntry.pass, strVal);
		 }
		 if(loadroot[0]){
		     	strcpy(fileName, CERT_PATH);
		     	strcat(fileName, name);
			strcat(fileName,".cer");
			strcpy(rootEntry.comment, name);
		 }
		 else{
		     	strcpy(fileName, CERT_PATH);
		     	strcat(fileName, name);
		     	strcat(fileName, ".pfx");
		     	strcpy(userEntry.comment, name);
		 }  
		 if ((fp = fopen(fileName, "w+b")) != NULL) {
			numWrite = fwrite(wp->postData,1, wp->lenPostData, fp);
			if(numWrite < 0) perror("write error");
			if (numWrite == wp->lenPostData)
				sprintf(tmpBuf, T("Update successfully (size = %d bytes)!<br>"), wp->lenPostData);
			else
				sprintf(tmpBuf, T("Writesize=%d %dbytes."), wp->lenPostData, numWrite);
		 }
		 else {
			sprintf(tmpBuf, T("open file error"));
			goto ret_upload;
		 }
		    	
		fclose(fp);
		if ( apmib_set(add_id, (void *)pEntry) == 0) {
			strcpy(tmpBuf, T("Add table entry error!"));
			goto ret_upload;
		}
		add_entry =1 ;
		
    	}
    	/* Delete entry */
	if (strDelRoot[0] || strDelUser[0]) {
		if ( !apmib_get(num_id, (void *)&entryNum)) {
			strcpy(tmpBuf, T("Get entry number error!"));
			goto ret_upload;
		}

		strVal = websGetVar(wp, "selectcert", T(""));
		if ( strVal[0] ) {
			*((char *)pEntry) = atoi(strVal);
			if ( !apmib_get(get_id, (void *)pEntry)) {
				strcpy(tmpBuf, T("Get table entry error!"));
				goto ret_upload;
			}
			if ( !apmib_set(del_id, (void *)pEntry)) {
				strcpy(tmpBuf, T("Delete table entry error!"));
				goto ret_upload;
			}
		}
		if(strDelRoot[0])
			sprintf(tmpBuf, "rm -f %s%s.cer", CERT_PATH, rootEntry.comment);
		else			
			sprintf(tmpBuf, "rm -f %s%s.pfx", CERT_PATH, userEntry.comment);
		
		system(tmpBuf);
	}
	/* Delete all entry */
	if ( strDelAllRoot[0] || strDelAllUser[0]) {
		if ( !apmib_set(delall_id, pEntry)) {
			strcpy(tmpBuf, T("Delete all table error!"));
			goto ret_upload;
		}
		if(strDelAllRoot[0])
			system("rm -f /etc/1x/*.cer");
		else
			system("rm -f /etc/1x/*.pfx");
	}
	apmib_update_web(CURRENT_SETTING);	// update configuration to flash
	if(update_image){
		system("find   /etc/1x/*.pfx  -type f > /tmp/cert.list"); 
		system("find   /etc/1x/*.cer  -type f >> /tmp/cert.list"); 
#ifdef __mips__
		makeCertImage(FLASH_DEVICE_NAME, "/tmp/cert.list");
#else
		makeCertImage("cert.img", "/tmp/cert.list");
#endif
		system("rm -f /tmp/cert.list");

	}
#ifndef NO_ACTION
	else
		run_init_script("bridge");
#endif
		
	if(add_entry){
		OK_MSG1(tmpBuf, submitUrl);
	}
	else
	{
		if (submitUrl[0])
			websRedirect(wp, submitUrl);
		else
			websDone(wp, 200);
	}			
    return;

ret_upload:
    ERR_MSG(tmpBuf);
}

int certRootList(int eid, webs_t wp, int argc, char_t **argv)
{
	int	nBytesSent=0, entryNum, i;
	CERTROOT_T entry;

	if ( !apmib_get(MIB_CERTROOT_NUM, (void *)&entryNum)) {
  		websError(wp, 400, T("Get table entry error!\n"));
		return -1;
	}

	nBytesSent += websWrite(wp, T("<tr>"
      	"<td align=center width=\"30%%\" bgcolor=\"#808080\"><font size=\"2\"><b>Name</b></font></td>\n"
      	"<td align=center width=\"20%%\" bgcolor=\"#808080\"><font size=\"2\"><b>Select</b></font></td></tr>\n"));

	for (i=1; i<=entryNum; i++) {
		*((char *)&entry) = (char)i;
		if ( !apmib_get(MIB_CERTROOT, (void *)&entry))
			return -1;

		nBytesSent += websWrite(wp, T("<tr>"
			"<td align=center width=\"30%%\" bgcolor=\"#C0C0C0\"><font size=\"2\">%s</td>\n"
      			"<td align=center width=\"20%%\" bgcolor=\"#C0C0C0\"><input type=\"radio\" name=\"selectcert\" value=\"%d\" onClick=\"selectcaClick(this)\">"
      			"</td></tr>\n"), entry.comment, i);
	}
	return nBytesSent;
}

int certUserList(int eid, webs_t wp, int argc, char_t **argv)
{
	int	nBytesSent=0, entryNum, i;
	CERTUSER_T entry;

	if ( !apmib_get(MIB_CERTUSER_NUM, (void *)&entryNum)) {
  		websError(wp, 400, T("Get table entry error!\n"));
		return -1;
	}

	nBytesSent += websWrite(wp, T("<tr>"
      	"<td align=center width=\"30%%\" bgcolor=\"#808080\"><font size=\"2\"><b>Name</b></font></td>\n"
      	"<td align=center width=\"20%%\" bgcolor=\"#808080\"><font size=\"2\"><b>Select</b></font></td></tr>\n"));

	for (i=1; i<=entryNum; i++) {
		*((char *)&entry) = (char)i;
		if ( !apmib_get(MIB_CERTUSER, (void *)&entry))
			return -1;

		nBytesSent += websWrite(wp, T("<tr>"
			"<td align=center width=\"30%%\" bgcolor=\"#C0C0C0\"><font size=\"2\">%s</td>\n"
      			"<td align=center width=\"20%%\" bgcolor=\"#C0C0C0\"><input type=\"radio\" name=\"selectcert\" value=\"%d\" onClick=\"selectprClick(this)\"></td></tr>\n"), entry.comment, i);
	}
	return nBytesSent;
}
#endif
