/*
 * Note: this file originally auto-generated by mib2c using
 *        : mib2c.old-api.conf,v 1.4.2.2 2006/04/18 17:36:35 hardaker Exp $
 */

#include <net-snmp/net-snmp-config.h>
#include <net-snmp/net-snmp-includes.h>
#include <net-snmp/agent/net-snmp-agent-includes.h>
#include "ieee802dot11.h"

#include "apmib.h"
#include "mibtbl.h"

#define TABLE_SIZE 1

#include <unistd.h>
#include <netinet/in.h>
#include <sys/ioctl.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <signal.h>
#include <fcntl.h>
#include <errno.h>
#include <linux/wireless.h>
#include <linux/if_arp.h>
#include <linux/if_ether.h>
#include <linux/if_packet.h>
#include <time.h>
#include <sys/time.h>

#include <stdlib.h>
#include <stdio.h>
#include <string.h>



/*
 * ieee802dot11_variables_oid:
 *   this is the top level oid that we want to register under.  This
 *   is essentially a prefix, with the suffix appearing in the
 *   variable below.
 */

oid             ieee802dot11_variables_oid[] = { 1, 2, 840, 10036 };

/*
 * variable4 ieee802dot11_variables:
 *   this variable defines function callbacks and type return information 
 *   for the ieee802dot11 mib section 
 */

struct variable7 ieee802dot11_variables[] = {
    /*
     * magic number        , variable type , ro/rw , callback fn  , L, oidsuffix 
     */
#define DOT11RESOURCETYPEIDNAME		1
    {DOT11RESOURCETYPEIDNAME, ASN_OCTET_STR, RONLY, var_ieee802dot11, 3,
     {3, 1, 1}},

#define DOT11STATIONID		2
    {DOT11STATIONID, ASN_OCTET_STR, RWRITE, var_dot11StationConfigTable, 4,
     {1, 1, 1, 1}},
#define DOT11MEDIUMOCCUPANCYLIMIT		3
    {DOT11MEDIUMOCCUPANCYLIMIT, ASN_INTEGER, RWRITE,
     var_dot11StationConfigTable, 4, {1, 1, 1, 2}},
#define DOT11CFPOLLABLE		4
    {DOT11CFPOLLABLE, ASN_INTEGER, RONLY, var_dot11StationConfigTable, 4,
     {1, 1, 1, 3}},
#define DOT11CFPPERIOD		5
    {DOT11CFPPERIOD, ASN_INTEGER, RWRITE, var_dot11StationConfigTable, 4,
     {1, 1, 1, 4}},
#define DOT11CFPMAXDURATION		6
    {DOT11CFPMAXDURATION, ASN_INTEGER, RWRITE, var_dot11StationConfigTable,
     4, {1, 1, 1, 5}},
#define DOT11AUTHENTICATIONRESPONSETIMEOUT		7
    {DOT11AUTHENTICATIONRESPONSETIMEOUT, ASN_INTEGER, RWRITE,
     var_dot11StationConfigTable, 4, {1, 1, 1, 6}},
#define DOT11PRIVACYOPTIONIMPLEMENTED		8
    {DOT11PRIVACYOPTIONIMPLEMENTED, ASN_INTEGER, RONLY,
     var_dot11StationConfigTable, 4, {1, 1, 1, 7}},
#define DOT11POWERMANAGEMENTMODE		9
    {DOT11POWERMANAGEMENTMODE, ASN_INTEGER, RWRITE,
     var_dot11StationConfigTable, 4, {1, 1, 1, 8}},
#define DOT11DESIREDSSID		10
    {DOT11DESIREDSSID, ASN_OCTET_STR, RWRITE, var_dot11StationConfigTable,
     4, {1, 1, 1, 9}},
#define DOT11DESIREDBSSTYPE		11
    {DOT11DESIREDBSSTYPE, ASN_INTEGER, RWRITE, var_dot11StationConfigTable,
     4, {1, 1, 1, 10}},
#define DOT11OPERATIONALRATESET		12
    {DOT11OPERATIONALRATESET, ASN_OCTET_STR, RWRITE,
     var_dot11StationConfigTable, 4, {1, 1, 1, 11}},
#define DOT11BEACONPERIOD		13
    {DOT11BEACONPERIOD, ASN_INTEGER, RWRITE, var_dot11StationConfigTable,
     4, {1, 1, 1, 12}},
#define DOT11DTIMPERIOD		14
    {DOT11DTIMPERIOD, ASN_INTEGER, RWRITE, var_dot11StationConfigTable, 4,
     {1, 1, 1, 13}},
#define DOT11ASSOCIATIONRESPONSETIMEOUT		15
    {DOT11ASSOCIATIONRESPONSETIMEOUT, ASN_INTEGER, RWRITE,
     var_dot11StationConfigTable, 4, {1, 1, 1, 14}},
#define DOT11DISASSOCIATEREASON		16
    {DOT11DISASSOCIATEREASON, ASN_INTEGER, RONLY,
     var_dot11StationConfigTable, 4, {1, 1, 1, 15}},
#define DOT11DISASSOCIATESTATION		17
    {DOT11DISASSOCIATESTATION, ASN_OCTET_STR, RONLY,
     var_dot11StationConfigTable, 4, {1, 1, 1, 16}},
#define DOT11DEAUTHENTICATEREASON		18
    {DOT11DEAUTHENTICATEREASON, ASN_INTEGER, RONLY,
     var_dot11StationConfigTable, 4, {1, 1, 1, 17}},
#define DOT11DEAUTHENTICATESTATION		19
    {DOT11DEAUTHENTICATESTATION, ASN_OCTET_STR, RONLY,
     var_dot11StationConfigTable, 4, {1, 1, 1, 18}},
#define DOT11AUTHENTICATEFAILSTATUS		20
    {DOT11AUTHENTICATEFAILSTATUS, ASN_INTEGER, RONLY,
     var_dot11StationConfigTable, 4, {1, 1, 1, 19}},
#define DOT11AUTHENTICATEFAILSTATION		21
    {DOT11AUTHENTICATEFAILSTATION, ASN_OCTET_STR, RONLY,
     var_dot11StationConfigTable, 4, {1, 1, 1, 20}},
#define DOT11AUTHENTICATIONALGORITHMSINDEX		22
    {DOT11AUTHENTICATIONALGORITHMSINDEX, ASN_INTEGER, RONLY,
     var_dot11AuthenticationAlgorithmsTable, 4, {1, 2, 1, 1}},
#define DOT11AUTHENTICATIONALGORITHM		23
    {DOT11AUTHENTICATIONALGORITHM, ASN_INTEGER, RONLY,
     var_dot11AuthenticationAlgorithmsTable, 4, {1, 2, 1, 2}},
#define DOT11AUTHENTICATIONALGORITHMSENABLE		24
    {DOT11AUTHENTICATIONALGORITHMSENABLE, ASN_INTEGER, RWRITE,
     var_dot11AuthenticationAlgorithmsTable, 4, {1, 2, 1, 3}},
#define DOT11WEPDEFAULTKEYINDEX		25
    {DOT11WEPDEFAULTKEYINDEX, ASN_INTEGER, RONLY,
     var_dot11WEPDefaultKeysTable, 4, {1, 3, 1, 1}},
#define DOT11WEPDEFAULTKEYVALUE		26
    {DOT11WEPDEFAULTKEYVALUE, ASN_OCTET_STR, RWRITE,
     var_dot11WEPDefaultKeysTable, 4, {1, 3, 1, 2}},
#define DOT11WEPKEYMAPPINGINDEX		27
    {DOT11WEPKEYMAPPINGINDEX, ASN_INTEGER, RONLY,
     var_dot11WEPKeyMappingsTable, 4, {1, 4, 1, 1}},
#define DOT11WEPKEYMAPPINGADDRESS		28
    {DOT11WEPKEYMAPPINGADDRESS, ASN_OCTET_STR, RWRITE,
     var_dot11WEPKeyMappingsTable, 4, {1, 4, 1, 2}},
#define DOT11WEPKEYMAPPINGWEPON		29
    {DOT11WEPKEYMAPPINGWEPON, ASN_INTEGER, RWRITE,
     var_dot11WEPKeyMappingsTable, 4, {1, 4, 1, 3}},
#define DOT11WEPKEYMAPPINGVALUE		30
    {DOT11WEPKEYMAPPINGVALUE, ASN_OCTET_STR, RWRITE,
     var_dot11WEPKeyMappingsTable, 4, {1, 4, 1, 4}},
#define DOT11WEPKEYMAPPINGSTATUS		31
    {DOT11WEPKEYMAPPINGSTATUS, ASN_INTEGER, RWRITE,
     var_dot11WEPKeyMappingsTable, 4, {1, 4, 1, 5}},
#define DOT11PRIVACYINVOKED		32
    {DOT11PRIVACYINVOKED, ASN_INTEGER, RWRITE, var_dot11PrivacyTable, 4,
     {1, 5, 1, 1}},
#define DOT11WEPDEFAULTKEYID		33
    {DOT11WEPDEFAULTKEYID, ASN_INTEGER, RWRITE, var_dot11PrivacyTable, 4,
     {1, 5, 1, 2}},
#define DOT11WEPKEYMAPPINGLENGTH		34
    {DOT11WEPKEYMAPPINGLENGTH, ASN_INTEGER, RWRITE, var_dot11PrivacyTable,
     4, {1, 5, 1, 3}},
#define DOT11EXCLUDEUNENCRYPTED		35
    {DOT11EXCLUDEUNENCRYPTED, ASN_INTEGER, RWRITE, var_dot11PrivacyTable,
     4, {1, 5, 1, 4}},
#define DOT11WEPICVERRORCOUNT		36
    {DOT11WEPICVERRORCOUNT, ASN_COUNTER, RONLY, var_dot11PrivacyTable, 4,
     {1, 5, 1, 5}},
#define DOT11WEPEXCLUDEDCOUNT		37
    {DOT11WEPEXCLUDEDCOUNT, ASN_COUNTER, RONLY, var_dot11PrivacyTable, 4,
     {1, 5, 1, 6}},
#define DOT11MACADDRESS		38
    {DOT11MACADDRESS, ASN_OCTET_STR, RONLY, var_dot11OperationTable, 4,
     {2, 1, 1, 1}},
#define DOT11RTSTHRESHOLD		39
    {DOT11RTSTHRESHOLD, ASN_INTEGER, RWRITE, var_dot11OperationTable, 4,
     {2, 1, 1, 2}},
#define DOT11SHORTRETRYLIMIT		40
    {DOT11SHORTRETRYLIMIT, ASN_INTEGER, RWRITE, var_dot11OperationTable, 4,
     {2, 1, 1, 3}},
#define DOT11LONGRETRYLIMIT		41
    {DOT11LONGRETRYLIMIT, ASN_INTEGER, RWRITE, var_dot11OperationTable, 4,
     {2, 1, 1, 4}},
#define DOT11FRAGMENTATIONTHRESHOLD		42
    {DOT11FRAGMENTATIONTHRESHOLD, ASN_INTEGER, RWRITE,
     var_dot11OperationTable, 4, {2, 1, 1, 5}},
#define DOT11MAXTRANSMITMSDULIFETIME		43
    {DOT11MAXTRANSMITMSDULIFETIME, ASN_INTEGER, RWRITE,
     var_dot11OperationTable, 4, {2, 1, 1, 6}},
#define DOT11MAXRECEIVELIFETIME		44
    {DOT11MAXRECEIVELIFETIME, ASN_INTEGER, RWRITE, var_dot11OperationTable,
     4, {2, 1, 1, 7}},
#define DOT11MANUFACTURERID		45
    {DOT11MANUFACTURERID, ASN_OCTET_STR, RONLY, var_dot11OperationTable, 4,
     {2, 1, 1, 8}},
#define DOT11PRODUCTID		46
    {DOT11PRODUCTID, ASN_OCTET_STR, RONLY, var_dot11OperationTable, 4,
     {2, 1, 1, 9}},
#define DOT11TRANSMITTEDFRAGMENTCOUNT		47
    {DOT11TRANSMITTEDFRAGMENTCOUNT, ASN_COUNTER, RONLY,
     var_dot11CountersTable, 4, {2, 2, 1, 1}},
#define DOT11MULTICASTTRANSMITTEDFRAMECOUNT		48
    {DOT11MULTICASTTRANSMITTEDFRAMECOUNT, ASN_COUNTER, RONLY,
     var_dot11CountersTable, 4, {2, 2, 1, 2}},
#define DOT11FAILEDCOUNT		49
    {DOT11FAILEDCOUNT, ASN_COUNTER, RONLY, var_dot11CountersTable, 4,
     {2, 2, 1, 3}},
#define DOT11RETRYCOUNT		50
    {DOT11RETRYCOUNT, ASN_COUNTER, RONLY, var_dot11CountersTable, 4,
     {2, 2, 1, 4}},
#define DOT11MULTIPLERETRYCOUNT		51
    {DOT11MULTIPLERETRYCOUNT, ASN_COUNTER, RONLY, var_dot11CountersTable,
     4, {2, 2, 1, 5}},
#define DOT11FRAMEDUPLICATECOUNT		52
    {DOT11FRAMEDUPLICATECOUNT, ASN_COUNTER, RONLY, var_dot11CountersTable,
     4, {2, 2, 1, 6}},
#define DOT11RTSSUCCESSCOUNT		53
    {DOT11RTSSUCCESSCOUNT, ASN_COUNTER, RONLY, var_dot11CountersTable, 4,
     {2, 2, 1, 7}},
#define DOT11RTSFAILURECOUNT		54
    {DOT11RTSFAILURECOUNT, ASN_COUNTER, RONLY, var_dot11CountersTable, 4,
     {2, 2, 1, 8}},
#define DOT11ACKFAILURECOUNT		55
    {DOT11ACKFAILURECOUNT, ASN_COUNTER, RONLY, var_dot11CountersTable, 4,
     {2, 2, 1, 9}},
#define DOT11RECEIVEDFRAGMENTCOUNT		56
    {DOT11RECEIVEDFRAGMENTCOUNT, ASN_COUNTER, RONLY,
     var_dot11CountersTable, 4, {2, 2, 1, 10}},
#define DOT11MULTICASTRECEIVEDFRAMECOUNT		57
    {DOT11MULTICASTRECEIVEDFRAMECOUNT, ASN_COUNTER, RONLY,
     var_dot11CountersTable, 4, {2, 2, 1, 11}},
#define DOT11FCSERRORCOUNT		58
    {DOT11FCSERRORCOUNT, ASN_COUNTER, RONLY, var_dot11CountersTable, 4,
     {2, 2, 1, 12}},
#define DOT11TRANSMITTEDFRAMECOUNT		59
    {DOT11TRANSMITTEDFRAMECOUNT, ASN_COUNTER, RONLY,
     var_dot11CountersTable, 4, {2, 2, 1, 13}},
#define DOT11WEPUNDECRYPTABLECOUNT		60
    {DOT11WEPUNDECRYPTABLECOUNT, ASN_COUNTER, RONLY,
     var_dot11CountersTable, 4, {2, 2, 1, 14}},
#define DOT11GROUPADDRESSESINDEX		61
    {DOT11GROUPADDRESSESINDEX, ASN_INTEGER, RONLY,
     var_dot11GroupAddressesTable, 4, {2, 3, 1, 1}},
#define DOT11ADDRESS		62
    {DOT11ADDRESS, ASN_OCTET_STR, RWRITE, var_dot11GroupAddressesTable, 4,
     {2, 3, 1, 2}},
#define DOT11GROUPADDRESSESSTATUS		63
    {DOT11GROUPADDRESSESSTATUS, ASN_INTEGER, RWRITE,
     var_dot11GroupAddressesTable, 4, {2, 3, 1, 3}},
#define DOT11MANUFACTUREROUI		64
    {DOT11MANUFACTUREROUI, ASN_OCTET_STR, RONLY,
     var_dot11ResourceInfoTable, 5, {3, 1, 2, 1, 1}},
#define DOT11MANUFACTURERNAME		65
    {DOT11MANUFACTURERNAME, ASN_OCTET_STR, RONLY,
     var_dot11ResourceInfoTable, 5, {3, 1, 2, 1, 2}},
#define DOT11MANUFACTURERPRODUCTNAME		66
    {DOT11MANUFACTURERPRODUCTNAME, ASN_OCTET_STR, RONLY,
     var_dot11ResourceInfoTable, 5, {3, 1, 2, 1, 3}},
#define DOT11MANUFACTURERPRODUCTVERSION		67
    {DOT11MANUFACTURERPRODUCTVERSION, ASN_OCTET_STR, RONLY,
     var_dot11ResourceInfoTable, 5, {3, 1, 2, 1, 4}},
#define DOT11PHYTYPE		68
    {DOT11PHYTYPE, ASN_INTEGER, RONLY, var_dot11PhyOperationTable, 4,
     {4, 1, 1, 1}},
#define DOT11CURRENTREGDOMAIN		69
    {DOT11CURRENTREGDOMAIN, ASN_INTEGER, RWRITE,
     var_dot11PhyOperationTable, 4, {4, 1, 1, 2}},
#define DOT11TEMPTYPE		70
    {DOT11TEMPTYPE, ASN_INTEGER, RONLY, var_dot11PhyOperationTable, 4,
     {4, 1, 1, 3}},
#define DOT11CURRENTTXANTENNA		71
    {DOT11CURRENTTXANTENNA, ASN_INTEGER, RWRITE, var_dot11PhyAntennaTable,
     4, {4, 2, 1, 1}},
#define DOT11DIVERSITYSUPPORT		72
    {DOT11DIVERSITYSUPPORT, ASN_INTEGER, RONLY, var_dot11PhyAntennaTable,
     4, {4, 2, 1, 2}},
#define DOT11CURRENTRXANTENNA		73
    {DOT11CURRENTRXANTENNA, ASN_INTEGER, RWRITE, var_dot11PhyAntennaTable,
     4, {4, 2, 1, 3}},
#define DOT11NUMBERSUPPORTEDPOWERLEVELS		74
    {DOT11NUMBERSUPPORTEDPOWERLEVELS, ASN_INTEGER, RONLY,
     var_dot11PhyTxPowerTable, 4, {4, 3, 1, 1}},
#define DOT11TXPOWERLEVEL1		75
    {DOT11TXPOWERLEVEL1, ASN_INTEGER, RONLY, var_dot11PhyTxPowerTable, 4,
     {4, 3, 1, 2}},
#define DOT11TXPOWERLEVEL2		76
    {DOT11TXPOWERLEVEL2, ASN_INTEGER, RONLY, var_dot11PhyTxPowerTable, 4,
     {4, 3, 1, 3}},
#define DOT11TXPOWERLEVEL3		77
    {DOT11TXPOWERLEVEL3, ASN_INTEGER, RONLY, var_dot11PhyTxPowerTable, 4,
     {4, 3, 1, 4}},
#define DOT11TXPOWERLEVEL4		78
    {DOT11TXPOWERLEVEL4, ASN_INTEGER, RONLY, var_dot11PhyTxPowerTable, 4,
     {4, 3, 1, 5}},
#define DOT11TXPOWERLEVEL5		79
    {DOT11TXPOWERLEVEL5, ASN_INTEGER, RONLY, var_dot11PhyTxPowerTable, 4,
     {4, 3, 1, 6}},
#define DOT11TXPOWERLEVEL6		80
    {DOT11TXPOWERLEVEL6, ASN_INTEGER, RONLY, var_dot11PhyTxPowerTable, 4,
     {4, 3, 1, 7}},
#define DOT11TXPOWERLEVEL7		81
    {DOT11TXPOWERLEVEL7, ASN_INTEGER, RONLY, var_dot11PhyTxPowerTable, 4,
     {4, 3, 1, 8}},
#define DOT11TXPOWERLEVEL8		82
    {DOT11TXPOWERLEVEL8, ASN_INTEGER, RONLY, var_dot11PhyTxPowerTable, 4,
     {4, 3, 1, 9}},
#define DOT11CURRENTTXPOWERLEVEL		83
    {DOT11CURRENTTXPOWERLEVEL, ASN_INTEGER, RWRITE,
     var_dot11PhyTxPowerTable, 4, {4, 3, 1, 10}},
#define DOT11HOPTIME		84
    {DOT11HOPTIME, ASN_INTEGER, RONLY, var_dot11PhyFHSSTable, 4,
     {4, 4, 1, 1}},
#define DOT11CURRENTCHANNELNUMBER		85
    {DOT11CURRENTCHANNELNUMBER, ASN_INTEGER, RWRITE, var_dot11PhyFHSSTable,
     4, {4, 4, 1, 2}},
#define DOT11MAXDWELLTIME		86
    {DOT11MAXDWELLTIME, ASN_INTEGER, RONLY, var_dot11PhyFHSSTable, 4,
     {4, 4, 1, 3}},
#define DOT11CURRENTDWELLTIME		87
    {DOT11CURRENTDWELLTIME, ASN_INTEGER, RWRITE, var_dot11PhyFHSSTable, 4,
     {4, 4, 1, 4}},
#define DOT11CURRENTSET		88
    {DOT11CURRENTSET, ASN_INTEGER, RWRITE, var_dot11PhyFHSSTable, 4,
     {4, 4, 1, 5}},
#define DOT11CURRENTPATTERN		89
    {DOT11CURRENTPATTERN, ASN_INTEGER, RWRITE, var_dot11PhyFHSSTable, 4,
     {4, 4, 1, 6}},
#define DOT11CURRENTINDEX		90
    {DOT11CURRENTINDEX, ASN_INTEGER, RWRITE, var_dot11PhyFHSSTable, 4,
     {4, 4, 1, 7}},
#define DOT11CURRENTCHANNEL		91
    {DOT11CURRENTCHANNEL, ASN_INTEGER, RWRITE, var_dot11PhyDSSSTable, 4,
     {4, 5, 1, 1}},
#define DOT11CCAMODESUPPORTED		92
    {DOT11CCAMODESUPPORTED, ASN_INTEGER, RONLY, var_dot11PhyDSSSTable, 4,
     {4, 5, 1, 2}},
#define DOT11CURRENTCCAMODE		93
    {DOT11CURRENTCCAMODE, ASN_INTEGER, RWRITE, var_dot11PhyDSSSTable, 4,
     {4, 5, 1, 3}},
#define DOT11EDTHRESHOLD		94
    {DOT11EDTHRESHOLD, ASN_INTEGER, RWRITE, var_dot11PhyDSSSTable, 4,
     {4, 5, 1, 4}},
#define DOT11CCAWATCHDOGTIMERMAX		95
    {DOT11CCAWATCHDOGTIMERMAX, ASN_INTEGER, RWRITE, var_dot11PhyIRTable, 4,
     {4, 6, 1, 1}},
#define DOT11CCAWATCHDOGCOUNTMAX		96
    {DOT11CCAWATCHDOGCOUNTMAX, ASN_INTEGER, RWRITE, var_dot11PhyIRTable, 4,
     {4, 6, 1, 2}},
#define DOT11CCAWATCHDOGTIMERMIN		97
    {DOT11CCAWATCHDOGTIMERMIN, ASN_INTEGER, RWRITE, var_dot11PhyIRTable, 4,
     {4, 6, 1, 3}},
#define DOT11CCAWATCHDOGCOUNTMIN		98
    {DOT11CCAWATCHDOGCOUNTMIN, ASN_INTEGER, RWRITE, var_dot11PhyIRTable, 4,
     {4, 6, 1, 4}},
#define DOT11REGDOMAINSSUPPORTINDEX		99
    {DOT11REGDOMAINSSUPPORTINDEX, ASN_INTEGER, RONLY,
     var_dot11RegDomainsSupportedTable, 4, {4, 7, 1, 1}},
#define DOT11REGDOMAINSSUPPORTVALUE		100
    {DOT11REGDOMAINSSUPPORTVALUE, ASN_INTEGER, RONLY,
     var_dot11RegDomainsSupportedTable, 4, {4, 7, 1, 2}},
#define DOT11ANTENNALISTINDEX		101
    {DOT11ANTENNALISTINDEX, ASN_INTEGER, RONLY, var_dot11AntennasListTable,
     4, {4, 8, 1, 1}},
#define DOT11SUPPORTEDTXANTENNA		102
    {DOT11SUPPORTEDTXANTENNA, ASN_INTEGER, RWRITE,
     var_dot11AntennasListTable, 4, {4, 8, 1, 2}},
#define DOT11SUPPORTEDRXANTENNA		103
    {DOT11SUPPORTEDRXANTENNA, ASN_INTEGER, RWRITE,
     var_dot11AntennasListTable, 4, {4, 8, 1, 3}},
#define DOT11DIVERSITYSELECTIONRX		104
    {DOT11DIVERSITYSELECTIONRX, ASN_INTEGER, RWRITE,
     var_dot11AntennasListTable, 4, {4, 8, 1, 4}},
#define DOT11SUPPORTEDDATARATESTXINDEX		105
    {DOT11SUPPORTEDDATARATESTXINDEX, ASN_INTEGER, RONLY,
     var_dot11SupportedDataRatesTxTable, 4, {4, 9, 1, 1}},
#define DOT11SUPPORTEDDATARATESTXVALUE		106
    {DOT11SUPPORTEDDATARATESTXVALUE, ASN_INTEGER, RONLY,
     var_dot11SupportedDataRatesTxTable, 4, {4, 9, 1, 2}},
#define DOT11SUPPORTEDDATARATESRXINDEX		107
    {DOT11SUPPORTEDDATARATESRXINDEX, ASN_INTEGER, RONLY,
     var_dot11SupportedDataRatesRxTable, 4, {4, 10, 1, 1}},
#define DOT11SUPPORTEDDATARATESRXVALUE		108
    {DOT11SUPPORTEDDATARATESRXVALUE, ASN_INTEGER, RONLY,
     var_dot11SupportedDataRatesRxTable, 4, {4, 10, 1, 2}},
};


#define SIOCGSNMPMIB 0x8B3D
#define UNI_OID_LEN 5
#define MAX_DATA_SIZE MAX_OID_LEN * UNI_OID_LEN
#define IOCTL_SNMP(interface, oid, len, out, plen)  _ioctl_snmp(interface, oid, len, out, plen)
#define OID_TAIL(oid) oid + 4
#define OID_COUNT_LEN 2
#define NO_SUCH_INSTANCE() return NULL

static inline int
iw_get_ext(int                  skfd,           /* Socket to the kernel */
           char *               ifname,         /* Device name */
           int                  request,        /* WE ID */
           struct iwreq *       pwrq)           /* Fixed part of the request */
{
	/* Set device name */
	strncpy(pwrq->ifr_name, ifname, IFNAMSIZ);
	
	/* Do the request */
	return(ioctl(skfd, request, pwrq));
}

static int get_wlan_mib(char *interface, char *oid, unsigned char *out, u_long *len)
{
    int skfd;
    struct iwreq wrq;
    unsigned char data[MAX_DATA_SIZE];

    skfd = socket(AF_INET, SOCK_DGRAM, 0);

    /* Get wireless name */
    if ( iw_get_ext(skfd, interface, SIOCGIWNAME, &wrq) < 0)
      /* If no wireless name : no wireless extensions */
        return -1;

	strcpy(data, oid);
    wrq.u.data.pointer = (caddr_t)data;
    wrq.u.data.length = strlen(data);
    if (iw_get_ext(skfd, interface, SIOCGSNMPMIB, &wrq) < 0)
		return -1;
    close(skfd);
    
    memcpy(out, data, wrq.u.data.length);
    *len = wrq.u.data.length;	
	return 1;
}

void oid2str(char *str, oid *name, size_t oid_len){
	int i;
	int str_len;

	str_len = 0;
	for(i = 0; i < oid_len; i++ ) {
	    sprintf(str + str_len, "%d.", name[i]);
	    str_len += strlen(str + str_len);
	}
	str[str_len - 1] = '\0';
}

static int _ioctl_snmp(char *interface, oid *oid, size_t len, unsigned char *out, u_long *plen){
	unsigned char name[MAX_DATA_SIZE];
	
	oid2str(name, oid, len);
	return get_wlan_mib(interface, name, out, plen);
}



/*
 * (L = length of the oidsuffix) 
 */

/** Initializes the ieee802dot11 module */
void
init_ieee802dot11(void)
{

    DEBUGMSGTL(("ieee802dot11", "Initializing\n"));

    /*
     * register ourselves with the agent to handle our mib tree 
     */
    REGISTER_MIB("ieee802dot11", ieee802dot11_variables, variable7,
                 ieee802dot11_variables_oid);

    if ( apmib_init() == 0 ){
//		snmp_log(LOG_INFO, "ieee802dot11: init apmib failed\n");
    }
    else{
//		snmp_log(LOG_INFO, "ieee802dot11: success\n");
    }   
}   

int _translateWordToByte( u_char * ucString,int iLens )
{
	int i;
	u_char * pEnd;
	char pTmp[3] ="FF";
	
	pEnd = ucString;

	for(i=0 ; i < (iLens/2) ; i++ )
	{
		memcpy( pTmp,&ucString[i*2],2 );
		ucString[i] = strtol (pTmp,NULL,16);
	}
	return (iLens / 2) ;
}
/*
	translate a string for Rate setting to 2byte format
	to match Apmib format
*/
u_long _translateOperationRateTo8186( u_char * ucString,int iLens )
{
	int ret_val = 0;
	int i;
	u_long ul_ret = 0;

	for( i = 0 ; i < iLens ; i++ )
	{
		if( ucString[i] == 108 ) ul_ret |= TX_RATE_54M;
		if( ucString[i] == 96 )  ul_ret |= TX_RATE_48M;
		if( ucString[i] == 72 )  ul_ret |= TX_RATE_36M;
		if( ucString[i] == 48 )  ul_ret |= TX_RATE_24M;
		if( ucString[i] == 36 )  ul_ret |= TX_RATE_18M;
		if( ucString[i] == 24 )  ul_ret |= TX_RATE_12M;
		if( ucString[i] == 18 )  ul_ret |= TX_RATE_9M;
		if( ucString[i] == 12 )  ul_ret |= TX_RATE_6M;
		if( ucString[i] == 22 )  ul_ret |= TX_RATE_11M;
		if( ucString[i] == 10 )  ul_ret |= TX_RATE_5M;
		if( ucString[i] == 4 )   ul_ret |= TX_RATE_2M;
		if( ucString[i] == 2 )   ul_ret |= TX_RATE_1M;
	}

//	snmp_log(LOG_INFO, "translate: ul_ret = %x\n",ul_ret);
	return ul_ret;
}
int _translateOperationRateToIEEE( u_long rate_set,u_char * ret_value )
{
	int ret_val = 0;
	int i;

	snmp_log(LOG_INFO, "u_short rate_set = %x\n",rate_set);

	if( rate_set & TX_RATE_54M )
	{
		ret_value[ret_val] = 108;
		ret_val++;
	}
	if( rate_set & TX_RATE_48M)
	{
		ret_value[ret_val] = 96;
		ret_val++;
	}
	if( rate_set & TX_RATE_36M )
	{
		ret_value[ret_val] = 72;
		ret_val++;
	}
	if( rate_set & TX_RATE_24M )
	{
		ret_value[ret_val] = 48;
		ret_val++;
	}
	if( rate_set & TX_RATE_18M )
	{
		ret_value[ret_val] = 36;
		ret_val++;
	}
	if( rate_set & TX_RATE_12M )
	{
		ret_value[ret_val] = 24;
		ret_val++;
	}
	if( rate_set & TX_RATE_9M )
	{
		ret_value[ret_val] = 18;
		ret_val++;
	}
	if( rate_set & TX_RATE_6M )
	{
		ret_value[ret_val] = 12;
		ret_val++;
	}
	if( rate_set & TX_RATE_11M )
	{
		ret_value[ret_val] = 22;
		ret_val++;
	}
	if( rate_set & TX_RATE_5M )
	{
		ret_value[ret_val] = 10;
		ret_val++;
	}
	if( rate_set & TX_RATE_2M )
	{
		ret_value[ret_val] = 4;
		ret_val++;
	}
	if( rate_set & TX_RATE_1M )
	{
		ret_value[ret_val] = 2;
		ret_val++;
	}

	return ret_val;
}
	
/*  
 * var_ieee802dot11():
 *   This function is called every time the agent gets a request for
 *   a scalar variable that might be found within your mib section
 *   registered above.  It is up to you to do the right thing and
 *   return the correct value.
 *     You should also correct the value of "var_len" if necessary.
 *
 *   Please see the documentation for more information about writing
 *   module extensions, and check out the examples in the examples
 *   and mibII directories.
 */
unsigned char  *
var_ieee802dot11(struct variable *vp,
                 oid * name,
                 size_t *length,
                 int exact, size_t *var_len, WriteMethod ** write_method)
{
    /*
     * variables we may use later 
     */
	static unsigned char data[MAX_DATA_SIZE];
	u_long len;
	
	
    if (header_generic(vp, name, length, exact, var_len, write_method)
        == MATCH_FAILED)
        return NULL;

	if(IOCTL_SNMP("wlan0", OID_TAIL(name), 4, data, &len) == -1){
		//snmp_log(LOG_INFO, "var_ieee802dot11: IOCT_SNMP failed");
		return NULL;
	};
	

    switch (vp->magic) {
    case DOT11RESOURCETYPEIDNAME:
		*var_len = len - 1;
        return  (u_char *) data + 1;
    default:
        ERROR_MSG("var_ieee802dot11: Error!!!\n");
    }
    return NULL;
}




/*
 * var_dot11StationConfigTable():
 *   Handle this table separately from the scalar value case.
 *   The workings of this are basically the same as for var_ieee802dot11 above.
 */
unsigned char  *
var_dot11StationConfigTable(struct variable *vp,
                            oid * name,
                            size_t *length,
                            int exact,
                            size_t *var_len, WriteMethod ** write_method)
{
    /*
     * variables we may use later 
     */
    static u_long   ulong_ret;
    static u_short  ushort_ret;
	static unsigned char data[MAX_DATA_SIZE];
	static char string[10];
	static char rate_octet[16];
	static unsigned char mac_string[6];
	u_long table_size;
	u_long len;
	oid count_id[] = {6, 1};
	char			*ro_comm;	
	int i;

	if(IOCTL_SNMP("wlan0", count_id, OID_COUNT_LEN, data, &len) == -1){
//		snmp_log(LOG_INFO, "var_dot11StationConfigTable: IOCT_SNMP failed \n");
		return NULL;
	};

	table_size = *(data+1);

    if (header_simple_table
        (vp, name, length, exact, var_len, write_method, table_size)
        == MATCH_FAILED){
		
		return NULL;
    }

#define OID_STATIONCONFIG_LEN 5
	if(IOCTL_SNMP("wlan0", OID_TAIL(name), OID_STATIONCONFIG_LEN, data, &len) == -1){
//		snmp_log(LOG_INFO, "var_dot11StationConfigTable: IOCT_SNMP failed \n");
		return NULL;
	};

    switch (vp->magic) {
    case DOT11STATIONID:
        *write_method = write_dot11StationID;
        *var_len = 6;
		apmib_get(MIB_WLAN_MAC_ADDR,string);
        return (unsigned char *) string;
    case DOT11MEDIUMOCCUPANCYLIMIT:
        *write_method = write_dot11MediumOccupancyLimit;
		if(len == 1)
			ulong_ret = 0;
		else
			ulong_ret = *(data + 1);
		
        return  (u_char *) &ulong_ret;
    case DOT11CFPOLLABLE:
		if(len == 1)
			ulong_ret = 0;
		else
			ulong_ret = *(data + 1);
		
        return  (u_char *) &ulong_ret;
    case DOT11CFPPERIOD:
        *write_method = write_dot11CFPPeriod;
		if(len == 1)
			ulong_ret = 0;
		else
			ulong_ret = *(data + 1);

        return  (u_char *) &ulong_ret;
    case DOT11CFPMAXDURATION:
        *write_method = write_dot11CFPMaxDuration;
		if(len == 1)
			ulong_ret = 0;
		else
			ulong_ret = *(data + 1);

        return  (u_char *) &ulong_ret;
    case DOT11AUTHENTICATIONRESPONSETIMEOUT:
        *write_method = write_dot11AuthenticationResponseTimeOut;
		if(len == 1)
			ulong_ret = 0;
		else
			ulong_ret = *((int *)(data + 1));
		
        return  (u_char *) &ulong_ret;
    case DOT11PRIVACYOPTIONIMPLEMENTED:
		if(len == 1)
			ulong_ret = 0;
		else
			ulong_ret = *(data + 1);

        return  (u_char *) &ulong_ret;
    case DOT11POWERMANAGEMENTMODE:
        *write_method = write_dot11PowerManagementMode;
		if(len == 1)
			ulong_ret = 0;
		else
			ulong_ret = *(data + 1);

        return  (u_char *) &ulong_ret;
    case DOT11DESIREDSSID:		
        *write_method = write_dot11DesiredSSID;    
		apmib_get(MIB_WLAN_SSID,string);
		*var_len = strlen(string);
        return (unsigned char *) string;

    case DOT11DESIREDBSSTYPE:
        *write_method = write_dot11DesiredBSSType;
		apmib_get(MIB_WLAN_NETWORK_TYPE,(void *)&ulong_ret);
		// translate between 8186 and agent
		// 8186                     agent
		// infrastructure---->0     ----->1
		// Ad hoc ----------->1     ----->2		
		ulong_ret++;
        return  (u_char *) &ulong_ret;

    case DOT11OPERATIONALRATESET:
        *write_method = write_dot11OperationalRateSet;
		apmib_get(MIB_WLAN_SUPPORTED_RATE,(void *)&ulong_ret);
		*var_len = _translateOperationRateToIEEE( ulong_ret, rate_octet);
        return  (u_char *) &rate_octet;

    case DOT11BEACONPERIOD:
        *write_method = write_dot11BeaconPeriod;
 		apmib_get(MIB_WLAN_BEACON_INTERVAL,&ulong_ret);
        return  (u_char *) &ulong_ret;

    case DOT11DTIMPERIOD:
        *write_method = write_dot11DTIMPeriod;
 		apmib_get(MIB_WLAN_DTIM_PERIOD,&ulong_ret);
        return  (u_char *) &ulong_ret;
    case DOT11ASSOCIATIONRESPONSETIMEOUT:
        *write_method = write_dot11AssociationResponseTimeOut;
		if(len == 1)
			ulong_ret = 0;
		else
			ulong_ret = *((int *)(data + 1));

        return  (u_char *) &ulong_ret;
    case DOT11DISASSOCIATEREASON:
		if(len == 1)
			ulong_ret = 0;
		else
			ulong_ret = *((int *)(data + 1));

        return  (u_char *) &ulong_ret;
    case DOT11DISASSOCIATESTATION:
		*var_len = len - 1;
        return  (u_char *) data + 1;
    case DOT11DEAUTHENTICATEREASON:
		if(len == 1)
			ulong_ret = 0;
		else
			ulong_ret = *((int *)(data + 1));

        return  (u_char *) &ulong_ret;
    case DOT11DEAUTHENTICATESTATION:
		*var_len = len - 1;
        return  (u_char *) data + 1;
    case DOT11AUTHENTICATEFAILSTATUS:
		if(len == 1)
			ulong_ret = 0;
		else
			ulong_ret = *((int *)(data + 1));

        return  (u_char *) &ulong_ret;
    case DOT11AUTHENTICATEFAILSTATION:
		*var_len = len - 1;
        return  (u_char *) data + 1;
    default:
        ERROR_MSG("var_dot11StationConfigTable: Error!!!\n");
    }
    return NULL;
}

/*
 * var_dot11AuthenticationAlgorithmsTable():
 *   Handle this table separately from the scalar value case.
 *   The workings of this are basically the same as for var_ieee802dot11 above.
 */
unsigned char  *
var_dot11AuthenticationAlgorithmsTable(struct variable *vp,
                                       oid * name,
                                       size_t *length,
                                       int exact,
                                       size_t *var_len,
                                       WriteMethod ** write_method)
{
    /*
     * variables we may use later 
     */
    static u_long   ulong_ret;
	static unsigned char data[MAX_DATA_SIZE];
	u_long table_size;
	u_long len;
	oid count_id[] = {6, 2};
	int	table_value,auth_type;


	if(IOCTL_SNMP("wlan0", count_id, OID_COUNT_LEN, data, &len) == -1){
		//snmp_log(LOG_INFO, "var_dot11StationConfigTable: IOCT_SNMP failed \n");
		return NULL;
	};

	table_size = *(data+1);
	
    if (header_simple_table
        (vp, name, length, exact, var_len, write_method, table_size)
        == MATCH_FAILED)
        return NULL;

#define OID_AUTHENTICATIONALGORTHMS_LEN 5

	if(IOCTL_SNMP("wlan0", OID_TAIL(name), OID_AUTHENTICATIONALGORTHMS_LEN, data, &len) == -1){
		//snmp_log(LOG_INFO, "var_dot11StationConfigTable: IOCT_SNMP failed \n");
		return NULL;
	};


    switch (vp->magic) {
    case DOT11AUTHENTICATIONALGORITHMSINDEX:
		if(len == 1)
			ulong_ret = 0;
		else
			ulong_ret = *(data + 1);

        return  (u_char *) &ulong_ret;
    case DOT11AUTHENTICATIONALGORITHM:
		if(len == 1)
			ulong_ret = 0;
		else
			ulong_ret = *(data + 1);
		
        return  (u_char *) &ulong_ret;
    case DOT11AUTHENTICATIONALGORITHMSENABLE:
        *write_method = write_dot11AuthenticationAlgorithmsEnable;
		table_value = name[*length-1];
		
		apmib_get(MIB_WLAN_AUTH_TYPE, (void *)&auth_type);
		auth_type = auth_type + 1;
		if( table_value & auth_type )
		{
			ulong_ret = 1;		
		}
		else
		{
			ulong_ret = 0;		
		}
        return  (u_char *) &ulong_ret;
    default:
        ERROR_MSG("var_dot11AuthenticationAlgorithmsTable: Error!!!\n");
    }
    return NULL;
}

/*
 * var_dot11WEPDefaultKeysTable():
 *   Handle this table separately from the scalar value case.
 *   The workings of this are basically the same as for var_ieee802dot11 above.
 */
unsigned char  *
var_dot11WEPDefaultKeysTable(struct variable *vp,
                             oid * name,
                             size_t *length,
                             int exact,
                             size_t *var_len, WriteMethod ** write_method)
{
    /*
     * variables we may use later 
     */
    static u_long   ulong_ret;
	static unsigned char data[MAX_DATA_SIZE];
	u_char	key_id;
	int  wep_offset,wep;
	static u_char  *key_value;
	u_long table_size;
	u_long len;
	oid count_id[] = {6, 3};
	static char string[5];

	if(IOCTL_SNMP("wlan0", count_id, OID_COUNT_LEN, data, &len) == -1){
		//snmp_log(LOG_INFO, "var_dot11StationConfigTable: IOCT_SNMP failed \n");
		return NULL;
	};

	table_size = *(data+1);
		
    if (header_simple_table
        (vp, name, length, exact, var_len, write_method, table_size)
        == MATCH_FAILED)
        return NULL;

#define OID_WEPDEFALKEYS_LEN 5
	if(IOCTL_SNMP("wlan0", OID_TAIL(name), OID_WEPDEFALKEYS_LEN, data, &len) == -1){
		//snmp_log(LOG_INFO, "var_dot11StationConfigTable: IOCT_SNMP failed \n");
		return NULL;
	};

    switch (vp->magic) {
    case DOT11WEPDEFAULTKEYINDEX:
		if(len == 1)
			ulong_ret = 0;
		else
			ulong_ret = *(data + 1);

        return  (u_char *) &ulong_ret;
    case DOT11WEPDEFAULTKEYVALUE:
        *write_method = write_dot11WEPDefaultKeyValue;
		wep_offset = name[*length-1] - 1;
//		snmp_log(LOG_INFO, "wep_offset = %d\n",wep_offset);
//		snmp_log(LOG_INFO, "MIB_WLAN_WEP64_KEY1+wep_offset = %d\n",MIB_WLAN_WEP64_KEY1+wep_offset );
		apmib_get(MIB_WLAN_WEP, (void *)&wep);
		if (wep == 1) 
		{
			apmib_get(MIB_WLAN_WEP64_KEY1+wep_offset ,string);
		}
		else
		{
			apmib_get(MIB_WLAN_WEP128_KEY1+wep_offset ,string);
		}
		*var_len = strlen(string);
        return (unsigned char *) string;

    default:
        ERROR_MSG("var_dot11WEPDefaultKeysTable: Error!!!\n");
    }
    return NULL;
}

/*
 * var_dot11WEPKeyMappingsTable():
 *   Handle this table separately from the scalar value case.
 *   The workings of this are basically the same as for var_ieee802dot11 above.
 */
unsigned char  *
var_dot11WEPKeyMappingsTable(struct variable *vp,
                             oid * name,
                             size_t *length,
                             int exact,
                             size_t *var_len, WriteMethod ** write_method)
{
    /*
     * variables we may use later 
     */
    static u_long   ulong_ret;
	static unsigned char data[MAX_DATA_SIZE];
	u_long table_size;
	u_long len;
	oid count_id[] = {6, 4};


	if(IOCTL_SNMP("wlan0", count_id, OID_COUNT_LEN, data, &len) == -1){
		//snmp_log(LOG_INFO, "var_dot11WEPKeyMappingsTable: IOCT_SNMP failed \n");
		return NULL;
	};

	table_size = *(data+1);


    if (header_simple_table
        (vp, name, length, exact, var_len, write_method, table_size)
        == MATCH_FAILED)
        return NULL;

#define OID_WEPKEYMAPPINGS_LEN 5
	if(IOCTL_SNMP("wlan0", OID_TAIL(name), OID_WEPKEYMAPPINGS_LEN, data, &len) == -1){
		//snmp_log(LOG_INFO, "var_dot11WEPKeyMappingsTable: IOCT_SNMP failed \n");
		return NULL;
	};

	
    switch (vp->magic) {
    case DOT11WEPKEYMAPPINGINDEX:
		if(len == 1)
			ulong_ret = 0;
		else
			ulong_ret = *(data + 1);

        return  (u_char *) &ulong_ret;
    case DOT11WEPKEYMAPPINGADDRESS:
        *write_method = write_dot11WEPKeyMappingAddress;
		*var_len = len - 1;
        return  (u_char *) data + 1;
    case DOT11WEPKEYMAPPINGWEPON:
        *write_method = write_dot11WEPKeyMappingWEPOn;
		if(len == 1)
			ulong_ret = 0;
		else
			ulong_ret = *(data + 1);
		
        return  (u_char *) &ulong_ret;
    case DOT11WEPKEYMAPPINGVALUE:
        *write_method = write_dot11WEPKeyMappingValue;
		*var_len = len - 1;
        return  (u_char *) data + 1;
    case DOT11WEPKEYMAPPINGSTATUS:
        *write_method = write_dot11WEPKeyMappingStatus;
		if(len == 1)
			ulong_ret = 0;
		else
			ulong_ret = *(data + 1);
		
        return  (u_char *) &ulong_ret;
    default:
        ERROR_MSG("var_dot11WEPKeyMappingsTable: Error!!!\n");
    }
    return NULL;
}

/*
 * var_dot11PrivacyTable():
 *   Handle this table separately from the scalar value case.
 *   The workings of this are basically the same as for var_ieee802dot11 above.
 */
unsigned char  *
var_dot11PrivacyTable(struct variable *vp,
                      oid * name,
                      size_t *length,
                      int exact,
                      size_t *var_len, WriteMethod ** write_method)
{
    /*
     * variables we may use later 
     */
    static u_long   ulong_ret;
	static unsigned char data[MAX_DATA_SIZE];
	u_long table_size;
	u_long len;
	oid count_id[] = {6, 5};


	if(IOCTL_SNMP("wlan0", count_id, OID_COUNT_LEN, data, &len) == -1){
		//snmp_log(LOG_INFO, "var_dot11WEPKeyMappingsTable: IOCT_SNMP failed \n");
		return NULL;
	};

	table_size = *(data+1);
		
    if (header_simple_table
        (vp, name, length, exact, var_len, write_method, table_size)
        == MATCH_FAILED)
        return NULL;

#define OID_PRIVACY_LEN 5
	if(IOCTL_SNMP("wlan0", OID_TAIL(name), OID_PRIVACY_LEN, data, &len) == -1){
		//snmp_log(LOG_INFO, "var_dot11WEPKeyMappingsTable: IOCT_SNMP failed \n");
		return NULL;
	};


    /*
     * this is where we do the value assignments for the mib results.
     */
    switch (vp->magic) {
    case DOT11PRIVACYINVOKED:
        *write_method = write_dot11PrivacyInvoked;
		apmib_get(MIB_WLAN_ENCRYPT, (void *)&ulong_ret);
		return (u_char *) &ulong_ret;
    case DOT11WEPDEFAULTKEYID:
        *write_method = write_dot11WEPDefaultKeyID;
		apmib_get(MIB_WLAN_WEP_DEFAULT_KEY, (void *)&ulong_ret);
		return (u_char *) &ulong_ret;
    case DOT11WEPKEYMAPPINGLENGTH:
        *write_method = write_dot11WEPKeyMappingLength;
		if(len == 1)
			ulong_ret = 0;
		else
			ulong_ret = *(data + 1);

		return (u_char *) &ulong_ret;
    case DOT11EXCLUDEUNENCRYPTED:
        *write_method = write_dot11ExcludeUnencrypted;
		if(len == 1)
			ulong_ret = 0;
		else
			ulong_ret = *((u_long *)(data + 1));

		return (u_char *) &ulong_ret;
    case DOT11WEPICVERRORCOUNT:
		if(len == 1)
			ulong_ret = 0;
		else
			ulong_ret = *((u_long *)(data + 1));

		return (u_char *) &ulong_ret;
    case DOT11WEPEXCLUDEDCOUNT:
		if(len == 1)
			ulong_ret = 0;
		else
			ulong_ret = *((u_long *)(data + 1));

		return (u_char *) &ulong_ret;
    default:
        ERROR_MSG("var_dot11PrivacyTable: Error!!!\n");
    }
    return NULL;
}

/*
 * var_dot11OperationTable():
 *   Handle this table separately from the scalar value case.
 *   The workings of this are basically the same as for var_ieee802dot11 above.
 */
unsigned char  *
var_dot11OperationTable(struct variable *vp,
                        oid * name,
                        size_t *length,
                        int exact,
                        size_t *var_len, WriteMethod ** write_method)
{
    /*
     * variables we may use later 
     */
    static u_long   ulong_ret;
	static unsigned char data[MAX_DATA_SIZE];
	u_long table_size;
	u_long len;
	oid count_id[] = {6, 6};


	if(IOCTL_SNMP("wlan0", count_id, OID_COUNT_LEN, data, &len) == -1){
		//snmp_log(LOG_INFO, "var_dot11WEPKeyMappingsTable: IOCT_SNMP failed \n");
		return NULL;
	};

	table_size = *(data+1);
		
    if (header_simple_table
        (vp, name, length, exact, var_len, write_method, table_size)
        == MATCH_FAILED)
        return NULL;

#define OID_OPERATION_LEN 5
	if(IOCTL_SNMP("wlan0", OID_TAIL(name), OID_OPERATION_LEN, data, &len) == -1){
		//snmp_log(LOG_INFO, "var_dot11WEPKeyMappingsTable: IOCT_SNMP failed \n");
		return NULL;
	};


    /*
     * this is where we do the value assignments for the mib results.
     */
    switch (vp->magic) {
    case DOT11MACADDRESS:
		*var_len = len - 1;
        return  (u_char *) data + 1;
    case DOT11RTSTHRESHOLD:
        *write_method = write_dot11RTSThreshold;
		apmib_get(MIB_WLAN_RTS_THRESHOLD, (void *)&ulong_ret);
		return (u_char *) &ulong_ret;
    case DOT11SHORTRETRYLIMIT:
        *write_method = write_dot11ShortRetryLimit;
		if(len == 1)
			ulong_ret = 0;
		else
			ulong_ret = *((u_long *)(data + 1));

		return (u_char *) &ulong_ret;
    case DOT11LONGRETRYLIMIT:
        *write_method = write_dot11LongRetryLimit;
		if(len == 1)
			ulong_ret = 0;
		else
			ulong_ret = *((u_long *)(data + 1));

		return (u_char *) &ulong_ret;
    case DOT11FRAGMENTATIONTHRESHOLD:
        *write_method = write_dot11FragmentationThreshold;
		apmib_get(MIB_WLAN_FRAG_THRESHOLD, (void *)&ulong_ret);
		return (u_char *) &ulong_ret;
    case DOT11MAXTRANSMITMSDULIFETIME:
        *write_method = write_dot11MaxTransmitMSDULifetime;
		if(len == 1)
			ulong_ret = 0;
		else
			ulong_ret = *(data + 1);

		ulong_ret++;
		return (u_char *) &ulong_ret;
    case DOT11MAXRECEIVELIFETIME:
        *write_method = write_dot11MaxReceiveLifetime;
		if(len == 1)
			ulong_ret = 0;
		else
			ulong_ret = *((u_long *)(data + 1));
		
		ulong_ret++;
		return (u_char *) &ulong_ret;
    case DOT11MANUFACTURERID:
		*var_len = len - 1;
        return  (u_char *) data + 1;
    case DOT11PRODUCTID:
		*var_len = len - 1;
        return  (u_char *) data + 1;
    default:
        ERROR_MSG("var_dot11OperationTable: Error!!!\n");
    }
    return NULL;
}

/*
 * var_dot11CountersTable():
 *   Handle this table separately from the scalar value case.
 *   The workings of this are basically the same as for var_ieee802dot11 above.
 */
unsigned char  *
var_dot11CountersTable(struct variable *vp,
                       oid * name,
                       size_t *length,
                       int exact,
                       size_t *var_len, WriteMethod ** write_method)
{
    /*
     * variables we may use later 
     */
    static u_long   ulong_ret;
	static unsigned char data[MAX_DATA_SIZE];
	u_long table_size;
	u_long len;
	oid count_id[] = {6, 7};


	if(IOCTL_SNMP("wlan0", count_id, OID_COUNT_LEN, data, &len) == -1){
		//snmp_log(LOG_INFO, "var_dot11WEPKeyMappingsTable: IOCT_SNMP failed \n");
		return NULL;
	};

	table_size = *(data+1);
		
    if (header_simple_table
        (vp, name, length, exact, var_len, write_method, table_size)
        == MATCH_FAILED)
        return NULL;

#define OID_COUNTERS_LEN 5
	if(IOCTL_SNMP("wlan0", OID_TAIL(name), OID_COUNTERS_LEN, data, &len) == -1){
		//snmp_log(LOG_INFO, "var_dot11WEPKeyMappingsTable: IOCT_SNMP failed \n");
		return NULL;
	};
	
    switch (vp->magic) {
    case DOT11TRANSMITTEDFRAGMENTCOUNT:
		if(len == 1)
			ulong_ret = 0;
		else
			ulong_ret = *((u_long *)(data + 1));

		return (u_char *) &ulong_ret;
    case DOT11MULTICASTTRANSMITTEDFRAMECOUNT:
		if(len == 1)
			ulong_ret = 0;
		else
			ulong_ret = *((u_long *)(data + 1));

		return (u_char *) &ulong_ret;
    case DOT11FAILEDCOUNT:
		if(len == 1)
			ulong_ret = 0;
		else
			ulong_ret = *((u_long *)(data + 1));

		return (u_char *) &ulong_ret;
    case DOT11RETRYCOUNT:
		if(len == 1)
			ulong_ret = 0;
		else
			ulong_ret = *((u_long *)(data + 1));

		return (u_char *) &ulong_ret;
    case DOT11MULTIPLERETRYCOUNT:
		if(len == 1)
			ulong_ret = 0;
		else
			ulong_ret = *((u_long *)(data + 1));

		return (u_char *) &ulong_ret;
    case DOT11FRAMEDUPLICATECOUNT:
		if(len == 1)
			ulong_ret = 0;
		else
			ulong_ret = *((u_long *)(data + 1));

		return (u_char *) &ulong_ret;
    case DOT11RTSSUCCESSCOUNT:
		if(len == 1)
			ulong_ret = 0;
		else
			ulong_ret = *((u_long *)(data + 1));

		return (u_char *) &ulong_ret;
    case DOT11RTSFAILURECOUNT:
		if(len == 1)
			ulong_ret = 0;
		else
			ulong_ret = *((u_long *)(data + 1));

		return (u_char *) &ulong_ret;
    case DOT11ACKFAILURECOUNT:
		if(len == 1)
			ulong_ret = 0;
		else
			ulong_ret = *((u_long *)(data + 1));

		return (u_char *) &ulong_ret;
    case DOT11RECEIVEDFRAGMENTCOUNT:
		if(len == 1)
			ulong_ret = 0;
		else
			ulong_ret = *((u_long *)(data + 1));

		return (u_char *) &ulong_ret;
    case DOT11MULTICASTRECEIVEDFRAMECOUNT:
		if(len == 1)
			ulong_ret = 0;
		else
			ulong_ret = *((u_long *)(data + 1));

		return (u_char *) &ulong_ret;
    case DOT11FCSERRORCOUNT:
		if(len == 1)
			ulong_ret = 0;
		else
			ulong_ret = *((u_long *)(data + 1));

		return (u_char *) &ulong_ret;
    case DOT11TRANSMITTEDFRAMECOUNT:
		if(len == 1)
			ulong_ret = 0;
		else
			ulong_ret = *((u_long *)(data + 1));

		return (u_char *) &ulong_ret;
    case DOT11WEPUNDECRYPTABLECOUNT:
		if(len == 1)
			ulong_ret = 0;
		else
			ulong_ret = *((u_long *)(data + 1));

		return (u_char *) &ulong_ret;
    default:
        ERROR_MSG("var_dot11CountersTable: Error!!!\n");
    }
    return NULL;
}

/*
 * var_dot11GroupAddressesTable():
 *   Handle this table separately from the scalar value case.
 *   The workings of this are basically the same as for var_ieee802dot11 above.
 */
unsigned char  *
var_dot11GroupAddressesTable(struct variable *vp,
                             oid * name,
                             size_t *length,
                             int exact,
                             size_t *var_len, WriteMethod ** write_method)
{
    /*
     * variables we may use later 
     */
    static u_long   ulong_ret;
	static unsigned char data[MAX_DATA_SIZE];
	u_long table_size;
	u_long len;
	oid count_id[] = {6, 8};


	if(IOCTL_SNMP("wlan0", count_id, OID_COUNT_LEN, data, &len) == -1){
		//snmp_log(LOG_INFO, "var_dot11WEPKeyMappingsTable: IOCT_SNMP failed \n");
		return NULL;
	};

	table_size = *(data+1);
		
    if (header_simple_table
        (vp, name, length, exact, var_len, write_method, table_size)
        == MATCH_FAILED)
        return NULL;

#define OID_GROUPADDRESSES_LEN 5
	if(IOCTL_SNMP("wlan0", OID_TAIL(name), OID_GROUPADDRESSES_LEN, data, &len) == -1){
		//snmp_log(LOG_INFO, "var_dot11WEPKeyMappingsTable: IOCT_SNMP failed \n");
		return NULL;
	};
	
    switch (vp->magic) {
    case DOT11GROUPADDRESSESINDEX:
		if(len == 1)
			ulong_ret = 0;
		else
			ulong_ret = *(data + 1);

		return (u_char *) &ulong_ret;
    case DOT11ADDRESS:
        *write_method = write_dot11Address;
		*var_len = len - 1;
        return  (u_char *) data + 1;
    case DOT11GROUPADDRESSESSTATUS:
        *write_method = write_dot11GroupAddressesStatus;
		if(len == 1)
			ulong_ret = 0;
		else
			ulong_ret = *(data + 1);

		return (u_char *) &ulong_ret;
    default:
        ERROR_MSG("var_dot11GroupAddressesTable: Error!!!\n");
    }
    return NULL;
}

/*
 * var_dot11ResourceInfoTable():
 *   Handle this table separately from the scalar value case.
 *   The workings of this are basically the same as for var_ieee802dot11 above.
 */
unsigned char  *
var_dot11ResourceInfoTable(struct variable *vp,
                           oid * name,
                           size_t *length,
                           int exact,
                           size_t *var_len, WriteMethod ** write_method)
{
    /*
     * variables we may use later 
     */
    static u_long   ulong_ret;
	static unsigned char data[MAX_DATA_SIZE];
	u_long table_size;
	u_long len;
	oid count_id[] = {6, 9};


	if(IOCTL_SNMP("wlan0", count_id, OID_COUNT_LEN, data, &len) == -1){
		//snmp_log(LOG_INFO, "var_dot11WEPKeyMappingsTable: IOCT_SNMP failed \n");
		return NULL;
	};

	table_size = *(data+1);
		
    if (header_simple_table
        (vp, name, length, exact, var_len, write_method, table_size)
        == MATCH_FAILED)
        return NULL;

#define OID_RESOURCEINFO_LEN 6
	if(IOCTL_SNMP("wlan0", OID_TAIL(name), OID_RESOURCEINFO_LEN, data, &len) == -1){
		//snmp_log(LOG_INFO, "var_dot11WEPKeyMappingsTable: IOCT_SNMP failed \n");
		return NULL;
	};

    /*
     * this is where we do the value assignments for the mib results.
     */
    switch (vp->magic) {
    case DOT11MANUFACTUREROUI:
		*var_len = len - 1;
        return  (u_char *) data + 1;
    case DOT11MANUFACTURERNAME:
		*var_len = len - 1;
        return  (u_char *) data + 1;
    case DOT11MANUFACTURERPRODUCTNAME:
		*var_len = len - 1;
        return  (u_char *) data + 1;
    case DOT11MANUFACTURERPRODUCTVERSION:
		*var_len = len - 1;
        return  (u_char *) data + 1;
    default:
        ERROR_MSG("var_dot11ResourceInfoTable: Error!!!\n");
    }
    return NULL;
}

/*
 * var_dot11PhyOperationTable():
 *   Handle this table separately from the scalar value case.
 *   The workings of this are basically the same as for var_ieee802dot11 above.
 */
unsigned char  *
var_dot11PhyOperationTable(struct variable *vp,
                           oid * name,
                           size_t *length,
                           int exact,
                           size_t *var_len, WriteMethod ** write_method)
{
    /*
     * variables we may use later 
     */
    static u_long   ulong_ret;
	static unsigned char data[MAX_DATA_SIZE];
	u_long table_size;
	u_long len;
	oid count_id[] = {6, 10};


	if(IOCTL_SNMP("wlan0", count_id, OID_COUNT_LEN, data, &len) == -1){
		//snmp_log(LOG_INFO, "var_dot11WEPKeyMappingsTable: IOCT_SNMP failed \n");
		return NULL;
	};

	table_size = *(data+1);
		
    if (header_simple_table
        (vp, name, length, exact, var_len, write_method, table_size)
        == MATCH_FAILED)
        return NULL;

#define OID_PHYOPERATION_LEN 5
	if(IOCTL_SNMP("wlan0", OID_TAIL(name), OID_PHYOPERATION_LEN, data, &len) == -1){
		//snmp_log(LOG_INFO, "var_dot11WEPKeyMappingsTable: IOCT_SNMP failed \n");
		return NULL;
	};

    /*
     * this is where we do the value assignments for the mib results.
     */
    switch (vp->magic) {
    case DOT11PHYTYPE:
		if(len == 1)
			ulong_ret = 0;
		else
			ulong_ret = *(data + 1);

		return (u_char *) &ulong_ret;
    case DOT11CURRENTREGDOMAIN:
        *write_method = write_dot11CurrentRegDomain;
// 		apmib_get(MIB_HW_REG_DOMAIN,&ulong_ret);
		if(len == 1)
			ulong_ret = 0;
		else
			ulong_ret = *((u_long *)(data + 1));

		return (u_char *) &ulong_ret;
    case DOT11TEMPTYPE:
		if(len == 1)
			ulong_ret = 0;
		else
			ulong_ret = *(data + 1);

		return (u_char *) &ulong_ret;
    default:
        ERROR_MSG("var_dot11PhyOperationTable: Error!!!\n");
    }
    return NULL;
}

/*
 * var_dot11PhyAntennaTable():
 *   Handle this table separately from the scalar value case.
 *   The workings of this are basically the same as for var_ieee802dot11 above.
 */
unsigned char  *
var_dot11PhyAntennaTable(struct variable *vp,
                         oid * name,
                         size_t *length,
                         int exact,
                         size_t *var_len, WriteMethod ** write_method)
{
    /*
     * variables we may use later 
     */
    static u_long   ulong_ret;
	static unsigned char data[MAX_DATA_SIZE];
	u_long table_size;
	u_long len;
	oid count_id[] = {6, 11};


	if(IOCTL_SNMP("wlan0", count_id, OID_COUNT_LEN, data, &len) == -1){
		//snmp_log(LOG_INFO, "var_dot11WEPKeyMappingsTable: IOCT_SNMP failed \n");
		return NULL;
	};

	table_size = *(data+1);
		
    if (header_simple_table
        (vp, name, length, exact, var_len, write_method, table_size)
        == MATCH_FAILED)
        return NULL;

#define OID_PHYANTENNA_LEN 5
	if(IOCTL_SNMP("wlan0", OID_TAIL(name), OID_PHYANTENNA_LEN, data, &len) == -1){
		//snmp_log(LOG_INFO, "var_dot11WEPKeyMappingsTable: IOCT_SNMP failed \n");
		return NULL;
	};

    /*
     * this is where we do the value assignments for the mib results.
     */
    switch (vp->magic) {
    case DOT11CURRENTTXANTENNA:
        *write_method = write_dot11CurrentTxAntenna;
		apmib_get( MIB_HW_TX_ANT, (void *)&ulong_ret);
		ulong_ret++;
//		snmp_log(LOG_INFO, "get_ulong_ret = %d \n",ulong_ret);
		return (u_char *) &ulong_ret;
    case DOT11DIVERSITYSUPPORT:
		if(len == 1)
			ulong_ret = 0;
		else
			ulong_ret = *(data + 1);

		return (u_char *) &ulong_ret;
    case DOT11CURRENTRXANTENNA:
        *write_method = write_dot11CurrentRxAntenna;
		apmib_get(MIB_HW_TX_ANT, (void *)&ulong_ret);
		ulong_ret++;
//		snmp_log(LOG_INFO, "get_ulong_ret = %d \n",ulong_ret);		
		return (u_char *) &ulong_ret;
    default:
        ERROR_MSG("var_dot11PhyAntennaTable: Error!!!\n");
    }
    return NULL;
}

/*
 * var_dot11PhyTxPowerTable():
 *   Handle this table separately from the scalar value case.
 *   The workings of this are basically the same as for var_ieee802dot11 above.
 */
unsigned char  *
var_dot11PhyTxPowerTable(struct variable *vp,
                         oid * name,
                         size_t *length,
                         int exact,
                         size_t *var_len, WriteMethod ** write_method)
{
    /*
     * variables we may use later 
     */
    static u_long   ulong_ret;
	static unsigned char data[MAX_DATA_SIZE];
	u_long table_size;
	u_long len;
	oid count_id[] = {6, 12};


	if(IOCTL_SNMP("wlan0", count_id, OID_COUNT_LEN, data, &len) == -1){
		//snmp_log(LOG_INFO, "var_dot11WEPKeyMappingsTable: IOCT_SNMP failed \n");
		return NULL;
	};

	table_size = *(data+1);
		
    if (header_simple_table
        (vp, name, length, exact, var_len, write_method, table_size)
        == MATCH_FAILED)
        return NULL;

#define OID_PHYANTENNA_LEN 5
	if(IOCTL_SNMP("wlan0", OID_TAIL(name), OID_PHYANTENNA_LEN, data, &len) == -1){
		//snmp_log(LOG_INFO, "var_dot11WEPKeyMappingsTable: IOCT_SNMP failed \n");
		return NULL;
	};


    /*
     * this is where we do the value assignments for the mib results.
     */
    switch (vp->magic) {
    case DOT11NUMBERSUPPORTEDPOWERLEVELS:
		if(len == 1)
			ulong_ret = 0;
		else
			ulong_ret = *(data + 1);

		return (u_char *) &ulong_ret;
    case DOT11TXPOWERLEVEL1:
		if(len == 1)
			ulong_ret = 0;
		else
			ulong_ret = *(data + 1);

		return (u_char *) &ulong_ret;
    case DOT11TXPOWERLEVEL2:
		if(len == 1)
			ulong_ret = 0;
		else
			ulong_ret = *(data + 1);

		return (u_char *) &ulong_ret;
    case DOT11TXPOWERLEVEL3:
		if(len == 1)
			ulong_ret = 0;
		else
			ulong_ret = *(data + 1);

		return (u_char *) &ulong_ret;
    case DOT11TXPOWERLEVEL4:
		if(len == 1)
			ulong_ret = 0;
		else
			ulong_ret = *(data + 1);

		return (u_char *) &ulong_ret;
    case DOT11TXPOWERLEVEL5:
		if(len == 1)
			ulong_ret = 0;
		else
			ulong_ret = *(data + 1);

		return (u_char *) &ulong_ret;
    case DOT11TXPOWERLEVEL6:
		if(len == 1)
			ulong_ret = 0;
		else
			ulong_ret = *(data + 1);

		return (u_char *) &ulong_ret;
    case DOT11TXPOWERLEVEL7:
		if(len == 1)
			ulong_ret = 0;
		else
			ulong_ret = *(data + 1);

		return (u_char *) &ulong_ret;
    case DOT11TXPOWERLEVEL8:
		if(len == 1)
			ulong_ret = 0;
		else
			ulong_ret = *(data + 1);

		return (u_char *) &ulong_ret;
    case DOT11CURRENTTXPOWERLEVEL:
        *write_method = write_dot11CurrentTxPowerLevel;
		if(len == 1)
			ulong_ret = 0;
		else
			ulong_ret = *(data + 1);

		return (u_char *) &ulong_ret;
    default:
        ERROR_MSG("var_dot11PhyTxPowerTable: Error!!!\n");
    }
    return NULL;
}

/*
 * var_dot11PhyFHSSTable():
 *   Handle this table separately from the scalar value case.
 *   The workings of this are basically the same as for var_ieee802dot11 above.
 */
unsigned char  *
var_dot11PhyFHSSTable(struct variable *vp,
                      oid * name,
                      size_t *length,
                      int exact,
                      size_t *var_len, WriteMethod ** write_method)
{
    /*
     * variables we may use later 
     */
    static u_long   ulong_ret;
	static unsigned char data[MAX_DATA_SIZE];
	u_long table_size;
	u_long len;
//	oid count_id[] = {6, 13};


//	if(IOCTL_SNMP("wlan0", count_id, OID_COUNT_LEN, data, &len) == -1){
//		//snmp_log(LOG_INFO, "var_dot11WEPKeyMappingsTable: IOCT_SNMP failed \n");
//		return NULL;
//	};

//	table_size = *(data+1);


	//snmp_log(LOG_INFO, "@@@@@@@@@@@@@@@@@@@@@22\n");
	NO_SUCH_INSTANCE();


    if (header_simple_table
        (vp, name, length, exact, var_len, write_method, 1)
        == MATCH_FAILED)
        return NULL;

//	NO_SUCH_INSTANCE();


#define OID_PHYFHSS_LEN 5
	if(IOCTL_SNMP("wlan0", OID_TAIL(name), OID_PHYFHSS_LEN, data, &len) == -1){
		//snmp_log(LOG_INFO, "var_dot11WEPKeyMappingsTable: IOCT_SNMP failed \n");
		return NULL;
	};


    /*
     * this is where we do the value assignments for the mib results.
     */
    switch (vp->magic) {
    case DOT11HOPTIME:
        ulong_ret = 0;
		return (u_char *) &ulong_ret;
    case DOT11CURRENTCHANNELNUMBER:
        *write_method = write_dot11CurrentChannelNumber;
        ulong_ret = 0;
		return (u_char *) &ulong_ret;
    case DOT11MAXDWELLTIME:
        ulong_ret = 0;
		return (u_char *) &ulong_ret;
    case DOT11CURRENTDWELLTIME:
        *write_method = write_dot11CurrentDwellTime;
        ulong_ret = 0;
		return (u_char *) &ulong_ret;
    case DOT11CURRENTSET:
        *write_method = write_dot11CurrentSet;
        ulong_ret = 0;
		return (u_char *) &ulong_ret;
    case DOT11CURRENTPATTERN:
        *write_method = write_dot11CurrentPattern;
        ulong_ret = 0;
		return (u_char *) &ulong_ret;
    case DOT11CURRENTINDEX:
        *write_method = write_dot11CurrentIndex;
        ulong_ret = 0;
		return (u_char *) &ulong_ret;
    default:
        ERROR_MSG("var_dot11PhyFHSSTable: Error!!!\n");
    }
    return NULL;
}

/*
 * var_dot11PhyDSSSTable():
 *   Handle this table separately from the scalar value case.
 *   The workings of this are basically the same as for var_ieee802dot11 above.
 */
unsigned char  *
var_dot11PhyDSSSTable(struct variable *vp,
                      oid * name,
                      size_t *length,
                      int exact,
                      size_t *var_len, WriteMethod ** write_method)
{
    /*
     * variables we may use later 
     */
    static u_long   ulong_ret;
	static unsigned char data[MAX_DATA_SIZE];
	u_long table_size;
	u_long len;
	oid count_id[] = {6, 13};


	if(IOCTL_SNMP("wlan0", count_id, OID_COUNT_LEN, data, &len) == -1){
		//snmp_log(LOG_INFO, "var_dot11WEPKeyMappingsTable: IOCT_SNMP failed \n");
		return NULL;
	};

	table_size = *(data+1);
		
    if (header_simple_table
        (vp, name, length, exact, var_len, write_method, table_size)
        == MATCH_FAILED)
        return NULL;

#define OID_PHYANTENNA_LEN 5
	if(IOCTL_SNMP("wlan0", OID_TAIL(name), OID_PHYANTENNA_LEN, data, &len) == -1){
		//snmp_log(LOG_INFO, "var_dot11WEPKeyMappingsTable: IOCT_SNMP failed \n");
		return NULL;
	};



    /*
     * this is where we do the value assignments for the mib results.
     */
    switch (vp->magic) {
    case DOT11CURRENTCHANNEL:
        *write_method = write_dot11CurrentChannel;
		if(len == 1)
			ulong_ret = 0;
		else
			ulong_ret = *((u_long *)(data + 1));

		return (u_char *) &ulong_ret;
    case DOT11CCAMODESUPPORTED:
		if(len == 1)
			ulong_ret = 0;
		else
			ulong_ret = *(data + 1);

		return (u_char *) &ulong_ret;
    case DOT11CURRENTCCAMODE:
        *write_method = write_dot11CurrentCCAMode;
		if(len == 1)
			ulong_ret = 0;
		else
			ulong_ret = *(data + 1);

		return (u_char *) &ulong_ret;
    case DOT11EDTHRESHOLD:
        *write_method = write_dot11EDThreshold;
		if(len == 1)
			ulong_ret = 0;
		else
			ulong_ret = *(data + 1);

		return (u_char *) &ulong_ret;
    default:
        ERROR_MSG("var_dot11PhyDSSSTable: Error!!!\n");
    }
    return NULL;
}

/*
 * var_dot11PhyIRTable():
 *   Handle this table separately from the scalar value case.
 *   The workings of this are basically the same as for var_ieee802dot11 above.
 */
unsigned char  *
var_dot11PhyIRTable(struct variable *vp,
                    oid * name,
                    size_t *length,
                    int exact,
                    size_t *var_len, WriteMethod ** write_method)
{
    /*
     * variables we may use later 
     */
    static u_long   ulong_ret;
	static unsigned char data[MAX_DATA_SIZE];
	u_long table_size;
	u_long len;
//	oid count_id[] = {6, 13};


//	if(IOCTL_SNMP("wlan0", count_id, OID_COUNT_LEN, data, &len) == -1){
//		//snmp_log(LOG_INFO, "var_dot11WEPKeyMappingsTable: IOCT_SNMP failed \n");
//		return NULL;
//	};

//	table_size = *(data+1);

	NO_SUCH_INSTANCE();

    if (header_simple_table
        (vp, name, length, exact, var_len, write_method, 1)
        == MATCH_FAILED)
        return NULL;

#define OID_PHYIR_LEN 5
	if(IOCTL_SNMP("wlan0", OID_TAIL(name), OID_PHYIR_LEN, data, &len) == -1){
		//snmp_log(LOG_INFO, "var_dot11WEPKeyMappingsTable: IOCT_SNMP failed \n");
		return NULL;
	};


    /*
     * this is where we do the value assignments for the mib results.
     */
    switch (vp->magic) {
    case DOT11CCAWATCHDOGTIMERMAX:
        *write_method = write_dot11CCAWatchdogTimerMax;
        ulong_ret = 0;
		return (u_char *) &ulong_ret;
    case DOT11CCAWATCHDOGCOUNTMAX:
        *write_method = write_dot11CCAWatchdogCountMax;
        ulong_ret = 0;
		return (u_char *) &ulong_ret;
    case DOT11CCAWATCHDOGTIMERMIN:
        *write_method = write_dot11CCAWatchdogTimerMin;
        ulong_ret = 0;
		return (u_char *) &ulong_ret;
    case DOT11CCAWATCHDOGCOUNTMIN:
        *write_method = write_dot11CCAWatchdogCountMin;
        ulong_ret = 0;
		return (u_char *) &ulong_ret;
    default:
        ERROR_MSG("var_dot11PhyIRTable: Error!!!\n");
    }
    return NULL;
}

/*
 * var_dot11RegDomainsSupportedTable():
 *   Handle this table separately from the scalar value case.
 *   The workings of this are basically the same as for var_ieee802dot11 above.
 */
unsigned char  *
var_dot11RegDomainsSupportedTable(struct variable *vp,
                                  oid * name,
                                  size_t *length,
                                  int exact,
                                  size_t *var_len,
                                  WriteMethod ** write_method)
{
    /*
     * variables we may use later 
     */
    static u_long   ulong_ret;
	static unsigned char data[MAX_DATA_SIZE];
	u_long table_size;
	u_long len;
	oid count_id[] = {6, 14};


	if(IOCTL_SNMP("wlan0", count_id, OID_COUNT_LEN, data, &len) == -1){
		//snmp_log(LOG_INFO, "var_dot11WEPKeyMappingsTable: IOCT_SNMP failed \n");
		return NULL;
	};

	table_size = *(data+1);
		
    if (header_simple_table
        (vp, name, length, exact, var_len, write_method, table_size)
        == MATCH_FAILED)
        return NULL;

#define OID_PHYANTENNA_LEN 5
	if(IOCTL_SNMP("wlan0", OID_TAIL(name), OID_PHYANTENNA_LEN, data, &len) == -1){
		//snmp_log(LOG_INFO, "var_dot11WEPKeyMappingsTable: IOCT_SNMP failed \n");
		return NULL;
	};


    /*
     * this is where we do the value assignments for the mib results.
     */
    switch (vp->magic) {
    case DOT11REGDOMAINSSUPPORTINDEX:
		if(len == 1)
			ulong_ret = 0;
		else
			ulong_ret = *(data + 1);

		return (u_char *) &ulong_ret;
    case DOT11REGDOMAINSSUPPORTVALUE:
		if(len == 1)
			ulong_ret = 0;
		else
			ulong_ret = *(data + 1);

		return (u_char *) &ulong_ret;
    default:
        ERROR_MSG("var_dot11RegDomainsSupportedTable: Error!!!\n");
    }
    return NULL;
}

/*
 * var_dot11AntennasListTable():
 *   Handle this table separately from the scalar value case.
 *   The workings of this are basically the same as for var_ieee802dot11 above.
 */
unsigned char  *
var_dot11AntennasListTable(struct variable *vp,
                           oid * name,
                           size_t *length,
                           int exact,
                           size_t *var_len, WriteMethod ** write_method)
{
    /*
     * variables we may use later 
     */
    static u_long   ulong_ret;
	static unsigned char data[MAX_DATA_SIZE];
	u_long table_size;
	u_long len;
	oid count_id[] = {6, 15};


	if(IOCTL_SNMP("wlan0", count_id, OID_COUNT_LEN, data, &len) == -1){
		//snmp_log(LOG_INFO, "var_dot11WEPKeyMappingsTable: IOCT_SNMP failed \n");
		return NULL;
	};

	table_size = *(data+1);
		
    if (header_simple_table
        (vp, name, length, exact, var_len, write_method, table_size)
        == MATCH_FAILED)
        return NULL;

#define OID_ANTENNASLIST_LEN 5
	if(IOCTL_SNMP("wlan0", OID_TAIL(name), OID_ANTENNASLIST_LEN, data, &len) == -1){
		//snmp_log(LOG_INFO, "var_dot11WEPKeyMappingsTable: IOCT_SNMP failed \n");
		return NULL;
	};

    /*
     * this is where we do the value assignments for the mib results.
     */
    switch (vp->magic) {
    case DOT11ANTENNALISTINDEX:
		if(len == 1)
			ulong_ret = 0;
		else
			ulong_ret = *(data + 1);

		return (u_char *) &ulong_ret;
    case DOT11SUPPORTEDTXANTENNA:
        *write_method = write_dot11SupportedTxAntenna;
		if(len == 1)
			ulong_ret = 0;
		else
			ulong_ret = *(data + 1);

		return (u_char *) &ulong_ret;
    case DOT11SUPPORTEDRXANTENNA:
        *write_method = write_dot11SupportedRxAntenna;
		if(len == 1)
			ulong_ret = 0;
		else
			ulong_ret = *(data + 1);

		return (u_char *) &ulong_ret;
    case DOT11DIVERSITYSELECTIONRX:
        *write_method = write_dot11DiversitySelectionRx;
		if(len == 1)
			ulong_ret = 0;
		else
			ulong_ret = *(data + 1);

		return (u_char *) &ulong_ret;
    default:
        ERROR_MSG("var_dot11AntennasListTable: Error!!!\n");
    }
    return NULL;
}

/*
 * var_dot11SupportedDataRatesTxTable():
 *   Handle this table separately from the scalar value case.
 *   The workings of this are basically the same as for var_ieee802dot11 above.
 */
unsigned char  *
var_dot11SupportedDataRatesTxTable(struct variable *vp,
                                   oid * name,
                                   size_t *length,
                                   int exact,
                                   size_t *var_len,
                                   WriteMethod ** write_method)
{
    /*
     * variables we may use later 
     */
    static u_long   ulong_ret;
	static unsigned char data[MAX_DATA_SIZE];
	u_long table_size;
	u_long len;
	oid count_id[] = {6, 17};


	if(IOCTL_SNMP("wlan0", count_id, OID_COUNT_LEN, data, &len) == -1){
		//snmp_log(LOG_INFO, "var_dot11WEPKeyMappingsTable: IOCT_SNMP failed \n");
		return NULL;
	};

	table_size = *(data+1);
		
    if (header_simple_table
        (vp, name, length, exact, var_len, write_method, table_size)
        == MATCH_FAILED)
        return NULL;

#define OID_SUPPORTEDDATARATESTX_LEN 5
	if(IOCTL_SNMP("wlan0", OID_TAIL(name), OID_SUPPORTEDDATARATESTX_LEN, data, &len) == -1){
		//snmp_log(LOG_INFO, "var_dot11WEPKeyMappingsTable: IOCT_SNMP failed \n");
		return NULL;
	};


    /*
     * this is where we do the value assignments for the mib results.
     */
    switch (vp->magic) {
    case DOT11SUPPORTEDDATARATESTXINDEX:
		if(len == 1)
			ulong_ret = 0;
		else
			ulong_ret = *(data + 1);

		return (u_char *) &ulong_ret;
    case DOT11SUPPORTEDDATARATESTXVALUE:
		if(len == 1)
			ulong_ret = 0;
		else
			ulong_ret = *((u_long *)(data + 1));

		return (u_char *) &ulong_ret;
    default:
        ERROR_MSG("var_dot11SupportedDataRatesTxTable: Error!!!\n");
    }
    return NULL;
}

/*
 * var_dot11SupportedDataRatesRxTable():
 *   Handle this table separately from the scalar value case.
 *   The workings of this are basically the same as for var_ieee802dot11 above.
 */
unsigned char  *
var_dot11SupportedDataRatesRxTable(struct variable *vp,
                                   oid * name,
                                   size_t *length,
                                   int exact,
                                   size_t *var_len,
                                   WriteMethod ** write_method)
{
    /*
     * variables we may use later 
     */
    static u_long   ulong_ret;
	static unsigned char data[MAX_DATA_SIZE];
	u_long table_size;
	u_long len;
	oid count_id[] = {6, 18};


	if(IOCTL_SNMP("wlan0", count_id, OID_COUNT_LEN, data, &len) == -1){
		//snmp_log(LOG_INFO, "var_dot11WEPKeyMappingsTable: IOCT_SNMP failed \n");
		return NULL;
	};

	table_size = *(data+1);
		
    if (header_simple_table
        (vp, name, length, exact, var_len, write_method, table_size)
        == MATCH_FAILED)
        return NULL;

#define OID_SUPPORTEDDATARATESRX_LEN 5
	if(IOCTL_SNMP("wlan0", OID_TAIL(name), OID_SUPPORTEDDATARATESRX_LEN, data, &len) == -1){
		//snmp_log(LOG_INFO, "var_dot11WEPKeyMappingsTable: IOCT_SNMP failed \n");
		return NULL;
	};

    /*
     * this is where we do the value assignments for the mib results.
     */
    switch (vp->magic) {
    case DOT11SUPPORTEDDATARATESRXINDEX:
		if(len == 1)
			ulong_ret = 0;
		else
			ulong_ret = *(data + 1);

		return (u_char *) &ulong_ret;
    case DOT11SUPPORTEDDATARATESRXVALUE:
		if(len == 1)
			ulong_ret = 0;
		else
			ulong_ret = *((u_long *)(data + 1));

		return (u_char *) &ulong_ret;
    default:
        ERROR_MSG("var_dot11SupportedDataRatesRxTable: Error!!!\n");
    }
    return NULL;
}


int
write_dot11StationID(int action,
                     u_char * var_val,
                     u_char var_val_type,
                     size_t var_val_len,
                     u_char * statP, oid * name, size_t name_len)
{
    char            value;
    int             size;
	int 			i;
	char			ucTmp[2]="F";

    switch (action) {
    case RESERVE1:
        if (var_val_type != ASN_OCTET_STR) {
            fprintf(stderr, "write to ieee802dot11 not ASN_OCTET_STR\n");
            return SNMP_ERR_WRONGTYPE;
        }
        if (var_val_len != 12) {
            fprintf(stderr, "write to ieee802dot11 value is wrong\n");
            return SNMP_ERR_WRONGLENGTH;
        }

		for( i = 0 ; i < var_val_len ; i++ )
		{
			memcpy(ucTmp,&var_val[i],1);

			if( (*ucTmp >= 0x30 )&&( *ucTmp <= 0x39)|| 		// 0--9
				(*ucTmp >= 0x41 )&&( *ucTmp <= 0x46)|| 		// A--F
				(*ucTmp >= 0x61 )&&( *ucTmp <= 0x66))		// a--f
			{
//				snmp_log(LOG_INFO, "Continue\n");
				continue;
			}
			return SNMP_ERR_WRONGVALUE;
		}
        break;

    case RESERVE2:
        size = var_val_len;
        value = *(char *) var_val;

        break;

    case FREE:
        /*
         * Release any resources that have been allocated 
         */
        break;

    case ACTION:
		var_val_len = _translateWordToByte( var_val ,var_val_len );
		apmib_set( MIB_WLAN_MAC_ADDR,var_val );
        break;

    case UNDO:
        /*
         * Back out any changes made in the ACTION case 
         */
        break;

    case COMMIT:
        /*
         * Things are working well, so it's now safe to make the change
         * permanently.  Make sure that anything done here can't fail!
         */
        break;
    }
    return SNMP_ERR_NOERROR;
}

int
write_dot11MediumOccupancyLimit(int action,
                                u_char * var_val,
                                u_char var_val_type,
                                size_t var_val_len,
                                u_char * statP,
                                oid * name, size_t name_len)
{
    long            value;
    int             size;

	// not implement
    return SNMP_ERR_NOERROR;


    switch (action) {
    case RESERVE1:
        if (var_val_type != ASN_INTEGER) {
            fprintf(stderr, "write to ieee802dot11 not ASN_INTEGER\n");
            return SNMP_ERR_WRONGTYPE;
        }
        if (var_val_len > sizeof(long)) {
            fprintf(stderr, "write to ieee802dot11: bad length\n");
            return SNMP_ERR_WRONGLENGTH;
        }
        break;

    case RESERVE2:
        size = var_val_len;
        value = *(long *) var_val;

        break;

    case FREE:
        /*
         * Release any resources that have been allocated 
         */
        break;

    case ACTION:
        /*
         * The variable has been stored in 'value' for you to use,
         * and you have just been asked to do something with it.
         * Note that anything done here must be reversable in the UNDO case
         */
        break;

    case UNDO:
        /*
         * Back out any changes made in the ACTION case 
         */
        break;

    case COMMIT:
        /*
         * Things are working well, so it's now safe to make the change
         * permanently.  Make sure that anything done here can't fail!
         */
        break;
    }
    return SNMP_ERR_NOERROR;
}

int
write_dot11CFPPeriod(int action,
                     u_char * var_val,
                     u_char var_val_type,
                     size_t var_val_len,
                     u_char * statP, oid * name, size_t name_len)
{
    long            value;
    int             size;
	// not implement
    return SNMP_ERR_NOERROR;

    switch (action) {
    case RESERVE1:
        if (var_val_type != ASN_INTEGER) {
            fprintf(stderr, "write to ieee802dot11 not ASN_INTEGER\n");
            return SNMP_ERR_WRONGTYPE;
        }
        if (var_val_len > sizeof(long)) {
            fprintf(stderr, "write to ieee802dot11: bad length\n");
            return SNMP_ERR_WRONGLENGTH;
        }
        break;

    case RESERVE2:
        size = var_val_len;
        value = *(long *) var_val;

        break;

    case FREE:
        /*
         * Release any resources that have been allocated 
         */
        break;

    case ACTION:
        /*
         * The variable has been stored in 'value' for you to use,
         * and you have just been asked to do something with it.
         * Note that anything done here must be reversable in the UNDO case
         */
        break;

    case UNDO:
        /*
         * Back out any changes made in the ACTION case 
         */
        break;

    case COMMIT:
        /*
         * Things are working well, so it's now safe to make the change
         * permanently.  Make sure that anything done here can't fail!
         */
        break;
    }
    return SNMP_ERR_NOERROR;
}

int
write_dot11CFPMaxDuration(int action,
                          u_char * var_val,
                          u_char var_val_type,
                          size_t var_val_len,
                          u_char * statP, oid * name, size_t name_len)
{
    long            value;
    int             size;
	// not implement
    return SNMP_ERR_NOERROR;

    switch (action) {
    case RESERVE1:
        if (var_val_type != ASN_INTEGER) {
            fprintf(stderr, "write to ieee802dot11 not ASN_INTEGER\n");
            return SNMP_ERR_WRONGTYPE;
        }
        if (var_val_len > sizeof(long)) {
            fprintf(stderr, "write to ieee802dot11: bad length\n");
            return SNMP_ERR_WRONGLENGTH;
        }
        break;

    case RESERVE2:
        size = var_val_len;
        value = *(long *) var_val;

        break;

    case FREE:
        /*
         * Release any resources that have been allocated 
         */
        break;

    case ACTION:
        /*
         * The variable has been stored in 'value' for you to use,
         * and you have just been asked to do something with it.
         * Note that anything done here must be reversable in the UNDO case
         */
        break;

    case UNDO:
        /*
         * Back out any changes made in the ACTION case 
         */
        break;

    case COMMIT:
        /*
         * Things are working well, so it's now safe to make the change
         * permanently.  Make sure that anything done here can't fail!
         */
        break;
    }
    return SNMP_ERR_NOERROR;
}

int
write_dot11AuthenticationResponseTimeOut(int action,
                                         u_char * var_val,
                                         u_char var_val_type,
                                         size_t var_val_len,
                                         u_char * statP,
                                         oid * name, size_t name_len)
{
    long            value;
    int             size;
	// not implement
    return SNMP_ERR_NOERROR;

    switch (action) {
    case RESERVE1:
        if (var_val_type != ASN_INTEGER) {
            fprintf(stderr, "write to ieee802dot11 not ASN_INTEGER\n");
            return SNMP_ERR_WRONGTYPE;
        }
        if (var_val_len > sizeof(long)) {
            fprintf(stderr, "write to ieee802dot11: bad length\n");
            return SNMP_ERR_WRONGLENGTH;
        }
        break;

    case RESERVE2:
        size = var_val_len;
        value = *(long *) var_val;

        break;

    case FREE:
        /*
         * Release any resources that have been allocated 
         */
        break;

    case ACTION:
        /*
         * The variable has been stored in 'value' for you to use,
         * and you have just been asked to do something with it.
         * Note that anything done here must be reversable in the UNDO case
         */
        break;

    case UNDO:
        /*
         * Back out any changes made in the ACTION case 
         */
        break;

    case COMMIT:
        /*
         * Things are working well, so it's now safe to make the change
         * permanently.  Make sure that anything done here can't fail!
         */
        break;
    }
    return SNMP_ERR_NOERROR;
}

int
write_dot11PowerManagementMode(int action,
                               u_char * var_val,
                               u_char var_val_type,
                               size_t var_val_len,
                               u_char * statP, oid * name, size_t name_len)
{
    long            value;
    int             size;
	// not implement
    return SNMP_ERR_NOERROR;

    switch (action) {
    case RESERVE1:
        if (var_val_type != ASN_INTEGER) {
            fprintf(stderr, "write to ieee802dot11 not ASN_INTEGER\n");
            return SNMP_ERR_WRONGTYPE;
        }
        if (var_val_len > sizeof(long)) {
            fprintf(stderr, "write to ieee802dot11: bad length\n");
            return SNMP_ERR_WRONGLENGTH;
        }
        break;

    case RESERVE2:
        size = var_val_len;
        value = *(long *) var_val;

        break;

    case FREE:
        /*
         * Release any resources that have been allocated 
         */
        break;

    case ACTION:
        /*
         * The variable has been stored in 'value' for you to use,
         * and you have just been asked to do something with it.
         * Note that anything done here must be reversable in the UNDO case
         */
        break;

    case UNDO:
        /*
         * Back out any changes made in the ACTION case 
         */
        break;

    case COMMIT:
        /*
         * Things are working well, so it's now safe to make the change
         * permanently.  Make sure that anything done here can't fail!
         */
        break;
    }
    return SNMP_ERR_NOERROR;
}

int
write_dot11DesiredSSID(int action,
                       u_char * var_val,
                       u_char var_val_type,
                       size_t var_val_len,
                       u_char * statP, oid * name, size_t name_len)
{
    char            value;
    int             size;

    switch (action) {
    case RESERVE1:
        if (var_val_type != ASN_OCTET_STR) {
            fprintf(stderr, "write to ieee802dot11 not ASN_OCTET_STR\n");
            return SNMP_ERR_WRONGTYPE;
        }

        if (var_val_len > 32 ) {
            fprintf(stderr, "write to ieee802dot11: bad length\n");
            return SNMP_ERR_WRONGLENGTH;
        }
        break;

    case RESERVE2:
        size = var_val_len;
        value = *(char *) var_val;

        break;

    case FREE:
        /*
         * Release any resources that have been allocated 
         */
        break;

    case ACTION:
        /*
         * The variable has been stored in 'value' for you to use,
         * and you have just been asked to do something with it.
         * Note that anything done here must be reversable in the UNDO case
         */
	var_val[ var_val_len ] = '\0';
	apmib_set(MIB_WLAN_SSID,var_val);
        break;

    case UNDO:
        /*
         * Back out any changes made in the ACTION case 
         */
        break;

    case COMMIT:
        /*
         * Things are working well, so it's now safe to make the change
         * permanently.  Make sure that anything done here can't fail!
         */
        break;
    }
    return SNMP_ERR_NOERROR;
}

int
write_dot11DesiredBSSType(int action,
                          u_char * var_val,
                          u_char var_val_type,
                          size_t var_val_len,
                          u_char * statP, oid * name, size_t name_len)
{
    int            value;
    int             size;

    value = *(long *) var_val;
//    snmp_log(LOG_INFO, "value = %d\n",value);

    switch (action) {
    case RESERVE1:

//		snmp_log(LOG_INFO, "var_val = %d\n",*var_val);
        if (var_val_type != ASN_INTEGER) {
            fprintf(stderr, "write to ieee802dot11 not ASN_INTEGER\n");
            return SNMP_ERR_WRONGTYPE;
        }

       if ( value < 1 || value > 2 ) 
		{
            fprintf(stderr, "write to ieee802dot11: wrong value\n");
            return SNMP_ERR_WRONGVALUE;
        }
        break;

    case RESERVE2:
        break;

    case FREE:
        /*
         * Release any resources that have been allocated 
         */
        break;

    case ACTION:
        /*
         * The variable has been stored in 'value' for you to use,
         * and you have just been asked to do something with it.
         * Note that anything done here must be reversable in the UNDO case
         */

//	 	snmp_log(LOG_INFO, "write_dot11DesiredBSSType: var_val = %d\n",*var_val);

		// translate between 8186 and agent
		// 8186                     agent
		// infrastructure---->0     ----->1
		// Ad hoc ----------->1     ----->2		
		value--;
		apmib_set( MIB_WLAN_NETWORK_TYPE,&value );

        break;

    case UNDO:
        /*
         * Back out any changes made in the ACTION case 
         */
        break;

    case COMMIT:
        /*
         * Things are working well, so it's now safe to make the change
         * permanently.  Make sure that anything done here can't fail!
         */
        break;
    }
    return SNMP_ERR_NOERROR;
}

int
write_dot11OperationalRateSet(int action,
                              u_char * var_val,
                              u_char var_val_type,
                              size_t var_val_len,
                              u_char * statP, oid * name, size_t name_len)
{
    char            value;
    int             size;
	u_long			ul_set;
    switch (action) {
    case RESERVE1:
        if (var_val_type != ASN_OCTET_STR) {
            fprintf(stderr, "write to ieee802dot11 not ASN_OCTET_STR\n");
            return SNMP_ERR_WRONGTYPE;
        }
        if ( (var_val_len % 2) != 0 ) {
            fprintf(stderr, "write to ieee802dot11: bad length\n");
            return SNMP_ERR_WRONGLENGTH;
        }
        break;

    case RESERVE2:
	case FREE:
    case UNDO:
    case COMMIT:
         break;

    case ACTION:
		var_val_len = _translateWordToByte( var_val ,var_val_len );
		ul_set = _translateOperationRateTo8186( var_val ,var_val_len );
		snmp_log(LOG_INFO, "ul_set = %x\n",ul_set );		
		apmib_set(MIB_WLAN_SUPPORTED_RATE,(void *)&ul_set  );
		
        break;

    }
    return SNMP_ERR_NOERROR;
}

int
write_dot11BeaconPeriod(int action,
                        u_char * var_val,
                        u_char var_val_type,
                        size_t var_val_len,
                        u_char * statP, oid * name, size_t name_len)
{
    long            value;
    int             size;

	value = *(long *) var_val;

    switch (action) {
    case RESERVE1:
        if (var_val_type != ASN_INTEGER) {
            fprintf(stderr, "write to ieee802dot11 not ASN_INTEGER\n");
            return SNMP_ERR_WRONGTYPE;
        }
		if ( (value < 1) || (value > 65535) ) 
		{
            fprintf(stderr, "write to ieee802dot11: wrong value\n");
            return SNMP_ERR_WRONGVALUE;
        }		
        break;

    case RESERVE2:
	case FREE:
    case UNDO:
    case COMMIT:
         break;

    case ACTION:
		apmib_set( MIB_WLAN_BEACON_INTERVAL,&value );
        break;

    }
    return SNMP_ERR_NOERROR;
}

int
write_dot11DTIMPeriod(int action,
                      u_char * var_val,
                      u_char var_val_type,
                      size_t var_val_len,
                      u_char * statP, oid * name, size_t name_len)
{
    long            value;
    int             size;

    value = *(long *) var_val;
//    snmp_log(LOG_INFO, "value = %d\n",value);

    switch (action) {
    case RESERVE1:
        if (var_val_type != ASN_INTEGER) {
            fprintf(stderr, "write to ieee802dot11 not ASN_INTEGER\n");
            return SNMP_ERR_WRONGTYPE;
        }
        if (var_val_len > sizeof(long)) {
            fprintf(stderr, "write to ieee802dot11: bad length\n");
            return SNMP_ERR_WRONGLENGTH;
        }

		if ( value > 255 ) 
		{
            fprintf(stderr, "write to ieee802dot11: wrong value\n");
            return SNMP_ERR_WRONGVALUE;
        }		
        break;

    case RESERVE2:
    case COMMIT:
    case FREE:
    case UNDO:
        break;
 
    case ACTION:
        /*
         * The variable has been stored in 'value' for you to use,
         * and you have just been asked to do something with it.
         * Note that anything done here must be reversable in the UNDO case
         */
        apmib_set(MIB_WLAN_DTIM_PERIOD,&value);
        break;
    }
    return SNMP_ERR_NOERROR;
}

int
write_dot11AssociationResponseTimeOut(int action,
                                      u_char * var_val,
                                      u_char var_val_type,
                                      size_t var_val_len,
                                      u_char * statP,
                                      oid * name, size_t name_len)
{
    long            value;
    int             size;
	// not implement
    return SNMP_ERR_NOERROR;

    switch (action) {
    case RESERVE1:
        if (var_val_type != ASN_INTEGER) {
            fprintf(stderr, "write to ieee802dot11 not ASN_INTEGER\n");
            return SNMP_ERR_WRONGTYPE;
        }
        if (var_val_len > sizeof(long)) {
            fprintf(stderr, "write to ieee802dot11: bad length\n");
            return SNMP_ERR_WRONGLENGTH;
        }
        break;

    case RESERVE2:
        size = var_val_len;
        value = *(long *) var_val;

        break;

    case FREE:
        /*
         * Release any resources that have been allocated 
         */
        break;

    case ACTION:
        /*
         * The variable has been stored in 'value' for you to use,
         * and you have just been asked to do something with it.
         * Note that anything done here must be reversable in the UNDO case
         */
        break;

    case UNDO:
        /*
         * Back out any changes made in the ACTION case 
         */
        break;

    case COMMIT:
        /*
         * Things are working well, so it's now safe to make the change
         * permanently.  Make sure that anything done here can't fail!
         */
        break;
    }
    return SNMP_ERR_NOERROR;
}

int
write_dot11AuthenticationAlgorithmsEnable(int action,
                                          u_char * var_val,
                                          u_char var_val_type,
                                          size_t var_val_len,
                                          u_char * statP,
                                          oid * name, size_t name_len)
{
    long            value;
    int             size;
	int 			table_value,auth_type;

    switch (action) {
    case RESERVE1:
        if (var_val_type != ASN_INTEGER) {
            fprintf(stderr, "write to ieee802dot11 not ASN_INTEGER\n");
            return SNMP_ERR_WRONGTYPE;
        }
        break;

    case RESERVE2:
        size = var_val_len;
        value = *(long *) var_val;

        break;

    case FREE:
        /*
         * Release any resources that have been allocated 
         */
        break;

    case ACTION:
	        value = *(long *) var_val;
			table_value = name[name_len-1];

			if( value == 0 )
			{
				if( table_value == 1 )
				{
					value = 2;
				}
				else
				{
					value = 1;
				}
				value = value - 1;
				apmib_set(MIB_WLAN_AUTH_TYPE,&value);				
			}
			else
			{
				apmib_get(MIB_WLAN_AUTH_TYPE, (void *)&auth_type);
				auth_type = auth_type + 1;
				auth_type = auth_type | table_value;
				auth_type = auth_type - 1;
				apmib_set(MIB_WLAN_AUTH_TYPE,&auth_type);
			}
        break;

    case UNDO:
        /*
         * Back out any changes made in the ACTION case 
         */
        break;

    case COMMIT:
        /*
         * Things are working well, so it's now safe to make the change
         * permanently.  Make sure that anything done here can't fail!
         */
        break;
    }
    return SNMP_ERR_NOERROR;
}

int
write_dot11WEPDefaultKeyValue(int action,
                              u_char * var_val,
                              u_char var_val_type,
                              size_t var_val_len,
                              u_char * statP, oid * name, size_t name_len)
{
    char            value;
    int             size;
	int 			wep_offset,wep;

    switch (action) {
    case RESERVE1:

        if (var_val_type != ASN_OCTET_STR) {
            fprintf(stderr, "write to ieee802dot11 not ASN_OCTET_STR\n");
            return SNMP_ERR_WRONGTYPE;
        }

		apmib_get(MIB_WLAN_WEP, (void *)&wep);

		if( wep == 1 )
		{
	        if (var_val_len != 5 ) 
			{
	            fprintf(stderr, "write to ieee802dot11: bad length\n");
	            return SNMP_ERR_WRONGLENGTH;
		    }		
		}
		else
		{
	        if (var_val_len != 13 ) 
			{
	            fprintf(stderr, "write to ieee802dot11: bad length\n");
	            return SNMP_ERR_WRONGLENGTH;
        	}		
		}
        break;

    case RESERVE2:
        size = var_val_len;
        value = *(char *) var_val;
        break;

    case FREE:
    case UNDO:
    case COMMIT:
        break;

    case ACTION:
			wep_offset = name[name_len-1] - 1;
			apmib_get(MIB_WLAN_WEP, (void *)&wep);
//			snmp_log(LOG_INFO, "wep = %d\n",wep);
//			snmp_log(LOG_INFO, "wep_offset = %d\n",wep_offset);
//			snmp_log(LOG_INFO, "MIB_WLAN_WEP64_KEY1+wep_offset = %d\n",MIB_WLAN_WEP64_KEY1+wep_offset );
			if (wep == 1) 
			{
				apmib_set(MIB_WLAN_WEP64_KEY1+wep_offset ,var_val);
			}
			else
			{
				apmib_set(MIB_WLAN_WEP128_KEY1+wep_offset ,var_val);
			}
//			*var_len = strlen(string);
        break;
    }
    return SNMP_ERR_NOERROR;
}

int
write_dot11WEPKeyMappingAddress(int action,
                                u_char * var_val,
                                u_char var_val_type,
                                size_t var_val_len,
                                u_char * statP,
                                oid * name, size_t name_len)
{
    char            value;
    int             size;
	// not implement
    return SNMP_ERR_NOERROR;

    switch (action) {
    case RESERVE1:
        if (var_val_type != ASN_OCTET_STR) {
            fprintf(stderr, "write to ieee802dot11 not ASN_OCTET_STR\n");
            return SNMP_ERR_WRONGTYPE;
        }
        if (var_val_len > sizeof(char)) {
            fprintf(stderr, "write to ieee802dot11: bad length\n");
            return SNMP_ERR_WRONGLENGTH;
        }
        break;

    case RESERVE2:
        size = var_val_len;
        value = *(char *) var_val;

        break;

    case FREE:
        /*
         * Release any resources that have been allocated 
         */
        break;

    case ACTION:
        /*
         * The variable has been stored in 'value' for you to use,
         * and you have just been asked to do something with it.
         * Note that anything done here must be reversable in the UNDO case
         */
        break;

    case UNDO:
        /*
         * Back out any changes made in the ACTION case 
         */
        break;

    case COMMIT:
        /*
         * Things are working well, so it's now safe to make the change
         * permanently.  Make sure that anything done here can't fail!
         */
        break;
    }
    return SNMP_ERR_NOERROR;
}

int
write_dot11WEPKeyMappingWEPOn(int action,
                              u_char * var_val,
                              u_char var_val_type,
                              size_t var_val_len,
                              u_char * statP, oid * name, size_t name_len)
{
    long            value;
    int             size;
	// not implement
    return SNMP_ERR_NOERROR;

    switch (action) {
    case RESERVE1:
        if (var_val_type != ASN_INTEGER) {
            fprintf(stderr, "write to ieee802dot11 not ASN_INTEGER\n");
            return SNMP_ERR_WRONGTYPE;
        }
        if (var_val_len > sizeof(long)) {
            fprintf(stderr, "write to ieee802dot11: bad length\n");
            return SNMP_ERR_WRONGLENGTH;
        }
        break;

    case RESERVE2:
        size = var_val_len;
        value = *(long *) var_val;

        break;

    case FREE:
        /*
         * Release any resources that have been allocated 
         */
        break;

    case ACTION:
        /*
         * The variable has been stored in 'value' for you to use,
         * and you have just been asked to do something with it.
         * Note that anything done here must be reversable in the UNDO case
         */
        break;

    case UNDO:
        /*
         * Back out any changes made in the ACTION case 
         */
        break;

    case COMMIT:
        /*
         * Things are working well, so it's now safe to make the change
         * permanently.  Make sure that anything done here can't fail!
         */
        break;
    }
    return SNMP_ERR_NOERROR;
}

int
write_dot11WEPKeyMappingValue(int action,
                              u_char * var_val,
                              u_char var_val_type,
                              size_t var_val_len,
                              u_char * statP, oid * name, size_t name_len)
{
    char            value;
    int             size;
	// not implement
    return SNMP_ERR_NOERROR;

    switch (action) {
    case RESERVE1:
        if (var_val_type != ASN_OCTET_STR) {
            fprintf(stderr, "write to ieee802dot11 not ASN_OCTET_STR\n");
            return SNMP_ERR_WRONGTYPE;
        }
        if (var_val_len > sizeof(char)) {
            fprintf(stderr, "write to ieee802dot11: bad length\n");
            return SNMP_ERR_WRONGLENGTH;
        }
        break;

    case RESERVE2:
        size = var_val_len;
        value = *(char *) var_val;

        break;

    case FREE:
        /*
         * Release any resources that have been allocated 
         */
        break;

    case ACTION:
        /*
         * The variable has been stored in 'value' for you to use,
         * and you have just been asked to do something with it.
         * Note that anything done here must be reversable in the UNDO case
         */
        break;

    case UNDO:
        /*
         * Back out any changes made in the ACTION case 
         */
        break;

    case COMMIT:
        /*
         * Things are working well, so it's now safe to make the change
         * permanently.  Make sure that anything done here can't fail!
         */
        break;
    }
    return SNMP_ERR_NOERROR;
}

int
write_dot11WEPKeyMappingStatus(int action,
                               u_char * var_val,
                               u_char var_val_type,
                               size_t var_val_len,
                               u_char * statP, oid * name, size_t name_len)
{
    long            value;
    int             size;
	// not implement
    return SNMP_ERR_NOERROR;

    switch (action) {
    case RESERVE1:
        if (var_val_type != ASN_INTEGER) {
            fprintf(stderr, "write to ieee802dot11 not ASN_INTEGER\n");
            return SNMP_ERR_WRONGTYPE;
        }
        if (var_val_len > sizeof(long)) {
            fprintf(stderr, "write to ieee802dot11: bad length\n");
            return SNMP_ERR_WRONGLENGTH;
        }
        break;

    case RESERVE2:
        size = var_val_len;
        value = *(long *) var_val;

        break;

    case FREE:
        /*
         * Release any resources that have been allocated 
         */
        break;

    case ACTION:
        /*
         * The variable has been stored in 'value' for you to use,
         * and you have just been asked to do something with it.
         * Note that anything done here must be reversable in the UNDO case
         */
        break;

    case UNDO:
        /*
         * Back out any changes made in the ACTION case 
         */
        break;

    case COMMIT:
        /*
         * Things are working well, so it's now safe to make the change
         * permanently.  Make sure that anything done here can't fail!
         */
        break;
    }
    return SNMP_ERR_NOERROR;
}

int
write_dot11PrivacyInvoked(int action,
                          u_char * var_val,
                          u_char var_val_type,
                          size_t var_val_len,
                          u_char * statP, oid * name, size_t name_len)
{
    long            value;
    int             size;

	value = *(long *) var_val;
	
    switch (action) {
    case RESERVE1:
        if (var_val_type != ASN_INTEGER) {
            fprintf(stderr, "write to ieee802dot11 not ASN_INTEGER\n");
            return SNMP_ERR_WRONGTYPE;
        }
        break;

    case RESERVE2:
    case UNDO:
    case FREE:
    case COMMIT:
        break;

    case ACTION:
		if( value != 0) value = 1;
		
		apmib_set( MIB_WLAN_ENCRYPT, &value );
        break;

    }
    return SNMP_ERR_NOERROR;
}

int
write_dot11WEPDefaultKeyID(int action,
                           u_char * var_val,
                           u_char var_val_type,
                           size_t var_val_len,
                           u_char * statP, oid * name, size_t name_len)
{
    long            value;
    int             size;

	value = *(long *) var_val;
	
    switch (action) 
	{
	    case RESERVE1:
	        if (var_val_type != ASN_INTEGER) {
	            fprintf(stderr, "write to ieee802dot11 not ASN_INTEGER\n");
	            return SNMP_ERR_WRONGTYPE;
	        }
	        if ( value > 3 ) {
	            fprintf(stderr, "write to ieee802dot11: wrong value\n");
	            return SNMP_ERR_WRONGVALUE;
	        }
	        break;

	    case FREE:
	    case UNDO:
	    case RESERVE2:
	    case COMMIT:
	        break;

	    case ACTION:
			apmib_set(MIB_WLAN_WEP_DEFAULT_KEY, (void *)&value);
	        break;

    }
    return SNMP_ERR_NOERROR;
}

int
write_dot11WEPKeyMappingLength(int action,
                               u_char * var_val,
                               u_char var_val_type,
                               size_t var_val_len,
                               u_char * statP, oid * name, size_t name_len)
{
    long            value;
    int             size;
	// not implement
    return SNMP_ERR_NOERROR;

    switch (action) {
    case RESERVE1:
        if (var_val_type != ASN_INTEGER) {
            fprintf(stderr, "write to ieee802dot11 not ASN_INTEGER\n");
            return SNMP_ERR_WRONGTYPE;
        }
        if (var_val_len > sizeof(long)) {
            fprintf(stderr, "write to ieee802dot11: bad length\n");
            return SNMP_ERR_WRONGLENGTH;
        }
        break;

    case RESERVE2:
        size = var_val_len;
        value = *(long *) var_val;

        break;

    case FREE:
        /*
         * Release any resources that have been allocated 
         */
        break;

    case ACTION:
        /*
         * The variable has been stored in 'value' for you to use,
         * and you have just been asked to do something with it.
         * Note that anything done here must be reversable in the UNDO case
         */
        break;

    case UNDO:
        /*
         * Back out any changes made in the ACTION case 
         */
        break;

    case COMMIT:
        /*
         * Things are working well, so it's now safe to make the change
         * permanently.  Make sure that anything done here can't fail!
         */
        break;
    }
    return SNMP_ERR_NOERROR;
}

int
write_dot11ExcludeUnencrypted(int action,
                              u_char * var_val,
                              u_char var_val_type,
                              size_t var_val_len,
                              u_char * statP, oid * name, size_t name_len)
{
    long            value;
    int             size;
	// not implement
    return SNMP_ERR_NOERROR;

    switch (action) {
    case RESERVE1:
        if (var_val_type != ASN_INTEGER) {
            fprintf(stderr, "write to ieee802dot11 not ASN_INTEGER\n");
            return SNMP_ERR_WRONGTYPE;
        }
        if (var_val_len > sizeof(long)) {
            fprintf(stderr, "write to ieee802dot11: bad length\n");
            return SNMP_ERR_WRONGLENGTH;
        }
        break;

    case RESERVE2:
        size = var_val_len;
        value = *(long *) var_val;

        break;

    case FREE:
        /*
         * Release any resources that have been allocated 
         */
        break;

    case ACTION:
        /*
         * The variable has been stored in 'value' for you to use,
         * and you have just been asked to do something with it.
         * Note that anything done here must be reversable in the UNDO case
         */
        break;

    case UNDO:
        /*
         * Back out any changes made in the ACTION case 
         */
        break;

    case COMMIT:
        /*
         * Things are working well, so it's now safe to make the change
         * permanently.  Make sure that anything done here can't fail!
         */
        break;
    }
    return SNMP_ERR_NOERROR;
}

int
write_dot11RTSThreshold(int action,
                        u_char * var_val,
                        u_char var_val_type,
                        size_t var_val_len,
                        u_char * statP, oid * name, size_t name_len)
{
    long            value;
    int             size;

	value = *(long *) var_val;
	
    switch (action) {
    case RESERVE1:
        if (var_val_type != ASN_INTEGER) {
            fprintf(stderr, "write to ieee802dot11 not ASN_INTEGER\n");
            return SNMP_ERR_WRONGTYPE;
        }

        if ( value > 2347 ) {
            fprintf(stderr, "write to ieee802dot11: wrong value\n");
            return SNMP_ERR_WRONGVALUE;
        }

        break;
    case RESERVE2:
	case FREE:
 	case UNDO:
	case COMMIT:
         break;

    case ACTION:
		apmib_set(MIB_WLAN_RTS_THRESHOLD, &value);
        break;
    }
    return SNMP_ERR_NOERROR;
}

int
write_dot11ShortRetryLimit(int action,
                           u_char * var_val,
                           u_char var_val_type,
                           size_t var_val_len,
                           u_char * statP, oid * name, size_t name_len)
{
    long            value;
    int             size;
	// not implement
    return SNMP_ERR_NOERROR;

    switch (action) {
    case RESERVE1:
        if (var_val_type != ASN_INTEGER) {
            fprintf(stderr, "write to ieee802dot11 not ASN_INTEGER\n");
            return SNMP_ERR_WRONGTYPE;
        }
        if (var_val_len > sizeof(long)) {
            fprintf(stderr, "write to ieee802dot11: bad length\n");
            return SNMP_ERR_WRONGLENGTH;
        }
        break;

    case RESERVE2:
        size = var_val_len;
        value = *(long *) var_val;

        break;

    case FREE:
        /*
         * Release any resources that have been allocated 
         */
        break;

    case ACTION:
        /*
         * The variable has been stored in 'value' for you to use,
         * and you have just been asked to do something with it.
         * Note that anything done here must be reversable in the UNDO case
         */
        break;

    case UNDO:
        /*
         * Back out any changes made in the ACTION case 
         */
        break;

    case COMMIT:
        /*
         * Things are working well, so it's now safe to make the change
         * permanently.  Make sure that anything done here can't fail!
         */
        break;
    }
    return SNMP_ERR_NOERROR;
}

int
write_dot11LongRetryLimit(int action,
                          u_char * var_val,
                          u_char var_val_type,
                          size_t var_val_len,
                          u_char * statP, oid * name, size_t name_len)
{
    long            value;
    int             size;
	// not implement
    return SNMP_ERR_NOERROR;

    switch (action) {
    case RESERVE1:
        if (var_val_type != ASN_INTEGER) {
            fprintf(stderr, "write to ieee802dot11 not ASN_INTEGER\n");
            return SNMP_ERR_WRONGTYPE;
        }
        if (var_val_len > sizeof(long)) {
            fprintf(stderr, "write to ieee802dot11: bad length\n");
            return SNMP_ERR_WRONGLENGTH;
        }
        break;

    case RESERVE2:
        size = var_val_len;
        value = *(long *) var_val;

        break;

    case FREE:
        /*
         * Release any resources that have been allocated 
         */
        break;

    case ACTION:
        /*
         * The variable has been stored in 'value' for you to use,
         * and you have just been asked to do something with it.
         * Note that anything done here must be reversable in the UNDO case
         */
        break;

    case UNDO:
        /*
         * Back out any changes made in the ACTION case 
         */
        break;

    case COMMIT:
        /*
         * Things are working well, so it's now safe to make the change
         * permanently.  Make sure that anything done here can't fail!
         */
        break;
    }
    return SNMP_ERR_NOERROR;
}

int
write_dot11FragmentationThreshold(int action,
                                  u_char * var_val,
                                  u_char var_val_type,
                                  size_t var_val_len,
                                  u_char * statP,
                                  oid * name, size_t name_len)
{
    long            value;
    int             size;

	value = *(long *) var_val;

    switch (action) {
    case RESERVE1:
        if (var_val_type != ASN_INTEGER) {
            fprintf(stderr, "write to ieee802dot11 not ASN_INTEGER\n");
            return SNMP_ERR_WRONGTYPE;
        }
//		snmp_log(LOG_INFO, "value = %d \n",value);		
        if ( (value < 256) || (value > 2346)) {
            fprintf(stderr, "write to ieee802dot11: wrong value\n");
            return SNMP_ERR_WRONGVALUE;
        }
        break;

    case RESERVE2:
	case FREE:
 	case UNDO:
	case COMMIT:
         break;

    case ACTION:
		apmib_set(MIB_WLAN_FRAG_THRESHOLD, &value);
        break;
    }
    return SNMP_ERR_NOERROR;
}

int
write_dot11MaxTransmitMSDULifetime(int action,
                                   u_char * var_val,
                                   u_char var_val_type,
                                   size_t var_val_len,
                                   u_char * statP,
                                   oid * name, size_t name_len)
{
    long            value;
    int             size;
	// not implement
    return SNMP_ERR_NOERROR;

    switch (action) {
    case RESERVE1:
        if (var_val_type != ASN_INTEGER) {
            fprintf(stderr, "write to ieee802dot11 not ASN_INTEGER\n");
            return SNMP_ERR_WRONGTYPE;
        }
        if (var_val_len > sizeof(long)) {
            fprintf(stderr, "write to ieee802dot11: bad length\n");
            return SNMP_ERR_WRONGLENGTH;
        }
        break;

    case RESERVE2:
        size = var_val_len;
        value = *(long *) var_val;

        break;

    case FREE:
        /*
         * Release any resources that have been allocated 
         */
        break;

    case ACTION:
        /*
         * The variable has been stored in 'value' for you to use,
         * and you have just been asked to do something with it.
         * Note that anything done here must be reversable in the UNDO case
         */
        break;

    case UNDO:
        /*
         * Back out any changes made in the ACTION case 
         */
        break;

    case COMMIT:
        /*
         * Things are working well, so it's now safe to make the change
         * permanently.  Make sure that anything done here can't fail!
         */
        break;
    }
    return SNMP_ERR_NOERROR;
}

int
write_dot11MaxReceiveLifetime(int action,
                              u_char * var_val,
                              u_char var_val_type,
                              size_t var_val_len,
                              u_char * statP, oid * name, size_t name_len)
{
    long            value;
    int             size;
	// not implement
    return SNMP_ERR_NOERROR;

    switch (action) {
    case RESERVE1:
        if (var_val_type != ASN_INTEGER) {
            fprintf(stderr, "write to ieee802dot11 not ASN_INTEGER\n");
            return SNMP_ERR_WRONGTYPE;
        }
        if (var_val_len > sizeof(long)) {
            fprintf(stderr, "write to ieee802dot11: bad length\n");
            return SNMP_ERR_WRONGLENGTH;
        }
        break;

    case RESERVE2:
        size = var_val_len;
        value = *(long *) var_val;

        break;

    case FREE:
        /*
         * Release any resources that have been allocated 
         */
        break;

    case ACTION:
        /*
         * The variable has been stored in 'value' for you to use,
         * and you have just been asked to do something with it.
         * Note that anything done here must be reversable in the UNDO case
         */
        break;

    case UNDO:
        /*
         * Back out any changes made in the ACTION case 
         */
        break;

    case COMMIT:
        /*
         * Things are working well, so it's now safe to make the change
         * permanently.  Make sure that anything done here can't fail!
         */
        break;
    }
    return SNMP_ERR_NOERROR;
}

int
write_dot11Address(int action,
                   u_char * var_val,
                   u_char var_val_type,
                   size_t var_val_len,
                   u_char * statP, oid * name, size_t name_len)
{
    char            value;
    int             size;
	// not implement
    return SNMP_ERR_NOERROR;

    switch (action) {
    case RESERVE1:
        if (var_val_type != ASN_OCTET_STR) {
            fprintf(stderr, "write to ieee802dot11 not ASN_OCTET_STR\n");
            return SNMP_ERR_WRONGTYPE;
        }
        if (var_val_len > sizeof(char)) {
            fprintf(stderr, "write to ieee802dot11: bad length\n");
            return SNMP_ERR_WRONGLENGTH;
        }
        break;

    case RESERVE2:
        size = var_val_len;
        value = *(char *) var_val;

        break;

    case FREE:
        /*
         * Release any resources that have been allocated 
         */
        break;

    case ACTION:
        /*
         * The variable has been stored in 'value' for you to use,
         * and you have just been asked to do something with it.
         * Note that anything done here must be reversable in the UNDO case
         */
        break;

    case UNDO:
        /*
         * Back out any changes made in the ACTION case 
         */
        break;

    case COMMIT:
        /*
         * Things are working well, so it's now safe to make the change
         * permanently.  Make sure that anything done here can't fail!
         */
        break;
    }
    return SNMP_ERR_NOERROR;
}

int
write_dot11GroupAddressesStatus(int action,
                                u_char * var_val,
                                u_char var_val_type,
                                size_t var_val_len,
                                u_char * statP,
                                oid * name, size_t name_len)
{
    long            value;
    int             size;
	// not implement
    return SNMP_ERR_NOERROR;

    switch (action) {
    case RESERVE1:
        if (var_val_type != ASN_INTEGER) {
            fprintf(stderr, "write to ieee802dot11 not ASN_INTEGER\n");
            return SNMP_ERR_WRONGTYPE;
        }
        if (var_val_len > sizeof(long)) {
            fprintf(stderr, "write to ieee802dot11: bad length\n");
            return SNMP_ERR_WRONGLENGTH;
        }
        break;

    case RESERVE2:
        size = var_val_len;
        value = *(long *) var_val;

        break;

    case FREE:
        /*
         * Release any resources that have been allocated 
         */
        break;

    case ACTION:
        /*
         * The variable has been stored in 'value' for you to use,
         * and you have just been asked to do something with it.
         * Note that anything done here must be reversable in the UNDO case
         */
        break;

    case UNDO:
        /*
         * Back out any changes made in the ACTION case 
         */
        break;

    case COMMIT:
        /*
         * Things are working well, so it's now safe to make the change
         * permanently.  Make sure that anything done here can't fail!
         */
        break;
    }
    return SNMP_ERR_NOERROR;
}

int
write_dot11CurrentRegDomain(int action,
                            u_char * var_val,
                            u_char var_val_type,
                            size_t var_val_len,
                            u_char * statP, oid * name, size_t name_len)
{
    long            value;
    int             size;
	// not implement
    return SNMP_ERR_NOERROR;

    switch (action) {
    case RESERVE1:
        if (var_val_type != ASN_INTEGER) {
            fprintf(stderr, "write to ieee802dot11 not ASN_INTEGER\n");
            return SNMP_ERR_WRONGTYPE;
        }
        if (var_val_len > sizeof(long)) {
            fprintf(stderr, "write to ieee802dot11: bad length\n");
            return SNMP_ERR_WRONGLENGTH;
        }
        break;

    case RESERVE2:
        size = var_val_len;
        value = *(long *) var_val;

        break;

    case FREE:
        /*
         * Release any resources that have been allocated 
         */
        break;

    case ACTION:
        /*
         * The variable has been stored in 'value' for you to use,
         * and you have just been asked to do something with it.
         * Note that anything done here must be reversable in the UNDO case
         */
        break;

    case UNDO:
        /*
         * Back out any changes made in the ACTION case 
         */
        break;

    case COMMIT:
        /*
         * Things are working well, so it's now safe to make the change
         * permanently.  Make sure that anything done here can't fail!
         */
        break;
    }
    return SNMP_ERR_NOERROR;
}

int
write_dot11CurrentTxAntenna(int action,
                            u_char * var_val,
                            u_char var_val_type,
                            size_t var_val_len,
                            u_char * statP, oid * name, size_t name_len)
{
    long            value;
    int             size;

	value = *(long *) var_val;
	
    switch (action) {
    case RESERVE1:
        if (var_val_type != ASN_INTEGER) {
            fprintf(stderr, "write to ieee802dot11 not ASN_INTEGER\n");
            return SNMP_ERR_WRONGTYPE;
        }
        if ( ( value < 1 ) || (value > 255 )) {
            fprintf(stderr, "write to ieee802dot11: wrong value\n");
            return SNMP_ERR_WRONGVALUE;
        }
        break;

    case RESERVE2:
	case FREE:
 	case UNDO:
	case COMMIT:
         break;

    case ACTION:
		value--;
		apmib_set(MIB_HW_TX_ANT,(void *)&value);
        break;

    }
    return SNMP_ERR_NOERROR;
}

int
write_dot11CurrentRxAntenna(int action,
                            u_char * var_val,
                            u_char var_val_type,
                            size_t var_val_len,
                            u_char * statP, oid * name, size_t name_len)
{
    long            value;
    int             size;

	value = *(long *) var_val;
	
    switch (action) {
    case RESERVE1:
        if (var_val_type != ASN_INTEGER) {
            fprintf(stderr, "write to ieee802dot11 not ASN_INTEGER\n");
            return SNMP_ERR_WRONGTYPE;
        }
        if ( ( value < 1 ) || (value > 255 )) {
            fprintf(stderr, "write to ieee802dot11: wrong value\n");
            return SNMP_ERR_WRONGVALUE;
        }
		break;

	case RESERVE2:
	case UNDO:
	case COMMIT:
	case FREE:
         break;
		 
	case ACTION:
// 		snmp_log(LOG_INFO, "set_var_val = %d \n",*var_val);
		value--;
		apmib_set(MIB_HW_TX_ANT,(void *)&value);
        break;

    }
    return SNMP_ERR_NOERROR;
}

int
write_dot11CurrentTxPowerLevel(int action,
                               u_char * var_val,
                               u_char var_val_type,
                               size_t var_val_len,
                               u_char * statP, oid * name, size_t name_len)
{
    long            value;
    int             size;
	// not implement
    return SNMP_ERR_NOERROR;

    switch (action) {
    case RESERVE1:
        if (var_val_type != ASN_INTEGER) {
            fprintf(stderr, "write to ieee802dot11 not ASN_INTEGER\n");
            return SNMP_ERR_WRONGTYPE;
        }
        if (var_val_len > sizeof(long)) {
            fprintf(stderr, "write to ieee802dot11: bad length\n");
            return SNMP_ERR_WRONGLENGTH;
        }
        break;

    case RESERVE2:
        size = var_val_len;
        value = *(long *) var_val;

        break;

    case FREE:
        /*
         * Release any resources that have been allocated 
         */
        break;

    case ACTION:
        /*
         * The variable has been stored in 'value' for you to use,
         * and you have just been asked to do something with it.
         * Note that anything done here must be reversable in the UNDO case
         */
        break;

    case UNDO:
        /*
         * Back out any changes made in the ACTION case 
         */
        break;

    case COMMIT:
        /*
         * Things are working well, so it's now safe to make the change
         * permanently.  Make sure that anything done here can't fail!
         */
        break;
    }
    return SNMP_ERR_NOERROR;
}

int
write_dot11CurrentChannelNumber(int action,
                                u_char * var_val,
                                u_char var_val_type,
                                size_t var_val_len,
                                u_char * statP,
                                oid * name, size_t name_len)
{
    long            value;
    int             size;
	// not implement
    return SNMP_ERR_NOERROR;

    switch (action) {
    case RESERVE1:
        if (var_val_type != ASN_INTEGER) {
            fprintf(stderr, "write to ieee802dot11 not ASN_INTEGER\n");
            return SNMP_ERR_WRONGTYPE;
        }
        if (var_val_len > sizeof(long)) {
            fprintf(stderr, "write to ieee802dot11: bad length\n");
            return SNMP_ERR_WRONGLENGTH;
        }
        break;

    case RESERVE2:
        size = var_val_len;
        value = *(long *) var_val;

        break;

    case FREE:
        /*
         * Release any resources that have been allocated 
         */
        break;

    case ACTION:
        /*
         * The variable has been stored in 'value' for you to use,
         * and you have just been asked to do something with it.
         * Note that anything done here must be reversable in the UNDO case
         */
        break;

    case UNDO:
        /*
         * Back out any changes made in the ACTION case 
         */
        break;

    case COMMIT:
        /*
         * Things are working well, so it's now safe to make the change
         * permanently.  Make sure that anything done here can't fail!
         */
        break;
    }
    return SNMP_ERR_NOERROR;
}

int
write_dot11CurrentDwellTime(int action,
                            u_char * var_val,
                            u_char var_val_type,
                            size_t var_val_len,
                            u_char * statP, oid * name, size_t name_len)
{
    long            value;
    int             size;
	// not implement
    return SNMP_ERR_NOERROR;

    switch (action) {
    case RESERVE1:
        if (var_val_type != ASN_INTEGER) {
            fprintf(stderr, "write to ieee802dot11 not ASN_INTEGER\n");
            return SNMP_ERR_WRONGTYPE;
        }
        if (var_val_len > sizeof(long)) {
            fprintf(stderr, "write to ieee802dot11: bad length\n");
            return SNMP_ERR_WRONGLENGTH;
        }
        break;

    case RESERVE2:
        size = var_val_len;
        value = *(long *) var_val;

        break;

    case FREE:
        /*
         * Release any resources that have been allocated 
         */
        break;

    case ACTION:
        /*
         * The variable has been stored in 'value' for you to use,
         * and you have just been asked to do something with it.
         * Note that anything done here must be reversable in the UNDO case
         */
        break;

    case UNDO:
        /*
         * Back out any changes made in the ACTION case 
         */
        break;

    case COMMIT:
        /*
         * Things are working well, so it's now safe to make the change
         * permanently.  Make sure that anything done here can't fail!
         */
        break;
    }
    return SNMP_ERR_NOERROR;
}

int
write_dot11CurrentSet(int action,
                      u_char * var_val,
                      u_char var_val_type,
                      size_t var_val_len,
                      u_char * statP, oid * name, size_t name_len)
{
    long            value;
    int             size;
	// not implement
    return SNMP_ERR_NOERROR;

    switch (action) {
    case RESERVE1:
        if (var_val_type != ASN_INTEGER) {
            fprintf(stderr, "write to ieee802dot11 not ASN_INTEGER\n");
            return SNMP_ERR_WRONGTYPE;
        }
        if (var_val_len > sizeof(long)) {
            fprintf(stderr, "write to ieee802dot11: bad length\n");
            return SNMP_ERR_WRONGLENGTH;
        }
        break;

    case RESERVE2:
        size = var_val_len;
        value = *(long *) var_val;

        break;

    case FREE:
        /*
         * Release any resources that have been allocated 
         */
        break;

    case ACTION:
        /*
         * The variable has been stored in 'value' for you to use,
         * and you have just been asked to do something with it.
         * Note that anything done here must be reversable in the UNDO case
         */
        break;

    case UNDO:
        /*
         * Back out any changes made in the ACTION case 
         */
        break;

    case COMMIT:
        /*
         * Things are working well, so it's now safe to make the change
         * permanently.  Make sure that anything done here can't fail!
         */
        break;
    }
    return SNMP_ERR_NOERROR;
}

int
write_dot11CurrentPattern(int action,
                          u_char * var_val,
                          u_char var_val_type,
                          size_t var_val_len,
                          u_char * statP, oid * name, size_t name_len)
{
    long            value;
    int             size;
	// not implement
    return SNMP_ERR_NOERROR;

    switch (action) {
    case RESERVE1:
        if (var_val_type != ASN_INTEGER) {
            fprintf(stderr, "write to ieee802dot11 not ASN_INTEGER\n");
            return SNMP_ERR_WRONGTYPE;
        }
        if (var_val_len > sizeof(long)) {
            fprintf(stderr, "write to ieee802dot11: bad length\n");
            return SNMP_ERR_WRONGLENGTH;
        }
        break;

    case RESERVE2:
        size = var_val_len;
        value = *(long *) var_val;

        break;

    case FREE:
        /*
         * Release any resources that have been allocated 
         */
        break;

    case ACTION:
        /*
         * The variable has been stored in 'value' for you to use,
         * and you have just been asked to do something with it.
         * Note that anything done here must be reversable in the UNDO case
         */
        break;

    case UNDO:
        /*
         * Back out any changes made in the ACTION case 
         */
        break;

    case COMMIT:
        /*
         * Things are working well, so it's now safe to make the change
         * permanently.  Make sure that anything done here can't fail!
         */
        break;
    }
    return SNMP_ERR_NOERROR;
}

int
write_dot11CurrentIndex(int action,
                        u_char * var_val,
                        u_char var_val_type,
                        size_t var_val_len,
                        u_char * statP, oid * name, size_t name_len)
{
    long            value;
    int             size;
	// not implement
    return SNMP_ERR_NOERROR;

    switch (action) {
    case RESERVE1:
        if (var_val_type != ASN_INTEGER) {
            fprintf(stderr, "write to ieee802dot11 not ASN_INTEGER\n");
            return SNMP_ERR_WRONGTYPE;
        }
        if (var_val_len > sizeof(long)) {
            fprintf(stderr, "write to ieee802dot11: bad length\n");
            return SNMP_ERR_WRONGLENGTH;
        }
        break;

    case RESERVE2:
        size = var_val_len;
        value = *(long *) var_val;

        break;

    case FREE:
        /*
         * Release any resources that have been allocated 
         */
        break;

    case ACTION:
        /*
         * The variable has been stored in 'value' for you to use,
         * and you have just been asked to do something with it.
         * Note that anything done here must be reversable in the UNDO case
         */
        break;

    case UNDO:
        /*
         * Back out any changes made in the ACTION case 
         */
        break;

    case COMMIT:
        /*
         * Things are working well, so it's now safe to make the change
         * permanently.  Make sure that anything done here can't fail!
         */
        break;
    }
    return SNMP_ERR_NOERROR;
}

int
write_dot11CurrentChannel(int action,
                          u_char * var_val,
                          u_char var_val_type,
                          size_t var_val_len,
                          u_char * statP, oid * name, size_t name_len)
{
    long            value;
    int             size;
	// not implement
    return SNMP_ERR_NOERROR;

    switch (action) {
    case RESERVE1:
        if (var_val_type != ASN_INTEGER) {
            fprintf(stderr, "write to ieee802dot11 not ASN_INTEGER\n");
            return SNMP_ERR_WRONGTYPE;
        }
        if (var_val_len > sizeof(long)) {
            fprintf(stderr, "write to ieee802dot11: bad length\n");
            return SNMP_ERR_WRONGLENGTH;
        }
        break;

    case RESERVE2:
        size = var_val_len;
        value = *(long *) var_val;

        break;

    case FREE:
        /*
         * Release any resources that have been allocated 
         */
        break;

    case ACTION:
        /*
         * The variable has been stored in 'value' for you to use,
         * and you have just been asked to do something with it.
         * Note that anything done here must be reversable in the UNDO case
         */
        break;

    case UNDO:
        /*
         * Back out any changes made in the ACTION case 
         */
        break;

    case COMMIT:
        /*
         * Things are working well, so it's now safe to make the change
         * permanently.  Make sure that anything done here can't fail!
         */
        break;
    }
    return SNMP_ERR_NOERROR;
}

int
write_dot11CurrentCCAMode(int action,
                          u_char * var_val,
                          u_char var_val_type,
                          size_t var_val_len,
                          u_char * statP, oid * name, size_t name_len)
{
    long            value;
    int             size;
	// not implement
    return SNMP_ERR_NOERROR;

    switch (action) {
    case RESERVE1:
        if (var_val_type != ASN_INTEGER) {
            fprintf(stderr, "write to ieee802dot11 not ASN_INTEGER\n");
            return SNMP_ERR_WRONGTYPE;
        }
        if (var_val_len > sizeof(long)) {
            fprintf(stderr, "write to ieee802dot11: bad length\n");
            return SNMP_ERR_WRONGLENGTH;
        }
        break;

    case RESERVE2:
        size = var_val_len;
        value = *(long *) var_val;

        break;

    case FREE:
        /*
         * Release any resources that have been allocated 
         */
        break;

    case ACTION:
        /*
         * The variable has been stored in 'value' for you to use,
         * and you have just been asked to do something with it.
         * Note that anything done here must be reversable in the UNDO case
         */
        break;

    case UNDO:
        /*
         * Back out any changes made in the ACTION case 
         */
        break;

    case COMMIT:
        /*
         * Things are working well, so it's now safe to make the change
         * permanently.  Make sure that anything done here can't fail!
         */
        break;
    }
    return SNMP_ERR_NOERROR;
}

int
write_dot11EDThreshold(int action,
                       u_char * var_val,
                       u_char var_val_type,
                       size_t var_val_len,
                       u_char * statP, oid * name, size_t name_len)
{
    long            value;
    int             size;
	// not implement
    return SNMP_ERR_NOERROR;

    switch (action) {
    case RESERVE1:
        if (var_val_type != ASN_INTEGER) {
            fprintf(stderr, "write to ieee802dot11 not ASN_INTEGER\n");
            return SNMP_ERR_WRONGTYPE;
        }
        if (var_val_len > sizeof(long)) {
            fprintf(stderr, "write to ieee802dot11: bad length\n");
            return SNMP_ERR_WRONGLENGTH;
        }
        break;

    case RESERVE2:
        size = var_val_len;
        value = *(long *) var_val;

        break;

    case FREE:
        /*
         * Release any resources that have been allocated 
         */
        break;

    case ACTION:
        /*
         * The variable has been stored in 'value' for you to use,
         * and you have just been asked to do something with it.
         * Note that anything done here must be reversable in the UNDO case
         */
        break;

    case UNDO:
        /*
         * Back out any changes made in the ACTION case 
         */
        break;

    case COMMIT:
        /*
         * Things are working well, so it's now safe to make the change
         * permanently.  Make sure that anything done here can't fail!
         */
        break;
    }
    return SNMP_ERR_NOERROR;
}

int
write_dot11CCAWatchdogTimerMax(int action,
                               u_char * var_val,
                               u_char var_val_type,
                               size_t var_val_len,
                               u_char * statP, oid * name, size_t name_len)
{
    long            value;
    int             size;
	// not implement
    return SNMP_ERR_NOERROR;

    switch (action) {
    case RESERVE1:
        if (var_val_type != ASN_INTEGER) {
            fprintf(stderr, "write to ieee802dot11 not ASN_INTEGER\n");
            return SNMP_ERR_WRONGTYPE;
        }
        if (var_val_len > sizeof(long)) {
            fprintf(stderr, "write to ieee802dot11: bad length\n");
            return SNMP_ERR_WRONGLENGTH;
        }
        break;

    case RESERVE2:
        size = var_val_len;
        value = *(long *) var_val;

        break;

    case FREE:
        /*
         * Release any resources that have been allocated 
         */
        break;

    case ACTION:
        /*
         * The variable has been stored in 'value' for you to use,
         * and you have just been asked to do something with it.
         * Note that anything done here must be reversable in the UNDO case
         */
        break;

    case UNDO:
        /*
         * Back out any changes made in the ACTION case 
         */
        break;

    case COMMIT:
        /*
         * Things are working well, so it's now safe to make the change
         * permanently.  Make sure that anything done here can't fail!
         */
        break;
    }
    return SNMP_ERR_NOERROR;
}

int
write_dot11CCAWatchdogCountMax(int action,
                               u_char * var_val,
                               u_char var_val_type,
                               size_t var_val_len,
                               u_char * statP, oid * name, size_t name_len)
{
    long            value;
    int             size;
	// not implement
    return SNMP_ERR_NOERROR;

    switch (action) {
    case RESERVE1:
        if (var_val_type != ASN_INTEGER) {
            fprintf(stderr, "write to ieee802dot11 not ASN_INTEGER\n");
            return SNMP_ERR_WRONGTYPE;
        }
        if (var_val_len > sizeof(long)) {
            fprintf(stderr, "write to ieee802dot11: bad length\n");
            return SNMP_ERR_WRONGLENGTH;
        }
        break;

    case RESERVE2:
        size = var_val_len;
        value = *(long *) var_val;

        break;

    case FREE:
        /*
         * Release any resources that have been allocated 
         */
        break;

    case ACTION:
        /*
         * The variable has been stored in 'value' for you to use,
         * and you have just been asked to do something with it.
         * Note that anything done here must be reversable in the UNDO case
         */
        break;

    case UNDO:
        /*
         * Back out any changes made in the ACTION case 
         */
        break;

    case COMMIT:
        /*
         * Things are working well, so it's now safe to make the change
         * permanently.  Make sure that anything done here can't fail!
         */
        break;
    }
    return SNMP_ERR_NOERROR;
}

int
write_dot11CCAWatchdogTimerMin(int action,
                               u_char * var_val,
                               u_char var_val_type,
                               size_t var_val_len,
                               u_char * statP, oid * name, size_t name_len)
{
    long            value;
    int             size;
	// not implement
    return SNMP_ERR_NOERROR;

    switch (action) {
    case RESERVE1:
        if (var_val_type != ASN_INTEGER) {
            fprintf(stderr, "write to ieee802dot11 not ASN_INTEGER\n");
            return SNMP_ERR_WRONGTYPE;
        }
        if (var_val_len > sizeof(long)) {
            fprintf(stderr, "write to ieee802dot11: bad length\n");
            return SNMP_ERR_WRONGLENGTH;
        }
        break;

    case RESERVE2:
        size = var_val_len;
        value = *(long *) var_val;

        break;

    case FREE:
        /*
         * Release any resources that have been allocated 
         */
        break;

    case ACTION:
        /*
         * The variable has been stored in 'value' for you to use,
         * and you have just been asked to do something with it.
         * Note that anything done here must be reversable in the UNDO case
         */
        break;

    case UNDO:
        /*
         * Back out any changes made in the ACTION case 
         */
        break;

    case COMMIT:
        /*
         * Things are working well, so it's now safe to make the change
         * permanently.  Make sure that anything done here can't fail!
         */
        break;
    }
    return SNMP_ERR_NOERROR;
}

int
write_dot11CCAWatchdogCountMin(int action,
                               u_char * var_val,
                               u_char var_val_type,
                               size_t var_val_len,
                               u_char * statP, oid * name, size_t name_len)
{
    long            value;
    int             size;
	// not implement
    return SNMP_ERR_NOERROR;

    switch (action) {
    case RESERVE1:
        if (var_val_type != ASN_INTEGER) {
            fprintf(stderr, "write to ieee802dot11 not ASN_INTEGER\n");
            return SNMP_ERR_WRONGTYPE;
        }
        if (var_val_len > sizeof(long)) {
            fprintf(stderr, "write to ieee802dot11: bad length\n");
            return SNMP_ERR_WRONGLENGTH;
        }
        break;

    case RESERVE2:
        size = var_val_len;
        value = *(long *) var_val;

        break;

    case FREE:
        /*
         * Release any resources that have been allocated 
         */
        break;

    case ACTION:
        /*
         * The variable has been stored in 'value' for you to use,
         * and you have just been asked to do something with it.
         * Note that anything done here must be reversable in the UNDO case
         */
        break;

    case UNDO:
        /*
         * Back out any changes made in the ACTION case 
         */
        break;

    case COMMIT:
        /*
         * Things are working well, so it's now safe to make the change
         * permanently.  Make sure that anything done here can't fail!
         */
        break;
    }
    return SNMP_ERR_NOERROR;
}

int
write_dot11SupportedTxAntenna(int action,
                              u_char * var_val,
                              u_char var_val_type,
                              size_t var_val_len,
                              u_char * statP, oid * name, size_t name_len)
{
    long            value;
    int             size;
	// not implement
    return SNMP_ERR_NOERROR;

    switch (action) {
    case RESERVE1:
        if (var_val_type != ASN_INTEGER) {
            fprintf(stderr, "write to ieee802dot11 not ASN_INTEGER\n");
            return SNMP_ERR_WRONGTYPE;
        }
        if (var_val_len > sizeof(long)) {
            fprintf(stderr, "write to ieee802dot11: bad length\n");
            return SNMP_ERR_WRONGLENGTH;
        }
        break;

    case RESERVE2:
        size = var_val_len;
        value = *(long *) var_val;

        break;

    case FREE:
        /*
         * Release any resources that have been allocated 
         */
        break;

    case ACTION:
        /*
         * The variable has been stored in 'value' for you to use,
         * and you have just been asked to do something with it.
         * Note that anything done here must be reversable in the UNDO case
         */
        break;

    case UNDO:
        /*
         * Back out any changes made in the ACTION case 
         */
        break;

    case COMMIT:
        /*
         * Things are working well, so it's now safe to make the change
         * permanently.  Make sure that anything done here can't fail!
         */
        break;
    }
    return SNMP_ERR_NOERROR;
}

int
write_dot11SupportedRxAntenna(int action,
                              u_char * var_val,
                              u_char var_val_type,
                              size_t var_val_len,
                              u_char * statP, oid * name, size_t name_len)
{
    long            value;
    int             size;
	// not implement
    return SNMP_ERR_NOERROR;

    switch (action) {
    case RESERVE1:
        if (var_val_type != ASN_INTEGER) {
            fprintf(stderr, "write to ieee802dot11 not ASN_INTEGER\n");
            return SNMP_ERR_WRONGTYPE;
        }
        if (var_val_len > sizeof(long)) {
            fprintf(stderr, "write to ieee802dot11: bad length\n");
            return SNMP_ERR_WRONGLENGTH;
        }
        break;

    case RESERVE2:
        size = var_val_len;
        value = *(long *) var_val;

        break;

    case FREE:
        /*
         * Release any resources that have been allocated 
         */
        break;

    case ACTION:
        /*
         * The variable has been stored in 'value' for you to use,
         * and you have just been asked to do something with it.
         * Note that anything done here must be reversable in the UNDO case
         */
        break;

    case UNDO:
        /*
         * Back out any changes made in the ACTION case 
         */
        break;

    case COMMIT:
        /*
         * Things are working well, so it's now safe to make the change
         * permanently.  Make sure that anything done here can't fail!
         */
        break;
    }
    return SNMP_ERR_NOERROR;
}

int
write_dot11DiversitySelectionRx(int action,
                                u_char * var_val,
                                u_char var_val_type,
                                size_t var_val_len,
                                u_char * statP,
                                oid * name, size_t name_len)
{
    long            value;
    int             size;
	// not implement
    return SNMP_ERR_NOERROR;

    switch (action) {
    case RESERVE1:
        if (var_val_type != ASN_INTEGER) {
            fprintf(stderr, "write to ieee802dot11 not ASN_INTEGER\n");
            return SNMP_ERR_WRONGTYPE;
        }
        if (var_val_len > sizeof(long)) {
            fprintf(stderr, "write to ieee802dot11: bad length\n");
            return SNMP_ERR_WRONGLENGTH;
        }
        break;

    case RESERVE2:
        size = var_val_len;
        value = *(long *) var_val;

        break;

    case FREE:
        /*
         * Release any resources that have been allocated 
         */
        break;

    case ACTION:
        /*
         * The variable has been stored in 'value' for you to use,
         * and you have just been asked to do something with it.
         * Note that anything done here must be reversable in the UNDO case
         */
        break;

    case UNDO:
        /*
         * Back out any changes made in the ACTION case 
         */
        break;

    case COMMIT:
        /*
         * Things are working well, so it's now safe to make the change
         * permanently.  Make sure that anything done here can't fail!
         */
        break;
    }
    return SNMP_ERR_NOERROR;
}
